/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.tomcat.util.buf.Asn1Parser;
import org.apache.tomcat.util.buf.Asn1Writer;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.res.StringManager;

public class PEMFile {
    private static final StringManager sm = StringManager.getManager(PEMFile.class);
    private static final byte[] OID_EC_PUBLIC_KEY = new byte[]{6, 7, 42, -122, 72, -50, 61, 2, 1};
    private static final String OID_PKCS5_PBES2 = "1.2.840.113549.1.5.13";
    private static final String PBES2 = "PBES2";
    private List<X509Certificate> certificates = new ArrayList<X509Certificate>();
    private PrivateKey privateKey;

    public static String toPEM(X509Certificate x509Certificate) throws CertificateEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("-----BEGIN CERTIFICATE-----");
        stringBuilder.append(System.lineSeparator());
        Base64 base64 = new Base64(64);
        stringBuilder.append(base64.encodeAsString(x509Certificate.getEncoded()));
        stringBuilder.append("-----END CERTIFICATE-----");
        return stringBuilder.toString();
    }

    public List<X509Certificate> getCertificates() {
        return this.certificates;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PEMFile(String string) throws IOException, GeneralSecurityException {
        this(string, null);
    }

    public PEMFile(String string, String string2) throws IOException, GeneralSecurityException {
        this(string, string2, null);
    }

    public PEMFile(String string, String string2, String string3) throws IOException, GeneralSecurityException {
        this(string, ConfigFileLoader.getSource().getResource(string).getInputStream(), string2, string3);
    }

    public PEMFile(String string, InputStream inputStream, String string2, String string3) throws IOException, GeneralSecurityException {
        ArrayList<Part> arrayList = new ArrayList<Part>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.US_ASCII));){
            String string4;
            Part part = null;
            while ((string4 = bufferedReader.readLine()) != null) {
                if (string4.startsWith("-----BEGIN ")) {
                    part = new Part();
                    part.type = string4.substring("-----BEGIN ".length(), string4.length() - "-----".length()).trim();
                    continue;
                }
                if (string4.startsWith("-----END ")) {
                    arrayList.add(part);
                    part = null;
                    continue;
                }
                if (part != null && !string4.contains(":") && !string4.startsWith(" ")) {
                    part.content = part.content + string4;
                    continue;
                }
                if (part == null || !string4.contains(":") || string4.startsWith(" ") || !string4.startsWith("DEK-Info: ")) continue;
                String[] stringArray = string4.split(" ");
                if ((stringArray = stringArray[1].split(",")).length != 2) continue;
                part.algorithm = stringArray[0];
                part.ivHex = stringArray[1];
            }
        }
        for (Part part : arrayList) {
            switch (part.type) {
                case "PRIVATE KEY": {
                    this.privateKey = part.toPrivateKey(null, string3, Format.PKCS8, string);
                    break;
                }
                case "EC PRIVATE KEY": {
                    this.privateKey = part.toPrivateKey(null, "EC", Format.RFC5915, string);
                    break;
                }
                case "ENCRYPTED PRIVATE KEY": {
                    this.privateKey = part.toPrivateKey(string2, string3, Format.PKCS8, string);
                    break;
                }
                case "RSA PRIVATE KEY": {
                    if (part.algorithm == null) {
                        this.privateKey = part.toPrivateKey(null, string3, Format.PKCS1, string);
                        break;
                    }
                    this.privateKey = part.toPrivateKey(string2, string3, Format.PKCS1, string);
                    break;
                }
                case "CERTIFICATE": 
                case "X509 CERTIFICATE": {
                    this.certificates.add(part.toCertificate());
                }
            }
        }
    }

    private static enum Format {
        PKCS1,
        PKCS8,
        RFC5915;

    }

    private class Part {
        public static final String BEGIN_BOUNDARY = "-----BEGIN ";
        public static final String END_BOUNDARY = "-----END ";
        public static final String FINISH_BOUNDARY = "-----";
        public static final String PRIVATE_KEY = "PRIVATE KEY";
        public static final String EC_PRIVATE_KEY = "EC PRIVATE KEY";
        public static final String ENCRYPTED_PRIVATE_KEY = "ENCRYPTED PRIVATE KEY";
        public static final String RSA_PRIVATE_KEY = "RSA PRIVATE KEY";
        public static final String CERTIFICATE = "CERTIFICATE";
        public static final String X509_CERTIFICATE = "X509 CERTIFICATE";
        public String type;
        public String content = "";
        public String algorithm = null;
        public String ivHex = null;

        private Part() {
        }

        private byte[] decode() {
            return Base64.decodeBase64((String)this.content);
        }

        public X509Certificate toCertificate() throws CertificateException {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.decode()));
        }

        /*
         * WARNING - void declaration
         */
        public PrivateKey toPrivateKey(String string, String string2, Format format, String string3) throws GeneralSecurityException, IOException {
            Object object2;
            String[] stringArray;
            Object object3;
            KeySpec keySpec = null;
            if (string == null) {
                switch (format) {
                    case PKCS1: {
                        keySpec = this.parsePKCS1(this.decode());
                        break;
                    }
                    case PKCS8: {
                        keySpec = new PKCS8EncodedKeySpec(this.decode());
                        break;
                    }
                    case RFC5915: {
                        keySpec = new PKCS8EncodedKeySpec(this.rfc5915ToPkcs8(this.decode()));
                    }
                }
            } else if (this.algorithm == null) {
                object3 = new EncryptedPrivateKeyInfo(this.decode());
                stringArray = this.getPBEAlgorithm((EncryptedPrivateKeyInfo)object3);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance((String)stringArray);
                object2 = secretKeyFactory.generateSecret(new PBEKeySpec(string.toCharArray()));
                Cipher object4 = Cipher.getInstance((String)stringArray);
                object4.init(2, (Key)object2, ((EncryptedPrivateKeyInfo)object3).getAlgParameters());
                keySpec = ((EncryptedPrivateKeyInfo)object3).getKeySpec(object4);
            } else {
                int n;
                void var10_19;
                object2 = this.algorithm;
                int n2 = -1;
                switch (((String)object2).hashCode()) {
                    case -2020788375: {
                        if (!((String)object2).equals("DES-CBC")) break;
                        boolean bl = false;
                        break;
                    }
                    case -165238049: {
                        if (!((String)object2).equals("DES-EDE3-CBC")) break;
                        boolean bl = true;
                        break;
                    }
                    case -1390896596: {
                        if (!((String)object2).equals("AES-256-CBC")) break;
                        int n3 = 2;
                    }
                }
                switch (var10_19) {
                    case 0: {
                        object3 = "DES";
                        stringArray = "DES/CBC/PKCS5Padding";
                        n = 8;
                        break;
                    }
                    case 1: {
                        object3 = "DESede";
                        stringArray = "DESede/CBC/PKCS5Padding";
                        n = 24;
                        break;
                    }
                    case 2: {
                        object3 = "AES";
                        stringArray = "AES/CBC/PKCS5Padding";
                        n = 32;
                        break;
                    }
                    default: {
                        object3 = this.algorithm;
                        stringArray = this.algorithm;
                        n = 8;
                    }
                }
                object2 = this.fromHex(this.ivHex);
                byte[] byArray = this.deriveKey(n, string, (byte[])object2);
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, (String)object3);
                Cipher cipher = Cipher.getInstance((String)stringArray);
                cipher.init(2, (Key)secretKeySpec, new IvParameterSpec((byte[])object2));
                byte[] byArray2 = cipher.doFinal(this.decode());
                keySpec = this.parsePKCS1(byArray2);
            }
            object3 = new InvalidKeyException(sm.getString("pemFile.parseError", new Object[]{string3}));
            if (string2 == null) {
                for (String string4 : new String[]{"RSA", "DSA", "EC"}) {
                    try {
                        return KeyFactory.getInstance(string4).generatePrivate(keySpec);
                    }
                    catch (InvalidKeySpecException invalidKeySpecException) {
                        ((Throwable)object3).addSuppressed(invalidKeySpecException);
                    }
                }
            } else {
                try {
                    return KeyFactory.getInstance(string2).generatePrivate(keySpec);
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    ((Throwable)object3).addSuppressed(invalidKeySpecException);
                }
            }
            throw object3;
        }

        private String getPBEAlgorithm(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) {
            AlgorithmParameters algorithmParameters = encryptedPrivateKeyInfo.getAlgParameters();
            String string = encryptedPrivateKeyInfo.getAlgName();
            if (algorithmParameters != null && (PEMFile.OID_PKCS5_PBES2.equals(string) || PEMFile.PBES2.equals(string))) {
                return algorithmParameters.toString();
            }
            return encryptedPrivateKeyInfo.getAlgName();
        }

        private byte[] deriveKey(int n, String string, byte[] byArray) throws NoSuchAlgorithmException {
            byte[] byArray2;
            byte[] byArray3 = new byte[n];
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray4 = string.getBytes(StandardCharsets.UTF_8);
            for (int i = 0; i < n; i += byArray2.length) {
                messageDigest.update(byArray4);
                messageDigest.update(byArray, 0, 8);
                byArray2 = messageDigest.digest();
                messageDigest.update(byArray2);
                System.arraycopy(byArray2, 0, byArray3, i, Math.min(n - i, byArray2.length));
            }
            return byArray3;
        }

        private byte[] rfc5915ToPkcs8(byte[] byArray) {
            Asn1Parser asn1Parser = new Asn1Parser(byArray);
            asn1Parser.parseTag(48);
            asn1Parser.parseFullLength();
            BigInteger bigInteger = asn1Parser.parseInt();
            if (bigInteger.intValue() != 1) {
                throw new IllegalArgumentException(sm.getString("pemFile.notValidRFC5915"));
            }
            asn1Parser.parseTag(4);
            int n = asn1Parser.parseLength();
            byte[] byArray2 = new byte[n];
            asn1Parser.parseBytes(byArray2);
            asn1Parser.parseTag(160);
            int n2 = asn1Parser.parseLength();
            byte[] byArray3 = new byte[n2];
            asn1Parser.parseBytes(byArray3);
            if (byArray3[0] != 6) {
                throw new IllegalArgumentException(sm.getString("pemFile.notValidRFC5915"));
            }
            asn1Parser.parseTag(161);
            int n3 = asn1Parser.parseLength();
            byte[] byArray4 = new byte[n3];
            asn1Parser.parseBytes(byArray4);
            if (byArray4[0] != 3) {
                throw new IllegalArgumentException(sm.getString("pemFile.notValidRFC5915"));
            }
            return Asn1Writer.writeSequence((byte[][])new byte[][]{Asn1Writer.writeInteger((int)0), Asn1Writer.writeSequence((byte[][])new byte[][]{OID_EC_PUBLIC_KEY, byArray3}), Asn1Writer.writeOctetString((byte[])Asn1Writer.writeSequence((byte[][])new byte[][]{Asn1Writer.writeInteger((int)1), Asn1Writer.writeOctetString((byte[])byArray2), Asn1Writer.writeTag((byte)-95, (byte[])byArray4)}))});
        }

        private RSAPrivateCrtKeySpec parsePKCS1(byte[] byArray) {
            Asn1Parser asn1Parser = new Asn1Parser(byArray);
            asn1Parser.parseTag(48);
            asn1Parser.parseFullLength();
            BigInteger bigInteger = asn1Parser.parseInt();
            if (bigInteger.intValue() == 1) {
                throw new IllegalArgumentException(sm.getString("pemFile.noMultiPrimes"));
            }
            return new RSAPrivateCrtKeySpec(asn1Parser.parseInt(), asn1Parser.parseInt(), asn1Parser.parseInt(), asn1Parser.parseInt(), asn1Parser.parseInt(), asn1Parser.parseInt(), asn1Parser.parseInt(), asn1Parser.parseInt());
        }

        private byte[] fromHex(String string) {
            byte[] byArray = new byte[string.length() / 2];
            for (int i = 0; i < string.length(); i += 2) {
                byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
            }
            return byArray;
        }
    }
}

