/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.common.integration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graalvm.visualvm.lib.common.Profiler;
import org.graalvm.visualvm.lib.jfluid.ProfilerLogger;
import org.graalvm.visualvm.lib.jfluid.global.Platform;

public class IntegrationUtils {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.common.integration.Bundle");
    public static final String PLATFORM_JAVA_50 = messages.getString("IntegrationUtils_PlatformJava50");
    public static final String PLATFORM_JAVA_60 = messages.getString("IntegrationUtils_PlatformJava60");
    public static final String PLATFORM_JAVA_70 = messages.getString("IntegrationUtils_PlatformJava70");
    public static final String PLATFORM_JAVA_80 = messages.getString("IntegrationUtils_PlatformJava80");
    public static final String PLATFORM_JAVA_90 = messages.getString("IntegrationUtils_PlatformJava90");
    public static final String PLATFORM_JAVA_100 = messages.getString("IntegrationUtils_PlatformJava100");
    public static final String PLATFORM_JAVA_110 = messages.getString("IntegrationUtils_PlatformJava110");
    public static final String PLATFORM_JAVA_120 = messages.getString("IntegrationUtils_PlatformJava120");
    public static final String PLATFORM_JAVA_130 = messages.getString("IntegrationUtils_PlatformJava130");
    public static final String PLATFORM_JAVA_140 = messages.getString("IntegrationUtils_PlatformJava140");
    public static final String PLATFORM_JAVA_150 = messages.getString("IntegrationUtils_PlatformJava150");
    public static final String PLATFORM_JAVA_160 = messages.getString("IntegrationUtils_PlatformJava160");
    public static final String PLATFORM_JAVA_170 = messages.getString("IntegrationUtils_PlatformJava170");
    public static final String PLATFORM_JAVA_180 = messages.getString("IntegrationUtils_PlatformJava180");
    public static final String PLATFORM_JAVA_190 = messages.getString("IntegrationUtils_PlatformJava190");
    public static final String PLATFORM_JAVA_200 = messages.getString("IntegrationUtils_PlatformJava200");
    public static final String PLATFORM_JAVA_CVM = messages.getString("IntegrationUtils_PlatformJavaCvm");
    public static final String PLATFORM_WINDOWS_OS = messages.getString("IntegrationUtils_PlatformWindowsOs");
    public static final String PLATFORM_WINDOWS_AMD64_OS = messages.getString("IntegrationUtils_PlatformWindowsAmd64Os");
    public static final String PLATFORM_WINDOWS_CVM = messages.getString("IntegrationUtils_PlatformWindowsCvm");
    public static final String PLATFORM_LINUX_OS = messages.getString("IntegrationUtils_PlatformLinuxOs");
    public static final String PLATFORM_LINUX_AMD64_OS = messages.getString("IntegrationUtils_PlatformLinuxAmd64Os");
    public static final String PLATFORM_LINUX_ARM_OS = messages.getString("IntegrationUtils_PlatformLinuxArmOs");
    public static final String PLATFORM_LINUX_ARM_VFP_HFLT_OS = messages.getString("IntegrationUtils_PlatformLinuxArmVfpHfltOs");
    public static final String PLATFORM_LINUX_ARM_AARCH64_OS = messages.getString("IntegrationUtils_PlatformLinuxAarch64Os");
    public static final String PLATFORM_LINUX_CVM = messages.getString("IntegrationUtils_PlatformLinuxCvm");
    public static final String PLATFORM_SOLARIS_INTEL_OS = messages.getString("IntegrationUtils_PlatformSolarisIntelOs");
    public static final String PLATFORM_SOLARIS_AMD64_OS = messages.getString("IntegrationUtils_PlatformSolarisAmd64Os");
    public static final String PLATFORM_SOLARIS_SPARC_OS = messages.getString("IntegrationUtils_PlatformSolarisSparcOs");
    public static final String PLATFORM_SOLARIS_SPARC64_OS = messages.getString("IntegrationUtils_PlatformSolarisSparc64Os");
    public static final String PLATFORM_MAC_OS = messages.getString("IntegrationUtils_PlatformMacOs");
    public static final String MODIFIED_FOR_PROFILER_STRING = messages.getString("IntegrationUtils_ModifiedForProfilerString");
    public static final String ORIGINAL_BACKUP_LOCATION_STRING = messages.getString("IntegrationUtils_OriginalBackupLocationString");
    private static final String APPLICATION_STRING = messages.getString("IntegrationUtils_ApplicationString");
    private static final String APPLET_STRING = messages.getString("IntegrationUtils_AppletString");
    private static final String SERVER_STRING = messages.getString("IntegrationUtils_ServerString");
    private static final String DATABASE_STRING = messages.getString("IntegrationUtils_DatabaseString");
    private static final String TARGET_STRING = messages.getString("IntegrationUtils_TargetString");
    private static final String JDK_50_NAME = messages.getString("IntegrationUtils_Jdk50Name");
    private static final String JDK_60_NAME = messages.getString("IntegrationUtils_Jdk60Name");
    private static final String JDK_70_NAME = messages.getString("IntegrationUtils_Jdk70Name");
    private static final String JDK_80_NAME = messages.getString("IntegrationUtils_Jdk80Name");
    private static final String JDK_90_NAME = messages.getString("IntegrationUtils_Jdk90Name");
    private static final String JDK_100_NAME = messages.getString("IntegrationUtils_Jdk100Name");
    private static final String JDK_110_NAME = messages.getString("IntegrationUtils_Jdk110Name");
    private static final String JDK_120_NAME = messages.getString("IntegrationUtils_Jdk120Name");
    private static final String JDK_130_NAME = messages.getString("IntegrationUtils_Jdk130Name");
    private static final String JDK_140_NAME = messages.getString("IntegrationUtils_Jdk140Name");
    private static final String JDK_150_NAME = messages.getString("IntegrationUtils_Jdk150Name");
    private static final String JDK_160_NAME = messages.getString("IntegrationUtils_Jdk160Name");
    private static final String JDK_170_NAME = messages.getString("IntegrationUtils_Jdk170Name");
    private static final String JDK_180_NAME = messages.getString("IntegrationUtils_Jdk180Name");
    private static final String JDK_190_NAME = messages.getString("IntegrationUtils_Jdk190Name");
    private static final String JDK_200_NAME = messages.getString("IntegrationUtils_Jdk200Name");
    private static final String JDK_CVM_NAME = messages.getString("IntegrationUtils_JdkCvmName");
    private static final String HTML_REMOTE_STRING = "&lt;" + messages.getString("IntegrationUtils_RemoteString") + "&gt;";
    private static final String EXPORT_SETENV_MESSAGE = messages.getString("IntegrationUtils_ExportSetenvMessage");
    private static final String REDUCE_OVERHEAD_MESSAGE = messages.getString("IntegrationUtils_ReduceOverheadMessage");
    private static final String COPY_FILE_NOT_FOUND_MESSAGE = messages.getString("IntegrationUtils_CopyFileNotFoundMessage");
    private static final String COPY_CANNOT_DELETE_FILE_MESSAGE = messages.getString("IntegrationUtils_CopyCannotDeleteFileMessage");
    private static final String COPY_ERROR_MESSAGE = messages.getString("IntegrationUtils_CopyErrorMessage");
    private static final String BACKUP_FILE_NOT_FOUND_MESSAGE = messages.getString("IntegrationUtils_BackupFileNotFoundMessage");
    private static final String BACKUP_CANNOT_DELETE_FILE_MESSAGE = messages.getString("IntegrationUtils_BackupCannotDeleteFileMessage");
    private static final String BACKUP_ERROR_MESSAGE = messages.getString("IntegrationUtils_BackupErrorMessage");
    private static final String BACKUP_ERROR_COPY_FILE_MESSAGE = messages.getString("IntegrationUtils_BackupErrorCopyFileMessage");
    private static final String RESTORE_FILE_NOT_FOUND_MESSAGE = messages.getString("IntegrationUtils_RestoreFileNotFoundMessage");
    private static final String RESTORE_CANNOT_DELETE_FILE_MESSAGE = messages.getString("IntegrationUtils_RestoreCannotDeleteFileMessage");
    private static final String RESTORE_ERROR_MESSAGE = messages.getString("IntegrationUtils_RestoreErrorMessage");
    private static final String MANUAL_REMOTE_STEP1_MESSAGE = messages.getString("IntegrationUtils_ManualRemoteStep1Message");
    private static final String MANUAL_REMOTE_STEP2_MESSAGE = messages.getString("IntegrationUtils_ManualRemoteStep2Message");
    private static final String REMOTE_ABSOLUTE_PATH_HINT = messages.getString("IntegrationUtils_RemoteAbsolutePathHint");
    private static final String SPACES_IN_PATH_WARNING_MSG = messages.getString("IntegrationUtils_SpacesInPathWarningMsg");
    public static final String FILE_BACKUP_EXTENSION = ".backup";
    private static final String BINARIES_TMP_PREFIX = "NBProfiler";
    private static final String BINARIES_TMP_EXT = ".link";

    public static String getAddProfilerLibrariesToPathString(String targetPlatform, String targetJVM, boolean isRemote, boolean formatAsHTML) {
        return IntegrationUtils.getExportEnvVariableValueString(targetPlatform, IntegrationUtils.getNativePathEnvVariableString(targetPlatform), IntegrationUtils.getNativeLibrariesPath(targetPlatform, targetJVM, isRemote) + IntegrationUtils.getClassPathSeparator(targetPlatform) + IntegrationUtils.getEnvVariableReference(IntegrationUtils.getNativePathEnvVariableString(targetPlatform), targetPlatform), formatAsHTML);
    }

    public static String getAssignEnvVariableValueString(String targetPlatform, String variableName, String variableValue) {
        variableValue = variableValue.trim();
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return IntegrationUtils.getExportCommandString(targetPlatform) + " " + variableName + "=" + variableValue;
        }
        return variableName + "=" + (variableValue.contains(" ") ? "\"" + variableValue + "\"" : variableValue);
    }

    public static String getBatchExtensionString(String targetPlatform, String customExt) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return customExt + ".bat";
        }
        return customExt + ".sh";
    }

    public static String getBatchExtensionString(String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return ".bat";
        }
        return ".sh";
    }

    public static String getCPUReduceOverheadHint() {
        return REDUCE_OVERHEAD_MESSAGE;
    }

    public static String getDirectorySeparator(String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return "\\";
        }
        return "/";
    }

    public static String getEnvVariableReference(String envVariable, String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return "%" + envVariable + "%";
        }
        return "$" + envVariable;
    }

    public static String getExportCommandString(String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return "SET";
        }
        return "export";
    }

    public static String getExportEnvVariableValueString(String targetPlatform, String variableName, String variableValue, boolean formatAsHTML) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return IntegrationUtils.getAssignEnvVariableValueString(targetPlatform, variableName, variableValue);
        }
        if (targetPlatform.equals(PLATFORM_LINUX_OS)) {
            return IntegrationUtils.getExportCommandString(targetPlatform) + " " + IntegrationUtils.getAssignEnvVariableValueString(targetPlatform, variableName, variableValue);
        }
        return IntegrationUtils.getAssignEnvVariableValueString(targetPlatform, variableName, variableValue) + (formatAsHTML ? "<br>" : IntegrationUtils.getLineBreak(targetPlatform)) + IntegrationUtils.getExportCommandString(targetPlatform) + " " + variableName;
    }

    public static String getExportVSSetenvNote() {
        return EXPORT_SETENV_MESSAGE;
    }

    public static boolean isFileModifiedForProfiler(File file) {
        try {
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            if (line == null) {
                br.close();
                return false;
            }
            if (line.contains(MODIFIED_FOR_PROFILER_STRING)) {
                br.close();
                return true;
            }
            line = br.readLine();
            if (line == null) {
                br.close();
                return false;
            }
            if (line.contains(MODIFIED_FOR_PROFILER_STRING)) {
                br.close();
                return true;
            }
            br.close();
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getJavaPlatformFromJavaVersionString(String javaVersionString) {
        if (javaVersionString.equals("jdk15")) {
            return PLATFORM_JAVA_50;
        }
        if (javaVersionString.equals("jdk16")) {
            return PLATFORM_JAVA_60;
        }
        if (javaVersionString.equals("jdk17")) {
            return PLATFORM_JAVA_70;
        }
        if (javaVersionString.equals("jdk18")) {
            return PLATFORM_JAVA_80;
        }
        if (javaVersionString.equals("jdk19")) {
            return PLATFORM_JAVA_90;
        }
        if (javaVersionString.equals("jdk100")) {
            return PLATFORM_JAVA_100;
        }
        if (javaVersionString.equals("jdk110")) {
            return PLATFORM_JAVA_110;
        }
        if (javaVersionString.equals("jdk120")) {
            return PLATFORM_JAVA_120;
        }
        if (javaVersionString.equals("jdk130")) {
            return PLATFORM_JAVA_130;
        }
        if (javaVersionString.equals("jdk140")) {
            return PLATFORM_JAVA_140;
        }
        if (javaVersionString.equals("jdk150")) {
            return PLATFORM_JAVA_150;
        }
        if (javaVersionString.equals("jdk160")) {
            return PLATFORM_JAVA_160;
        }
        if (javaVersionString.equals("jdk170")) {
            return PLATFORM_JAVA_170;
        }
        if (javaVersionString.equals("jdk180")) {
            return PLATFORM_JAVA_180;
        }
        if (javaVersionString.equals("jdk190")) {
            return PLATFORM_JAVA_190;
        }
        if (javaVersionString.equals("jdk200")) {
            return PLATFORM_JAVA_200;
        }
        if (javaVersionString.equals("cvm")) {
            return PLATFORM_JAVA_CVM;
        }
        return null;
    }

    public static String getPlatformByOSAndArch(int platform, int dataModel, String arch, String archAbi) {
        switch (dataModel) {
            case 32: {
                if (platform == 16) {
                    if (arch.startsWith("arm")) {
                        if (archAbi != null && archAbi.toLowerCase().contains("abihf")) {
                            return PLATFORM_LINUX_ARM_VFP_HFLT_OS;
                        }
                        return PLATFORM_LINUX_ARM_OS;
                    }
                    return PLATFORM_LINUX_OS;
                }
                if ((0x5007 & platform) != 0) {
                    return PLATFORM_WINDOWS_OS;
                }
                if (platform == 8) {
                    if (arch.startsWith("x86")) {
                        return PLATFORM_SOLARIS_INTEL_OS;
                    }
                    return PLATFORM_SOLARIS_SPARC_OS;
                }
                throw new UnsupportedOperationException();
            }
            case 64: {
                if (platform == 16) {
                    return PLATFORM_LINUX_AMD64_OS;
                }
                if ((0x5007 & platform) != 0) {
                    return PLATFORM_WINDOWS_AMD64_OS;
                }
                if (platform == 2048) {
                    return PLATFORM_MAC_OS;
                }
                if (platform == 8) {
                    if (arch.startsWith("x86")) {
                        return PLATFORM_SOLARIS_AMD64_OS;
                    }
                    return PLATFORM_SOLARIS_SPARC64_OS;
                }
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }

    public static String getJavaPlatformName(String javaPlatform) {
        if (javaPlatform.equals(PLATFORM_JAVA_50)) {
            return JDK_50_NAME;
        }
        if (javaPlatform.equals(PLATFORM_JAVA_60)) {
            return JDK_60_NAME;
        }
        if (javaPlatform.equals(PLATFORM_JAVA_70)) {
            return JDK_70_NAME;
        }
        if (javaPlatform.equals(PLATFORM_JAVA_80)) {
            return JDK_80_NAME;
        }
        if (javaPlatform.equals(PLATFORM_JAVA_90)) {
            return JDK_90_NAME;
        }
        if (javaPlatform.equals(PLATFORM_JAVA_100)) {
            return JDK_100_NAME;
        }
        if (javaPlatform.equals(PLATFORM_JAVA_110)) {
            return JDK_110_NAME;
        }
        if (javaPlatform.equals(PLATFORM_JAVA_120)) {
            return JDK_120_NAME;
        }
        if (javaPlatform.equals(PLATFORM_JAVA_130)) {
            return JDK_130_NAME;
        }
        if (javaPlatform.equals(PLATFORM_JAVA_140)) {
            return JDK_140_NAME;
        }
        if (javaPlatform.equals(PLATFORM_JAVA_150)) {
            return JDK_150_NAME;
        }
        if (javaPlatform.equals(PLATFORM_JAVA_160)) {
            return JDK_160_NAME;
        }
        if (javaPlatform.equals(PLATFORM_JAVA_170)) {
            return JDK_170_NAME;
        }
        if (javaPlatform.equals(PLATFORM_JAVA_180)) {
            return JDK_180_NAME;
        }
        if (javaPlatform.equals(PLATFORM_JAVA_190)) {
            return JDK_190_NAME;
        }
        if (javaPlatform.equals(PLATFORM_JAVA_200)) {
            return JDK_200_NAME;
        }
        if (javaPlatform.equals(PLATFORM_JAVA_CVM)) {
            return JDK_CVM_NAME;
        }
        return javaPlatform;
    }

    public static String getJavaPlatformNativeLibrariesDirectoryName(String javaPlatform) {
        if (javaPlatform.equals(PLATFORM_JAVA_50)) {
            return "jdk15";
        }
        if (javaPlatform.equals(PLATFORM_JAVA_60)) {
            return "jdk16";
        }
        if (javaPlatform.equals(PLATFORM_JAVA_70)) {
            return "jdk16";
        }
        if (javaPlatform.equals(PLATFORM_JAVA_80)) {
            return "jdk16";
        }
        if (javaPlatform.equals(PLATFORM_JAVA_90)) {
            return "jdk16";
        }
        if (javaPlatform.equals(PLATFORM_JAVA_100)) {
            return "jdk16";
        }
        if (javaPlatform.equals(PLATFORM_JAVA_110)) {
            return "jdk16";
        }
        if (javaPlatform.equals(PLATFORM_JAVA_120)) {
            return "jdk16";
        }
        if (javaPlatform.equals(PLATFORM_JAVA_130)) {
            return "jdk16";
        }
        if (javaPlatform.equals(PLATFORM_JAVA_140)) {
            return "jdk16";
        }
        if (javaPlatform.equals(PLATFORM_JAVA_150)) {
            return "jdk16";
        }
        if (javaPlatform.equals(PLATFORM_JAVA_160)) {
            return "jdk16";
        }
        if (javaPlatform.equals(PLATFORM_JAVA_170)) {
            return "jdk16";
        }
        if (javaPlatform.equals(PLATFORM_JAVA_180)) {
            return "jdk16";
        }
        if (javaPlatform.equals(PLATFORM_JAVA_190)) {
            return "jdk16";
        }
        if (javaPlatform.equals(PLATFORM_JAVA_200)) {
            return "jdk16";
        }
        if (javaPlatform.equals(PLATFORM_JAVA_CVM)) {
            return "cvm";
        }
        throw new IllegalArgumentException("Unsupported platform " + javaPlatform);
    }

    public static String getLibsDir(String targetPlatform, boolean isRemote) {
        if (isRemote) {
            return IntegrationUtils.getRemoteLibsDir(HTML_REMOTE_STRING, targetPlatform);
        }
        return Profiler.getDefault().getLibsDir();
    }

    private static String getRemoteLibsDir(String prefix, String targetPlatform) {
        return prefix + IntegrationUtils.getDirectorySeparator(targetPlatform) + "lib";
    }

    public static String getLineBreak(String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return "\r\n";
        }
        return "\n";
    }

    public static String getLocalJavaPlatform() {
        int jdkVersion = Platform.getJDKVersionNumber();
        if (jdkVersion == 2) {
            return PLATFORM_JAVA_50;
        }
        if (jdkVersion == 3) {
            return PLATFORM_JAVA_60;
        }
        if (jdkVersion == 4) {
            return PLATFORM_JAVA_70;
        }
        if (jdkVersion == 6) {
            return PLATFORM_JAVA_80;
        }
        if (jdkVersion == 7) {
            return PLATFORM_JAVA_90;
        }
        if (jdkVersion == 8) {
            return PLATFORM_JAVA_100;
        }
        if (jdkVersion == 9) {
            return PLATFORM_JAVA_110;
        }
        if (jdkVersion == 10) {
            return PLATFORM_JAVA_120;
        }
        if (jdkVersion == 11) {
            return PLATFORM_JAVA_130;
        }
        if (jdkVersion == 12) {
            return PLATFORM_JAVA_140;
        }
        if (jdkVersion == 13) {
            return PLATFORM_JAVA_150;
        }
        if (jdkVersion == 14) {
            return PLATFORM_JAVA_160;
        }
        if (jdkVersion == 15) {
            return PLATFORM_JAVA_170;
        }
        if (jdkVersion == 16) {
            return PLATFORM_JAVA_180;
        }
        if (jdkVersion == 17) {
            return PLATFORM_JAVA_190;
        }
        if (jdkVersion == 18) {
            return PLATFORM_JAVA_200;
        }
        return null;
    }

    public static String getLocalPlatform(int architecture) {
        if (architecture == -1) {
            architecture = Platform.getSystemArchitecture();
        }
        if (architecture == 32) {
            if (Platform.isWindows()) {
                return PLATFORM_WINDOWS_OS;
            }
            if (Platform.isLinux()) {
                return PLATFORM_LINUX_OS;
            }
            if (Platform.isSolarisIntel()) {
                return PLATFORM_SOLARIS_INTEL_OS;
            }
            if (Platform.isSolarisSparc()) {
                return PLATFORM_SOLARIS_SPARC_OS;
            }
            if (Platform.isMac()) {
                return PLATFORM_MAC_OS;
            }
            return PLATFORM_SOLARIS_SPARC_OS;
        }
        if (Platform.isWindows()) {
            return PLATFORM_WINDOWS_AMD64_OS;
        }
        if (Platform.isLinux()) {
            return PLATFORM_LINUX_AMD64_OS;
        }
        if (Platform.isSolarisIntel()) {
            return PLATFORM_SOLARIS_AMD64_OS;
        }
        if (Platform.isSolarisSparc()) {
            return PLATFORM_SOLARIS_SPARC64_OS;
        }
        if (Platform.isMac()) {
            return PLATFORM_MAC_OS;
        }
        return PLATFORM_SOLARIS_SPARC64_OS;
    }

    public static String getManualRemoteStep1(String targetOS, String targetJVM) {
        return MessageFormat.format(MANUAL_REMOTE_STEP1_MESSAGE, "JDK 5.0/6.0/7.0/8.0", targetOS, HTML_REMOTE_STRING);
    }

    public static String getManualRemoteStep2(String targetOS, String targetJVM) {
        return MessageFormat.format(MANUAL_REMOTE_STEP2_MESSAGE, IntegrationUtils.getRemoteCalibrateCommandString(targetOS, targetJVM));
    }

    public static String getNativeLibrariesPath(String targetPlatform, String targetJVM, boolean isRemote) {
        return IntegrationUtils.getLibsDir(targetPlatform, isRemote) + IntegrationUtils.getDirectorySeparator(targetPlatform) + "deployed" + IntegrationUtils.getDirectorySeparator(targetPlatform) + IntegrationUtils.getJavaPlatformNativeLibrariesDirectoryName(targetJVM) + IntegrationUtils.getDirectorySeparator(targetPlatform) + IntegrationUtils.getOSPlatformNativeLibrariesDirectoryName(targetPlatform, isRemote);
    }

    private static String getRemoteNativeLibrariesPath(String prefix, String targetPlatform, String targetJVM) {
        return IntegrationUtils.getRemoteLibsDir(prefix, targetPlatform) + IntegrationUtils.getDirectorySeparator(targetPlatform) + "deployed" + IntegrationUtils.getDirectorySeparator(targetPlatform) + IntegrationUtils.getJavaPlatformNativeLibrariesDirectoryName(targetJVM) + IntegrationUtils.getDirectorySeparator(targetPlatform) + IntegrationUtils.getOSPlatformNativeLibrariesDirectoryName(targetPlatform, true);
    }

    public static String getNativePathEnvVariableString(String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return "Path";
        }
        return "LD_LIBRARY_PATH";
    }

    public static String getOSPlatformNativeLibrariesDirectoryName(String targetPlatform, boolean isRemote) {
        if (targetPlatform.equals(PLATFORM_WINDOWS_OS)) {
            return "windows";
        }
        if (targetPlatform.equals(PLATFORM_WINDOWS_AMD64_OS)) {
            return "windows-amd64";
        }
        if (targetPlatform.equals(PLATFORM_LINUX_OS)) {
            return "linux";
        }
        if (targetPlatform.equals(PLATFORM_LINUX_AMD64_OS)) {
            return "linux-amd64";
        }
        if (targetPlatform.equals(PLATFORM_LINUX_ARM_OS)) {
            return "linux-arm";
        }
        if (targetPlatform.equals(PLATFORM_LINUX_ARM_VFP_HFLT_OS)) {
            return "linux-arm-vfp-hflt";
        }
        if (targetPlatform.equals(PLATFORM_LINUX_ARM_AARCH64_OS)) {
            return "linux-aarch64";
        }
        if (targetPlatform.equals(PLATFORM_SOLARIS_INTEL_OS)) {
            return "solaris-i386";
        }
        if (targetPlatform.equals(PLATFORM_SOLARIS_AMD64_OS)) {
            return "solaris-amd64";
        }
        if (targetPlatform.equals(PLATFORM_SOLARIS_SPARC_OS)) {
            return "solaris-sparc";
        }
        if (targetPlatform.equals(PLATFORM_SOLARIS_SPARC64_OS)) {
            return "solaris-sparcv9";
        }
        if (targetPlatform.equals(PLATFORM_MAC_OS)) {
            return "mac";
        }
        return null;
    }

    public static String getClassPathSeparator(String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return ";";
        }
        return ":";
    }

    public static String getProfilerAgentCommandLineArgs(String targetPlatform, String targetJVM, boolean isRemote, int portNumber) {
        return IntegrationUtils.getProfilerAgentCommandLineArgs(targetPlatform, targetJVM, isRemote, portNumber, true);
    }

    public static String getProfilerAgentCommandLineArgs(String targetPlatform, String targetJVM, boolean isRemote, int portNumber, boolean createTemp) {
        if (IntegrationUtils.getNativeLibrariesPath(targetPlatform, targetJVM, isRemote).indexOf(32) == -1) {
            return IntegrationUtils.getProfilerAgentCommandLineArgsWithoutQuotes(targetPlatform, targetJVM, isRemote, portNumber);
        }
        if (!IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            String libsDirPath = IntegrationUtils.getLibsDir(targetPlatform, isRemote);
            String args = IntegrationUtils.getProfilerAgentCommandLineArgsWithoutQuotes(targetPlatform, targetJVM, isRemote, portNumber);
            return IntegrationUtils.fixLibsDirPath(libsDirPath, args, createTemp);
        }
        return "-agentpath:\"" + IntegrationUtils.getNativeLibrariesPath(targetPlatform, targetJVM, isRemote) + IntegrationUtils.getDirectorySeparator(targetPlatform) + IntegrationUtils.getProfilerAgentLibraryFile(targetPlatform) + "=" + IntegrationUtils.getLibsDir(targetPlatform, isRemote) + "\"," + portNumber;
    }

    public static String fixLibsDirPath(String libsDirPath, String args) {
        return IntegrationUtils.fixLibsDirPath(libsDirPath, args, true);
    }

    public static String fixLibsDirPath(String libsDirPath, String args, boolean createTmp) {
        if (createTmp) {
            try {
                File tmpFile = File.createTempFile(BINARIES_TMP_PREFIX, BINARIES_TMP_EXT);
                String tmpPath = tmpFile.getAbsolutePath();
                tmpFile.delete();
                Runtime.getRuntime().exec(new String[]{"/bin/ln", "-s", libsDirPath, tmpPath});
                new File(tmpPath).deleteOnExit();
                return args.replace(libsDirPath, tmpPath);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return args.replaceAll("agentpath:(.*?)=(.*?),(.*)", "agentpath:\"$1\"=\"$2\",$3");
    }

    public static String getRemoteProfilerAgentCommandLineArgsWithoutQuotes(String prefix, String targetPlatform, String targetJVM, int portNumber) {
        StringBuilder args = new StringBuilder();
        if ((targetJVM.equals(PLATFORM_JAVA_60) || targetJVM.equals(PLATFORM_JAVA_70) || targetJVM.equals(PLATFORM_JAVA_80) || targetJVM.equals(PLATFORM_JAVA_90)) && IntegrationUtils.isLinuxPlatform(targetPlatform)) {
            args.append(" -XX:+UseLinuxPosixThreadCPUClocks ");
        }
        args.append("-agentpath:").append(IntegrationUtils.getRemoteNativeLibrariesPath(prefix, targetPlatform, targetJVM)).append(IntegrationUtils.getDirectorySeparator(targetPlatform)).append(IntegrationUtils.getProfilerAgentLibraryFile(targetPlatform)).append("=").append(IntegrationUtils.getRemoteLibsDir(prefix, targetPlatform)).append(",").append(portNumber);
        return args.toString();
    }

    public static String getProfilerAgentCommandLineArgsWithoutQuotes(String targetPlatform, String targetJVM, boolean isRemote, int portNumber) {
        StringBuilder args = new StringBuilder();
        if ((targetJVM.equals(PLATFORM_JAVA_60) || targetJVM.equals(PLATFORM_JAVA_70) || targetJVM.equals(PLATFORM_JAVA_80) || targetJVM.equals(PLATFORM_JAVA_90)) && IntegrationUtils.isLinuxPlatform(targetPlatform)) {
            args.append(" -XX:+UseLinuxPosixThreadCPUClocks ");
        }
        args.append("-agentpath:").append(IntegrationUtils.getNativeLibrariesPath(targetPlatform, targetJVM, isRemote)).append(IntegrationUtils.getDirectorySeparator(targetPlatform)).append(IntegrationUtils.getProfilerAgentLibraryFile(targetPlatform)).append("=").append(IntegrationUtils.getLibsDir(targetPlatform, isRemote)).append(",").append(portNumber);
        return args.toString();
    }

    public static String getProfilerAgentCommandLineArgsWithoutQuotes(String targetPlatform, String targetJVM, boolean isRemote, int portNumber, String pathSpaceChar) {
        StringBuilder args = new StringBuilder();
        if ((targetJVM.equals(PLATFORM_JAVA_60) || targetJVM.equals(PLATFORM_JAVA_70) || targetJVM.equals(PLATFORM_JAVA_80) || targetJVM.equals(PLATFORM_JAVA_90)) && IntegrationUtils.isLinuxPlatform(targetPlatform)) {
            args.append(" -XX:+UseLinuxPosixThreadCPUClocks ");
        }
        String natLibs = IntegrationUtils.getNativeLibrariesPath(targetPlatform, targetJVM, isRemote).replace(" ", pathSpaceChar != null ? pathSpaceChar : " ");
        String libsDir = IntegrationUtils.getLibsDir(targetPlatform, isRemote).replace(" ", pathSpaceChar != null ? pathSpaceChar : " ");
        String agentFile = IntegrationUtils.getProfilerAgentLibraryFile(targetPlatform).replace(" ", pathSpaceChar != null ? pathSpaceChar : " ");
        args.append("-agentpath:").append(natLibs).append(IntegrationUtils.getDirectorySeparator(targetPlatform)).append(agentFile).append("=").append(libsDir).append(",").append(portNumber);
        return args.toString();
    }

    public static String getProfilerAgentLibraryFile(String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return "profilerinterface.dll";
        }
        if (targetPlatform.equals(PLATFORM_MAC_OS)) {
            return "libprofilerinterface.jnilib";
        }
        return "libprofilerinterface.so";
    }

    public static String getProfilerModifiedFileHeader(String targetPlatform) {
        return IntegrationUtils.getSilentScriptCommentSign(targetPlatform) + " " + MODIFIED_FOR_PROFILER_STRING + IntegrationUtils.getLineBreak(targetPlatform);
    }

    public static String getProfilerModifiedReplaceFileHeader(String targetPlatform) {
        return IntegrationUtils.getProfilerModifiedFileHeader(targetPlatform) + IntegrationUtils.getSilentScriptCommentSign(targetPlatform) + " " + ORIGINAL_BACKUP_LOCATION_STRING + IntegrationUtils.getLineBreak(targetPlatform);
    }

    public static String getRemoteAbsolutePathHint() {
        return MessageFormat.format(REMOTE_ABSOLUTE_PATH_HINT, HTML_REMOTE_STRING);
    }

    public static String getRemoteCalibrateCommandString(String targetPlatform, String targetJava) {
        String customExt = IntegrationUtils.isLinuxPlatform(targetPlatform) ? (PLATFORM_JAVA_60.equals(targetJava) ? "-16" : "-15") : "";
        return HTML_REMOTE_STRING + IntegrationUtils.getDirectorySeparator(targetPlatform) + "bin" + IntegrationUtils.getDirectorySeparator(targetPlatform) + "calibrate" + IntegrationUtils.getBatchExtensionString(targetPlatform, customExt);
    }

    public static String getRemoteProfileCommandString(String targetPlatform, String targetJava) {
        String customExt = PLATFORM_JAVA_50.equals(targetJava) ? "-15" : "-16";
        return HTML_REMOTE_STRING + IntegrationUtils.getDirectorySeparator(targetPlatform) + "bin" + IntegrationUtils.getDirectorySeparator(targetPlatform) + "profile" + IntegrationUtils.getBatchExtensionString(targetPlatform, customExt);
    }

    public static String getScriptCommentSign(String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return "rem";
        }
        return "#";
    }

    public static String getSilentScriptCommentSign(String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return "@rem";
        }
        return "#";
    }

    public static String getSpacesInPathWarning() {
        return SPACES_IN_PATH_WARNING_MSG;
    }

    public static boolean isWindowsPlatform(String targetPlatform) {
        return targetPlatform.equals(PLATFORM_WINDOWS_OS) || targetPlatform.equals(PLATFORM_WINDOWS_AMD64_OS) || targetPlatform.equals(PLATFORM_WINDOWS_CVM);
    }

    public static boolean isSolarisPlatform(String targetPlatform) {
        return targetPlatform.equals(PLATFORM_SOLARIS_AMD64_OS) || targetPlatform.equals(PLATFORM_SOLARIS_INTEL_OS) || targetPlatform.equals(PLATFORM_SOLARIS_SPARC64_OS) || targetPlatform.equals(PLATFORM_SOLARIS_SPARC_OS);
    }

    public static boolean isMacPlatform(String targetPlatform) {
        return targetPlatform.equals(PLATFORM_MAC_OS);
    }

    public static boolean isLinuxPlatform(String targetPlatform) {
        return targetPlatform.equals(PLATFORM_LINUX_OS) || targetPlatform.equals(PLATFORM_LINUX_AMD64_OS) || targetPlatform.equals(PLATFORM_LINUX_ARM_OS) || targetPlatform.equals(PLATFORM_LINUX_ARM_VFP_HFLT_OS) || targetPlatform.equals(PLATFORM_LINUX_ARM_AARCH64_OS) || targetPlatform.equals(PLATFORM_LINUX_CVM);
    }

    public static String getXMLCommendEndSign() {
        return "-->";
    }

    public static String getXMLCommentStartSign() {
        return "<!--";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static boolean backupFile(File file) {
        File source = new File(file.getAbsolutePath());
        File target = new File(source.getAbsolutePath() + FILE_BACKUP_EXTENSION);
        if (!source.exists()) {
            ProfilerLogger.severe((String)MessageFormat.format(BACKUP_FILE_NOT_FOUND_MESSAGE, source.getAbsolutePath()));
            return false;
        }
        if (target.exists() && !target.delete()) {
            ProfilerLogger.severe((String)MessageFormat.format(BACKUP_CANNOT_DELETE_FILE_MESSAGE, target.getAbsolutePath()));
            return false;
        }
        if (!source.renameTo(target)) {
            ProfilerLogger.severe((String)MessageFormat.format(BACKUP_ERROR_MESSAGE, source.getAbsolutePath(), target.getAbsolutePath()));
            return false;
        }
        try {
            source = new File(file.getAbsolutePath());
            source.createNewFile();
            target = new File(source.getAbsolutePath() + FILE_BACKUP_EXTENSION);
            try (FileChannel sourceChannel = new FileOutputStream(source).getChannel();){
                boolean bl;
                FileChannel targetChannel = new FileInputStream(target).getChannel();
                try {
                    targetChannel.transferTo(0L, targetChannel.size(), sourceChannel);
                    bl = true;
                }
                catch (Throwable throwable) {
                    targetChannel.close();
                    throw throwable;
                }
                targetChannel.close();
                return bl;
            }
        }
        catch (Exception ex) {
            ProfilerLogger.severe((String)MessageFormat.format(BACKUP_ERROR_COPY_FILE_MESSAGE, target.getAbsolutePath(), source.getAbsolutePath(), ex));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFile(File sourceFile, File targetFile) {
        if (!sourceFile.exists()) {
            ProfilerLogger.severe((String)MessageFormat.format(COPY_FILE_NOT_FOUND_MESSAGE, sourceFile.getAbsolutePath()));
            return false;
        }
        if (targetFile.exists() && !targetFile.delete()) {
            ProfilerLogger.severe((String)MessageFormat.format(COPY_CANNOT_DELETE_FILE_MESSAGE, targetFile.getAbsolutePath()));
            return false;
        }
        try (FileChannel sourceChannel = new FileInputStream(sourceFile).getChannel();){
            boolean bl;
            FileChannel destinationChannel = new FileOutputStream(targetFile).getChannel();
            try {
                sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
                bl = true;
            }
            catch (Throwable throwable) {
                destinationChannel.close();
                throw throwable;
            }
            destinationChannel.close();
            return bl;
        }
        catch (Exception ex) {
            ProfilerLogger.log((Exception)ex);
            ProfilerLogger.severe((String)MessageFormat.format(COPY_ERROR_MESSAGE, sourceFile.getAbsolutePath(), targetFile.getAbsolutePath()));
            return false;
        }
    }

    public static boolean fileBackupExists(File file) {
        File target = new File(file.getAbsolutePath());
        File source = new File(target.getAbsolutePath() + FILE_BACKUP_EXTENSION);
        return source.exists();
    }

    public static boolean restoreFile(File file) {
        File target = file;
        File source = new File(target.getAbsolutePath() + FILE_BACKUP_EXTENSION);
        if (!source.exists()) {
            ProfilerLogger.severe((String)MessageFormat.format(RESTORE_FILE_NOT_FOUND_MESSAGE, source.getAbsolutePath(), target.getAbsolutePath()));
            return false;
        }
        if (target.exists() && !target.delete()) {
            ProfilerLogger.severe((String)MessageFormat.format(RESTORE_CANNOT_DELETE_FILE_MESSAGE, target.getAbsolutePath()));
            return false;
        }
        if (!source.renameTo(target)) {
            ProfilerLogger.severe((String)MessageFormat.format(RESTORE_ERROR_MESSAGE, source.getAbsolutePath(), target.getAbsolutePath()));
            return false;
        }
        return true;
    }

    public static String getTemporaryBinariesLink(String agentCmds) {
        Pattern p = Pattern.compile("(/.*?NBProfiler.*?.link)");
        Matcher m = p.matcher(agentCmds);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}

