/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ExportsStatement;
import org.eclipse.jdt.internal.compiler.ast.ModuleDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ModuleStatement;
import org.eclipse.jdt.internal.compiler.ast.OpensStatement;
import org.eclipse.jdt.internal.compiler.ast.ProvidesStatement;
import org.eclipse.jdt.internal.compiler.ast.RequiresStatement;
import org.eclipse.jdt.internal.compiler.ast.UsesStatement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredExportsStatement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredOpensStatement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredProvidesStatement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredRequiresStatement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredUsesStatement;

public class RecoveredModule
extends RecoveredElement {
    public RecoveredExportsStatement[] exports;
    public int exportCount;
    public RecoveredOpensStatement[] opens;
    public int opensCount;
    public RecoveredRequiresStatement[] requires;
    public int requiresCount;
    public RecoveredUsesStatement[] uses;
    public int usesCount;
    public RecoveredProvidesStatement[] services;
    public int servicesCount;
    public ModuleDeclaration moduleDeclaration;

    public RecoveredModule(ModuleDeclaration moduleDeclaration, RecoveredElement recoveredElement, int n) {
        super(recoveredElement, n);
        this.moduleDeclaration = moduleDeclaration;
    }

    @Override
    public RecoveredElement add(ModuleStatement moduleStatement, int n) {
        if (moduleStatement instanceof ExportsStatement) {
            return this.add((ExportsStatement)moduleStatement, n);
        }
        if (moduleStatement instanceof OpensStatement) {
            return this.add((OpensStatement)moduleStatement, n);
        }
        if (moduleStatement instanceof RequiresStatement) {
            return this.add((RequiresStatement)moduleStatement, n);
        }
        if (moduleStatement instanceof ProvidesStatement) {
            return this.add((ProvidesStatement)moduleStatement, n);
        }
        if (moduleStatement instanceof UsesStatement) {
            return this.add((UsesStatement)moduleStatement, n);
        }
        return this;
    }

    public RecoveredElement add(ExportsStatement exportsStatement, int n) {
        this.resetPendingModifiers();
        if (this.exports == null) {
            this.exports = new RecoveredExportsStatement[5];
            this.exportCount = 0;
        } else if (this.exportCount == this.exports.length) {
            this.exports = new RecoveredExportsStatement[2 * this.exportCount];
            System.arraycopy(this.exports, 0, this.exports, 0, this.exportCount);
        }
        RecoveredExportsStatement recoveredExportsStatement = new RecoveredExportsStatement(exportsStatement, (RecoveredElement)this, n);
        this.exports[this.exportCount++] = recoveredExportsStatement;
        return recoveredExportsStatement;
    }

    public RecoveredElement add(OpensStatement opensStatement, int n) {
        this.resetPendingModifiers();
        if (this.opens == null) {
            this.opens = new RecoveredOpensStatement[5];
            this.opensCount = 0;
        } else if (this.opensCount == this.opens.length) {
            this.opens = new RecoveredOpensStatement[2 * this.opensCount];
            System.arraycopy(this.opens, 0, this.opens, 0, this.opensCount);
        }
        RecoveredOpensStatement recoveredOpensStatement = new RecoveredOpensStatement(opensStatement, (RecoveredElement)this, n);
        this.opens[this.opensCount++] = recoveredOpensStatement;
        return recoveredOpensStatement;
    }

    public RecoveredElement add(RequiresStatement requiresStatement, int n) {
        if (this.requires == null) {
            this.requires = new RecoveredRequiresStatement[5];
            this.requiresCount = 0;
        } else if (this.requiresCount == this.requires.length) {
            this.requires = new RecoveredRequiresStatement[2 * this.requiresCount];
            System.arraycopy(this.requires, 0, this.requires, 0, this.requiresCount);
        }
        RecoveredRequiresStatement recoveredRequiresStatement = new RecoveredRequiresStatement(requiresStatement, (RecoveredElement)this, n);
        this.requires[this.requiresCount++] = recoveredRequiresStatement;
        return this;
    }

    public RecoveredElement add(ProvidesStatement providesStatement, int n) {
        if (this.services == null) {
            this.services = new RecoveredProvidesStatement[5];
            this.servicesCount = 0;
        } else if (this.servicesCount == this.services.length) {
            this.services = new RecoveredProvidesStatement[2 * this.servicesCount];
            System.arraycopy(this.services, 0, this.services, 0, this.servicesCount);
        }
        RecoveredProvidesStatement recoveredProvidesStatement = new RecoveredProvidesStatement(providesStatement, (RecoveredElement)this, n);
        this.services[this.servicesCount++] = recoveredProvidesStatement;
        return recoveredProvidesStatement;
    }

    public RecoveredElement add(UsesStatement usesStatement, int n) {
        this.genAssign(usesStatement, n);
        return this;
    }

    private void genAssign(UsesStatement usesStatement, int n) {
        if (this.uses == null) {
            this.uses = new RecoveredUsesStatement[5];
            this.usesCount = 0;
        } else if (this.usesCount == this.uses.length) {
            this.uses = new RecoveredUsesStatement[2 * this.usesCount];
            System.arraycopy(this.uses, 0, this.uses, 0, this.usesCount);
        }
        RecoveredUsesStatement recoveredUsesStatement = new RecoveredUsesStatement(usesStatement, (RecoveredElement)this, n);
        this.uses[this.usesCount++] = recoveredUsesStatement;
    }

    @Override
    public String toString(int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(this.tabString(n));
        stringBuilder.append("Recovered module:\n");
        stringBuilder.append("module ");
        stringBuilder.append(CharOperation.charToString(this.moduleDeclaration.moduleName));
        stringBuilder.append(" {");
        if (this.exportCount > 0) {
            for (n2 = 0; n2 < this.exportCount; ++n2) {
                stringBuilder.append("\n");
                stringBuilder.append(this.exports[n2].toString(n + 1));
            }
        }
        if (this.requiresCount > 0) {
            for (n2 = 0; n2 < this.requiresCount; ++n2) {
                stringBuilder.append("\n");
                stringBuilder.append(this.requires[n2].toString(n + 1));
            }
        }
        if (this.usesCount > 0) {
            for (n2 = 0; n2 < this.usesCount; ++n2) {
                stringBuilder.append("\n");
                stringBuilder.append(this.uses[n2].toString(n + 1));
            }
        }
        if (this.servicesCount > 0) {
            for (n2 = 0; n2 < this.servicesCount; ++n2) {
                stringBuilder.append("\n");
                stringBuilder.append(this.services[n2].toString(n + 1));
            }
        }
        stringBuilder.append("\n}");
        return stringBuilder.toString();
    }

    public ModuleDeclaration updatedModuleDeclaration() {
        this.updateExports(this.moduleDeclaration);
        this.updateOpens(this.moduleDeclaration);
        this.updateRequires(this.moduleDeclaration);
        this.updateUses(this.moduleDeclaration);
        this.updateServices(this.moduleDeclaration);
        return this.moduleDeclaration;
    }

    private void updateExports(ModuleDeclaration moduleDeclaration) {
        if (this.exportCount > 0) {
            int n = moduleDeclaration.exportsCount;
            int n2 = 0;
            ExportsStatement[] exportsStatementArray = new ExportsStatement[n + this.exportCount];
            if (n > 0) {
                System.arraycopy(moduleDeclaration.exports, 0, exportsStatementArray, 0, n);
                n2 = n;
            }
            for (int i = 0; i < this.exportCount; ++i) {
                exportsStatementArray[n2++] = (ExportsStatement)this.exports[i].updatedPackageVisibilityStatement();
            }
            moduleDeclaration.exports = exportsStatementArray;
            moduleDeclaration.exportsCount = n2;
        }
    }

    private void updateOpens(ModuleDeclaration moduleDeclaration) {
        if (this.opensCount > 0) {
            int n = moduleDeclaration.opensCount;
            int n2 = 0;
            OpensStatement[] opensStatementArray = new OpensStatement[n + this.opensCount];
            if (n > 0) {
                System.arraycopy(moduleDeclaration.exports, 0, opensStatementArray, 0, n);
                n2 = n;
            }
            for (int i = 0; i < this.opensCount; ++i) {
                opensStatementArray[n2++] = (OpensStatement)this.opens[i].updatedPackageVisibilityStatement();
            }
            moduleDeclaration.opens = opensStatementArray;
            moduleDeclaration.opensCount = n2;
        }
    }

    private void updateRequires(ModuleDeclaration moduleDeclaration) {
        if (this.requiresCount > 0) {
            int n = moduleDeclaration.requiresCount;
            int n2 = 0;
            RequiresStatement[] requiresStatementArray = new RequiresStatement[n + this.requiresCount];
            if (n > 0) {
                System.arraycopy(moduleDeclaration.requires, 0, requiresStatementArray, 0, n);
                n2 = n;
            }
            for (int i = 0; i < this.requiresCount; ++i) {
                requiresStatementArray[n2++] = this.requires[i].updatedRequiresStatement();
            }
            moduleDeclaration.requires = requiresStatementArray;
            moduleDeclaration.requiresCount = n2;
        }
    }

    private void updateUses(ModuleDeclaration moduleDeclaration) {
        if (this.usesCount > 0) {
            int n = moduleDeclaration.usesCount;
            int n2 = 0;
            UsesStatement[] usesStatementArray = new UsesStatement[n + this.usesCount];
            if (n > 0) {
                System.arraycopy(moduleDeclaration.uses, 0, usesStatementArray, 0, n);
                n2 = n;
            }
            for (int i = 0; i < this.usesCount; ++i) {
                usesStatementArray[n2++] = this.uses[i].updatedUsesStatement();
            }
            moduleDeclaration.uses = usesStatementArray;
            moduleDeclaration.usesCount = n2;
        }
    }

    private void updateServices(ModuleDeclaration moduleDeclaration) {
        if (this.servicesCount > 0) {
            int n = moduleDeclaration.servicesCount;
            int n2 = 0;
            ProvidesStatement[] providesStatementArray = new ProvidesStatement[n + this.servicesCount];
            if (n > 0) {
                System.arraycopy(moduleDeclaration.services, 0, providesStatementArray, 0, n);
                n2 = n;
            }
            for (int i = 0; i < this.servicesCount; ++i) {
                providesStatementArray[n2++] = this.services[i].updatedProvidesStatement();
            }
            moduleDeclaration.services = providesStatementArray;
            moduleDeclaration.servicesCount = n2;
        }
    }

    @Override
    public void updateParseTree() {
        this.updatedModuleDeclaration();
    }
}

