/*******************************************************************************
 * Copyright (c) 2017 - 2020 Intel Corporation and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Intel Corporation - Initial implementation, based on code taken and modified
 *     					   from org.eclipse.cdt.launch.remote
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.ui.launching;

import org.eclipse.cdt.dsf.iss.launching.IIssDebugPreferenceConstants;
import org.eclipse.cdt.dsf.iss.launching.IIssLaunchConfigurationConstants;
import org.eclipse.cdt.dsf.iss.ui.IssGdbUIPlugin;
import org.eclipse.cdt.launch.remote.tabs.RemoteDSFGDBDebuggerPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.preference.IPreferenceStore;


@SuppressWarnings("restriction")
public class ISSRemoteDSFGDBDebuggerPage extends RemoteDSFGDBDebuggerPage {
	private boolean fIsInitializing;

	public ISSRemoteDSFGDBDebuggerPage(){
		super();
	}
	@Override
	public void initializeFrom(final ILaunchConfiguration configuration) {
		super.initializeFrom(configuration);
		setInitializing(true);
		final IPreferenceStore preferenceStore = IssGdbUIPlugin.getDefault().getPreferenceStore();
		final String defaultValue = preferenceStore.getString(IIssDebugPreferenceConstants.PREF_DEFAULT_ONEAPI_GDB_COMMAND);
		String gdbCommand ;
		try {
			gdbCommand = configuration.getAttribute(IIssLaunchConfigurationConstants.ATTR_DEBUG_NAME_ONEAPI_GDB , defaultValue);
		} catch (CoreException e){
			setErrorMessage("Unable to get GDB-ONEAPI name from launch configuration constants.");
			gdbCommand = defaultValue;
		}
		fGDBCommandText.setText(gdbCommand);
		setInitializing(false);
	}
	@Override
	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
		super.setDefaults(configuration);
		final IPreferenceStore preferenceStore = IssGdbUIPlugin.getDefault().getPreferenceStore();
		configuration.setAttribute(IIssLaunchConfigurationConstants.ATTR_DEBUG_NAME_ONEAPI_GDB,
				preferenceStore.getString(IIssDebugPreferenceConstants.PREF_DEFAULT_ONEAPI_GDB_COMMAND));

	}
	@Override
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		super.performApply(configuration);

		configuration.setAttribute(IIssLaunchConfigurationConstants.ATTR_DEBUG_NAME_ONEAPI_GDB,
				fGDBCommandText.getText().trim());
	}
	@Override
	public boolean isValid(ILaunchConfiguration launchConfig) {
		boolean valid = fGDBCommandText.getText().length() != 0;
		if (valid) {
			setErrorMessage(null);
		} else {
			setErrorMessage("Unable to locate gdb-oneapi."); //$NON-NLS-1$
		}
		setMessage(null);
		return valid;
	}
	protected boolean isInitializing() {
		return fIsInitializing;
	}
	private void setInitializing(boolean isInitializing) {
		fIsInitializing = isInitializing;
	}
}


