/*******************************************************************************
 * Copyright (c) 2016 - 2020 Intel Corporation and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Intel Corporation - Initial implementation, based on code taken and modified
 *     					   from org.eclipse.cdt.dsf.gdb.
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.ui.launching;

import org.eclipse.cdt.dsf.gdb.internal.ui.launching.GdbServerDebuggerPage;
import org.eclipse.cdt.dsf.iss.launching.IIssDebugPreferenceConstants;
import org.eclipse.cdt.dsf.iss.launching.IIssLaunchConfigurationConstants;
import org.eclipse.cdt.dsf.iss.ui.IssGdbUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;

@SuppressWarnings("restriction")
public class IssGdbServerDebuggerPage extends GdbServerDebuggerPage {
	private boolean fIsInitializing;

	@Override
	public void initializeFrom(ILaunchConfiguration configuration) {
		super.initializeFrom(configuration);

		setInitializing(true);
		IPreferenceStore preferenceStore = IssGdbUIPlugin.getDefault().getPreferenceStore();
		String gdbCommand = getStringAttr(configuration, IIssLaunchConfigurationConstants.ATTR_DEBUG_NAME_ONEAPI_GDB,
				preferenceStore.getString(IIssDebugPreferenceConstants.PREF_DEFAULT_ONEAPI_GDB_COMMAND));

		fGDBCommandText.setText(gdbCommand);
		setInitializing(false);
	}

	protected boolean isInitializing() {
		return fIsInitializing;
	}

	private void setInitializing(boolean isInitializing) {
		fIsInitializing = isInitializing;
	}

	/** utility method to cut down on clutter */
	private String getStringAttr(ILaunchConfiguration config, String attributeName, String defaultValue) {
		try {
			return config.getAttribute(attributeName, defaultValue);
		} catch (CoreException e) {
			return defaultValue;
		}
	}
}
