/*******************************************************************************
 * Copyright (c) 2016 - 2022 Intel Corporation and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Michael Sturm (Intel Corporation) - initial implementation.
 *     Intel Corporation - OneAPI Debugger enhancements
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.mi.service.command;

import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.iss.mi.service.command.commands.MIFunctionRecordInfo;
import org.eclipse.cdt.dsf.iss.mi.service.command.commands.MIFunctionRecordLength;
import org.eclipse.cdt.dsf.iss.mi.service.command.output.MIFunctionRecordInfoInfo;
import org.eclipse.cdt.dsf.iss.mi.service.command.output.MIFunctionRecordLengthInfo;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;

public class IssCommandFactory extends org.eclipse.cdt.dsf.mi.service.command.CommandFactory {

	public ICommand<MIFunctionRecordInfoInfo> createMIFunctionRecordInfo(IMIExecutionDMContext execDmc) {
		return new MIFunctionRecordInfo(execDmc);
	}

	public ICommand<MIFunctionRecordLengthInfo> createMIFunctionRecordLength(IMIExecutionDMContext execDmc) {
		return new MIFunctionRecordLength(execDmc);
	}

	public ICommand<MIFunctionRecordInfoInfo> createMIFunctionRecordInfo(IMIExecutionDMContext execDmc, int funcBegin,
			int funcEnd) {
		return new MIFunctionRecordInfo(execDmc, funcBegin, funcEnd);
	}

}
