"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _common = require("../../common");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function _default(Client, config, components) {
  const clientAction = components.clientAction.factory;
  Client.prototype.opensearch_reports = components.clientAction.namespaceFactory();
  const opensearchReports = Client.prototype.opensearch_reports.prototype;
  /**
   * report related APIs
   */

  opensearchReports.createReport = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.ON_DEMAND_REPORT}`
    },
    method: 'PUT',
    needBody: true
  });
  opensearchReports.createReportFromDefinition = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.ON_DEMAND_REPORT}/<%=reportDefinitionId%>`,
      req: {
        reportDefinitionId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST',
    needBody: true
  });
  opensearchReports.updateReportInstanceStatus = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.REPORT_INSTANCE}/<%=reportInstanceId%>`,
      req: {
        reportInstanceId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST',
    needBody: true
  });
  opensearchReports.getReportById = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.REPORT_INSTANCE}/<%=reportInstanceId%>`,
      req: {
        reportInstanceId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  opensearchReports.getReports = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.LIST_REPORT_INSTANCES}`,
      params: {
        fromIndex: {
          type: 'number'
        },
        maxItems: {
          type: 'number'
        }
      }
    },
    method: 'GET'
  });
  /**
   * report definition related APIs
   */

  opensearchReports.createReportDefinition = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.REPORT_DEFINITION}`
    },
    method: 'POST',
    needBody: true
  });
  opensearchReports.updateReportDefinitionById = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.REPORT_DEFINITION}/<%=reportDefinitionId%>`,
      req: {
        reportDefinitionId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'PUT',
    needBody: true
  });
  opensearchReports.getReportDefinitionById = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.REPORT_DEFINITION}/<%=reportDefinitionId%>`,
      req: {
        reportDefinitionId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  opensearchReports.getReportDefinitions = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.LIST_REPORT_DEFINITIONS}`,
      params: {
        fromIndex: {
          type: 'number'
        },
        maxItems: {
          type: 'number'
        }
      }
    },
    method: 'GET'
  });
  opensearchReports.deleteReportDefinitionById = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.REPORT_DEFINITION}/<%=reportDefinitionId%>`,
      req: {
        reportDefinitionId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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