# Node.js

Trivy supports three types of Node.js package managers: `npm`, `Yarn` and `pnpm`.
The following table provides an outline of the features Trivy offers.

| Package manager | File              | Transitive dependencies | Dev dependencies  | Dependency graph | Position | License |
|:---------------:|-------------------|:-----------------------:|:-----------------:|:----------------:|:--------:|:-------:|
|       npm       | package-lock.json |            ✅            | [Excluded](#npm)  |        ✅         |    ✅     |    ✅    |
|      Yarn       | yarn.lock         |            ✅            | [Excluded](#yarn) |        ✅         |    ✅     |    -    |
|      pnpm       | pnpm-lock.yaml    |            ✅            |     Excluded      |        ✅         |    -     |    -    |

In addition, Trivy scans installed packages with `package.json`.

| File         | Dependency graph | Position | License |
|--------------|:----------------:|:--------:|:-------:|
| package.json |        -         |    -     |    ✅    |

These may be enabled or disabled depending on the target.
See [here](./index.md) for the detail.

## Package managers
Trivy parses your files generated by package managers in filesystem/repository scanning.

!!! tip
    Please make sure your lock file is up-to-date after modifying `package.json`.

### npm
Trivy parses `package-lock.json`.
To identify licenses, you need to download dependencies to `node_modules` beforehand.
Trivy analyzes `node_modules` for licenses.

By default, Trivy doesn't report development dependencies. Use the `--include-dev-deps` flag to include them.

### Yarn
Trivy parses `yarn.lock`, which doesn't contain information about development dependencies.
To exclude devDependencies, `package.json` also needs to be present next to `yarn.lock`.

### pnpm
Trivy parses `pnpm-lock.yaml`, then finds production dependencies and builds a [tree] of dependencies with vulnerabilities.

## Packages
Trivy parses the manifest files of installed packages in container image scanning and so on.

### package.json
Trivy searches for `package.json` files under `node_modules` and identifies installed packages.
It only extracts package names, versions and licenses for those packages.


[tree]: ../../../configuration/reporting.md#show-origins-of-vulnerable-dependencies 