#!/usr/bin/python
from __future__ import absolute_import, division, print_function
# Copyright 2019-2023 Fortinet, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

__metaclass__ = type

ANSIBLE_METADATA = {'status': ['preview'],
                    'supported_by': 'community',
                    'metadata_version': '1.1'}

DOCUMENTATION = '''
---
module: fmgr_system_npu
short_description: Configure NPU attributes.
description:
    - This module is able to configure a FortiManager device.
    - Examples include all parameters and values which need to be adjusted to data sources before usage.

version_added: "2.1.6"
author:
    - Xinwei Du (@dux-fortinet)
    - Xing Li (@lix-fortinet)
    - Jie Xue (@JieX19)
    - Link Zheng (@chillancezen)
    - Frank Shen (@fshen01)
    - Hongbin Lu (@fgtdev-hblu)
notes:
    - Running in workspace locking mode is supported in this FortiManager module, the top
      level parameters workspace_locking_adom and workspace_locking_timeout help do the work.
    - To create or update an object, use state present directive.
    - To delete an object, use state absent directive.
    - Normally, running one module can fail when a non-zero rc is returned. you can also override
      the conditions to fail or succeed with parameters rc_failed and rc_succeeded

options:
    access_token:
        description: The token to access FortiManager without using username and password.
        required: false
        type: str
    bypass_validation:
        description: Only set to True when module schema diffs with FortiManager API structure, module continues to execute without validating parameters.
        required: false
        type: bool
        default: false
    enable_log:
        description: Enable/Disable logging for task.
        required: false
        type: bool
        default: false
    forticloud_access_token:
        description: Authenticate Ansible client with forticloud API access token.
        required: false
        type: str
    proposed_method:
        description: The overridden method for the underlying Json RPC request.
        required: false
        type: str
        choices:
          - update
          - set
          - add
    rc_succeeded:
        description: The rc codes list with which the conditions to succeed will be overriden.
        type: list
        required: false
        elements: int
    rc_failed:
        description: The rc codes list with which the conditions to fail will be overriden.
        type: list
        required: false
        elements: int
    workspace_locking_adom:
        description: The adom to lock for FortiManager running in workspace mode, the value can be global and others including root.
        required: false
        type: str
    workspace_locking_timeout:
        description: The maximum time in seconds to wait for other user to release the workspace lock.
        required: false
        type: int
        default: 300
    adom:
        description: the parameter (adom) in requested url
        type: str
        required: true
    system_npu:
        description: the top level parameters set
        required: false
        type: dict
        suboptions:
            capwap-offload:
                type: str
                description: Enable/disable offloading managed FortiAP and FortiLink CAPWAP sessions.
                choices:
                    - 'disable'
                    - 'enable'
            dedicated-management-affinity:
                type: str
                description: Affinity setting for management deamons
            dedicated-management-cpu:
                type: str
                description: Enable to dedicate one CPU for GUI and CLI connections when NPs are busy.
                choices:
                    - 'disable'
                    - 'enable'
            fastpath:
                type: str
                description: Enable/disable NP6 offloading
                choices:
                    - 'disable'
                    - 'enable'
            fp-anomaly:
                description: no description
                type: dict
                required: false
                suboptions:
                    esp-minlen-err:
                        type: str
                        description: Invalid IPv4 ESP short packet anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    icmp-csum-err:
                        type: str
                        description: Invalid IPv4 ICMP packet checksum anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    icmp-minlen-err:
                        type: str
                        description: Invalid IPv4 ICMP short packet anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    ipv4-csum-err:
                        type: str
                        description: Invalid IPv4 packet checksum anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    ipv4-ihl-err:
                        type: str
                        description: Invalid IPv4 header length anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    ipv4-len-err:
                        type: str
                        description: Invalid IPv4 packet length anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    ipv4-opt-err:
                        type: str
                        description: Invalid IPv4 option parsing anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    ipv4-ttlzero-err:
                        type: str
                        description: Invalid IPv4 TTL field zero anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    ipv4-ver-err:
                        type: str
                        description: Invalid IPv4 header version anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    ipv6-exthdr-len-err:
                        type: str
                        description: Invalid IPv6 packet chain extension header total length anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    ipv6-exthdr-order-err:
                        type: str
                        description: Invalid IPv6 packet extension header ordering anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    ipv6-ihl-err:
                        type: str
                        description: Invalid IPv6 packet length anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    ipv6-plen-zero:
                        type: str
                        description: Invalid IPv6 packet payload length zero anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    ipv6-ver-err:
                        type: str
                        description: Invalid IPv6 packet version anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    tcp-csum-err:
                        type: str
                        description: Invalid IPv4 TCP packet checksum anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    tcp-hlen-err:
                        type: str
                        description: Invalid IPv4 TCP header length anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    tcp-plen-err:
                        type: str
                        description: Invalid IPv4 TCP packet length anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    udp-csum-err:
                        type: str
                        description: Invalid IPv4 UDP packet checksum anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    udp-hlen-err:
                        type: str
                        description: Invalid IPv4 UDP packet header length anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    udp-len-err:
                        type: str
                        description: Invalid IPv4 UDP packet length anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    udp-plen-err:
                        type: str
                        description: Invalid IPv4 UDP packet minimum length anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    udplite-cover-err:
                        type: str
                        description: Invalid IPv4 UDP-Lite packet coverage anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    udplite-csum-err:
                        type: str
                        description: Invalid IPv4 UDP-Lite packet checksum anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    unknproto-minlen-err:
                        type: str
                        description: Invalid IPv4 L4 unknown protocol short packet anomalies.
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    tcp-land:
                        type: str
                        description: TCP land anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    tcp-fin-noack:
                        type: str
                        description: TCP SYN flood with FIN flag set without ACK setting anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    tcp-syn-data:
                        type: str
                        description: TCP SYN flood packets with data anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    tcp-winnuke:
                        type: str
                        description: TCP WinNuke anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv4-optssrr:
                        type: str
                        description: Strict source record route option anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv6-proto-err:
                        type: str
                        description: Layer 4 invalid protocol anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv6-land:
                        type: str
                        description: Land anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    tcp-no-flag:
                        type: str
                        description: TCP SYN flood with no flag set anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv4-land:
                        type: str
                        description: Land anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv4-optlsrr:
                        type: str
                        description: Loose source record route option anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    udp-land:
                        type: str
                        description: UDP land anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    icmp-frag:
                        type: str
                        description: Layer 3 fragmented packets that could be part of layer 4 ICMP anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv6-optendpid:
                        type: str
                        description: End point identification anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv4-opttimestamp:
                        type: str
                        description: Timestamp option anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv4-optrr:
                        type: str
                        description: Record route option anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv6-unknopt:
                        type: str
                        description: Unknown option anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    tcp-fin-only:
                        type: str
                        description: TCP SYN flood with only FIN flag set anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    tcp-syn-fin:
                        type: str
                        description: TCP SYN flood SYN/FIN flag set anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv6-optinvld:
                        type: str
                        description: Invalid option anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv6-saddr-err:
                        type: str
                        description: Source address as multicast anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv4-proto-err:
                        type: str
                        description: Invalid layer 4 protocol anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv4-optstream:
                        type: str
                        description: Stream option anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv6-optnsap:
                        type: str
                        description: Network service access point address option anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    icmp-land:
                        type: str
                        description: ICMP land anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv6-optjumbo:
                        type: str
                        description: Jumbo options anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv4-optsecurity:
                        type: str
                        description: Security option anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv6-optralert:
                        type: str
                        description: Router alert option anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv6-daddr-err:
                        type: str
                        description: Destination address as unspecified or loopback address anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv6-opthomeaddr:
                        type: str
                        description: Home address option anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv4-unknopt:
                        type: str
                        description: Unknown option anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    ipv6-opttunnel:
                        type: str
                        description: Tunnel encapsulation limit option anomalies.
                        choices:
                            - 'allow'
                            - 'drop'
                            - 'trap-to-host'
                    uesp-minlen-err:
                        type: str
                        description: no description
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    vxlan-minlen-err:
                        type: str
                        description: no description
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    sctp-crc-err:
                        type: str
                        description: no description
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    nvgre-minlen-err:
                        type: str
                        description: no description
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    sctp-l4len-err:
                        type: str
                        description: no description
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    sctp-clen-err:
                        type: str
                        description: no description
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    gtpu-plen-err:
                        type: str
                        description: no description
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    capwap-minlen-err:
                        type: str
                        description: no description
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    gre-csum-err:
                        type: str
                        description: no description
                        choices:
                            - 'drop'
                            - 'trap-to-host'
                    tcp-hlenvsl4len-err:
                        type: str
                        description: no description
                        choices:
                            - 'drop'
                            - 'trap-to-host'
            gtp-enhanced-cpu-range:
                type: str
                description: GTP enhanced CPU range option.
                choices:
                    - '0'
                    - '1'
                    - '2'
            gtp-enhanced-mode:
                type: str
                description: Enable/disable GTP enhanced mode.
                choices:
                    - 'disable'
                    - 'enable'
            host-shortcut-mode:
                type: str
                description: Set np6 host shortcut mode.
                choices:
                    - 'bi-directional'
                    - 'host-shortcut'
            htx-gtse-quota:
                type: str
                description: Configure HTX GTSE quota.
                choices:
                    - '100Mbps'
                    - '200Mbps'
                    - '300Mbps'
                    - '400Mbps'
                    - '500Mbps'
                    - '600Mbps'
                    - '700Mbps'
                    - '800Mbps'
                    - '900Mbps'
                    - '1Gbps'
                    - '2Gbps'
                    - '4Gbps'
                    - '8Gbps'
                    - '10Gbps'
            intf-shaping-offload:
                type: str
                description: Enable/disable NPU offload when doing interface-based traffic shaping according to the egress-shaping-profile.
                choices:
                    - 'disable'
                    - 'enable'
            iph-rsvd-re-cksum:
                type: str
                description: Enable/disable IP checksum re-calculation for packets with iph.
                choices:
                    - 'disable'
                    - 'enable'
            ipsec-dec-subengine-mask:
                type: str
                description: IPsec decryption subengine mask
            ipsec-enc-subengine-mask:
                type: str
                description: IPsec encryption subengine mask
            ipsec-inbound-cache:
                type: str
                description: Enable/disable IPsec inbound cache for anti-replay.
                choices:
                    - 'disable'
                    - 'enable'
            ipsec-mtu-override:
                type: str
                description: Enable/disable NP6 IPsec MTU override.
                choices:
                    - 'disable'
                    - 'enable'
            ipsec-over-vlink:
                type: str
                description: Enable/disable IPSEC over vlink.
                choices:
                    - 'disable'
                    - 'enable'
            isf-np-queues:
                description: no description
                type: dict
                required: false
                suboptions:
                    cos0:
                        type: str
                        description: CoS profile name for CoS 0.
                    cos1:
                        type: str
                        description: CoS profile name for CoS 1.
                    cos2:
                        type: str
                        description: CoS profile name for CoS 2.
                    cos3:
                        type: str
                        description: CoS profile name for CoS 3.
                    cos4:
                        type: str
                        description: CoS profile name for CoS 4.
                    cos5:
                        type: str
                        description: CoS profile name for CoS 5.
                    cos6:
                        type: str
                        description: CoS profile name for CoS 6.
                    cos7:
                        type: str
                        description: CoS profile name for CoS 7.
            lag-out-port-select:
                type: str
                description: Enable/disable LAG outgoing port selection based on incoming traffic port.
                choices:
                    - 'disable'
                    - 'enable'
            mcast-session-accounting:
                type: str
                description: Enable/disable traffic accounting for each multicast session through TAE counter.
                choices:
                    - 'disable'
                    - 'session-based'
                    - 'tpe-based'
            np6-cps-optimization-mode:
                type: str
                description: Enable/disable NP6 connection per second
                choices:
                    - 'disable'
                    - 'enable'
            per-session-accounting:
                type: str
                description: Enable/disable per-session accounting.
                choices:
                    - 'enable'
                    - 'disable'
                    - 'enable-by-log'
                    - 'all-enable'
                    - 'traffic-log-only'
            port-cpu-map:
                description: description
                type: list
                elements: dict
                suboptions:
                    cpu-core:
                        type: str
                        description: The CPU core to map to an interface.
                    interface:
                        type: str
                        description: The interface to map to a CPU core.
            port-npu-map:
                description: description
                type: list
                elements: dict
                suboptions:
                    interface:
                        type: str
                        description: Set npu interface port to NPU group map.
                    npu-group-index:
                        type: int
                        description: Mapping NPU group index.
            priority-protocol:
                description: no description
                type: dict
                required: false
                suboptions:
                    bfd:
                        type: str
                        description: Enable/disable NPU BFD priority protocol.
                        choices:
                            - 'disable'
                            - 'enable'
                    bgp:
                        type: str
                        description: Enable/disable NPU BGP priority protocol.
                        choices:
                            - 'disable'
                            - 'enable'
                    slbc:
                        type: str
                        description: Enable/disable NPU SLBC priority protocol.
                        choices:
                            - 'disable'
                            - 'enable'
            qos-mode:
                type: str
                description: QoS mode on switch and NP.
                choices:
                    - 'disable'
                    - 'priority'
                    - 'round-robin'
            rdp-offload:
                type: str
                description: Enable/disable rdp offload.
                choices:
                    - 'disable'
                    - 'enable'
            recover-np6-link:
                type: str
                description: Enable/disable internal link failure check and recovery after boot up.
                choices:
                    - 'disable'
                    - 'enable'
            session-denied-offload:
                type: str
                description: Enable/disable offloading of denied sessions.
                choices:
                    - 'disable'
                    - 'enable'
            sse-backpressure:
                type: str
                description: Enable/disable sse backpressure.
                choices:
                    - 'disable'
                    - 'enable'
            strip-clear-text-padding:
                type: str
                description: Enable/disable stripping clear text padding.
                choices:
                    - 'disable'
                    - 'enable'
            strip-esp-padding:
                type: str
                description: Enable/disable stripping ESP padding.
                choices:
                    - 'disable'
                    - 'enable'
            sw-eh-hash:
                description: no description
                type: dict
                required: false
                suboptions:
                    computation:
                        type: str
                        description: Set hashing computation.
                        choices:
                            - 'xor16'
                            - 'xor8'
                            - 'xor4'
                            - 'crc16'
                    destination-ip-lower-16:
                        type: str
                        description: Include/exclude destination IP address lower 16 bits.
                        choices:
                            - 'include'
                            - 'exclude'
                    destination-ip-upper-16:
                        type: str
                        description: Include/exclude destination IP address upper 16 bits.
                        choices:
                            - 'include'
                            - 'exclude'
                    destination-port:
                        type: str
                        description: Include/exclude destination port if TCP/UDP.
                        choices:
                            - 'include'
                            - 'exclude'
                    ip-protocol:
                        type: str
                        description: Include/exclude IP protocol.
                        choices:
                            - 'include'
                            - 'exclude'
                    netmask-length:
                        type: int
                        description: Network mask length.
                    source-ip-lower-16:
                        type: str
                        description: Include/exclude source IP address lower 16 bits.
                        choices:
                            - 'include'
                            - 'exclude'
                    source-ip-upper-16:
                        type: str
                        description: Include/exclude source IP address upper 16 bits.
                        choices:
                            - 'include'
                            - 'exclude'
                    source-port:
                        type: str
                        description: Include/exclude source port if TCP/UDP.
                        choices:
                            - 'include'
                            - 'exclude'
            sw-np-bandwidth:
                type: str
                description: Bandwidth from switch to NP.
                choices:
                    - '0G'
                    - '2G'
                    - '4G'
                    - '5G'
                    - '6G'
                    - '7G'
                    - '8G'
                    - '9G'
            switch-np-hash:
                type: str
                description: Switch-NP trunk port selection Criteria.
                choices:
                    - 'src-ip'
                    - 'dst-ip'
                    - 'src-dst-ip'
            uesp-offload:
                type: str
                description: Enable/disable UDP-encapsulated ESP offload
                choices:
                    - 'disable'
                    - 'enable'
            policy-offload-level:
                type: str
                description: Configure firewall policy offload level
                choices:
                    - 'disable'
                    - 'dos-offload'
                    - 'full-offload'
            htab-dedi-queue-nr:
                type: int
                description: Set the number of dedicate queue for hash table messages.
            vlan-lookup-cache:
                type: str
                description: Enable/disable vlan lookup cache
                choices:
                    - 'disable'
                    - 'enable'
            ippool-overload-high:
                type: int
                description: High threshold for overload ippool port reuse
            ippool-overload-low:
                type: int
                description: Low threshold for overload ippool port reuse
            hw-ha-scan-interval:
                type: int
                description: HW HA periodical scan interval in seconds
            hash-tbl-spread:
                type: str
                description: Enable/disable hash table entry spread
                choices:
                    - 'disable'
                    - 'enable'
            ipsec-local-uesp-port:
                type: int
                description: no description
            ipsec-ob-np-sel:
                type: str
                description: IPsec NP selection for OB SA offloading.
                choices:
                    - 'RR'
                    - 'rr'
                    - 'Packet'
                    - 'Hash'
            dos-options:
                description: no description
                type: dict
                required: false
                suboptions:
                    npu-dos-meter-mode:
                        type: str
                        description: Set DoS meter NPU offloading mode.
                        choices:
                            - 'local'
                            - 'global'
                    npu-dos-synproxy-mode:
                        type: str
                        description: Set NPU DoS SYNPROXY mode.
                        choices:
                            - 'synack2ack'
                            - 'pass-synack'
                    npu-dos-tpe-mode:
                        type: str
                        description: Enable/disable insertion of DoS meter ID to session table.
                        choices:
                            - 'disable'
                            - 'enable'
            np-queues:
                description: no description
                type: dict
                required: false
                suboptions:
                    ethernet-type:
                        description: description
                        type: list
                        elements: dict
                        suboptions:
                            name:
                                type: str
                                description: Ethernet Type Name.
                            queue:
                                type: int
                                description: Queue Number.
                            type:
                                type: int
                                description: Ethernet Type.
                            weight:
                                type: int
                                description: Class Weight.
                    ip-protocol:
                        description: description
                        type: list
                        elements: dict
                        suboptions:
                            name:
                                type: str
                                description: IP Protocol Name.
                            protocol:
                                type: int
                                description: IP Protocol.
                            queue:
                                type: int
                                description: Queue Number.
                            weight:
                                type: int
                                description: Class Weight.
                    ip-service:
                        description: description
                        type: list
                        elements: dict
                        suboptions:
                            dport:
                                type: int
                                description: Destination port.
                            name:
                                type: str
                                description: IP service name.
                            protocol:
                                type: int
                                description: IP protocol.
                            queue:
                                type: int
                                description: Queue number.
                            sport:
                                type: int
                                description: Source port.
                            weight:
                                type: int
                                description: Class weight.
                    profile:
                        description: description
                        type: list
                        elements: dict
                        suboptions:
                            cos0:
                                type: str
                                description: Queue number of CoS 0.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            cos1:
                                type: str
                                description: Queue number of CoS 1.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            cos2:
                                type: str
                                description: Queue number of CoS 2.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            cos3:
                                type: str
                                description: Queue number of CoS 3.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            cos4:
                                type: str
                                description: Queue number of CoS 4.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            cos5:
                                type: str
                                description: Queue number of CoS 5.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            cos6:
                                type: str
                                description: Queue number of CoS 6.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            cos7:
                                type: str
                                description: Queue number of CoS 7.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp0:
                                type: str
                                description: Queue number of DSCP 0.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp1:
                                type: str
                                description: Queue number of DSCP 1.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp10:
                                type: str
                                description: Queue number of DSCP 10.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp11:
                                type: str
                                description: Queue number of DSCP 11.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp12:
                                type: str
                                description: Queue number of DSCP 12.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp13:
                                type: str
                                description: Queue number of DSCP 13.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp14:
                                type: str
                                description: Queue number of DSCP 14.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp15:
                                type: str
                                description: Queue number of DSCP 15.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp16:
                                type: str
                                description: Queue number of DSCP 16.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp17:
                                type: str
                                description: Queue number of DSCP 17.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp18:
                                type: str
                                description: Queue number of DSCP 18.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp19:
                                type: str
                                description: Queue number of DSCP 19.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp2:
                                type: str
                                description: Queue number of DSCP 2.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp20:
                                type: str
                                description: Queue number of DSCP 20.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp21:
                                type: str
                                description: Queue number of DSCP 21.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp22:
                                type: str
                                description: Queue number of DSCP 22.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp23:
                                type: str
                                description: Queue number of DSCP 23.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp24:
                                type: str
                                description: Queue number of DSCP 24.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp25:
                                type: str
                                description: Queue number of DSCP 25.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp26:
                                type: str
                                description: Queue number of DSCP 26.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp27:
                                type: str
                                description: Queue number of DSCP 27.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp28:
                                type: str
                                description: Queue number of DSCP 28.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp29:
                                type: str
                                description: Queue number of DSCP 29.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp3:
                                type: str
                                description: Queue number of DSCP 3.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp30:
                                type: str
                                description: Queue number of DSCP 30.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp31:
                                type: str
                                description: Queue number of DSCP 31.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp32:
                                type: str
                                description: Queue number of DSCP 32.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp33:
                                type: str
                                description: Queue number of DSCP 33.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp34:
                                type: str
                                description: Queue number of DSCP 34.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp35:
                                type: str
                                description: Queue number of DSCP 35.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp36:
                                type: str
                                description: Queue number of DSCP 36.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp37:
                                type: str
                                description: Queue number of DSCP 37.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp38:
                                type: str
                                description: Queue number of DSCP 38.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp39:
                                type: str
                                description: Queue number of DSCP 39.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp4:
                                type: str
                                description: Queue number of DSCP 4.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp40:
                                type: str
                                description: Queue number of DSCP 40.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp41:
                                type: str
                                description: Queue number of DSCP 41.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp42:
                                type: str
                                description: Queue number of DSCP 42.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp43:
                                type: str
                                description: Queue number of DSCP 43.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp44:
                                type: str
                                description: Queue number of DSCP 44.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp45:
                                type: str
                                description: Queue number of DSCP 45.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp46:
                                type: str
                                description: Queue number of DSCP 46.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp47:
                                type: str
                                description: Queue number of DSCP 47.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp48:
                                type: str
                                description: Queue number of DSCP 48.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp49:
                                type: str
                                description: Queue number of DSCP 49.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp5:
                                type: str
                                description: Queue number of DSCP 5.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp50:
                                type: str
                                description: Queue number of DSCP 50.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp51:
                                type: str
                                description: Queue number of DSCP 51.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp52:
                                type: str
                                description: Queue number of DSCP 52.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp53:
                                type: str
                                description: Queue number of DSCP 53.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp54:
                                type: str
                                description: Queue number of DSCP 54.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp55:
                                type: str
                                description: Queue number of DSCP 55.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp56:
                                type: str
                                description: Queue number of DSCP 56.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp57:
                                type: str
                                description: Queue number of DSCP 57.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp58:
                                type: str
                                description: Queue number of DSCP 58.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp59:
                                type: str
                                description: Queue number of DSCP 59.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp6:
                                type: str
                                description: Queue number of DSCP 6.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp60:
                                type: str
                                description: Queue number of DSCP 60.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp61:
                                type: str
                                description: Queue number of DSCP 61.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp62:
                                type: str
                                description: Queue number of DSCP 62.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp63:
                                type: str
                                description: Queue number of DSCP 63.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp7:
                                type: str
                                description: Queue number of DSCP 7.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp8:
                                type: str
                                description: Queue number of DSCP 8.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            dscp9:
                                type: str
                                description: Queue number of DSCP 9.
                                choices:
                                    - 'queue0'
                                    - 'queue1'
                                    - 'queue2'
                                    - 'queue3'
                                    - 'queue4'
                                    - 'queue5'
                                    - 'queue6'
                                    - 'queue7'
                            id:
                                type: int
                                description: Profile ID.
                            type:
                                type: str
                                description: Profile type.
                                choices:
                                    - 'cos'
                                    - 'dscp'
                            weight:
                                type: int
                                description: Class weight.
                    scheduler:
                        description: description
                        type: list
                        elements: dict
                        suboptions:
                            mode:
                                type: str
                                description: Scheduler mode.
                                choices:
                                    - 'none'
                                    - 'priority'
                                    - 'round-robin'
                            name:
                                type: str
                                description: Scheduler name.
            max-session-timeout:
                type: int
                description: Maximum time interval for refreshing NPU-offloaded sessions
            htx-icmp-csum-chk:
                type: str
                description: Set HTX icmp csum checking mode.
                choices:
                    - 'pass'
                    - 'drop'
            pba-eim:
                type: str
                description: Configure option for PBA
                choices:
                    - 'disallow'
                    - 'allow'
            qtm-buf-mode:
                type: str
                description: QTM channel configuration for packet buffer.
                choices:
                    - '6ch'
                    - '4ch'
            tcp-timeout-profile:
                description: description
                type: list
                elements: dict
                suboptions:
                    close-wait:
                        type: int
                        description: Set close-wait timeout
                    fin-wait:
                        type: int
                        description: Set fin-wait timeout
                    id:
                        type: int
                        description: Timeout profile ID
                    syn-sent:
                        type: int
                        description: Set syn-sent timeout
                    syn-wait:
                        type: int
                        description: Set syn-wait timeout
                    tcp-idle:
                        type: int
                        description: Set TCP establish timeout
                    time-wait:
                        type: int
                        description: Set time-wait timeout
            session-acct-interval:
                type: int
                description: Session accounting update interval
            hash-config:
                type: str
                description: Configure NPU trunk hash.
                choices:
                    - '5-tuple'
                    - 'src-ip'
                    - 'src-dst-ip'
            htab-msg-queue:
                type: str
                description: Set hash table message queue mode.
                choices:
                    - 'idle'
                    - 'data'
                    - 'dedicated'
            gtp-support:
                type: str
                description: Enable/Disable NP7 GTP support
                choices:
                    - 'disable'
                    - 'enable'
            background-sse-scan:
                description: no description
                type: dict
                required: false
                suboptions:
                    scan:
                        type: str
                        description: Enable/disable background SSE scan by driver thread
                        choices:
                            - 'disable'
                            - 'enable'
                    stats-update-interval:
                        type: int
                        description: Stats update interval
                    udp-keepalive-interval:
                        type: int
                        description: UDP keepalive interval
            napi-break-interval:
                type: int
                description: NAPI break interval
            dsw-dts-profile:
                description: description
                type: list
                elements: dict
                suboptions:
                    action:
                        type: str
                        description: Set NPU DSW DTS profile action.
                        choices:
                            - 'wait'
                            - 'drop'
                            - 'drop_tmr_0'
                            - 'drop_tmr_1'
                            - 'enque'
                            - 'enque_0'
                            - 'enque_1'
                    min-limit:
                        type: int
                        description: Set NPU DSW DTS profile min-limt.
                    profile-id:
                        type: int
                        description: Set NPU DSW DTS profile profile id.
                    step:
                        type: int
                        description: Set NPU DSW DTS profile step.
            port-path-option:
                description: no description
                type: dict
                required: false
                suboptions:
                    ports-using-npu:
                        description: description
                        type: str
            hpe:
                description: no description
                type: dict
                required: false
                suboptions:
                    all-protocol:
                        type: int
                        description: Maximum packet rate of each host queue except high priority traffic
                    arp-max:
                        type: int
                        description: Maximum ARP packet rate
                    enable-shaper:
                        type: str
                        description: Enable/Disable NPU Host Protection Engine
                        choices:
                            - 'disable'
                            - 'enable'
                    esp-max:
                        type: int
                        description: Maximum ESP packet rate
                    high-priority:
                        type: int
                        description: Maximum packet rate for high priority traffic packets
                    icmp-max:
                        type: int
                        description: Maximum ICMP packet rate
                    ip-frag-max:
                        type: int
                        description: Maximum fragmented IP packet rate
                    ip-others-max:
                        type: int
                        description: Maximum IP packet rate for other packets
                    l2-others-max:
                        type: int
                        description: Maximum L2 packet rate for L2 packets that are not ARP packets
                    pri-type-max:
                        type: int
                        description: Maximum overflow rate of priority type traffic
                    sctp-max:
                        type: int
                        description: Maximum SCTP packet rate
                    tcp-max:
                        type: int
                        description: Maximum TCP packet rate
                    tcpfin-rst-max:
                        type: int
                        description: Maximum TCP carries FIN or RST flags packet rate
                    tcpsyn-ack-max:
                        type: int
                        description: Maximum TCP carries SYN and ACK flags packet rate
                    tcpsyn-max:
                        type: int
                        description: Maximum TCP SYN packet rate
                    udp-max:
                        type: int
                        description: Maximum UDP packet rate
            dsw-queue-dts-profile:
                description: description
                type: list
                elements: dict
                suboptions:
                    iport:
                        type: str
                        description: Set NPU DSW DTS in port.
                        choices:
                            - 'EIF0'
                            - 'eif0'
                            - 'EIF1'
                            - 'eif1'
                            - 'EIF2'
                            - 'eif2'
                            - 'EIF3'
                            - 'eif3'
                            - 'EIF4'
                            - 'eif4'
                            - 'EIF5'
                            - 'eif5'
                            - 'EIF6'
                            - 'eif6'
                            - 'EIF7'
                            - 'eif7'
                            - 'HTX0'
                            - 'htx0'
                            - 'HTX1'
                            - 'htx1'
                            - 'SSE0'
                            - 'sse0'
                            - 'SSE1'
                            - 'sse1'
                            - 'SSE2'
                            - 'sse2'
                            - 'SSE3'
                            - 'sse3'
                            - 'RLT'
                            - 'rlt'
                            - 'DFR'
                            - 'dfr'
                            - 'IPSECI'
                            - 'ipseci'
                            - 'IPSECO'
                            - 'ipseco'
                            - 'IPTI'
                            - 'ipti'
                            - 'IPTO'
                            - 'ipto'
                            - 'VEP0'
                            - 'vep0'
                            - 'VEP2'
                            - 'vep2'
                            - 'VEP4'
                            - 'vep4'
                            - 'VEP6'
                            - 'vep6'
                            - 'IVS'
                            - 'ivs'
                            - 'L2TI1'
                            - 'l2ti1'
                            - 'L2TO'
                            - 'l2to'
                            - 'L2TI0'
                            - 'l2ti0'
                            - 'PLE'
                            - 'ple'
                            - 'SPATH'
                            - 'spath'
                            - 'QTM'
                            - 'qtm'
                    name:
                        type: str
                        description: Name.
                    oport:
                        type: str
                        description: Set NPU DSW DTS out port.
                        choices:
                            - 'EIF0'
                            - 'eif0'
                            - 'EIF1'
                            - 'eif1'
                            - 'EIF2'
                            - 'eif2'
                            - 'EIF3'
                            - 'eif3'
                            - 'EIF4'
                            - 'eif4'
                            - 'EIF5'
                            - 'eif5'
                            - 'EIF6'
                            - 'eif6'
                            - 'EIF7'
                            - 'eif7'
                            - 'HRX'
                            - 'hrx'
                            - 'SSE0'
                            - 'sse0'
                            - 'SSE1'
                            - 'sse1'
                            - 'SSE2'
                            - 'sse2'
                            - 'SSE3'
                            - 'sse3'
                            - 'RLT'
                            - 'rlt'
                            - 'DFR'
                            - 'dfr'
                            - 'IPSECI'
                            - 'ipseci'
                            - 'IPSECO'
                            - 'ipseco'
                            - 'IPTI'
                            - 'ipti'
                            - 'IPTO'
                            - 'ipto'
                            - 'VEP0'
                            - 'vep0'
                            - 'VEP2'
                            - 'vep2'
                            - 'VEP4'
                            - 'vep4'
                            - 'VEP6'
                            - 'vep6'
                            - 'IVS'
                            - 'ivs'
                            - 'L2TI1'
                            - 'l2ti1'
                            - 'L2TO'
                            - 'l2to'
                            - 'L2TI0'
                            - 'l2ti0'
                            - 'PLE'
                            - 'ple'
                            - 'SYNK'
                            - 'sync'
                            - 'NSS'
                            - 'nss'
                            - 'TSK'
                            - 'tsk'
                            - 'QTM'
                            - 'qtm'
                            - 'l2tO'
                    profile-id:
                        type: int
                        description: Set NPU DSW DTS profile ID.
                    queue-select:
                        type: int
                        description: Set NPU DSW DTS queue ID select
            ip-reassembly:
                description: no description
                type: dict
                required: false
                suboptions:
                    max-timeout:
                        type: int
                        description: Maximum timeout value for IP reassembly
                    min-timeout:
                        type: int
                        description: Minimum timeout value for IP reassembly
                    status:
                        type: str
                        description: Set IP reassembly processing status.
                        choices:
                            - 'disable'
                            - 'enable'
            dse-timeout:
                type: int
                description: DSE timeout in seconds
            tcp-rst-timeout:
                type: int
                description: TCP RST timeout in seconds
            inbound-dscp-copy-port:
                description: description
                type: str
            double-level-mcast-offload:
                type: str
                description: Enable double level mcast offload.
                choices:
                    - 'disable'
                    - 'enable'
            default-qos-type:
                type: str
                description: Set default QoS type.
                choices:
                    - 'policing'
                    - 'shaping'
                    - 'policing-enhanced'
            udp-timeout-profile:
                description: description
                type: list
                elements: dict
                suboptions:
                    id:
                        type: int
                        description: Timeout profile ID
                    udp-idle:
                        type: int
                        description: Set UDP idle timeout
            isf-np-rx-tr-distr:
                type: str
                description: Select ISF NP Rx trunk distribution
                choices:
                    - 'port-flow'
                    - 'round-robin'
                    - 'randomized'
            nat46-force-ipv4-packet-forwarding:
                type: str
                description: Enable/disable mandatory IPv4 packet forwarding in nat46.
                choices:
                    - 'disable'
                    - 'enable'
            rps-mode:
                type: str
                description: Enable/disable receive packet steering
                choices:
                    - 'disable'
                    - 'enable'
            mcast-session-counting6:
                type: str
                description: Enable/disable traffic accounting for each multicast session6 through TAE counter.
                choices:
                    - 'disable'
                    - 'enable'
                    - 'session-based'
                    - 'tpe-based'
            prp-port-out:
                description: description
                type: str
            per-policy-accounting:
                type: str
                description: Set per-policy accounting.
                choices:
                    - 'disable'
                    - 'enable'
            prp-port-in:
                description: description
                type: str
            inbound-dscp-copy:
                type: str
                description: Enable/disable copying the DSCP field from outer IP header to inner IP Header.
                choices:
                    - 'disable'
                    - 'enable'
            mcast-session-counting:
                type: str
                description: no description
                choices:
                    - 'disable'
                    - 'enable'
                    - 'session-based'
                    - 'tpe-based'
            ipsec-host-dfclr:
                type: str
                description: Enable/disable DF clearing of NP4lite host IPsec offload.
                choices:
                    - 'disable'
                    - 'enable'
            process-icmp-by-host:
                type: str
                description: Enable/disable process ICMP by host when received from IPsec tunnel and payload size
                choices:
                    - 'disable'
                    - 'enable'
            dedicated-tx-npu:
                type: str
                description: Enable/disable dedication of 3rd NPU for slow path TX.
                choices:
                    - 'disable'
                    - 'enable'
            ull-port-mode:
                type: str
                description: Set ULL ports speed to 10G/25G
                choices:
                    - '10G'
                    - '25G'
            sse-ha-scan:
                description: no description
                type: dict
                required: false
                suboptions:
                    gap:
                        type: int
                        description: Scanning message gap
                    max-session-cnt:
                        type: int
                        description: If the session count
                    min-duration:
                        type: int
                        description: Scanning filter for minimum duration of the session.
            hash-ipv6-sel:
                type: int
                description: Select which 4bytes of the IPv6 address are used for traffic hash
            ip-fragment-offload:
                type: str
                description: Enable/disable NP7 NPU IP fragment offload.
                choices:
                    - 'disable'
                    - 'enable'
            ple-non-syn-tcp-action:
                type: str
                description: Configure action for the PLE to take on TCP packets that have the SYN field unset.
                choices:
                    - 'forward'
                    - 'drop'
            npu-group-effective-scope:
                type: int
                description: npu-group-effective-scope defines under which npu-group cmds such as list/purge will be excecuted.
            prp-session-clear-mode:
                type: str
                description: PRP session clear mode for excluded ip sessions.
                choices:
                    - 'blocking'
                    - 'non-blocking'
                    - 'do-not-clear'
            shaping-stats:
                type: str
                description: Enable/disable NP7 traffic shaping statistics
                choices:
                    - 'disable'
                    - 'enable'
            sw-tr-hash:
                description: no description
                type: dict
                required: false
                suboptions:
                    draco15:
                        type: str
                        description: Enable/disable DRACO15 hashing.
                        choices:
                            - 'disable'
                            - 'enable'
                    tcp-udp-port:
                        type: str
                        description: Include/exclude TCP/UDP source and destination port for unicast trunk traffic.
                        choices:
                            - 'include'
                            - 'exclude'

'''

EXAMPLES = '''
 - hosts: fortimanager-inventory
   collections:
     - fortinet.fortimanager
   connection: httpapi
   vars:
      ansible_httpapi_use_ssl: True
      ansible_httpapi_validate_certs: False
      ansible_httpapi_port: 443
   tasks:
    - name: Configure NPU attributes.
      fmgr_system_npu:
         bypass_validation: False
         workspace_locking_adom: <value in [global, custom adom including root]>
         workspace_locking_timeout: 300
         rc_succeeded: [0, -2, -3, ...]
         rc_failed: [-2, -3, ...]
         adom: <your own value>
         system_npu:
            capwap-offload: <value in [disable, enable]>
            dedicated-management-affinity: <value of string>
            dedicated-management-cpu: <value in [disable, enable]>
            fastpath: <value in [disable, enable]>
            fp-anomaly:
               esp-minlen-err: <value in [drop, trap-to-host]>
               icmp-csum-err: <value in [drop, trap-to-host]>
               icmp-minlen-err: <value in [drop, trap-to-host]>
               ipv4-csum-err: <value in [drop, trap-to-host]>
               ipv4-ihl-err: <value in [drop, trap-to-host]>
               ipv4-len-err: <value in [drop, trap-to-host]>
               ipv4-opt-err: <value in [drop, trap-to-host]>
               ipv4-ttlzero-err: <value in [drop, trap-to-host]>
               ipv4-ver-err: <value in [drop, trap-to-host]>
               ipv6-exthdr-len-err: <value in [drop, trap-to-host]>
               ipv6-exthdr-order-err: <value in [drop, trap-to-host]>
               ipv6-ihl-err: <value in [drop, trap-to-host]>
               ipv6-plen-zero: <value in [drop, trap-to-host]>
               ipv6-ver-err: <value in [drop, trap-to-host]>
               tcp-csum-err: <value in [drop, trap-to-host]>
               tcp-hlen-err: <value in [drop, trap-to-host]>
               tcp-plen-err: <value in [drop, trap-to-host]>
               udp-csum-err: <value in [drop, trap-to-host]>
               udp-hlen-err: <value in [drop, trap-to-host]>
               udp-len-err: <value in [drop, trap-to-host]>
               udp-plen-err: <value in [drop, trap-to-host]>
               udplite-cover-err: <value in [drop, trap-to-host]>
               udplite-csum-err: <value in [drop, trap-to-host]>
               unknproto-minlen-err: <value in [drop, trap-to-host]>
               tcp-land: <value in [allow, drop, trap-to-host]>
               tcp-fin-noack: <value in [allow, drop, trap-to-host]>
               tcp-syn-data: <value in [allow, drop, trap-to-host]>
               tcp-winnuke: <value in [allow, drop, trap-to-host]>
               ipv4-optssrr: <value in [allow, drop, trap-to-host]>
               ipv6-proto-err: <value in [allow, drop, trap-to-host]>
               ipv6-land: <value in [allow, drop, trap-to-host]>
               tcp-no-flag: <value in [allow, drop, trap-to-host]>
               ipv4-land: <value in [allow, drop, trap-to-host]>
               ipv4-optlsrr: <value in [allow, drop, trap-to-host]>
               udp-land: <value in [allow, drop, trap-to-host]>
               icmp-frag: <value in [allow, drop, trap-to-host]>
               ipv6-optendpid: <value in [allow, drop, trap-to-host]>
               ipv4-opttimestamp: <value in [allow, drop, trap-to-host]>
               ipv4-optrr: <value in [allow, drop, trap-to-host]>
               ipv6-unknopt: <value in [allow, drop, trap-to-host]>
               tcp-fin-only: <value in [allow, drop, trap-to-host]>
               tcp-syn-fin: <value in [allow, drop, trap-to-host]>
               ipv6-optinvld: <value in [allow, drop, trap-to-host]>
               ipv6-saddr-err: <value in [allow, drop, trap-to-host]>
               ipv4-proto-err: <value in [allow, drop, trap-to-host]>
               ipv4-optstream: <value in [allow, drop, trap-to-host]>
               ipv6-optnsap: <value in [allow, drop, trap-to-host]>
               icmp-land: <value in [allow, drop, trap-to-host]>
               ipv6-optjumbo: <value in [allow, drop, trap-to-host]>
               ipv4-optsecurity: <value in [allow, drop, trap-to-host]>
               ipv6-optralert: <value in [allow, drop, trap-to-host]>
               ipv6-daddr-err: <value in [allow, drop, trap-to-host]>
               ipv6-opthomeaddr: <value in [allow, drop, trap-to-host]>
               ipv4-unknopt: <value in [allow, drop, trap-to-host]>
               ipv6-opttunnel: <value in [allow, drop, trap-to-host]>
               uesp-minlen-err: <value in [drop, trap-to-host]>
               vxlan-minlen-err: <value in [drop, trap-to-host]>
               sctp-crc-err: <value in [drop, trap-to-host]>
               nvgre-minlen-err: <value in [drop, trap-to-host]>
               sctp-l4len-err: <value in [drop, trap-to-host]>
               sctp-clen-err: <value in [drop, trap-to-host]>
               gtpu-plen-err: <value in [drop, trap-to-host]>
               capwap-minlen-err: <value in [drop, trap-to-host]>
               gre-csum-err: <value in [drop, trap-to-host]>
               tcp-hlenvsl4len-err: <value in [drop, trap-to-host]>
            gtp-enhanced-cpu-range: <value in [0, 1, 2]>
            gtp-enhanced-mode: <value in [disable, enable]>
            host-shortcut-mode: <value in [bi-directional, host-shortcut]>
            htx-gtse-quota: <value in [100Mbps, 200Mbps, 300Mbps, ...]>
            intf-shaping-offload: <value in [disable, enable]>
            iph-rsvd-re-cksum: <value in [disable, enable]>
            ipsec-dec-subengine-mask: <value of string>
            ipsec-enc-subengine-mask: <value of string>
            ipsec-inbound-cache: <value in [disable, enable]>
            ipsec-mtu-override: <value in [disable, enable]>
            ipsec-over-vlink: <value in [disable, enable]>
            isf-np-queues:
               cos0: <value of string>
               cos1: <value of string>
               cos2: <value of string>
               cos3: <value of string>
               cos4: <value of string>
               cos5: <value of string>
               cos6: <value of string>
               cos7: <value of string>
            lag-out-port-select: <value in [disable, enable]>
            mcast-session-accounting: <value in [disable, session-based, tpe-based]>
            np6-cps-optimization-mode: <value in [disable, enable]>
            per-session-accounting: <value in [enable, disable, enable-by-log, ...]>
            port-cpu-map:
              -
                  cpu-core: <value of string>
                  interface: <value of string>
            port-npu-map:
              -
                  interface: <value of string>
                  npu-group-index: <value of integer>
            priority-protocol:
               bfd: <value in [disable, enable]>
               bgp: <value in [disable, enable]>
               slbc: <value in [disable, enable]>
            qos-mode: <value in [disable, priority, round-robin]>
            rdp-offload: <value in [disable, enable]>
            recover-np6-link: <value in [disable, enable]>
            session-denied-offload: <value in [disable, enable]>
            sse-backpressure: <value in [disable, enable]>
            strip-clear-text-padding: <value in [disable, enable]>
            strip-esp-padding: <value in [disable, enable]>
            sw-eh-hash:
               computation: <value in [xor16, xor8, xor4, ...]>
               destination-ip-lower-16: <value in [include, exclude]>
               destination-ip-upper-16: <value in [include, exclude]>
               destination-port: <value in [include, exclude]>
               ip-protocol: <value in [include, exclude]>
               netmask-length: <value of integer>
               source-ip-lower-16: <value in [include, exclude]>
               source-ip-upper-16: <value in [include, exclude]>
               source-port: <value in [include, exclude]>
            sw-np-bandwidth: <value in [0G, 2G, 4G, ...]>
            switch-np-hash: <value in [src-ip, dst-ip, src-dst-ip]>
            uesp-offload: <value in [disable, enable]>
            policy-offload-level: <value in [disable, dos-offload, full-offload]>
            htab-dedi-queue-nr: <value of integer>
            vlan-lookup-cache: <value in [disable, enable]>
            ippool-overload-high: <value of integer>
            ippool-overload-low: <value of integer>
            hw-ha-scan-interval: <value of integer>
            hash-tbl-spread: <value in [disable, enable]>
            ipsec-local-uesp-port: <value of integer>
            ipsec-ob-np-sel: <value in [RR, rr, Packet, ...]>
            dos-options:
               npu-dos-meter-mode: <value in [local, global]>
               npu-dos-synproxy-mode: <value in [synack2ack, pass-synack]>
               npu-dos-tpe-mode: <value in [disable, enable]>
            np-queues:
               ethernet-type:
                 -
                     name: <value of string>
                     queue: <value of integer>
                     type: <value of integer>
                     weight: <value of integer>
               ip-protocol:
                 -
                     name: <value of string>
                     protocol: <value of integer>
                     queue: <value of integer>
                     weight: <value of integer>
               ip-service:
                 -
                     dport: <value of integer>
                     name: <value of string>
                     protocol: <value of integer>
                     queue: <value of integer>
                     sport: <value of integer>
                     weight: <value of integer>
               profile:
                 -
                     cos0: <value in [queue0, queue1, queue2, ...]>
                     cos1: <value in [queue0, queue1, queue2, ...]>
                     cos2: <value in [queue0, queue1, queue2, ...]>
                     cos3: <value in [queue0, queue1, queue2, ...]>
                     cos4: <value in [queue0, queue1, queue2, ...]>
                     cos5: <value in [queue0, queue1, queue2, ...]>
                     cos6: <value in [queue0, queue1, queue2, ...]>
                     cos7: <value in [queue0, queue1, queue2, ...]>
                     dscp0: <value in [queue0, queue1, queue2, ...]>
                     dscp1: <value in [queue0, queue1, queue2, ...]>
                     dscp10: <value in [queue0, queue1, queue2, ...]>
                     dscp11: <value in [queue0, queue1, queue2, ...]>
                     dscp12: <value in [queue0, queue1, queue2, ...]>
                     dscp13: <value in [queue0, queue1, queue2, ...]>
                     dscp14: <value in [queue0, queue1, queue2, ...]>
                     dscp15: <value in [queue0, queue1, queue2, ...]>
                     dscp16: <value in [queue0, queue1, queue2, ...]>
                     dscp17: <value in [queue0, queue1, queue2, ...]>
                     dscp18: <value in [queue0, queue1, queue2, ...]>
                     dscp19: <value in [queue0, queue1, queue2, ...]>
                     dscp2: <value in [queue0, queue1, queue2, ...]>
                     dscp20: <value in [queue0, queue1, queue2, ...]>
                     dscp21: <value in [queue0, queue1, queue2, ...]>
                     dscp22: <value in [queue0, queue1, queue2, ...]>
                     dscp23: <value in [queue0, queue1, queue2, ...]>
                     dscp24: <value in [queue0, queue1, queue2, ...]>
                     dscp25: <value in [queue0, queue1, queue2, ...]>
                     dscp26: <value in [queue0, queue1, queue2, ...]>
                     dscp27: <value in [queue0, queue1, queue2, ...]>
                     dscp28: <value in [queue0, queue1, queue2, ...]>
                     dscp29: <value in [queue0, queue1, queue2, ...]>
                     dscp3: <value in [queue0, queue1, queue2, ...]>
                     dscp30: <value in [queue0, queue1, queue2, ...]>
                     dscp31: <value in [queue0, queue1, queue2, ...]>
                     dscp32: <value in [queue0, queue1, queue2, ...]>
                     dscp33: <value in [queue0, queue1, queue2, ...]>
                     dscp34: <value in [queue0, queue1, queue2, ...]>
                     dscp35: <value in [queue0, queue1, queue2, ...]>
                     dscp36: <value in [queue0, queue1, queue2, ...]>
                     dscp37: <value in [queue0, queue1, queue2, ...]>
                     dscp38: <value in [queue0, queue1, queue2, ...]>
                     dscp39: <value in [queue0, queue1, queue2, ...]>
                     dscp4: <value in [queue0, queue1, queue2, ...]>
                     dscp40: <value in [queue0, queue1, queue2, ...]>
                     dscp41: <value in [queue0, queue1, queue2, ...]>
                     dscp42: <value in [queue0, queue1, queue2, ...]>
                     dscp43: <value in [queue0, queue1, queue2, ...]>
                     dscp44: <value in [queue0, queue1, queue2, ...]>
                     dscp45: <value in [queue0, queue1, queue2, ...]>
                     dscp46: <value in [queue0, queue1, queue2, ...]>
                     dscp47: <value in [queue0, queue1, queue2, ...]>
                     dscp48: <value in [queue0, queue1, queue2, ...]>
                     dscp49: <value in [queue0, queue1, queue2, ...]>
                     dscp5: <value in [queue0, queue1, queue2, ...]>
                     dscp50: <value in [queue0, queue1, queue2, ...]>
                     dscp51: <value in [queue0, queue1, queue2, ...]>
                     dscp52: <value in [queue0, queue1, queue2, ...]>
                     dscp53: <value in [queue0, queue1, queue2, ...]>
                     dscp54: <value in [queue0, queue1, queue2, ...]>
                     dscp55: <value in [queue0, queue1, queue2, ...]>
                     dscp56: <value in [queue0, queue1, queue2, ...]>
                     dscp57: <value in [queue0, queue1, queue2, ...]>
                     dscp58: <value in [queue0, queue1, queue2, ...]>
                     dscp59: <value in [queue0, queue1, queue2, ...]>
                     dscp6: <value in [queue0, queue1, queue2, ...]>
                     dscp60: <value in [queue0, queue1, queue2, ...]>
                     dscp61: <value in [queue0, queue1, queue2, ...]>
                     dscp62: <value in [queue0, queue1, queue2, ...]>
                     dscp63: <value in [queue0, queue1, queue2, ...]>
                     dscp7: <value in [queue0, queue1, queue2, ...]>
                     dscp8: <value in [queue0, queue1, queue2, ...]>
                     dscp9: <value in [queue0, queue1, queue2, ...]>
                     id: <value of integer>
                     type: <value in [cos, dscp]>
                     weight: <value of integer>
               scheduler:
                 -
                     mode: <value in [none, priority, round-robin]>
                     name: <value of string>
            max-session-timeout: <value of integer>
            htx-icmp-csum-chk: <value in [pass, drop]>
            pba-eim: <value in [disallow, allow]>
            qtm-buf-mode: <value in [6ch, 4ch]>
            tcp-timeout-profile:
              -
                  close-wait: <value of integer>
                  fin-wait: <value of integer>
                  id: <value of integer>
                  syn-sent: <value of integer>
                  syn-wait: <value of integer>
                  tcp-idle: <value of integer>
                  time-wait: <value of integer>
            session-acct-interval: <value of integer>
            hash-config: <value in [5-tuple, src-ip, src-dst-ip]>
            htab-msg-queue: <value in [idle, data, dedicated]>
            gtp-support: <value in [disable, enable]>
            background-sse-scan:
               scan: <value in [disable, enable]>
               stats-update-interval: <value of integer>
               udp-keepalive-interval: <value of integer>
            napi-break-interval: <value of integer>
            dsw-dts-profile:
              -
                  action: <value in [wait, drop, drop_tmr_0, ...]>
                  min-limit: <value of integer>
                  profile-id: <value of integer>
                  step: <value of integer>
            port-path-option:
               ports-using-npu: <value of string>
            hpe:
               all-protocol: <value of integer>
               arp-max: <value of integer>
               enable-shaper: <value in [disable, enable]>
               esp-max: <value of integer>
               high-priority: <value of integer>
               icmp-max: <value of integer>
               ip-frag-max: <value of integer>
               ip-others-max: <value of integer>
               l2-others-max: <value of integer>
               pri-type-max: <value of integer>
               sctp-max: <value of integer>
               tcp-max: <value of integer>
               tcpfin-rst-max: <value of integer>
               tcpsyn-ack-max: <value of integer>
               tcpsyn-max: <value of integer>
               udp-max: <value of integer>
            dsw-queue-dts-profile:
              -
                  iport: <value in [EIF0, eif0, EIF1, ...]>
                  name: <value of string>
                  oport: <value in [EIF0, eif0, EIF1, ...]>
                  profile-id: <value of integer>
                  queue-select: <value of integer>
            ip-reassembly:
               max-timeout: <value of integer>
               min-timeout: <value of integer>
               status: <value in [disable, enable]>
            dse-timeout: <value of integer>
            tcp-rst-timeout: <value of integer>
            inbound-dscp-copy-port: <value of string>
            double-level-mcast-offload: <value in [disable, enable]>
            default-qos-type: <value in [policing, shaping, policing-enhanced]>
            udp-timeout-profile:
              -
                  id: <value of integer>
                  udp-idle: <value of integer>
            isf-np-rx-tr-distr: <value in [port-flow, round-robin, randomized]>
            nat46-force-ipv4-packet-forwarding: <value in [disable, enable]>
            rps-mode: <value in [disable, enable]>
            mcast-session-counting6: <value in [disable, enable, session-based, ...]>
            prp-port-out: <value of string>
            per-policy-accounting: <value in [disable, enable]>
            prp-port-in: <value of string>
            inbound-dscp-copy: <value in [disable, enable]>
            mcast-session-counting: <value in [disable, enable, session-based, ...]>
            ipsec-host-dfclr: <value in [disable, enable]>
            process-icmp-by-host: <value in [disable, enable]>
            dedicated-tx-npu: <value in [disable, enable]>
            ull-port-mode: <value in [10G, 25G]>
            sse-ha-scan:
               gap: <value of integer>
               max-session-cnt: <value of integer>
               min-duration: <value of integer>
            hash-ipv6-sel: <value of integer>
            ip-fragment-offload: <value in [disable, enable]>
            ple-non-syn-tcp-action: <value in [forward, drop]>
            npu-group-effective-scope: <value of integer>
            prp-session-clear-mode: <value in [blocking, non-blocking, do-not-clear]>
            shaping-stats: <value in [disable, enable]>
            sw-tr-hash:
               draco15: <value in [disable, enable]>
               tcp-udp-port: <value in [include, exclude]>

'''

RETURN = '''
meta:
    description: The result of the request.
    type: dict
    returned: always
    contains:
        request_url:
            description: The full url requested.
            returned: always
            type: str
            sample: /sys/login/user
        response_code:
            description: The status of api request.
            returned: always
            type: int
            sample: 0
        response_data:
            description: The api response.
            type: list
            returned: always
        response_message:
            description: The descriptive message of the api response.
            type: str
            returned: always
            sample: OK.
        system_information:
            description: The information of the target system.
            type: dict
            returned: always
rc:
    description: The status the request.
    type: int
    returned: always
    sample: 0
version_check_warning:
    description: Warning if the parameters used in the playbook are not supported by the current FortiManager version.
    type: list
    returned: complex
'''
from ansible.module_utils.basic import AnsibleModule
from ansible.module_utils.connection import Connection
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import NAPIManager
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import check_galaxy_version
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import check_parameter_bypass


def main():
    jrpc_urls = [
        '/pm/config/global/obj/system/npu',
        '/pm/config/adom/{adom}/obj/system/npu'
    ]

    perobject_jrpc_urls = [
        '/pm/config/global/obj/system/npu/{npu}',
        '/pm/config/adom/{adom}/obj/system/npu/{npu}'
    ]

    url_params = ['adom']
    module_primary_key = None
    module_arg_spec = {
        'access_token': {
            'type': 'str',
            'required': False,
            'no_log': True
        },
        'bypass_validation': {
            'type': 'bool',
            'required': False,
            'default': False
        },
        'enable_log': {
            'type': 'bool',
            'required': False,
            'default': False
        },
        'forticloud_access_token': {
            'type': 'str',
            'required': False,
            'no_log': True
        },
        'proposed_method': {
            'type': 'str',
            'required': False,
            'choices': [
                'set',
                'update',
                'add'
            ]
        },
        'rc_succeeded': {
            'required': False,
            'type': 'list',
            'elements': 'int'
        },
        'rc_failed': {
            'required': False,
            'type': 'list',
            'elements': 'int'
        },
        'workspace_locking_adom': {
            'type': 'str',
            'required': False
        },
        'workspace_locking_timeout': {
            'type': 'int',
            'required': False,
            'default': 300
        },
        'adom': {
            'required': True,
            'type': 'str'
        },
        'system_npu': {
            'required': False,
            'type': 'dict',
            'revision': {
                '6.4.7': True,
                '6.4.8': True,
                '6.4.9': True,
                '6.4.10': True,
                '6.4.11': True,
                '7.0.1': True,
                '7.0.2': True,
                '7.0.3': True,
                '7.0.4': True,
                '7.0.5': True,
                '7.0.6': True,
                '7.0.7': True,
                '7.2.0': True,
                '7.2.1': True,
                '7.2.2': True,
                '7.4.0': True
            },
            'options': {
                'capwap-offload': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'dedicated-management-affinity': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': False,
                        '6.4.8': False,
                        '6.4.9': False,
                        '6.4.10': False,
                        '6.4.11': False,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'str'
                },
                'dedicated-management-cpu': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'fastpath': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'fp-anomaly': {
                    'required': False,
                    'type': 'dict',
                    'options': {
                        'esp-minlen-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'icmp-csum-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'icmp-minlen-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv4-csum-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv4-ihl-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv4-len-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv4-opt-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv4-ttlzero-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv4-ver-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv6-exthdr-len-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv6-exthdr-order-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv6-ihl-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv6-plen-zero': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv6-ver-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'tcp-csum-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'tcp-hlen-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'tcp-plen-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'udp-csum-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'udp-hlen-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'udp-len-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'udp-plen-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'udplite-cover-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'udplite-csum-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'unknproto-minlen-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'tcp-land': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'tcp-fin-noack': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'tcp-syn-data': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'tcp-winnuke': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv4-optssrr': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv6-proto-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv6-land': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'tcp-no-flag': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv4-land': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv4-optlsrr': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'udp-land': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'icmp-frag': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv6-optendpid': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv4-opttimestamp': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv4-optrr': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv6-unknopt': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'tcp-fin-only': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'tcp-syn-fin': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv6-optinvld': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv6-saddr-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv4-proto-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv4-optstream': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv6-optnsap': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'icmp-land': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv6-optjumbo': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv4-optsecurity': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv6-optralert': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv6-daddr-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv6-opthomeaddr': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv4-unknopt': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'ipv6-opttunnel': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'allow',
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'uesp-minlen-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'vxlan-minlen-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'sctp-crc-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'nvgre-minlen-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'sctp-l4len-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'sctp-clen-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'gtpu-plen-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'capwap-minlen-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'gre-csum-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        },
                        'tcp-hlenvsl4len-err': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'drop',
                                'trap-to-host'
                            ],
                            'type': 'str'
                        }
                    }
                },
                'gtp-enhanced-cpu-range': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        '0',
                        '1',
                        '2'
                    ],
                    'type': 'str'
                },
                'gtp-enhanced-mode': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'host-shortcut-mode': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'bi-directional',
                        'host-shortcut'
                    ],
                    'type': 'str'
                },
                'htx-gtse-quota': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        '100Mbps',
                        '200Mbps',
                        '300Mbps',
                        '400Mbps',
                        '500Mbps',
                        '600Mbps',
                        '700Mbps',
                        '800Mbps',
                        '900Mbps',
                        '1Gbps',
                        '2Gbps',
                        '4Gbps',
                        '8Gbps',
                        '10Gbps'
                    ],
                    'type': 'str'
                },
                'intf-shaping-offload': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'iph-rsvd-re-cksum': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'ipsec-dec-subengine-mask': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'str'
                },
                'ipsec-enc-subengine-mask': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'str'
                },
                'ipsec-inbound-cache': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'ipsec-mtu-override': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'ipsec-over-vlink': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'isf-np-queues': {
                    'required': False,
                    'type': 'dict',
                    'options': {
                        'cos0': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'str'
                        },
                        'cos1': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'str'
                        },
                        'cos2': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'str'
                        },
                        'cos3': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'str'
                        },
                        'cos4': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'str'
                        },
                        'cos5': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'str'
                        },
                        'cos6': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'str'
                        },
                        'cos7': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'str'
                        }
                    }
                },
                'lag-out-port-select': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'mcast-session-accounting': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'session-based',
                        'tpe-based'
                    ],
                    'type': 'str'
                },
                'np6-cps-optimization-mode': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'per-session-accounting': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'enable',
                        'disable',
                        'enable-by-log',
                        'all-enable',
                        'traffic-log-only'
                    ],
                    'type': 'str'
                },
                'port-cpu-map': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'list',
                    'options': {
                        'cpu-core': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'str'
                        },
                        'interface': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'str'
                        }
                    },
                    'elements': 'dict'
                },
                'port-npu-map': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'list',
                    'options': {
                        'interface': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'str'
                        },
                        'npu-group-index': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        }
                    },
                    'elements': 'dict'
                },
                'priority-protocol': {
                    'required': False,
                    'type': 'dict',
                    'options': {
                        'bfd': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        },
                        'bgp': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        },
                        'slbc': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        }
                    }
                },
                'qos-mode': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'priority',
                        'round-robin'
                    ],
                    'type': 'str'
                },
                'rdp-offload': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'recover-np6-link': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'session-denied-offload': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': False,
                        '6.4.8': False,
                        '6.4.9': False,
                        '6.4.10': False,
                        '6.4.11': False,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'sse-backpressure': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'strip-clear-text-padding': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'strip-esp-padding': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'sw-eh-hash': {
                    'required': False,
                    'type': 'dict',
                    'options': {
                        'computation': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': False,
                                '6.4.8': False,
                                '6.4.9': False,
                                '6.4.10': False,
                                '6.4.11': False,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'xor16',
                                'xor8',
                                'xor4',
                                'crc16'
                            ],
                            'type': 'str'
                        },
                        'destination-ip-lower-16': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': False,
                                '6.4.8': False,
                                '6.4.9': False,
                                '6.4.10': False,
                                '6.4.11': False,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'include',
                                'exclude'
                            ],
                            'type': 'str'
                        },
                        'destination-ip-upper-16': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': False,
                                '6.4.8': False,
                                '6.4.9': False,
                                '6.4.10': False,
                                '6.4.11': False,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'include',
                                'exclude'
                            ],
                            'type': 'str'
                        },
                        'destination-port': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': False,
                                '6.4.8': False,
                                '6.4.9': False,
                                '6.4.10': False,
                                '6.4.11': False,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'include',
                                'exclude'
                            ],
                            'type': 'str'
                        },
                        'ip-protocol': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': False,
                                '6.4.8': False,
                                '6.4.9': False,
                                '6.4.10': False,
                                '6.4.11': False,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'include',
                                'exclude'
                            ],
                            'type': 'str'
                        },
                        'netmask-length': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': False,
                                '6.4.8': False,
                                '6.4.9': False,
                                '6.4.10': False,
                                '6.4.11': False,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'source-ip-lower-16': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': False,
                                '6.4.8': False,
                                '6.4.9': False,
                                '6.4.10': False,
                                '6.4.11': False,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'include',
                                'exclude'
                            ],
                            'type': 'str'
                        },
                        'source-ip-upper-16': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': False,
                                '6.4.8': False,
                                '6.4.9': False,
                                '6.4.10': False,
                                '6.4.11': False,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'include',
                                'exclude'
                            ],
                            'type': 'str'
                        },
                        'source-port': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': False,
                                '6.4.8': False,
                                '6.4.9': False,
                                '6.4.10': False,
                                '6.4.11': False,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'include',
                                'exclude'
                            ],
                            'type': 'str'
                        }
                    }
                },
                'sw-np-bandwidth': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        '0G',
                        '2G',
                        '4G',
                        '5G',
                        '6G',
                        '7G',
                        '8G',
                        '9G'
                    ],
                    'type': 'str'
                },
                'switch-np-hash': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'src-ip',
                        'dst-ip',
                        'src-dst-ip'
                    ],
                    'type': 'str'
                },
                'uesp-offload': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'policy-offload-level': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'dos-offload',
                        'full-offload'
                    ],
                    'type': 'str'
                },
                'htab-dedi-queue-nr': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': False,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'int'
                },
                'vlan-lookup-cache': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': False,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'ippool-overload-high': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'int'
                },
                'ippool-overload-low': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'int'
                },
                'hw-ha-scan-interval': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': False,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': False,
                        '7.0.2': False,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'int'
                },
                'hash-tbl-spread': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'ipsec-local-uesp-port': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': False,
                        '6.4.8': False,
                        '6.4.9': False,
                        '6.4.10': False,
                        '6.4.11': False,
                        '7.0.1': False,
                        '7.0.2': False,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'int'
                },
                'ipsec-ob-np-sel': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'RR',
                        'rr',
                        'Packet',
                        'Hash'
                    ],
                    'type': 'str'
                },
                'dos-options': {
                    'required': False,
                    'type': 'dict',
                    'options': {
                        'npu-dos-meter-mode': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'local',
                                'global'
                            ],
                            'type': 'str'
                        },
                        'npu-dos-synproxy-mode': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'synack2ack',
                                'pass-synack'
                            ],
                            'type': 'str'
                        },
                        'npu-dos-tpe-mode': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        }
                    }
                },
                'np-queues': {
                    'required': False,
                    'type': 'dict',
                    'options': {
                        'ethernet-type': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'list',
                            'options': {
                                'name': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'type': 'str'
                                },
                                'queue': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'type': 'int'
                                },
                                'type': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'type': 'int'
                                },
                                'weight': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'type': 'int'
                                }
                            },
                            'elements': 'dict'
                        },
                        'ip-protocol': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'list',
                            'options': {
                                'name': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'type': 'str'
                                },
                                'protocol': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'type': 'int'
                                },
                                'queue': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'type': 'int'
                                },
                                'weight': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'type': 'int'
                                }
                            },
                            'elements': 'dict'
                        },
                        'ip-service': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'list',
                            'options': {
                                'dport': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'type': 'int'
                                },
                                'name': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'type': 'str'
                                },
                                'protocol': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'type': 'int'
                                },
                                'queue': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'type': 'int'
                                },
                                'sport': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'type': 'int'
                                },
                                'weight': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'type': 'int'
                                }
                            },
                            'elements': 'dict'
                        },
                        'profile': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'list',
                            'options': {
                                'cos0': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'cos1': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'cos2': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'cos3': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'cos4': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'cos5': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'cos6': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'cos7': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp0': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp1': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp10': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp11': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp12': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp13': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp14': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp15': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp16': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp17': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp18': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp19': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp2': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp20': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp21': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp22': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp23': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp24': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp25': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp26': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp27': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp28': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp29': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp3': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp30': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp31': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp32': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp33': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp34': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp35': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp36': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp37': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp38': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp39': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp4': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp40': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp41': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp42': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp43': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp44': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp45': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp46': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp47': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp48': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp49': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp5': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp50': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp51': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp52': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp53': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp54': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp55': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp56': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp57': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp58': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp59': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp6': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp60': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp61': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp62': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp63': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp7': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp8': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'dscp9': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'queue0',
                                        'queue1',
                                        'queue2',
                                        'queue3',
                                        'queue4',
                                        'queue5',
                                        'queue6',
                                        'queue7'
                                    ],
                                    'type': 'str'
                                },
                                'id': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'type': 'int'
                                },
                                'type': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'cos',
                                        'dscp'
                                    ],
                                    'type': 'str'
                                },
                                'weight': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'type': 'int'
                                }
                            },
                            'elements': 'dict'
                        },
                        'scheduler': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'list',
                            'options': {
                                'mode': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'choices': [
                                        'none',
                                        'priority',
                                        'round-robin'
                                    ],
                                    'type': 'str'
                                },
                                'name': {
                                    'required': False,
                                    'revision': {
                                        '7.2.0': True,
                                        '6.2.0': False,
                                        '6.2.2': False,
                                        '6.2.6': False,
                                        '6.2.7': False,
                                        '6.2.8': False,
                                        '6.2.9': False,
                                        '6.2.10': False,
                                        '6.4.1': False,
                                        '6.4.3': False,
                                        '6.4.4': False,
                                        '6.4.6': False,
                                        '6.4.7': True,
                                        '6.4.8': True,
                                        '6.4.9': True,
                                        '6.4.10': True,
                                        '6.4.11': True,
                                        '7.0.1': True,
                                        '7.0.2': True,
                                        '7.0.3': True,
                                        '7.0.4': True,
                                        '7.0.5': True,
                                        '7.0.6': True,
                                        '7.0.7': True,
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.4.0': True
                                    },
                                    'type': 'str'
                                }
                            },
                            'elements': 'dict'
                        }
                    }
                },
                'max-session-timeout': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'int'
                },
                'htx-icmp-csum-chk': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': False,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': False,
                        '7.0.2': False,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'pass',
                        'drop'
                    ],
                    'type': 'str'
                },
                'pba-eim': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disallow',
                        'allow'
                    ],
                    'type': 'str'
                },
                'qtm-buf-mode': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': False,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': False,
                        '7.0.2': False,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        '6ch',
                        '4ch'
                    ],
                    'type': 'str'
                },
                'tcp-timeout-profile': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'list',
                    'options': {
                        'close-wait': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'fin-wait': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'id': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'syn-sent': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'syn-wait': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'tcp-idle': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'time-wait': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        }
                    },
                    'elements': 'dict'
                },
                'session-acct-interval': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'int'
                },
                'hash-config': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        '5-tuple',
                        'src-ip',
                        'src-dst-ip'
                    ],
                    'type': 'str'
                },
                'htab-msg-queue': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': False,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'idle',
                        'data',
                        'dedicated'
                    ],
                    'type': 'str'
                },
                'gtp-support': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'background-sse-scan': {
                    'required': False,
                    'type': 'dict',
                    'options': {
                        'scan': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': False,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': False,
                                '7.0.2': False,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        },
                        'stats-update-interval': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': False,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': False,
                                '7.0.2': False,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'udp-keepalive-interval': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': False,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': False,
                                '7.0.2': False,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        }
                    }
                },
                'napi-break-interval': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': False,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'int'
                },
                'dsw-dts-profile': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'list',
                    'options': {
                        'action': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'wait',
                                'drop',
                                'drop_tmr_0',
                                'drop_tmr_1',
                                'enque',
                                'enque_0',
                                'enque_1'
                            ],
                            'type': 'str'
                        },
                        'min-limit': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'profile-id': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'step': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        }
                    },
                    'elements': 'dict'
                },
                'port-path-option': {
                    'required': False,
                    'type': 'dict',
                    'options': {
                        'ports-using-npu': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'str'
                        }
                    }
                },
                'hpe': {
                    'required': False,
                    'type': 'dict',
                    'options': {
                        'all-protocol': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'arp-max': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'enable-shaper': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        },
                        'esp-max': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'high-priority': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'icmp-max': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'ip-frag-max': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'ip-others-max': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'l2-others-max': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'pri-type-max': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'sctp-max': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'tcp-max': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'tcpfin-rst-max': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'tcpsyn-ack-max': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'tcpsyn-max': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'udp-max': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        }
                    }
                },
                'dsw-queue-dts-profile': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'list',
                    'options': {
                        'iport': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'EIF0',
                                'eif0',
                                'EIF1',
                                'eif1',
                                'EIF2',
                                'eif2',
                                'EIF3',
                                'eif3',
                                'EIF4',
                                'eif4',
                                'EIF5',
                                'eif5',
                                'EIF6',
                                'eif6',
                                'EIF7',
                                'eif7',
                                'HTX0',
                                'htx0',
                                'HTX1',
                                'htx1',
                                'SSE0',
                                'sse0',
                                'SSE1',
                                'sse1',
                                'SSE2',
                                'sse2',
                                'SSE3',
                                'sse3',
                                'RLT',
                                'rlt',
                                'DFR',
                                'dfr',
                                'IPSECI',
                                'ipseci',
                                'IPSECO',
                                'ipseco',
                                'IPTI',
                                'ipti',
                                'IPTO',
                                'ipto',
                                'VEP0',
                                'vep0',
                                'VEP2',
                                'vep2',
                                'VEP4',
                                'vep4',
                                'VEP6',
                                'vep6',
                                'IVS',
                                'ivs',
                                'L2TI1',
                                'l2ti1',
                                'L2TO',
                                'l2to',
                                'L2TI0',
                                'l2ti0',
                                'PLE',
                                'ple',
                                'SPATH',
                                'spath',
                                'QTM',
                                'qtm'
                            ],
                            'type': 'str'
                        },
                        'name': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'str'
                        },
                        'oport': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'EIF0',
                                'eif0',
                                'EIF1',
                                'eif1',
                                'EIF2',
                                'eif2',
                                'EIF3',
                                'eif3',
                                'EIF4',
                                'eif4',
                                'EIF5',
                                'eif5',
                                'EIF6',
                                'eif6',
                                'EIF7',
                                'eif7',
                                'HRX',
                                'hrx',
                                'SSE0',
                                'sse0',
                                'SSE1',
                                'sse1',
                                'SSE2',
                                'sse2',
                                'SSE3',
                                'sse3',
                                'RLT',
                                'rlt',
                                'DFR',
                                'dfr',
                                'IPSECI',
                                'ipseci',
                                'IPSECO',
                                'ipseco',
                                'IPTI',
                                'ipti',
                                'IPTO',
                                'ipto',
                                'VEP0',
                                'vep0',
                                'VEP2',
                                'vep2',
                                'VEP4',
                                'vep4',
                                'VEP6',
                                'vep6',
                                'IVS',
                                'ivs',
                                'L2TI1',
                                'l2ti1',
                                'L2TO',
                                'l2to',
                                'L2TI0',
                                'l2ti0',
                                'PLE',
                                'ple',
                                'SYNK',
                                'sync',
                                'NSS',
                                'nss',
                                'TSK',
                                'tsk',
                                'QTM',
                                'qtm',
                                'l2tO'
                            ],
                            'type': 'str'
                        },
                        'profile-id': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'queue-select': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        }
                    },
                    'elements': 'dict'
                },
                'ip-reassembly': {
                    'required': False,
                    'type': 'dict',
                    'options': {
                        'max-timeout': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'min-timeout': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'status': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        }
                    }
                },
                'dse-timeout': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'int'
                },
                'tcp-rst-timeout': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': False,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'int'
                },
                'inbound-dscp-copy-port': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'str'
                },
                'double-level-mcast-offload': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': False,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'default-qos-type': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'policing',
                        'shaping',
                        'policing-enhanced'
                    ],
                    'type': 'str'
                },
                'udp-timeout-profile': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'list',
                    'options': {
                        'id': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'udp-idle': {
                            'required': False,
                            'revision': {
                                '7.2.0': True,
                                '6.2.0': False,
                                '6.2.2': False,
                                '6.2.6': False,
                                '6.2.7': False,
                                '6.2.8': False,
                                '6.2.9': False,
                                '6.2.10': False,
                                '6.4.1': False,
                                '6.4.3': False,
                                '6.4.4': False,
                                '6.4.6': False,
                                '6.4.7': True,
                                '6.4.8': True,
                                '6.4.9': True,
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': True,
                                '7.0.2': True,
                                '7.0.3': True,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        }
                    },
                    'elements': 'dict'
                },
                'isf-np-rx-tr-distr': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': False,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': False,
                        '7.0.2': False,
                        '7.0.3': False,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'port-flow',
                        'round-robin',
                        'randomized'
                    ],
                    'type': 'str'
                },
                'nat46-force-ipv4-packet-forwarding': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': False,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': False,
                        '7.0.2': False,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'rps-mode': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': False,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': False,
                        '7.0.2': False,
                        '7.0.3': False,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'mcast-session-counting6': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable',
                        'session-based',
                        'tpe-based'
                    ],
                    'type': 'str'
                },
                'prp-port-out': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'str'
                },
                'per-policy-accounting': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': False,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': False,
                        '7.0.2': False,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'prp-port-in': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'str'
                },
                'inbound-dscp-copy': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'mcast-session-counting': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable',
                        'session-based',
                        'tpe-based'
                    ],
                    'type': 'str'
                },
                'ipsec-host-dfclr': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': False,
                        '7.4.0': False
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'process-icmp-by-host': {
                    'required': False,
                    'revision': {
                        '7.2.0': True,
                        '6.2.0': False,
                        '6.2.2': False,
                        '6.2.6': False,
                        '6.2.7': False,
                        '6.2.8': False,
                        '6.2.9': False,
                        '6.2.10': False,
                        '6.4.1': False,
                        '6.4.3': False,
                        '6.4.4': False,
                        '6.4.6': False,
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': True,
                        '7.0.2': True,
                        '7.0.3': True,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': False,
                        '7.4.0': False
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'dedicated-tx-npu': {
                    'required': False,
                    'revision': {
                        '6.4.7': True,
                        '6.4.8': True,
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': False,
                        '7.0.2': False,
                        '7.0.3': False,
                        '7.0.4': False,
                        '7.0.5': False,
                        '7.0.6': False,
                        '7.0.7': False,
                        '7.2.1': False,
                        '7.2.2': False,
                        '7.4.0': False
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'ull-port-mode': {
                    'required': False,
                    'revision': {
                        '6.4.9': True,
                        '6.4.10': True,
                        '6.4.11': True,
                        '7.0.1': False,
                        '7.0.2': False,
                        '7.0.3': False,
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        '10G',
                        '25G'
                    ],
                    'type': 'str'
                },
                'sse-ha-scan': {
                    'required': False,
                    'type': 'dict',
                    'options': {
                        'gap': {
                            'required': False,
                            'revision': {
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': False,
                                '7.0.2': False,
                                '7.0.3': False,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'max-session-cnt': {
                            'required': False,
                            'revision': {
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': False,
                                '7.0.2': False,
                                '7.0.3': False,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        },
                        'min-duration': {
                            'required': False,
                            'revision': {
                                '6.4.10': True,
                                '6.4.11': True,
                                '7.0.1': False,
                                '7.0.2': False,
                                '7.0.3': False,
                                '7.0.4': True,
                                '7.0.5': True,
                                '7.0.6': True,
                                '7.0.7': True,
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.4.0': True
                            },
                            'type': 'int'
                        }
                    }
                },
                'hash-ipv6-sel': {
                    'required': False,
                    'revision': {
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'int'
                },
                'ip-fragment-offload': {
                    'required': False,
                    'revision': {
                        '7.0.4': True,
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'ple-non-syn-tcp-action': {
                    'required': False,
                    'revision': {
                        '7.0.5': True,
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': False,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'forward',
                        'drop'
                    ],
                    'type': 'str'
                },
                'npu-group-effective-scope': {
                    'required': False,
                    'revision': {
                        '7.0.6': True,
                        '7.0.7': True,
                        '7.2.1': False,
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'type': 'int'
                },
                'prp-session-clear-mode': {
                    'required': False,
                    'revision': {
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'blocking',
                        'non-blocking',
                        'do-not-clear'
                    ],
                    'type': 'str'
                },
                'shaping-stats': {
                    'required': False,
                    'revision': {
                        '7.2.2': True,
                        '7.4.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'sw-tr-hash': {
                    'required': False,
                    'type': 'dict',
                    'options': {
                        'draco15': {
                            'required': False,
                            'revision': {
                                '7.4.0': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        },
                        'tcp-udp-port': {
                            'required': False,
                            'revision': {
                                '7.4.0': True
                            },
                            'choices': [
                                'include',
                                'exclude'
                            ],
                            'type': 'str'
                        }
                    }
                }
            }

        }
    }

    params_validation_blob = []
    check_galaxy_version(module_arg_spec)
    module = AnsibleModule(argument_spec=check_parameter_bypass(module_arg_spec, 'system_npu'),
                           supports_check_mode=False)

    fmgr = None
    if module._socket_path:
        connection = Connection(module._socket_path)
        connection.set_option('access_token', module.params['access_token'] if 'access_token' in module.params else None)
        connection.set_option('enable_log', module.params['enable_log'] if 'enable_log' in module.params else False)
        connection.set_option('forticloud_access_token',
                              module.params['forticloud_access_token'] if 'forticloud_access_token' in module.params else None)
        fmgr = NAPIManager(jrpc_urls, perobject_jrpc_urls, module_primary_key, url_params, module, connection, top_level_schema_name='data')
        fmgr.validate_parameters(params_validation_blob)
        fmgr.process_partial_curd(argument_specs=module_arg_spec)
    else:
        module.fail_json(msg='MUST RUN IN HTTPAPI MODE')
    module.exit_json(meta=module.params)


if __name__ == '__main__':
    main()
