/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultExceptionContext
implements ExceptionContext,
Serializable {
    private static final long serialVersionUID = 20110706L;
    private final List<Pair<String, Object>> contextValues = new ArrayList<Pair<String, Object>>();

    @Override
    public DefaultExceptionContext addContextValue(String label, Object value) {
        this.contextValues.add(new ImmutablePair<String, Object>(label, value));
        return this;
    }

    @Override
    public DefaultExceptionContext setContextValue(String label, Object value) {
        this.contextValues.removeIf(p -> StringUtils.equals(label, (CharSequence)p.getKey()));
        this.addContextValue(label, value);
        return this;
    }

    @Override
    public List<Object> getContextValues(String label) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Pair<String, Object> pair : this.contextValues) {
            if (!StringUtils.equals(label, pair.getKey())) continue;
            values.add(pair.getValue());
        }
        return values;
    }

    @Override
    public Object getFirstContextValue(String label) {
        for (Pair<String, Object> pair : this.contextValues) {
            if (!StringUtils.equals(label, pair.getKey())) continue;
            return pair.getValue();
        }
        return null;
    }

    @Override
    public Set<String> getContextLabels() {
        HashSet<String> labels = new HashSet<String>();
        for (Pair<String, Object> pair : this.contextValues) {
            labels.add(pair.getKey());
        }
        return labels;
    }

    @Override
    public List<Pair<String, Object>> getContextEntries() {
        return this.contextValues;
    }

    @Override
    public String getFormattedExceptionMessage(String baseMessage) {
        StringBuilder buffer2 = new StringBuilder(256);
        if (baseMessage != null) {
            buffer2.append(baseMessage);
        }
        if (!this.contextValues.isEmpty()) {
            if (buffer2.length() > 0) {
                buffer2.append('\n');
            }
            buffer2.append("Exception Context:\n");
            int i = 0;
            for (Pair<String, Object> pair : this.contextValues) {
                buffer2.append("\t[");
                buffer2.append(++i);
                buffer2.append(':');
                buffer2.append(pair.getKey());
                buffer2.append("=");
                Object value = pair.getValue();
                if (value == null) {
                    buffer2.append("null");
                } else {
                    String valueStr;
                    try {
                        valueStr = value.toString();
                    }
                    catch (Exception e2) {
                        valueStr = "Exception thrown on toString(): " + ExceptionUtils.getStackTrace(e2);
                    }
                    buffer2.append(valueStr);
                }
                buffer2.append("]\n");
            }
            buffer2.append("---------------------------------");
        }
        return buffer2.toString();
    }
}

