/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene;

import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.WildcardQueryBuilder;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.opensearch.storage.script.StringUtils;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.LuceneQuery;

public class LikeQuery
extends LuceneQuery {
    @Override
    public QueryBuilder build(FunctionExpression func) {
        ReferenceExpression ref = (ReferenceExpression)func.getArguments().get(0);
        String field = this.convertTextToKeyword(ref.getAttr(), ref.type());
        Expression expr = (Expression)func.getArguments().get(1);
        ExprValue literalValue = expr.valueOf();
        return this.createBuilder(field, literalValue.stringValue());
    }

    protected WildcardQueryBuilder createBuilder(String field, String query) {
        String matchText = StringUtils.convertSqlWildcardToLucene(query);
        return QueryBuilders.wildcardQuery((String)field, (String)matchText).caseInsensitive(true);
    }
}

