/*******************************************************************************
 * Copyright (c) 2016 - 2020 Intel Corporation and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Intel Corporation - Initial implementation, based on code taken and modified
 *                                         from org.eclipse.cdt.dsf.gdb.ui
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.ui;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbSessionAdapters;
import org.eclipse.cdt.dsf.iss.ui.fch.sourcelookup.DsfFCHSourceDisplayAdapter;
import org.eclipse.cdt.dsf.iss.ui.viewmodel.IssGdbViewModelAdapter;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputProvider;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;

/**
 * This class creates and holds the different adapters registered with the DSF
 * session as well as the adapters for the launch.
 */
@SuppressWarnings("restriction")
@Immutable
public class IssGdbSessionAdapters extends GdbSessionAdapters {
	private final ILaunch fLaunch;
	private final DsfSession fSession;

	private final Map<Class<?>, Object> fLaunchAdapters = new HashMap<>();
	private final Class<?>[] fLaunchAdapterTypes;

	public IssGdbSessionAdapters(ILaunch launch, DsfSession session, Class<?>[] launchAdapterTypes) {
		super(launch, session, launchAdapterTypes);

		this.fLaunch = launch;
		this.fSession = session;
		this.fLaunchAdapterTypes = launchAdapterTypes;

		createAdapters();
	}

	@Override
	@SuppressWarnings("unchecked")
	protected <T> T createModelAdapter(Class<T> adapterType, ILaunch launch, DsfSession session) {
		if (IViewerInputProvider.class.equals(adapterType)) {
			return (T) new IssGdbViewModelAdapter(session, getSteppingController());
		} else if (ISourceDisplay.class.equals(adapterType)) {
			return launch.getSourceLocator() instanceof ISourceLookupDirector
					? (T) new DsfFCHSourceDisplayAdapter(session, (ISourceLookupDirector) launch.getSourceLocator(),
							getSteppingController())
					: null;
		} else {
			return super.createModelAdapter(adapterType, launch, session);
		}
	}
}
