/*******************************************************************************
 * Copyright (c) 2016 - 2020 Intel Corporation and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Intel Corporation - Initial implementation, based on code taken and modified
 *     					   from org.eclipse.cdt.dsf.gdb.
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.ui.launching;

import org.eclipse.cdt.dsf.gdb.internal.ui.launching.GdbDebuggerPage;
import org.eclipse.cdt.dsf.iss.launching.IIssDebugPreferenceConstants;
import org.eclipse.cdt.dsf.iss.launching.IIssLaunchConfigurationConstants;
import org.eclipse.cdt.dsf.iss.ui.IssGdbUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.preference.IPreferenceStore;

@SuppressWarnings("restriction")
public class IssGdbDebuggerPage extends GdbDebuggerPage {
	private boolean fIsInitializing;

	public IssGdbDebuggerPage(){
		super();
	}
	
	@Override
	public void initializeFrom(ILaunchConfiguration configuration) {
		super.initializeFrom(configuration);

		setInitializing(true);
		IPreferenceStore preferenceStore = IssGdbUIPlugin.getDefault().getPreferenceStore();
		String gdbCommand = getStringAttr(configuration, IIssLaunchConfigurationConstants.ATTR_DEBUG_NAME_ONEAPI_GDB,
				preferenceStore.getString(IIssDebugPreferenceConstants.PREF_DEFAULT_ONEAPI_GDB_COMMAND));

		fGDBCommandText.setText(gdbCommand);
		setInitializing(false);
	}

	@Override
	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
		super.setDefaults(configuration);
		IPreferenceStore preferenceStore = IssGdbUIPlugin.getDefault().getPreferenceStore();
		configuration.setAttribute(IIssLaunchConfigurationConstants.ATTR_DEBUG_NAME_ONEAPI_GDB,
				preferenceStore.getString(IIssDebugPreferenceConstants.PREF_DEFAULT_ONEAPI_GDB_COMMAND));

	}

	@Override
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		super.performApply(configuration);

		configuration.setAttribute(IIssLaunchConfigurationConstants.ATTR_DEBUG_NAME_ONEAPI_GDB,
				fGDBCommandText.getText().trim());
	}

	@Override
	public boolean isValid(ILaunchConfiguration launchConfig) {
		boolean valid = fGDBCommandText.getText().length() != 0;
		if (valid) {
			setErrorMessage(null);
			setMessage(null);
		} else {
			setErrorMessage("Unable to locate gdb-oneapi."); //$NON-NLS-1$
			setMessage(null);
		}
		return valid;
	}



	protected boolean isInitializing() {
		return fIsInitializing;
	}

	private void setInitializing(boolean isInitializing) {
		fIsInitializing = isInitializing;
	}

	/** utility method to cut down on clutter */
	private String getStringAttr(ILaunchConfiguration config, String attributeName, String defaultValue) {
		try {
			return config.getAttribute(attributeName, defaultValue);
		} catch (CoreException e) {
			return defaultValue;
		}
	}
}
