/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.action;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.binding.When;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.controlsfx.control.SegmentedButton;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionCheck;
import org.controlsfx.control.action.ActionGroup;
import org.controlsfx.tools.Duplicatable;

public class ActionUtils {
    public static Action ACTION_SEPARATOR = new Action(null, null){

        public String toString() {
            return "Separator";
        }
    };
    public static Action ACTION_SPAN = new Action(null, null){

        public String toString() {
            return "Span";
        }
    };

    private ActionUtils() {
    }

    public static Button createButton(Action action, ActionTextBehavior textBehavior) {
        return ActionUtils.configure(new Button(), action, textBehavior);
    }

    public static Button createButton(Action action) {
        return ActionUtils.configure(new Button(), action, ActionTextBehavior.SHOW);
    }

    public static ButtonBase configureButton(Action action, ButtonBase button, ActionTextBehavior textBehavior) {
        return ActionUtils.configure(button, action, textBehavior);
    }

    public static ButtonBase configureButton(Action action, ButtonBase button) {
        return ActionUtils.configureButton(action, button, ActionTextBehavior.SHOW);
    }

    public static void unconfigureButton(ButtonBase button) {
        ActionUtils.unconfigure(button);
    }

    public static MenuButton createMenuButton(Action action, ActionTextBehavior textBehavior) {
        return ActionUtils.configure(new MenuButton(), action, textBehavior);
    }

    public static MenuButton createMenuButton(Action action) {
        return ActionUtils.configure(new MenuButton(), action, ActionTextBehavior.SHOW);
    }

    public static Hyperlink createHyperlink(Action action) {
        return ActionUtils.configure(new Hyperlink(), action, ActionTextBehavior.SHOW);
    }

    public static ToggleButton createToggleButton(Action action, ActionTextBehavior textBehavior) {
        return ActionUtils.configure(new ToggleButton(), action, textBehavior);
    }

    public static ToggleButton createToggleButton(Action action) {
        return ActionUtils.createToggleButton(action, ActionTextBehavior.SHOW);
    }

    public static SegmentedButton createSegmentedButton(ActionTextBehavior textBehavior, Collection<? extends Action> actions) {
        ObservableList buttons = FXCollections.observableArrayList();
        for (Action action : actions) {
            buttons.add((Object)ActionUtils.createToggleButton(action, textBehavior));
        }
        return new SegmentedButton((ObservableList<ToggleButton>)buttons);
    }

    public static SegmentedButton createSegmentedButton(Collection<? extends Action> actions) {
        return ActionUtils.createSegmentedButton(ActionTextBehavior.SHOW, actions);
    }

    public static SegmentedButton createSegmentedButton(ActionTextBehavior textBehavior, Action ... actions) {
        return ActionUtils.createSegmentedButton(textBehavior, Arrays.asList(actions));
    }

    public static SegmentedButton createSegmentedButton(Action ... actions) {
        return ActionUtils.createSegmentedButton(ActionTextBehavior.SHOW, Arrays.asList(actions));
    }

    public static CheckBox createCheckBox(Action action) {
        return ActionUtils.configure(new CheckBox(), action, ActionTextBehavior.SHOW);
    }

    public static RadioButton createRadioButton(Action action) {
        return ActionUtils.configure(new RadioButton(), action, ActionTextBehavior.SHOW);
    }

    public static MenuItem createMenuItem(Action action) {
        CheckMenuItem menuItem = action.getClass().isAnnotationPresent(ActionCheck.class) ? new CheckMenuItem() : new MenuItem();
        return ActionUtils.configure(menuItem, action);
    }

    public static MenuItem configureMenuItem(Action action, MenuItem menuItem) {
        return ActionUtils.configure(menuItem, action);
    }

    public static void unconfigureMenuItem(MenuItem menuItem) {
        ActionUtils.unconfigure(menuItem);
    }

    public static Menu createMenu(Action action) {
        return ActionUtils.configure(new Menu(), action);
    }

    public static CheckMenuItem createCheckMenuItem(Action action) {
        return ActionUtils.configure(new CheckMenuItem(), action);
    }

    public static RadioMenuItem createRadioMenuItem(Action action) {
        return ActionUtils.configure(new RadioMenuItem((String)action.textProperty().get()), action);
    }

    public static ToolBar createToolBar(Collection<? extends Action> actions, ActionTextBehavior textBehavior) {
        return ActionUtils.updateToolBar(new ToolBar(), actions, textBehavior);
    }

    public static ToolBar updateToolBar(ToolBar toolbar, Collection<? extends Action> actions, ActionTextBehavior textBehavior) {
        toolbar.getItems().clear();
        for (Action action : actions) {
            if (action instanceof ActionGroup) {
                MenuButton menu = ActionUtils.createMenuButton(action, textBehavior);
                menu.setFocusTraversable(false);
                menu.getItems().addAll(ActionUtils.toMenuItems(((ActionGroup)action).getActions()));
                toolbar.getItems().add((Object)menu);
                continue;
            }
            if (action == ACTION_SEPARATOR) {
                toolbar.getItems().add((Object)new Separator());
                continue;
            }
            if (action == ACTION_SPAN) {
                Pane span = new Pane();
                HBox.setHgrow((Node)span, (Priority)Priority.ALWAYS);
                VBox.setVgrow((Node)span, (Priority)Priority.ALWAYS);
                toolbar.getItems().add((Object)span);
                continue;
            }
            if (action == null) continue;
            Object button = action.getClass().getAnnotation(ActionCheck.class) != null ? ActionUtils.createToggleButton(action, textBehavior) : ActionUtils.createButton(action, textBehavior);
            button.setFocusTraversable(false);
            toolbar.getItems().add(button);
        }
        return toolbar;
    }

    public static MenuBar createMenuBar(Collection<? extends Action> actions) {
        return ActionUtils.updateMenuBar(new MenuBar(), actions);
    }

    public static MenuBar updateMenuBar(MenuBar menuBar, Collection<? extends Action> actions) {
        menuBar.getMenus().clear();
        for (Action action : actions) {
            if (action == ACTION_SEPARATOR || action == ACTION_SPAN) continue;
            Menu menu = ActionUtils.createMenu(action);
            if (action instanceof ActionGroup) {
                menu.getItems().addAll(ActionUtils.toMenuItems(((ActionGroup)action).getActions()));
            } else if (action == null) {
                // empty if block
            }
            menuBar.getMenus().add((Object)menu);
        }
        return menuBar;
    }

    public static ButtonBar createButtonBar(Collection<? extends Action> actions) {
        return ActionUtils.updateButtonBar(new ButtonBar(), actions);
    }

    public static ButtonBar updateButtonBar(ButtonBar buttonBar, Collection<? extends Action> actions) {
        buttonBar.getButtons().clear();
        for (Action action : actions) {
            if (action instanceof ActionGroup || action == ACTION_SPAN || action == ACTION_SEPARATOR || action == null) continue;
            buttonBar.getButtons().add((Object)ActionUtils.createButton(action, ActionTextBehavior.SHOW));
        }
        return buttonBar;
    }

    public static ContextMenu createContextMenu(Collection<? extends Action> actions) {
        return ActionUtils.updateContextMenu(new ContextMenu(), actions);
    }

    public static ContextMenu updateContextMenu(ContextMenu menu, Collection<? extends Action> actions) {
        menu.getItems().clear();
        menu.getItems().addAll(ActionUtils.toMenuItems(actions));
        return menu;
    }

    private static Collection<MenuItem> toMenuItems(Collection<? extends Action> actions) {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        for (Action action : actions) {
            if (action instanceof ActionGroup) {
                Menu menu = ActionUtils.createMenu(action);
                menu.getItems().addAll(ActionUtils.toMenuItems(((ActionGroup)action).getActions()));
                items.add((MenuItem)menu);
                continue;
            }
            if (action == ACTION_SEPARATOR) {
                items.add((MenuItem)new SeparatorMenuItem());
                continue;
            }
            if (action == null || action == ACTION_SPAN) continue;
            items.add(ActionUtils.createMenuItem(action));
        }
        return items;
    }

    private static Node copyNode(Node node) {
        if (node instanceof ImageView) {
            return new ImageView(((ImageView)node).getImage());
        }
        if (node instanceof Duplicatable) {
            return (Node)((Duplicatable)node).duplicate();
        }
        return null;
    }

    private static void bindStyle(final Styleable styleable, Action action) {
        styleable.getStyleClass().addAll(action.getStyleClass());
        ListChangeListener<String> listChangeListener = new ListChangeListener<String>(){

            public void onChanged(ListChangeListener.Change<? extends String> c) {
                while (c.next()) {
                    if (c.wasRemoved()) {
                        styleable.getStyleClass().removeAll((Collection)c.getRemoved());
                    }
                    if (!c.wasAdded()) continue;
                    styleable.getStyleClass().addAll((Collection)c.getAddedSubList());
                }
            }
        };
        if (styleable instanceof Node) {
            if (((Node)styleable).getProperties().containsKey((Object)ListChangeListener.class.getCanonicalName())) {
                throw new RuntimeException("222 Can't bind node to two actions!");
            }
            ((Node)styleable).getProperties().put((Object)ListChangeListener.class.getCanonicalName(), (Object)listChangeListener);
        }
        action.getStyleClass().addListener((ListChangeListener)listChangeListener);
    }

    private static <T extends ButtonBase> T configure(T btn, final Action action, ActionTextBehavior textBehavior) {
        if (action == null) {
            throw new NullPointerException("Action can not be null");
        }
        ActionUtils.bindStyle(btn, action);
        if (textBehavior == ActionTextBehavior.SHOW) {
            btn.textProperty().bind((ObservableValue)action.textProperty());
        }
        btn.disableProperty().bind((ObservableValue)action.disabledProperty());
        btn.graphicProperty().bind((ObservableValue)new ObjectBinding<Node>(){
            {
                this.bind(new Observable[]{action.graphicProperty()});
            }

            protected Node computeValue() {
                return ActionUtils.copyNode((Node)action.graphicProperty().get());
            }

            public void removeListener(InvalidationListener listener) {
                super.removeListener(listener);
                this.unbind(new Observable[]{action.graphicProperty()});
            }
        });
        btn.getProperties().putAll(action.getProperties());
        action.getProperties().addListener(new ButtonPropertiesMapChangeListener<T>(btn, action));
        btn.tooltipProperty().bind((ObservableValue)new ObjectBinding<Tooltip>(){
            private Tooltip tooltip = new Tooltip();
            private StringBinding textBinding = new When((ObservableBooleanValue)action.longTextProperty().isEmpty()).then((ObservableStringValue)action.textProperty()).otherwise((ObservableStringValue)action.longTextProperty());
            {
                this.bind(new Observable[]{this.textBinding});
                this.tooltip.textProperty().bind((ObservableValue)this.textBinding);
            }

            protected Tooltip computeValue() {
                String longText = this.textBinding.get();
                return longText == null || this.textBinding.get().isEmpty() ? null : this.tooltip;
            }

            public void removeListener(InvalidationListener listener) {
                super.removeListener(listener);
                this.unbind(new Observable[]{action.longTextProperty()});
                this.tooltip.textProperty().unbind();
            }
        });
        if (btn instanceof ToggleButton) {
            ((ToggleButton)btn).selectedProperty().bindBidirectional((Property)action.selectedProperty());
        }
        btn.setOnAction((EventHandler)action);
        return btn;
    }

    private static void unconfigure(ButtonBase btn) {
        if (btn == null || !(btn.getOnAction() instanceof Action)) {
            return;
        }
        Action action = (Action)btn.getOnAction();
        Object listChangeListener = btn.getProperties().get((Object)ListChangeListener.class.getCanonicalName());
        if (listChangeListener instanceof ListChangeListener) {
            btn.getProperties().remove((Object)ListChangeListener.class.getCanonicalName());
            action.getStyleClass().removeListener((ListChangeListener)listChangeListener);
        }
        btn.styleProperty().unbind();
        btn.textProperty().unbind();
        btn.disableProperty().unbind();
        btn.graphicProperty().unbind();
        action.getProperties().removeListener(new ButtonPropertiesMapChangeListener<ButtonBase>(btn, action));
        btn.tooltipProperty().unbind();
        if (btn instanceof ToggleButton) {
            ((ToggleButton)btn).selectedProperty().unbindBidirectional((Property)action.selectedProperty());
        }
        btn.setOnAction(null);
    }

    private static <T extends MenuItem> T configure(T menuItem, final Action action) {
        if (action == null) {
            throw new NullPointerException("Action can not be null");
        }
        ActionUtils.bindStyle(menuItem, action);
        menuItem.textProperty().bind((ObservableValue)action.textProperty());
        menuItem.disableProperty().bind((ObservableValue)action.disabledProperty());
        menuItem.acceleratorProperty().bind(action.acceleratorProperty());
        menuItem.graphicProperty().bind((ObservableValue)new ObjectBinding<Node>(){
            {
                this.bind(new Observable[]{action.graphicProperty()});
            }

            protected Node computeValue() {
                return ActionUtils.copyNode((Node)action.graphicProperty().get());
            }

            public void removeListener(InvalidationListener listener) {
                super.removeListener(listener);
                this.unbind(new Observable[]{action.graphicProperty()});
            }
        });
        menuItem.getProperties().putAll(action.getProperties());
        action.getProperties().addListener(new MenuItemPropertiesMapChangeListener<T>(menuItem, action));
        if (menuItem instanceof RadioMenuItem) {
            ((RadioMenuItem)menuItem).selectedProperty().bindBidirectional((Property)action.selectedProperty());
        } else if (menuItem instanceof CheckMenuItem) {
            ((CheckMenuItem)menuItem).selectedProperty().bindBidirectional((Property)action.selectedProperty());
        }
        menuItem.setOnAction((EventHandler)action);
        return menuItem;
    }

    private static void unconfigure(MenuItem menuItem) {
        if (menuItem == null || !(menuItem.getOnAction() instanceof Action)) {
            return;
        }
        Action action = (Action)menuItem.getOnAction();
        menuItem.styleProperty().unbind();
        menuItem.textProperty().unbind();
        menuItem.disableProperty().unbind();
        menuItem.acceleratorProperty().unbind();
        menuItem.graphicProperty().unbind();
        action.getProperties().removeListener(new MenuItemPropertiesMapChangeListener<MenuItem>(menuItem, action));
        if (menuItem instanceof RadioMenuItem) {
            ((RadioMenuItem)menuItem).selectedProperty().unbindBidirectional((Property)action.selectedProperty());
        } else if (menuItem instanceof CheckMenuItem) {
            ((CheckMenuItem)menuItem).selectedProperty().unbindBidirectional((Property)action.selectedProperty());
        }
        menuItem.setOnAction(null);
    }

    private static class MenuItemPropertiesMapChangeListener<T extends MenuItem>
    implements MapChangeListener<Object, Object> {
        private final WeakReference<T> menuItemWeakReference;
        private final Action action;

        private MenuItemPropertiesMapChangeListener(T menuItem, Action action) {
            this.menuItemWeakReference = new WeakReference<T>(menuItem);
            this.action = action;
        }

        public void onChanged(MapChangeListener.Change<?, ?> change) {
            MenuItem menuItem = (MenuItem)this.menuItemWeakReference.get();
            if (menuItem == null) {
                this.action.getProperties().removeListener((MapChangeListener)this);
            } else {
                menuItem.getProperties().clear();
                menuItem.getProperties().putAll(this.action.getProperties());
            }
        }

        public boolean equals(Object otherObject) {
            if (this == otherObject) {
                return true;
            }
            if (otherObject == null || this.getClass() != otherObject.getClass()) {
                return false;
            }
            MenuItemPropertiesMapChangeListener otherListener = (MenuItemPropertiesMapChangeListener)otherObject;
            MenuItem menuItem = (MenuItem)this.menuItemWeakReference.get();
            MenuItem otherMenuItem = (MenuItem)otherListener.menuItemWeakReference.get();
            return menuItem != null ? menuItem.equals(otherMenuItem) : otherMenuItem == null && this.action.equals(otherListener.action);
        }

        public int hashCode() {
            MenuItem menuItem = (MenuItem)this.menuItemWeakReference.get();
            int result = menuItem != null ? menuItem.hashCode() : 0;
            result = 31 * result + this.action.hashCode();
            return result;
        }
    }

    private static class ButtonPropertiesMapChangeListener<T extends ButtonBase>
    implements MapChangeListener<Object, Object> {
        private final WeakReference<T> btnWeakReference;
        private final Action action;

        private ButtonPropertiesMapChangeListener(T btn, Action action) {
            this.btnWeakReference = new WeakReference<T>(btn);
            this.action = action;
        }

        public void onChanged(MapChangeListener.Change<?, ?> change) {
            ButtonBase btn = (ButtonBase)this.btnWeakReference.get();
            if (btn == null) {
                this.action.getProperties().removeListener((MapChangeListener)this);
            } else {
                btn.getProperties().clear();
                btn.getProperties().putAll(this.action.getProperties());
            }
        }

        public boolean equals(Object otherObject) {
            if (this == otherObject) {
                return true;
            }
            if (otherObject == null || this.getClass() != otherObject.getClass()) {
                return false;
            }
            ButtonPropertiesMapChangeListener otherListener = (ButtonPropertiesMapChangeListener)otherObject;
            ButtonBase btn = (ButtonBase)this.btnWeakReference.get();
            ButtonBase otherBtn = (ButtonBase)otherListener.btnWeakReference.get();
            if (btn != null ? !btn.equals(otherBtn) : otherBtn != null) {
                return false;
            }
            return this.action.equals(otherListener.action);
        }

        public int hashCode() {
            ButtonBase btn = (ButtonBase)this.btnWeakReference.get();
            int result = btn != null ? btn.hashCode() : 0;
            result = 31 * result + this.action.hashCode();
            return result;
        }
    }

    public static enum ActionTextBehavior {
        SHOW,
        HIDE;

    }
}

