/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.traits;

import java.io.ObjectStreamException;
import org.apache.fop.traits.TraitEnum;

public final class Direction
extends TraitEnum {
    private static final long serialVersionUID = 1L;
    private static final String[] DIRECTION_NAMES = new String[]{"lr", "rl", "tb", "bt"};
    private static final int[] DIRECTION_VALUES = new int[]{199, 200, 201, 202};
    public static final Direction LR = new Direction(0);
    public static final Direction RL = new Direction(1);
    public static final Direction TB = new Direction(2);
    public static final Direction BT = new Direction(3);
    private static final Direction[] DIRECTIONS = new Direction[]{LR, RL, TB, BT};

    private Direction(int index) {
        super(DIRECTION_NAMES[index], DIRECTION_VALUES[index]);
    }

    public boolean isVertical() {
        return this.getEnumValue() == 201 || this.getEnumValue() == 202;
    }

    public boolean isHorizontal() {
        return this.getEnumValue() == 199 || this.getEnumValue() == 200;
    }

    public static Direction valueOf(String name) {
        for (Direction direction : DIRECTIONS) {
            if (!direction.getName().equalsIgnoreCase(name)) continue;
            return direction;
        }
        throw new IllegalArgumentException("Illegal direction: " + name);
    }

    public static Direction valueOf(int enumValue) {
        for (Direction direction : DIRECTIONS) {
            if (direction.getEnumValue() != enumValue) continue;
            return direction;
        }
        throw new IllegalArgumentException("Illegal direction: " + enumValue);
    }

    private Object readResolve() throws ObjectStreamException {
        return Direction.valueOf(this.getName());
    }

    public String toString() {
        return this.getName();
    }
}

