/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

class ReflectionUtil {
    ReflectionUtil() {
    }

    static Method findMethod(Method[] methodArray, String string) {
        if (methodArray != null) {
            for (Method method : methodArray) {
                if (!method.getName().equals(string)) continue;
                return method;
            }
        }
        return null;
    }

    static boolean hasMethod(Method[] methodArray, String string) {
        return null != ReflectionUtil.findMethod(methodArray, string);
    }

    static Class<?> getClass(final String string) {
        if (null == string) {
            return null;
        }
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    ClassLoader classLoader = ReflectionUtil.class.getClassLoader();
                    Class<?> clazz = null == classLoader ? Class.forName(string) : classLoader.loadClass(string);
                    return clazz;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    static <T> Constructor<T> getDeclaredConstructor(final String string, final Class<?> ... classArray) {
        if (null == string) {
            return null;
        }
        return (Constructor)AccessController.doPrivileged(new PrivilegedAction<Constructor<T>>(){

            @Override
            public Constructor<T> run() {
                try {
                    Class<?> clazz;
                    ClassLoader classLoader = ReflectionUtil.class.getClassLoader();
                    Class<?> clazz2 = clazz = null == classLoader ? Class.forName(string) : classLoader.loadClass(string);
                    if (null != clazz) {
                        return clazz.getDeclaredConstructor(classArray);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static Method getMethod(final String string, final String string2, final Class<?> ... classArray) {
        if (null == string || null == string2) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    Class<?> clazz;
                    ClassLoader classLoader = ReflectionUtil.class.getClassLoader();
                    Class<?> clazz2 = clazz = null == classLoader ? Class.forName(string) : classLoader.loadClass(string);
                    if (null != clazz) {
                        return clazz.getMethod(string2, classArray);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static Method[] getMethods(final String string) {
        if (null == string) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                try {
                    Class<?> clazz;
                    ClassLoader classLoader = ReflectionUtil.class.getClassLoader();
                    Class<?> clazz2 = clazz = null == classLoader ? Class.forName(string) : classLoader.loadClass(string);
                    if (null != clazz) {
                        return clazz.getMethods();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static Integer getStaticInt(final String string, final String string2) {
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                try {
                    Class<?> clazz;
                    Field field;
                    Class<?> clazz2;
                    ClassLoader classLoader = ReflectionUtil.class.getClassLoader();
                    Class<?> clazz3 = clazz2 = null == classLoader ? Class.forName(string) : classLoader.loadClass(string);
                    if (null != clazz2 && null != (field = clazz2.getField(string2)) && Integer.TYPE == (clazz = field.getType())) {
                        return field.getInt(null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static Integer getStaticIntOrDefault(String string, String string2, int n) {
        Integer n2 = ReflectionUtil.getStaticInt(string, string2);
        return null == n2 ? n : n2;
    }

    static Object invokeGetter(Object object, Method method) {
        return ReflectionUtil.invokeMethod(object, method, new Object[0]);
    }

    static Object invokeMethod(final Object object, final Method method, final Object ... objectArray) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return method.invoke(object, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException(invocationTargetException);
                }
            }
        });
    }

    static void invokeSetter(Object object, Method method, Object object2) {
        ReflectionUtil.invokeMethod(object, method, object2);
    }
}

