"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class QueryService {
  constructor(client) {
    _defineProperty(this, "client", void 0);

    _defineProperty(this, "describeQueryInternal", async (request, format, responseFormat) => {
      try {
        const queryRequest = {
          query: request.body
        };
        const params = {
          body: JSON.stringify(queryRequest)
        };
        const queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, params);
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        console.error(err);
        return {
          data: {
            ok: false,
            resp: err.response,
            body: err.body
          }
        };
      }
    });

    _defineProperty(this, "describeSQLQuery", async request => {
      return this.describeQueryInternal(request, 'ppl.sqlQuery', 'json');
    });

    _defineProperty(this, "describePPLQuery", async request => {
      return this.describeQueryInternal(request, 'ppl.pplQuery', 'json');
    });

    this.client = client;
  }

}

exports.default = QueryService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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