/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.find;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public interface OWLEntityFinder {
    public OWLClass getOWLClass(String var1);

    public OWLObjectProperty getOWLObjectProperty(String var1);

    public OWLDataProperty getOWLDataProperty(String var1);

    public OWLAnnotationProperty getOWLAnnotationProperty(String var1);

    public OWLNamedIndividual getOWLIndividual(String var1);

    public OWLDatatype getOWLDatatype(String var1);

    public OWLEntity getOWLEntity(String var1);

    public Set<OWLEntity> getOWLEntities(String var1);

    @Nonnull
    default public <E extends OWLEntity> Optional<E> getOWLEntity(@Nonnull EntityType<E> entityType, @Nonnull String rendering) {
        Preconditions.checkNotNull(entityType);
        Preconditions.checkNotNull((Object)rendering);
        if (entityType == EntityType.CLASS) {
            return Optional.ofNullable(this.getOWLClass(rendering));
        }
        if (entityType == EntityType.OBJECT_PROPERTY) {
            return Optional.ofNullable(this.getOWLObjectProperty(rendering));
        }
        if (entityType == EntityType.DATA_PROPERTY) {
            return Optional.ofNullable(this.getOWLDataProperty(rendering));
        }
        if (entityType == EntityType.ANNOTATION_PROPERTY) {
            return Optional.ofNullable(this.getOWLAnnotationProperty(rendering));
        }
        if (entityType == EntityType.NAMED_INDIVIDUAL) {
            return Optional.ofNullable(this.getOWLIndividual(rendering));
        }
        if (entityType == EntityType.DATATYPE) {
            return Optional.ofNullable(this.getOWLDatatype(rendering));
        }
        throw new RuntimeException("Unknown EntityType: " + entityType);
    }

    public Set<String> getOWLEntityRenderings();

    public Set<OWLClass> getMatchingOWLClasses(String var1);

    public Set<OWLClass> getMatchingOWLClasses(String var1, boolean var2);

    public Set<OWLClass> getMatchingOWLClasses(String var1, boolean var2, int var3);

    public Set<OWLObjectProperty> getMatchingOWLObjectProperties(String var1);

    public Set<OWLObjectProperty> getMatchingOWLObjectProperties(String var1, boolean var2);

    public Set<OWLObjectProperty> getMatchingOWLObjectProperties(String var1, boolean var2, int var3);

    public Set<OWLDataProperty> getMatchingOWLDataProperties(String var1);

    public Set<OWLDataProperty> getMatchingOWLDataProperties(String var1, boolean var2);

    public Set<OWLDataProperty> getMatchingOWLDataProperties(String var1, boolean var2, int var3);

    public Set<OWLNamedIndividual> getMatchingOWLIndividuals(String var1);

    public Set<OWLNamedIndividual> getMatchingOWLIndividuals(String var1, boolean var2);

    public Set<OWLNamedIndividual> getMatchingOWLIndividuals(String var1, boolean var2, int var3);

    public Set<OWLDatatype> getMatchingOWLDatatypes(String var1);

    public Set<OWLDatatype> getMatchingOWLDatatypes(String var1, boolean var2);

    public Set<OWLDatatype> getMatchingOWLDatatypes(String var1, boolean var2, int var3);

    public Set<OWLAnnotationProperty> getMatchingOWLAnnotationProperties(String var1);

    public Set<OWLAnnotationProperty> getMatchingOWLAnnotationProperties(String var1, boolean var2);

    public Set<OWLAnnotationProperty> getMatchingOWLAnnotationProperties(String var1, boolean var2, int var3);

    public Set<OWLEntity> getMatchingOWLEntities(String var1);

    public Set<OWLEntity> getMatchingOWLEntities(String var1, boolean var2);

    public Set<OWLEntity> getMatchingOWLEntities(String var1, boolean var2, int var3);

    public Set<OWLEntity> getEntities(IRI var1);
}

