/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.audio;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import org.openstreetmap.josm.actions.audio.AbstractAudioAction;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.io.audio.AudioPlayer;
import org.openstreetmap.josm.io.audio.AudioUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class AudioPlayPauseAction
extends AbstractAudioAction {
    public AudioPlayPauseAction() {
        super(I18n.trc("audio", "Play/Pause"), "audio-playpause", I18n.tr("Play/pause audio.", new Object[0]), Shortcut.registerShortcut("audio:pause", I18n.tr("Audio: {0}", I18n.trc("audio", "Play/Pause")), 46, 5003), true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        URL url = AudioPlayer.url();
        try {
            if (url != null && AudioPlayer.paused()) {
                AudioPlayer.play(url);
            } else if (AudioPlayer.playing()) {
                if (!Utils.equalsEpsilon(AudioPlayer.speed(), 1.0)) {
                    AudioPlayer.play(url, AudioPlayer.position());
                } else {
                    AudioPlayer.pause();
                }
            } else {
                AudioMarker lastPlayed = AudioMarker.recentlyPlayedMarker();
                if (lastPlayed != null) {
                    lastPlayed.play();
                } else {
                    MarkerLayer.playAudio();
                }
            }
        }
        catch (IOException | InterruptedException ex) {
            AudioUtil.audioMalfunction(ex);
        }
    }
}

