/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery.vectortile.mapbox;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.CommandInteger;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.Geometry;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.GeometryTypes;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.Layer;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.protobuf.ProtobufPacked;
import org.openstreetmap.josm.data.protobuf.ProtobufParser;
import org.openstreetmap.josm.data.protobuf.ProtobufRecord;
import org.openstreetmap.josm.tools.Utils;

public class Feature {
    private static final byte ID_FIELD = 1;
    private static final byte TAG_FIELD = 2;
    private static final byte GEOMETRY_TYPE_FIELD = 3;
    private static final byte GEOMETRY_FIELD = 4;
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance(Locale.ROOT);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final List<CommandInteger> geometry = new ArrayList<CommandInteger>();
    private final GeometryTypes geometryType;
    private final long id;
    private final TagMap tags;
    private Geometry geometryObject;

    public Feature(Layer layer, ProtobufRecord protobufRecord) throws IOException {
        long tId = 0L;
        GeometryTypes geometryTypeTemp = GeometryTypes.UNKNOWN;
        String key = null;
        ArrayList<String> tagList = null;
        try (ProtobufParser parser = new ProtobufParser(protobufRecord.getBytes());){
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
            while (parser.hasNext()) {
                try (ProtobufRecord next = new ProtobufRecord(byteArrayOutputStream, parser);){
                    ProtobufPacked packed;
                    if (next.getField() == 2) {
                        packed = new ProtobufPacked(next.getBytes());
                        if (tagList == null) {
                            tagList = new ArrayList<String>(packed.getArray().length);
                        } else {
                            tagList.ensureCapacity(tagList.size() + packed.getArray().length);
                        }
                        for (long number : packed.getArray()) {
                            key = Feature.parseTagValue(key, layer, (int)number, tagList);
                        }
                        continue;
                    }
                    if (next.getField() == 4) {
                        packed = new ProtobufPacked(next.getBytes());
                        CommandInteger currentCommand = null;
                        for (long number : packed.getArray()) {
                            if (currentCommand != null && currentCommand.hasAllExpectedParameters()) {
                                currentCommand = null;
                            }
                            if (currentCommand == null) {
                                currentCommand = new CommandInteger(Math.toIntExact(number));
                                this.geometry.add(currentCommand);
                                continue;
                            }
                            currentCommand.addParameter(ProtobufParser.decodeZigZag(number));
                        }
                        continue;
                    }
                    if (next.getField() == 3) {
                        geometryTypeTemp = GeometryTypes.getAllValues()[next.asUnsignedVarInt().intValue()];
                        continue;
                    }
                    if (next.getField() != 1) continue;
                    tId = next.asUnsignedVarInt().longValue();
                }
            }
        }
        this.id = tId;
        this.geometryType = geometryTypeTemp;
        protobufRecord.close();
        this.tags = tagList != null && !tagList.isEmpty() ? new TagMap(tagList.toArray(EMPTY_STRING_ARRAY)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String parseTagValue(String key, Layer layer, int number, List<String> tagList) {
        if (key == null) {
            key = layer.getKey(number);
        } else {
            tagList.add(key);
            Object value = layer.getValue(number);
            if (value instanceof Double || value instanceof Float) {
                boolean grouping = NUMBER_FORMAT.isGroupingUsed();
                try {
                    NUMBER_FORMAT.setGroupingUsed(false);
                    tagList.add(Utils.intern(NUMBER_FORMAT.format(value)));
                }
                finally {
                    NUMBER_FORMAT.setGroupingUsed(grouping);
                }
            } else {
                tagList.add(Utils.intern(value.toString()));
            }
            key = null;
        }
        return key;
    }

    public List<CommandInteger> getGeometry() {
        return this.geometry;
    }

    public GeometryTypes getGeometryType() {
        return this.geometryType;
    }

    public long getId() {
        return this.id;
    }

    public TagMap getTags() {
        return this.tags;
    }

    public Geometry getGeometryObject() {
        if (this.geometryObject == null) {
            this.geometryObject = new Geometry(this.getGeometryType(), this.getGeometry());
        }
        return this.geometryObject;
    }

    public String toString() {
        return "Feature [geometry=" + this.geometry + ", geometryType=" + (Object)((Object)this.geometryType) + ", id=" + this.id + ", " + (this.tags != null ? "tags=" + this.tags + ", " : "") + (this.geometryObject != null ? "geometryObject=" + this.geometryObject : "") + ']';
    }
}

