/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.Code;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Instruction;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.Utils;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;

class ClassReader {
    int verbose;
    Package pkg;
    Package.Class cls;
    long inPos;
    DataInputStream in;
    Map<Attribute.Layout, Attribute> attrDefs;
    Map<Attribute.Layout, String> attrCommands;
    String unknownAttrCommand = "error";
    private static final ConstantPool.Entry INVALID_ENTRY = new ConstantPool.Entry(-1){

        @Override
        public boolean equals(Object o) {
            throw new IllegalStateException("Should not call this");
        }

        @Override
        protected int computeValueHash() {
            throw new IllegalStateException("Should not call this");
        }

        @Override
        public int compareTo(Object o) {
            throw new IllegalStateException("Should not call this");
        }

        @Override
        public String stringValue() {
            throw new IllegalStateException("Should not call this");
        }
    };

    ClassReader(Package.Class cls, InputStream in) throws IOException {
        this.pkg = cls.getPackage();
        this.cls = cls;
        this.verbose = this.pkg.verbose;
        this.in = new DataInputStream(new FilterInputStream(in){

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int nr = super.read(b, off, len);
                if (nr >= 0) {
                    ClassReader.this.inPos += (long)nr;
                }
                return nr;
            }

            @Override
            public int read() throws IOException {
                int ch = super.read();
                if (ch >= 0) {
                    ++ClassReader.this.inPos;
                }
                return ch;
            }

            @Override
            public long skip(long n) throws IOException {
                long ns = super.skip(n);
                if (ns >= 0L) {
                    ClassReader.this.inPos += ns;
                }
                return ns;
            }
        });
    }

    public void setAttrDefs(Map<Attribute.Layout, Attribute> attrDefs) {
        this.attrDefs = attrDefs;
    }

    public void setAttrCommands(Map<Attribute.Layout, String> attrCommands) {
        this.attrCommands = attrCommands;
    }

    private void skip(int n, String what) throws IOException {
        long skipped;
        long j;
        Utils.log.warning("skipping " + n + " bytes of " + what);
        for (skipped = 0L; skipped < (long)n; skipped += j) {
            j = this.in.skip((long)n - skipped);
            assert (j > 0L);
        }
        assert (skipped == (long)n);
    }

    private int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    private int readInt() throws IOException {
        return this.in.readInt();
    }

    private ConstantPool.Entry readRef() throws IOException {
        int i = this.in.readUnsignedShort();
        return i == 0 ? null : this.cls.cpMap[i];
    }

    private ConstantPool.Entry readRef(byte tag) throws IOException {
        ConstantPool.Entry e = this.readRef();
        assert (e != null);
        assert (e.tagMatches(tag));
        return e;
    }

    private ConstantPool.Entry checkValid(ConstantPool.Entry e) {
        if (e == INVALID_ENTRY) {
            throw new IllegalStateException("Invalid constant pool reference");
        }
        return e;
    }

    private ConstantPool.Entry readRefOrNull(byte tag) throws IOException {
        ConstantPool.Entry e = this.readRef();
        assert (e == null || e.tagMatches(tag));
        return e;
    }

    private ConstantPool.Utf8Entry readUtf8Ref() throws IOException {
        return (ConstantPool.Utf8Entry)this.readRef((byte)1);
    }

    private ConstantPool.ClassEntry readClassRef() throws IOException {
        return (ConstantPool.ClassEntry)this.readRef((byte)7);
    }

    private ConstantPool.ClassEntry readClassRefOrNull() throws IOException {
        return (ConstantPool.ClassEntry)this.readRefOrNull((byte)7);
    }

    private ConstantPool.SignatureEntry readSignatureRef() throws IOException {
        ConstantPool.Entry e = this.readRef((byte)1);
        return ConstantPool.getSignatureEntry(e.stringValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read() throws IOException {
        boolean ok = false;
        try {
            this.readMagicNumbers();
            this.readConstantPool();
            this.readHeader();
            this.readMembers(false);
            this.readMembers(true);
            this.readAttributes(0, this.cls);
            this.cls.finishReading();
            assert (0 >= this.in.read(new byte[1]));
            ok = true;
        }
        finally {
            if (!ok && this.verbose > 0) {
                Utils.log.warning("Erroneous data at input offset " + this.inPos + " of " + this.cls.file);
            }
        }
    }

    void readMagicNumbers() throws IOException {
        this.cls.magic = this.in.readInt();
        if (this.cls.magic != -889275714) {
            throw new Attribute.FormatException("Bad magic number in class file " + Integer.toHexString(this.cls.magic), 0, "magic-number", "pass");
        }
        this.cls.minver = (short)this.readUnsignedShort();
        this.cls.majver = (short)this.readUnsignedShort();
        String bad = this.checkVersion(this.cls.majver, this.cls.minver);
        if (bad != null) {
            throw new Attribute.FormatException("classfile version too " + bad + ": " + this.cls.majver + "." + this.cls.minver + " in " + this.cls.file, 0, "version", "pass");
        }
    }

    private String checkVersion(int majver, int minver) {
        if (majver < this.pkg.min_class_majver || majver == this.pkg.min_class_majver && minver < this.pkg.min_class_minver) {
            return "small";
        }
        if (majver > this.pkg.max_class_majver || majver == this.pkg.max_class_majver && minver > this.pkg.max_class_minver) {
            return "large";
        }
        return null;
    }

    void readConstantPool() throws IOException {
        int length = this.in.readUnsignedShort();
        int[] fixups = new int[length * 4];
        int fptr = 0;
        ConstantPool.Entry[] cpMap = new ConstantPool.Entry[length];
        cpMap[0] = INVALID_ENTRY;
        block15: for (int i = 1; i < length; ++i) {
            byte tag = this.in.readByte();
            switch (tag) {
                case 1: {
                    cpMap[i] = ConstantPool.getUtf8Entry(this.in.readUTF());
                    continue block15;
                }
                case 3: {
                    cpMap[i] = ConstantPool.getLiteralEntry(Integer.valueOf(this.in.readInt()));
                    continue block15;
                }
                case 4: {
                    cpMap[i] = ConstantPool.getLiteralEntry(Float.valueOf(this.in.readFloat()));
                    continue block15;
                }
                case 5: {
                    cpMap[i] = ConstantPool.getLiteralEntry(Long.valueOf(this.in.readLong()));
                    cpMap[++i] = INVALID_ENTRY;
                    continue block15;
                }
                case 6: {
                    cpMap[i] = ConstantPool.getLiteralEntry(Double.valueOf(this.in.readDouble()));
                    cpMap[++i] = INVALID_ENTRY;
                    continue block15;
                }
                case 7: 
                case 8: {
                    fixups[fptr++] = i;
                    fixups[fptr++] = tag;
                    fixups[fptr++] = this.in.readUnsignedShort();
                    fixups[fptr++] = -1;
                    continue block15;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    fixups[fptr++] = i;
                    fixups[fptr++] = tag;
                    fixups[fptr++] = this.in.readUnsignedShort();
                    fixups[fptr++] = this.in.readUnsignedShort();
                    continue block15;
                }
                default: {
                    throw new ClassFormatException("Bad constant pool tag " + tag + " in File: " + this.cls.file.nameString + " at pos: " + this.inPos);
                }
            }
        }
        while (fptr > 0) {
            if (this.verbose > 3) {
                Utils.log.fine("CP fixups [" + fptr / 4 + "]");
            }
            int flimit = fptr;
            fptr = 0;
            int fi = 0;
            block17: while (fi < flimit) {
                int cpi = fixups[fi++];
                int tag = fixups[fi++];
                int ref = fixups[fi++];
                int ref2 = fixups[fi++];
                if (this.verbose > 3) {
                    Utils.log.fine("  cp[" + cpi + "] = " + ConstantPool.tagName(tag) + "{" + ref + "," + ref2 + "}");
                }
                if (this.checkValid(cpMap[ref]) == null || ref2 >= 0 && this.checkValid(cpMap[ref2]) == null) {
                    fixups[fptr++] = cpi;
                    fixups[fptr++] = tag;
                    fixups[fptr++] = ref;
                    fixups[fptr++] = ref2;
                    continue;
                }
                switch (tag) {
                    case 7: {
                        cpMap[cpi] = ConstantPool.getClassEntry(cpMap[ref].stringValue());
                        continue block17;
                    }
                    case 8: {
                        cpMap[cpi] = ConstantPool.getStringEntry(cpMap[ref].stringValue());
                        continue block17;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        ConstantPool.ClassEntry mclass = (ConstantPool.ClassEntry)cpMap[ref];
                        ConstantPool.DescriptorEntry mdescr = (ConstantPool.DescriptorEntry)cpMap[ref2];
                        cpMap[cpi] = ConstantPool.getMemberEntry((byte)tag, mclass, mdescr);
                        continue block17;
                    }
                    case 12: {
                        ConstantPool.Utf8Entry mname = (ConstantPool.Utf8Entry)cpMap[ref];
                        ConstantPool.Utf8Entry mtype = (ConstantPool.Utf8Entry)cpMap[ref2];
                        cpMap[cpi] = ConstantPool.getDescriptorEntry(mname, mtype);
                        continue block17;
                    }
                }
                assert (false);
            }
            assert (fptr < flimit);
        }
        this.cls.cpMap = cpMap;
    }

    void readHeader() throws IOException {
        this.cls.flags = this.readUnsignedShort();
        this.cls.thisClass = this.readClassRef();
        this.cls.superClass = this.readClassRefOrNull();
        int ni = this.readUnsignedShort();
        this.cls.interfaces = new ConstantPool.ClassEntry[ni];
        for (int i = 0; i < ni; ++i) {
            this.cls.interfaces[i] = this.readClassRef();
        }
    }

    void readMembers(boolean doMethods) throws IOException {
        int nm = this.readUnsignedShort();
        for (int i = 0; i < nm; ++i) {
            this.readMember(doMethods);
        }
    }

    void readMember(boolean doMethod) throws IOException {
        Package.Class.Member m;
        int mflags = this.readUnsignedShort();
        ConstantPool.Utf8Entry mname = this.readUtf8Ref();
        ConstantPool.SignatureEntry mtype = this.readSignatureRef();
        ConstantPool.DescriptorEntry descr = ConstantPool.getDescriptorEntry(mname, mtype);
        if (!doMethod) {
            Package.Class clazz = this.cls;
            clazz.getClass();
            m = new Package.Class.Field(clazz, mflags, descr);
        } else {
            Package.Class clazz = this.cls;
            clazz.getClass();
            m = new Package.Class.Method(clazz, mflags, descr);
        }
        this.readAttributes(!doMethod ? 1 : 2, m);
    }

    /*
     * Unable to fully structure code
     */
    void readAttributes(int ctype, Attribute.Holder h) throws IOException {
        na = this.readUnsignedShort();
        if (na == 0) {
            return;
        }
        if (this.verbose > 3) {
            Utils.log.fine("readAttributes " + h + " [" + na + "]");
        }
        block12: for (i = 0; i < na; ++i) {
            name = this.readUtf8Ref().stringValue();
            length = this.readInt();
            if (this.attrCommands == null || (cmd = this.attrCommands.get(lkey = Attribute.keyForLookup(ctype, name))) == null) ** GOTO lbl-1000
            var9_10 = cmd;
            var10_12 = -1;
            switch (var9_10.hashCode()) {
                case 3433489: {
                    if (!var9_10.equals("pass")) break;
                    var10_12 = 0;
                    break;
                }
                case 96784904: {
                    if (!var9_10.equals("error")) break;
                    var10_12 = 1;
                    break;
                }
                case 109773592: {
                    if (!var9_10.equals("strip")) break;
                    var10_12 = 2;
                }
            }
            switch (var10_12) {
                case 0: {
                    message1 = "passing attribute bitwise in " + h;
                    throw new Attribute.FormatException(message1, ctype, name, cmd);
                }
                case 1: {
                    message2 = "attribute not allowed in " + h;
                    throw new Attribute.FormatException(message2, ctype, name, cmd);
                }
                case 2: {
                    this.skip(length, name + " attribute in " + h);
                    continue block12;
                }
                default: lbl-1000:
                // 2 sources

                {
                    a = Attribute.lookup(Package.attrDefs, ctype, name);
                    if (this.verbose > 4 && a != null) {
                        Utils.log.fine("pkg_attribute_lookup " + name + " = " + a);
                    }
                    if (a == null) {
                        a = Attribute.lookup(this.attrDefs, ctype, name);
                        if (this.verbose > 4 && a != null) {
                            Utils.log.fine("this " + name + " = " + a);
                        }
                    }
                    if (a == null) {
                        a = Attribute.lookup(null, ctype, name);
                        if (this.verbose > 4 && a != null) {
                            Utils.log.fine("null_attribute_lookup " + name + " = " + a);
                        }
                    }
                    if (a == null && length == 0) {
                        a = Attribute.find(ctype, name, "");
                    }
                    v0 = isStackMap = ctype == 3 && (name.equals("StackMap") != false || name.equals("StackMapX") != false);
                    if (isStackMap) {
                        code = (Code)h;
                        TOO_BIG = 65536;
                        if (code.max_stack >= 65536 || code.max_locals >= 65536 || code.getLength() >= 65536 || name.endsWith("X")) {
                            a = null;
                        }
                    }
                    if (a == null) {
                        if (isStackMap) {
                            message = "unsupported StackMap variant in " + h;
                            throw new Attribute.FormatException(message, ctype, name, "pass");
                        }
                        if ("strip".equals(this.unknownAttrCommand)) {
                            this.skip(length, "unknown " + name + " attribute in " + h);
                            continue block12;
                        }
                        message = " is unknown attribute in class " + h;
                        throw new Attribute.FormatException(message, ctype, name, this.unknownAttrCommand);
                    }
                    if (a.layout() == Package.attrCodeEmpty || a.layout() == Package.attrInnerClassesEmpty) {
                        pos0 = this.inPos;
                        if ("Code".equals(a.name())) {
                            m = (Package.Class.Method)h;
                            m.code = new Code(m);
                            try {
                                this.readCode(m.code);
                            }
                            catch (Instruction.FormatException iie) {
                                message = iie.getMessage() + " in " + h;
                                throw new ClassFormatException(message, iie);
                            }
                        } else {
                            if (!ClassReader.$assertionsDisabled && h != this.cls) {
                                throw new AssertionError();
                            }
                            this.readInnerClasses(this.cls);
                        }
                        if (!ClassReader.$assertionsDisabled && (long)length != this.inPos - pos0) {
                            throw new AssertionError();
                        }
                    } else if (length > 0) {
                        bytes = new byte[length];
                        this.in.readFully(bytes);
                        a = a.addContent(bytes);
                    }
                    if (a.size() == 0 && !a.layout().isEmpty()) {
                        throw new ClassFormatException(name + ": attribute length cannot be zero, in " + h);
                    }
                    h.addAttribute(a);
                    if (this.verbose <= 2) continue block12;
                    Utils.log.fine("read " + a);
                }
            }
        }
    }

    void readCode(Code code) throws IOException {
        code.max_stack = this.readUnsignedShort();
        code.max_locals = this.readUnsignedShort();
        code.bytes = new byte[this.readInt()];
        this.in.readFully(code.bytes);
        Instruction.opcodeChecker(code.bytes);
        int nh = this.readUnsignedShort();
        code.setHandlerCount(nh);
        for (int i = 0; i < nh; ++i) {
            code.handler_start[i] = this.readUnsignedShort();
            code.handler_end[i] = this.readUnsignedShort();
            code.handler_catch[i] = this.readUnsignedShort();
            code.handler_class[i] = this.readClassRefOrNull();
        }
        this.readAttributes(3, code);
    }

    void readInnerClasses(Package.Class cls) throws IOException {
        int nc = this.readUnsignedShort();
        ArrayList<Package.InnerClass> ics = new ArrayList<Package.InnerClass>(nc);
        for (int i = 0; i < nc; ++i) {
            Package.InnerClass ic = new Package.InnerClass(this.readClassRef(), this.readClassRefOrNull(), (ConstantPool.Utf8Entry)this.readRefOrNull((byte)1), this.readUnsignedShort());
            ics.add(ic);
        }
        cls.innerClasses = ics;
    }

    static class ClassFormatException
    extends IOException {
        private static final long serialVersionUID = -3564121733989501833L;

        public ClassFormatException(String message) {
            super(message);
        }

        public ClassFormatException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

