"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const assert = __importStar(require("assert"));
const fs_1 = require("fs");
const path_1 = require("path");
const typescript_1 = __importDefault(require("typescript"));
const documents_1 = require("../../../../../src/lib/documents");
const ls_config_1 = require("../../../../../src/ls-config");
const plugins_1 = require("../../../../../src/plugins");
const DiagnosticsProvider_1 = require("../../../../../src/plugins/typescript/features/DiagnosticsProvider");
const service_1 = require("../../../../../src/plugins/typescript/service");
const utils_1 = require("../../../../../src/utils");
const test_utils_1 = require("../../test-utils");
const importPackage_1 = require("../../../../../src/importPackage");
function setup(workspaceDir, filePath) {
    const docManager = new documents_1.DocumentManager((textDocument) => new documents_1.Document(textDocument.uri, textDocument.text));
    const configManager = new ls_config_1.LSConfigManager();
    const lsAndTsDocResolver = new plugins_1.LSAndTSDocResolver(docManager, [(0, utils_1.pathToUrl)(workspaceDir)], configManager);
    const plugin = new DiagnosticsProvider_1.DiagnosticsProviderImpl(lsAndTsDocResolver, configManager);
    const document = docManager.openDocument({
        uri: (0, utils_1.pathToUrl)(filePath),
        text: typescript_1.default.sys.readFile(filePath) || ''
    });
    return { plugin, document, docManager, lsAndTsDocResolver };
}
const { version: { major } } = (0, importPackage_1.getPackageInfo)('svelte', __dirname);
const expected = 'expectedv2.json';
const newSvelteMajorExpected = `expected_svelte_${major}.json`;
async function executeTest(inputFile, { workspaceDir, dir }) {
    const { plugin, document } = setup(workspaceDir, inputFile);
    const diagnostics = await plugin.getDiagnostics(document);
    const defaultExpectedFile = (0, path_1.join)(dir, expected);
    const expectedFileForCurrentSvelteMajor = (0, path_1.join)(dir, newSvelteMajorExpected);
    const expectedFile = (0, fs_1.existsSync)(expectedFileForCurrentSvelteMajor)
        ? expectedFileForCurrentSvelteMajor
        : defaultExpectedFile;
    const snapshotFormatter = await (0, test_utils_1.createJsonSnapshotFormatter)(dir);
    (0, test_utils_1.updateSnapshotIfFailedOrEmpty)({
        assertion() {
            assert.deepStrictEqual(diagnostics, JSON.parse((0, fs_1.readFileSync)(expectedFile, 'utf-8')));
        },
        expectedFile,
        getFileContent() {
            return snapshotFormatter(diagnostics);
        },
        rootDir: __dirname
    });
}
const executeTests = (0, test_utils_1.createSnapshotTester)(executeTest);
describe('DiagnosticsProvider', function () {
    executeTests({
        dir: (0, path_1.join)(__dirname, 'fixtures'),
        workspaceDir: (0, path_1.join)(__dirname, 'fixtures'),
        context: this
    });
    // Hacky, but it works. Needed due to testing both new and old transformation
    after(() => {
        (0, service_1.__resetCache)();
    });
});
//# sourceMappingURL=index.test.js.map