/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import javax.management.ObjectName;
import org.apache.catalina.Executor;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Service;
import org.apache.catalina.connector.CoyoteAdapter;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.core.AprStatus;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.ajp.AjpAprProtocol;
import org.apache.coyote.ajp.AjpNioProtocol;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.coyote.http11.Http11AprProtocol;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.CharsetUtil;
import org.apache.tomcat.util.buf.EncodedSolidusHandling;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.openssl.OpenSSLImplementation;
import org.apache.tomcat.util.res.StringManager;

public class Connector
extends LifecycleMBeanBase {
    private static final Log log = LogFactory.getLog(Connector.class);
    public static final boolean RECYCLE_FACADES = Boolean.parseBoolean(System.getProperty("org.apache.catalina.connector.RECYCLE_FACADES", "false"));
    public static final String INTERNAL_EXECUTOR_NAME = "Internal";
    protected Service service = null;
    protected boolean allowTrace = false;
    protected long asyncTimeout = 30000L;
    protected boolean enableLookups = false;
    protected boolean xpoweredBy = false;
    protected String proxyName = null;
    protected int proxyPort = 0;
    protected boolean discardFacades = RECYCLE_FACADES;
    protected int redirectPort = 443;
    protected String scheme = "http";
    protected boolean secure = false;
    protected static final StringManager sm = StringManager.getManager(Connector.class);
    private int maxCookieCount = 200;
    protected int maxParameterCount = 10000;
    protected int maxPostSize = 0x200000;
    protected int maxSavePostSize = 4096;
    protected String parseBodyMethods = "POST";
    protected HashSet<String> parseBodyMethodsSet;
    protected boolean useIPVHosts = false;
    protected final String protocolHandlerClassName;
    protected final ProtocolHandler protocolHandler;
    protected Adapter adapter = null;
    private Charset uriCharset = StandardCharsets.UTF_8;
    private EncodedSolidusHandling encodedSolidusHandling = UDecoder.ALLOW_ENCODED_SLASH ? EncodedSolidusHandling.DECODE : EncodedSolidusHandling.REJECT;
    protected boolean useBodyEncodingForURI = false;

    public Connector() {
        this("HTTP/1.1");
    }

    public Connector(String string) {
        boolean bl = AprStatus.getUseAprConnector() && AprStatus.isInstanceCreated() && AprLifecycleListener.isAprAvailable();
        ProtocolHandler protocolHandler = null;
        try {
            protocolHandler = ProtocolHandler.create((String)string, (boolean)bl);
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("coyoteConnector.protocolHandlerInstantiationFailed"), (Throwable)exception);
        }
        if (protocolHandler != null) {
            this.protocolHandler = protocolHandler;
            this.protocolHandlerClassName = this.protocolHandler.getClass().getName();
        } else {
            this.protocolHandler = null;
            this.protocolHandlerClassName = string;
        }
        this.setThrowOnFailure(Boolean.getBoolean("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE"));
    }

    public Connector(ProtocolHandler protocolHandler) {
        this.protocolHandlerClassName = protocolHandler.getClass().getName();
        this.protocolHandler = protocolHandler;
        this.setThrowOnFailure(Boolean.getBoolean("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE"));
    }

    public Object getProperty(String string) {
        if (this.protocolHandler == null) {
            return null;
        }
        return IntrospectionUtils.getProperty((Object)this.protocolHandler, (String)string);
    }

    public boolean setProperty(String string, String string2) {
        if (this.protocolHandler == null) {
            return false;
        }
        return IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)string, (String)string2);
    }

    @Deprecated
    public Object getAttribute(String string) {
        return this.getProperty(string);
    }

    @Deprecated
    public void setAttribute(String string, Object object) {
        this.setProperty(string, String.valueOf(object));
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public boolean getAllowTrace() {
        return this.allowTrace;
    }

    public void setAllowTrace(boolean bl) {
        this.allowTrace = bl;
        this.setProperty("allowTrace", String.valueOf(bl));
    }

    public long getAsyncTimeout() {
        return this.asyncTimeout;
    }

    public void setAsyncTimeout(long l) {
        this.asyncTimeout = l;
    }

    public boolean getDiscardFacades() {
        return this.discardFacades || Globals.IS_SECURITY_ENABLED;
    }

    public void setDiscardFacades(boolean bl) {
        this.discardFacades = bl;
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public void setEnableLookups(boolean bl) {
        this.enableLookups = bl;
        this.setProperty("enableLookups", String.valueOf(bl));
    }

    public int getMaxCookieCount() {
        return this.maxCookieCount;
    }

    public void setMaxCookieCount(int n) {
        this.maxCookieCount = n;
    }

    public int getMaxParameterCount() {
        return this.maxParameterCount;
    }

    public void setMaxParameterCount(int n) {
        this.maxParameterCount = n;
        this.setProperty("maxParameterCount", String.valueOf(n));
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(int n) {
        this.maxPostSize = n;
        this.setProperty("maxPostSize", String.valueOf(n));
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int n) {
        this.maxSavePostSize = n;
        this.setProperty("maxSavePostSize", String.valueOf(n));
    }

    public String getParseBodyMethods() {
        return this.parseBodyMethods;
    }

    public void setParseBodyMethods(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (null != string) {
            hashSet.addAll(Arrays.asList(string.split("\\s*,\\s*")));
        }
        if (hashSet.contains("TRACE")) {
            throw new IllegalArgumentException(sm.getString("coyoteConnector.parseBodyMethodNoTrace"));
        }
        this.parseBodyMethods = string;
        this.parseBodyMethodsSet = hashSet;
        this.setProperty("parseBodyMethods", string);
    }

    protected boolean isParseBodyMethod(String string) {
        return this.parseBodyMethodsSet.contains(string);
    }

    public int getPort() {
        if (this.protocolHandler instanceof AbstractProtocol) {
            return ((AbstractProtocol)this.protocolHandler).getPort();
        }
        Object object = this.getProperty("port");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return -1;
    }

    public void setPort(int n) {
        this.setProperty("port", String.valueOf(n));
    }

    public int getPortOffset() {
        if (this.protocolHandler instanceof AbstractProtocol) {
            return ((AbstractProtocol)this.protocolHandler).getPortOffset();
        }
        Object object = this.getProperty("portOffset");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public void setPortOffset(int n) {
        this.setProperty("portOffset", String.valueOf(n));
    }

    public int getPortWithOffset() {
        int n = this.getPort();
        if (n > 0) {
            return n + this.getPortOffset();
        }
        return n;
    }

    public int getLocalPort() {
        return (Integer)this.getProperty("localPort");
    }

    public String getProtocol() {
        boolean bl = AprStatus.getUseAprConnector();
        if (!bl && Http11NioProtocol.class.getName().equals(this.protocolHandlerClassName) || bl && Http11AprProtocol.class.getName().equals(this.protocolHandlerClassName)) {
            return "HTTP/1.1";
        }
        if (!bl && AjpNioProtocol.class.getName().equals(this.protocolHandlerClassName) || bl && AjpAprProtocol.class.getName().equals(this.protocolHandlerClassName)) {
            return "AJP/1.3";
        }
        return this.protocolHandlerClassName;
    }

    public String getProtocolHandlerClassName() {
        return this.protocolHandlerClassName;
    }

    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public void setProxyName(String string) {
        this.proxyName = string != null && string.length() > 0 ? string : null;
        this.setProperty("proxyName", this.proxyName);
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int n) {
        this.proxyPort = n;
        this.setProperty("proxyPort", String.valueOf(n));
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public void setRedirectPort(int n) {
        this.redirectPort = n;
        this.setProperty("redirectPort", String.valueOf(n));
    }

    public int getRedirectPortWithOffset() {
        return this.getRedirectPort() + this.getPortOffset();
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String string) {
        this.scheme = string;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
        this.setProperty("secure", Boolean.toString(bl));
    }

    public String getURIEncoding() {
        return this.uriCharset.name();
    }

    public Charset getURICharset() {
        return this.uriCharset;
    }

    public void setURIEncoding(String string) {
        try {
            Charset charset = B2CConverter.getCharset((String)string);
            if (!CharsetUtil.isAsciiSuperset((Charset)charset)) {
                log.error((Object)sm.getString("coyoteConnector.notAsciiSuperset", new Object[]{string}));
            }
            this.uriCharset = charset;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error((Object)sm.getString("coyoteConnector.invalidEncoding", new Object[]{string, this.uriCharset.name()}), (Throwable)unsupportedEncodingException);
        }
    }

    public boolean getUseBodyEncodingForURI() {
        return this.useBodyEncodingForURI;
    }

    public void setUseBodyEncodingForURI(boolean bl) {
        this.useBodyEncodingForURI = bl;
        this.setProperty("useBodyEncodingForURI", String.valueOf(bl));
    }

    public boolean getXpoweredBy() {
        return this.xpoweredBy;
    }

    public void setXpoweredBy(boolean bl) {
        this.xpoweredBy = bl;
        this.setProperty("xpoweredBy", String.valueOf(bl));
    }

    public void setUseIPVHosts(boolean bl) {
        this.useIPVHosts = bl;
        this.setProperty("useIPVHosts", String.valueOf(bl));
    }

    public boolean getUseIPVHosts() {
        return this.useIPVHosts;
    }

    public String getExecutorName() {
        java.util.concurrent.Executor executor = this.protocolHandler.getExecutor();
        if (executor instanceof Executor) {
            return ((Executor)executor).getName();
        }
        return INTERNAL_EXECUTOR_NAME;
    }

    public void addSslHostConfig(SSLHostConfig sSLHostConfig) {
        this.protocolHandler.addSslHostConfig(sSLHostConfig);
    }

    public SSLHostConfig[] findSslHostConfigs() {
        return this.protocolHandler.findSslHostConfigs();
    }

    public void addUpgradeProtocol(UpgradeProtocol upgradeProtocol) {
        this.protocolHandler.addUpgradeProtocol(upgradeProtocol);
    }

    public UpgradeProtocol[] findUpgradeProtocols() {
        return this.protocolHandler.findUpgradeProtocols();
    }

    public String getEncodedSolidusHandling() {
        return this.encodedSolidusHandling.getValue();
    }

    public void setEncodedSolidusHandling(String string) {
        this.encodedSolidusHandling = EncodedSolidusHandling.fromString((String)string);
    }

    public EncodedSolidusHandling getEncodedSolidusHandlingInternal() {
        return this.encodedSolidusHandling;
    }

    public Request createRequest() {
        return new Request(this);
    }

    public Response createResponse() {
        int n = this.protocolHandler.getDesiredBufferSize();
        if (n > 0) {
            return new Response(n);
        }
        return new Response();
    }

    protected String createObjectNameKeyProperties(String string) {
        String string2;
        Object object = this.getProperty("address");
        StringBuilder stringBuilder = new StringBuilder("type=");
        stringBuilder.append(string);
        String string3 = string2 = this.protocolHandler != null ? this.protocolHandler.getId() : null;
        if (string2 != null) {
            stringBuilder.append(",port=0,address=");
            stringBuilder.append(ObjectName.quote(string2));
        } else {
            stringBuilder.append(",port=");
            int n = this.getPortWithOffset();
            if (n > 0) {
                stringBuilder.append(n);
            } else {
                stringBuilder.append("auto-");
                stringBuilder.append(this.getProperty("nameIndex"));
            }
            String string4 = "";
            if (object instanceof InetAddress) {
                string4 = ((InetAddress)object).getHostAddress();
            } else if (object != null) {
                string4 = object.toString();
            }
            if (string4.length() > 0) {
                stringBuilder.append(",address=");
                stringBuilder.append(ObjectName.quote(string4));
            }
        }
        return stringBuilder.toString();
    }

    public void pause() {
        try {
            if (this.protocolHandler != null) {
                this.protocolHandler.pause();
            }
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("coyoteConnector.protocolHandlerPauseFailed"), (Throwable)exception);
        }
    }

    public void resume() {
        try {
            if (this.protocolHandler != null) {
                this.protocolHandler.resume();
            }
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("coyoteConnector.protocolHandlerResumeFailed"), (Throwable)exception);
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        AbstractHttp11JsseProtocol abstractHttp11JsseProtocol;
        super.initInternal();
        if (this.protocolHandler == null) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerInstantiationFailed"));
        }
        this.adapter = new CoyoteAdapter(this);
        this.protocolHandler.setAdapter(this.adapter);
        if (null == this.parseBodyMethodsSet) {
            this.setParseBodyMethods(this.getParseBodyMethods());
        }
        if (this.protocolHandler.isAprRequired() && !AprStatus.isInstanceCreated()) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerNoAprListener", new Object[]{this.getProtocolHandlerClassName()}));
        }
        if (this.protocolHandler.isAprRequired() && !AprStatus.isAprAvailable()) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerNoAprLibrary", new Object[]{this.getProtocolHandlerClassName()}));
        }
        if (AprStatus.isAprAvailable() && AprStatus.getUseOpenSSL() && this.protocolHandler instanceof AbstractHttp11JsseProtocol && (abstractHttp11JsseProtocol = (AbstractHttp11JsseProtocol)this.protocolHandler).isSSLEnabled() && abstractHttp11JsseProtocol.getSslImplementationName() == null) {
            abstractHttp11JsseProtocol.setSslImplementationName(OpenSSLImplementation.class.getName());
        }
        try {
            this.protocolHandler.init();
        }
        catch (Exception exception) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerInitializationFailed"), exception);
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        String string;
        String string2 = string = this.protocolHandler != null ? this.protocolHandler.getId() : null;
        if (string == null && this.getPortWithOffset() < 0) {
            throw new LifecycleException(sm.getString("coyoteConnector.invalidPort", new Object[]{this.getPortWithOffset()}));
        }
        this.setState(LifecycleState.STARTING);
        if (this.protocolHandler != null && this.service != null) {
            this.protocolHandler.setUtilityExecutor(this.service.getServer().getUtilityExecutor());
        }
        try {
            this.protocolHandler.start();
        }
        catch (Exception exception) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerStartFailed"), exception);
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        try {
            if (this.protocolHandler != null) {
                this.protocolHandler.stop();
            }
        }
        catch (Exception exception) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerStopFailed"), exception);
        }
        if (this.protocolHandler != null) {
            this.protocolHandler.setUtilityExecutor(null);
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        try {
            if (this.protocolHandler != null) {
                this.protocolHandler.destroy();
            }
        }
        catch (Exception exception) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerDestroyFailed"), exception);
        }
        if (this.getService() != null) {
            this.getService().removeConnector(this);
        }
        super.destroyInternal();
    }

    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder("Connector[");
        stringBuilder.append(this.getProtocol());
        stringBuilder.append('-');
        String string2 = string = this.protocolHandler != null ? this.protocolHandler.getId() : null;
        if (string != null) {
            stringBuilder.append(string);
        } else {
            int n = this.getPortWithOffset();
            if (n > 0) {
                stringBuilder.append(n);
            } else {
                stringBuilder.append("auto-");
                stringBuilder.append(this.getProperty("nameIndex"));
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    protected String getDomainInternal() {
        Service service = this.getService();
        if (service == null) {
            return null;
        }
        return this.service.getDomain();
    }

    @Override
    protected String getObjectNameKeyProperties() {
        return this.createObjectNameKeyProperties("Connector");
    }
}

