<?php
namespace Jaeger\Thrift\Agent\Zipkin;

/**
 * Autogenerated by Thrift Compiler (0.11.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Protocol\TBinaryProtocolAccelerated;
use Thrift\Exception\TApplicationException;


/**
 * Indicates the network context of a service recording an annotation with two
 * exceptions.
 * 
 * When a BinaryAnnotation, and key is CLIENT_ADDR or SERVER_ADDR,
 * the endpoint indicates the source or destination of an RPC. This exception
 * allows zipkin to display network context of uninstrumented services, or
 * clients such as web browsers.
 */
class Endpoint extends TBase {
  static $isValidate = false;

  static $_TSPEC = array(
    1 => array(
      'var' => 'ipv4',
      'isRequired' => false,
      'type' => TType::I32,
      ),
    2 => array(
      'var' => 'port',
      'isRequired' => false,
      'type' => TType::I16,
      ),
    3 => array(
      'var' => 'service_name',
      'isRequired' => false,
      'type' => TType::STRING,
      ),
    4 => array(
      'var' => 'ipv6',
      'isRequired' => false,
      'type' => TType::STRING,
      ),
    );

  /**
   * IPv4 host address packed into 4 bytes.
   * 
   * Ex for the ip 1.2.3.4, it would be (1 << 24) | (2 << 16) | (3 << 8) | 4
   * 
   * @var int
   */
  public $ipv4 = null;
  /**
   * IPv4 port
   * 
   * Note: this is to be treated as an unsigned integer, so watch for negatives.
   * 
   * Conventionally, when the port isn't known, port = 0.
   * 
   * @var int
   */
  public $port = null;
  /**
   * Service name in lowercase, such as "memcache" or "zipkin-web"
   * 
   * Conventionally, when the service name isn't known, service_name = "unknown".
   * 
   * @var string
   */
  public $service_name = null;
  /**
   * IPv6 host address packed into 16 bytes. Ex Inet6Address.getBytes()
   * 
   * @var string
   */
  public $ipv6 = null;

  public function __construct($vals=null) {
    if (is_array($vals)) {
      parent::__construct(self::$_TSPEC, $vals);
    }
  }

  public function getName() {
    return 'Endpoint';
  }

  public function read($input)
  {
    return $this->_read('Endpoint', self::$_TSPEC, $input);
  }

  public function write($output) {
    return $this->_write('Endpoint', self::$_TSPEC, $output);
  }

}

