<?php
namespace Jaeger\Thrift\Agent\Zipkin;

/**
 * Autogenerated by Thrift Compiler (0.11.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Protocol\TBinaryProtocolAccelerated;
use Thrift\Exception\TApplicationException;


/**
 * A trace is a series of spans (often RPC calls) which form a latency tree.
 * 
 * The root span is where trace_id = id and parent_id = Nil. The root span is
 * usually the longest interval in the trace, starting with a SERVER_RECV
 * annotation and ending with a SERVER_SEND.
 */
class Span extends TBase {
  static $isValidate = false;

  static $_TSPEC = array(
    1 => array(
      'var' => 'trace_id',
      'isRequired' => false,
      'type' => TType::I64,
      ),
    3 => array(
      'var' => 'name',
      'isRequired' => false,
      'type' => TType::STRING,
      ),
    4 => array(
      'var' => 'id',
      'isRequired' => false,
      'type' => TType::I64,
      ),
    5 => array(
      'var' => 'parent_id',
      'isRequired' => false,
      'type' => TType::I64,
      ),
    6 => array(
      'var' => 'annotations',
      'isRequired' => false,
      'type' => TType::LST,
      'etype' => TType::STRUCT,
      'elem' => array(
        'type' => TType::STRUCT,
        'class' => '\Jaeger\Thrift\Agent\Zipkin\Annotation',
        ),
      ),
    8 => array(
      'var' => 'binary_annotations',
      'isRequired' => false,
      'type' => TType::LST,
      'etype' => TType::STRUCT,
      'elem' => array(
        'type' => TType::STRUCT,
        'class' => '\Jaeger\Thrift\Agent\Zipkin\BinaryAnnotation',
        ),
      ),
    9 => array(
      'var' => 'debug',
      'isRequired' => false,
      'type' => TType::BOOL,
      ),
    10 => array(
      'var' => 'timestamp',
      'isRequired' => false,
      'type' => TType::I64,
      ),
    11 => array(
      'var' => 'duration',
      'isRequired' => false,
      'type' => TType::I64,
      ),
    12 => array(
      'var' => 'trace_id_high',
      'isRequired' => false,
      'type' => TType::I64,
      ),
    );

  /**
   * @var int
   */
  public $trace_id = null;
  /**
   * Span name in lowercase, rpc method for example
   * 
   * Conventionally, when the span name isn't known, name = "unknown".
   * 
   * @var string
   */
  public $name = null;
  /**
   * @var int
   */
  public $id = null;
  /**
   * @var int
   */
  public $parent_id = null;
  /**
   * @var \Jaeger\Thrift\Agent\Zipkin\Annotation[]
   */
  public $annotations = null;
  /**
   * @var \Jaeger\Thrift\Agent\Zipkin\BinaryAnnotation[]
   */
  public $binary_annotations = null;
  /**
   * @var bool
   */
  public $debug = false;
  /**
   * Microseconds from epoch of the creation of this span.
   * 
   * This value should be set directly by instrumentation, using the most
   * precise value possible. For example, gettimeofday or syncing nanoTime
   * against a tick of currentTimeMillis.
   * 
   * For compatibilty with instrumentation that precede this field, collectors
   * or span stores can derive this via Annotation.timestamp.
   * For example, SERVER_RECV.timestamp or CLIENT_SEND.timestamp.
   * 
   * This field is optional for compatibility with old data: first-party span
   * stores are expected to support this at time of introduction.
   * 
   * @var int
   */
  public $timestamp = null;
  /**
   * Measurement of duration in microseconds, used to support queries.
   * 
   * This value should be set directly, where possible. Doing so encourages
   * precise measurement decoupled from problems of clocks, such as skew or NTP
   * updates causing time to move backwards.
   * 
   * For compatibilty with instrumentation that precede this field, collectors
   * or span stores can derive this by subtracting Annotation.timestamp.
   * For example, SERVER_SEND.timestamp - SERVER_RECV.timestamp.
   * 
   * If this field is persisted as unset, zipkin will continue to work, except
   * duration query support will be implementation-specific. Similarly, setting
   * this field non-atomically is implementation-specific.
   * 
   * This field is i64 vs i32 to support spans longer than 35 minutes.
   * 
   * @var int
   */
  public $duration = null;
  /**
   * Optional unique 8-byte additional identifier for a trace. If non zero, this
   * means the trace uses 128 bit traceIds instead of 64 bit.
   * 
   * @var int
   */
  public $trace_id_high = null;

  public function __construct($vals=null) {
    if (is_array($vals)) {
      parent::__construct(self::$_TSPEC, $vals);
    }
  }

  public function getName() {
    return 'Span';
  }

  public function read($input)
  {
    return $this->_read('Span', self::$_TSPEC, $input);
  }

  public function write($output) {
    return $this->_write('Span', self::$_TSPEC, $output);
  }

}

