/// <reference types="node" />
import { Zh, Ota, Logger } from '../types';
export declare const upgradeFileIdentifier: Buffer;
type IsNewImageAvailable = (current: Ota.ImageInfo, logger: Logger, device: Zh.Device, getImageMeta: Ota.GetImageMeta) => Promise<{
    available: number;
    currentFileVersion: number;
    otaFileVersion: number;
}>;
type DownloadImage = (meta: Ota.ImageMeta, logger: Logger) => Promise<{
    data: Buffer;
}>;
type GetNewImage = (current: Ota.Version, logger: Logger, device: Zh.Device, getImageMeta: Ota.GetImageMeta, downloadImage: DownloadImage) => Promise<Ota.Image>;
export declare function parseImage(buffer: Buffer): Ota.Image;
export declare function isUpdateAvailable(device: Zh.Device, logger: Logger, isNewImageAvailable: IsNewImageAvailable, requestPayload: Ota.ImageInfo, getImageMeta?: Ota.GetImageMeta): Promise<{
    available: boolean;
    currentFileVersion: number;
    otaFileVersion: number;
}>;
export declare function isNewImageAvailable(current: Ota.ImageInfo, logger: Logger, device: Zh.Device, getImageMeta: Ota.GetImageMeta): Promise<{
    available: number;
    currentFileVersion: number;
    otaFileVersion: number;
}>;
export declare function updateToLatest(device: Zh.Device, logger: Logger, onProgress: Ota.OnProgress, getNewImage: GetNewImage, getImageMeta?: Ota.GetImageMeta, downloadImage?: DownloadImage): Promise<number>;
export declare function getNewImage(current: Ota.ImageInfo, logger: Logger, device: Zh.Device, getImageMeta: Ota.GetImageMeta, downloadImage: DownloadImage): Promise<Ota.Image>;
export declare function getAxios(): import("axios").AxiosInstance;
export {};
//# sourceMappingURL=common.d.ts.map