/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.indices;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.ExceptionsHelper;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.admin.indices.rollover.RolloverRequest;
import org.opensearch.action.admin.indices.settings.get.GetSettingsAction;
import org.opensearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.ad.common.exception.EndRunException;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.constant.CommonValue;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.rest.handler.AnomalyDetectorFunction;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.util.DiscoveryNodeFilterer;
import org.opensearch.client.AdminClient;
import org.opensearch.client.Client;
import org.opensearch.cluster.LocalNodeClusterManagerListener;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Strings;
import org.opensearch.common.bytes.BytesArray;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.InjectSecurity;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

public class AnomalyDetectionIndices
implements LocalNodeClusterManagerListener {
    private static final Logger logger = LogManager.getLogger(AnomalyDetectionIndices.class);
    public static final String AD_RESULT_HISTORY_INDEX_PATTERN = "<.opendistro-anomaly-results-history-{now/d}-1>";
    public static final String ALL_AD_RESULTS_INDEX_PATTERN = ".opendistro-anomaly-results*";
    public static int minJobIndexReplicas = 1;
    public static int maxJobIndexReplicas = 20;
    static final String META = "_meta";
    private static final String SCHEMA_VERSION = "schema_version";
    private ClusterService clusterService;
    private final Client client;
    private final AdminClient adminClient;
    private final ThreadPool threadPool;
    private volatile TimeValue historyRolloverPeriod;
    private volatile Long historyMaxDocs;
    private volatile TimeValue historyRetentionPeriod;
    private Scheduler.Cancellable scheduledRollover = null;
    private DiscoveryNodeFilterer nodeFilter;
    private int maxPrimaryShards;
    private EnumMap<ADIndex, IndexState> indexStates;
    private boolean allMappingUpdated;
    private boolean allSettingUpdated;
    private final AtomicBoolean updateRunning;
    private final int maxUpdateRunningTimes;
    private int updateRunningTimes;
    private final Settings settings;
    private Map<String, Object> AD_RESULT_FIELD_CONFIGS;

    public AnomalyDetectionIndices(Client client, ClusterService clusterService, ThreadPool threadPool, Settings settings, DiscoveryNodeFilterer nodeFilter, int maxUpdateRunningTimes) {
        this.client = client;
        this.adminClient = client.admin();
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.clusterService.addLocalNodeClusterManagerListener((LocalNodeClusterManagerListener)this);
        this.historyRolloverPeriod = (TimeValue)AnomalyDetectorSettings.AD_RESULT_HISTORY_ROLLOVER_PERIOD.get(settings);
        this.historyMaxDocs = (Long)AnomalyDetectorSettings.AD_RESULT_HISTORY_MAX_DOCS_PER_SHARD.get(settings);
        this.historyRetentionPeriod = (TimeValue)AnomalyDetectorSettings.AD_RESULT_HISTORY_RETENTION_PERIOD.get(settings);
        this.maxPrimaryShards = (Integer)AnomalyDetectorSettings.MAX_PRIMARY_SHARDS.get(settings);
        this.nodeFilter = nodeFilter;
        this.indexStates = new EnumMap(ADIndex.class);
        this.allMappingUpdated = false;
        this.allSettingUpdated = false;
        this.updateRunning = new AtomicBoolean(false);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.AD_RESULT_HISTORY_MAX_DOCS_PER_SHARD, it -> {
            this.historyMaxDocs = it;
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.AD_RESULT_HISTORY_ROLLOVER_PERIOD, it -> {
            this.historyRolloverPeriod = it;
            this.rescheduleRollover();
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.AD_RESULT_HISTORY_RETENTION_PERIOD, it -> {
            this.historyRetentionPeriod = it;
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.MAX_PRIMARY_SHARDS, it -> {
            this.maxPrimaryShards = it;
        });
        this.settings = Settings.builder().put("index.hidden", true).build();
        this.maxUpdateRunningTimes = maxUpdateRunningTimes;
        this.updateRunningTimes = 0;
        this.AD_RESULT_FIELD_CONFIGS = null;
    }

    private void initResultMapping() throws IOException {
        if (this.AD_RESULT_FIELD_CONFIGS != null) {
            return;
        }
        String resultMapping = AnomalyDetectionIndices.getAnomalyResultMappings();
        Map asMap = (Map)XContentHelper.convertToMap((BytesReference)new BytesArray(resultMapping), (boolean)false, (XContentType)XContentType.JSON).v2();
        Object properties = asMap.get("properties");
        if (properties instanceof Map) {
            this.AD_RESULT_FIELD_CONFIGS = (Map)properties;
        } else {
            logger.error("Fail to read result mapping file.");
        }
    }

    public static String getAnomalyDetectorMappings() throws IOException {
        URL url = AnomalyDetectionIndices.class.getClassLoader().getResource("mappings/anomaly-detectors.json");
        return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
    }

    public static String getAnomalyResultMappings() throws IOException {
        URL url = AnomalyDetectionIndices.class.getClassLoader().getResource("mappings/anomaly-results.json");
        return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
    }

    public static String getAnomalyDetectorJobMappings() throws IOException {
        URL url = AnomalyDetectionIndices.class.getClassLoader().getResource("mappings/anomaly-detector-jobs.json");
        return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
    }

    public static String getDetectionStateMappings() throws IOException {
        URL url = AnomalyDetectionIndices.class.getClassLoader().getResource("mappings/anomaly-detection-state.json");
        String detectionStateMappings = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        String detectorIndexMappings = AnomalyDetectionIndices.getAnomalyDetectorMappings();
        detectorIndexMappings = detectorIndexMappings.substring(detectorIndexMappings.indexOf("\"properties\""), detectorIndexMappings.lastIndexOf("}"));
        return detectionStateMappings.replace("DETECTOR_INDEX_MAPPING_PLACE_HOLDER", detectorIndexMappings);
    }

    public static String getCheckpointMappings() throws IOException {
        URL url = AnomalyDetectionIndices.class.getClassLoader().getResource("mappings/checkpoint.json");
        return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
    }

    public boolean doesAnomalyDetectorIndexExist() {
        return this.clusterService.state().getRoutingTable().hasIndex(".opendistro-anomaly-detectors");
    }

    public boolean doesAnomalyDetectorJobIndexExist() {
        return this.clusterService.state().getRoutingTable().hasIndex(".opendistro-anomaly-detector-jobs");
    }

    public boolean doesDefaultAnomalyResultIndexExist() {
        return this.clusterService.state().metadata().hasAlias(".opendistro-anomaly-results");
    }

    public boolean doesIndexExist(String indexName) {
        return this.clusterService.state().metadata().hasIndex(indexName);
    }

    public <T> void initCustomResultIndexAndExecute(String resultIndex, AnomalyDetectorFunction function, ActionListener<T> listener) {
        try {
            if (!this.doesIndexExist(resultIndex)) {
                this.initCustomAnomalyResultIndexDirectly(resultIndex, (ActionListener<CreateIndexResponse>)ActionListener.wrap(response -> {
                    if (response.isAcknowledged()) {
                        logger.info("Successfully created anomaly detector result index {}", (Object)resultIndex);
                        this.validateCustomResultIndexAndExecute(resultIndex, function, listener);
                    } else {
                        String error = "Creating anomaly detector result index with mappings call not acknowledged: " + resultIndex;
                        logger.error(error);
                        listener.onFailure((Exception)new EndRunException(error, true));
                    }
                }, exception -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)exception) instanceof ResourceAlreadyExistsException) {
                        this.validateCustomResultIndexAndExecute(resultIndex, function, listener);
                    } else {
                        logger.error("Failed to create anomaly detector result index " + resultIndex, (Throwable)exception);
                        listener.onFailure(exception);
                    }
                }));
            } else {
                this.validateCustomResultIndexAndExecute(resultIndex, function, listener);
            }
        }
        catch (Exception e) {
            logger.error("Failed to create custom result index " + resultIndex, (Throwable)e);
            listener.onFailure(e);
        }
    }

    public <T> void validateCustomResultIndexAndExecute(String resultIndex, AnomalyDetectorFunction function, ActionListener<T> listener) {
        try {
            if (!this.isValidResultIndexMapping(resultIndex)) {
                logger.warn("Can't create detector with custom result index {} as its mapping is invalid", (Object)resultIndex);
                listener.onFailure((Exception)new IllegalArgumentException(CommonErrorMessages.INVALID_RESULT_INDEX_MAPPING + resultIndex));
                return;
            }
            AnomalyResult dummyResult = AnomalyResult.getDummyResult();
            IndexRequest indexRequest = new IndexRequest(resultIndex).id("dummy_ad_result_id").source(dummyResult.toXContent(XContentBuilder.builder((XContent)XContentType.JSON.xContent()), ToXContent.EMPTY_PARAMS));
            this.client.index(indexRequest, ActionListener.wrap(response -> {
                logger.debug("Successfully wrote dummy AD result to result index {}", (Object)resultIndex);
                this.client.delete(new DeleteRequest(resultIndex).id("dummy_ad_result_id"), ActionListener.wrap(deleteResponse -> {
                    logger.debug("Successfully deleted dummy AD result from result index {}", (Object)resultIndex);
                    function.execute();
                }, ex -> {
                    logger.error("Failed to delete dummy AD result from result index " + resultIndex, (Throwable)ex);
                    listener.onFailure(ex);
                }));
            }, exception -> {
                logger.error("Failed to write dummy AD result to result index " + resultIndex, (Throwable)exception);
                listener.onFailure(exception);
            }));
        }
        catch (Exception e) {
            logger.error("Failed to create detector with custom result index " + resultIndex, (Throwable)e);
            listener.onFailure(e);
        }
    }

    public <T> void validateCustomIndexForBackendJob(String resultIndex, String securityLogId, String user, List<String> roles, AnomalyDetectorFunction function, ActionListener<T> listener) {
        if (!this.doesIndexExist(resultIndex)) {
            listener.onFailure((Exception)new EndRunException(CommonErrorMessages.CAN_NOT_FIND_RESULT_INDEX + resultIndex, true));
            return;
        }
        if (!this.isValidResultIndexMapping(resultIndex)) {
            listener.onFailure((Exception)new EndRunException("Result index mapping is not correct", true));
            return;
        }
        try (InjectSecurity injectSecurity = new InjectSecurity(securityLogId, this.settings, this.client.threadPool().getThreadContext());){
            injectSecurity.inject(user, roles);
            ActionListener wrappedListener = ActionListener.wrap(r -> listener.onResponse(r), e -> {
                injectSecurity.close();
                listener.onFailure(e);
            });
            this.validateCustomResultIndexAndExecute(resultIndex, () -> {
                injectSecurity.close();
                function.execute();
            }, wrappedListener);
        }
        catch (Exception e2) {
            logger.error("Failed to validate custom index for backend job " + securityLogId, (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    public boolean isValidResultIndexMapping(String resultIndex) {
        try {
            String propertyName;
            this.initResultMapping();
            if (this.AD_RESULT_FIELD_CONFIGS == null) {
                return false;
            }
            IndexMetadata indexMetadata = this.clusterService.state().metadata().index(resultIndex);
            Map indexMapping = indexMetadata.mapping().sourceAsMap();
            if (!indexMapping.containsKey(propertyName = "properties") || !(indexMapping.get(propertyName) instanceof LinkedHashMap)) {
                return false;
            }
            LinkedHashMap mapping = (LinkedHashMap)indexMapping.get(propertyName);
            boolean correctResultIndexMapping = true;
            for (String fieldName : this.AD_RESULT_FIELD_CONFIGS.keySet()) {
                Object defaultSchema = this.AD_RESULT_FIELD_CONFIGS.get(fieldName);
                if (mapping.containsKey(fieldName) && defaultSchema.equals(mapping.get(fieldName))) continue;
                correctResultIndexMapping = false;
                break;
            }
            return correctResultIndexMapping;
        }
        catch (Exception e) {
            logger.error("Failed to validate result index mapping for index " + resultIndex, (Throwable)e);
            return false;
        }
    }

    public boolean doesDetectorStateIndexExist() {
        return this.clusterService.state().getRoutingTable().hasIndex(".opendistro-anomaly-detection-state");
    }

    public boolean doesCheckpointIndexExist() {
        return this.clusterService.state().getRoutingTable().hasIndex(".opendistro-anomaly-checkpoints");
    }

    public static boolean doesIndexExists(ClusterService clusterServiceAccessor, String name) {
        return clusterServiceAccessor.state().getRoutingTable().hasIndex(name);
    }

    public static boolean doesAliasExists(ClusterService clusterServiceAccessor, String alias) {
        return clusterServiceAccessor.state().metadata().hasAlias(alias);
    }

    private ActionListener<CreateIndexResponse> markMappingUpToDate(ADIndex index, ActionListener<CreateIndexResponse> followingListener) {
        return ActionListener.wrap(createdResponse -> {
            if (createdResponse.isAcknowledged()) {
                IndexState indexStatetate = this.indexStates.computeIfAbsent(index, x$0 -> new IndexState((ADIndex)((Object)((Object)x$0))));
                if (Boolean.FALSE.equals(indexStatetate.mappingUpToDate)) {
                    indexStatetate.mappingUpToDate = Boolean.TRUE;
                    logger.info((Message)new ParameterizedMessage("Mark [{}]'s mapping up-to-date", (Object)index.getIndexName()));
                }
            }
            followingListener.onResponse(createdResponse);
        }, exception -> followingListener.onFailure(exception));
    }

    public void initAnomalyDetectorIndexIfAbsent(ActionListener<CreateIndexResponse> actionListener) throws IOException {
        if (!this.doesAnomalyDetectorIndexExist()) {
            this.initAnomalyDetectorIndex(actionListener);
        }
    }

    public void initAnomalyDetectorIndex(ActionListener<CreateIndexResponse> actionListener) throws IOException {
        CreateIndexRequest request = new CreateIndexRequest(".opendistro-anomaly-detectors").mapping(AnomalyDetectionIndices.getAnomalyDetectorMappings(), XContentType.JSON).settings(this.settings);
        this.adminClient.indices().create(request, this.markMappingUpToDate(ADIndex.CONFIG, actionListener));
    }

    public void initDefaultAnomalyResultIndexIfAbsent(ActionListener<CreateIndexResponse> actionListener) throws IOException {
        if (!this.doesDefaultAnomalyResultIndexExist()) {
            this.initDefaultAnomalyResultIndexDirectly(actionListener);
        }
    }

    private void choosePrimaryShards(CreateIndexRequest request) {
        this.choosePrimaryShards(request, true);
    }

    private void choosePrimaryShards(CreateIndexRequest request, boolean hiddenIndex) {
        request.settings(Settings.builder().put("index.number_of_shards", this.getNumberOfPrimaryShards()).put("index.number_of_replicas", 1).put("index.hidden", hiddenIndex));
    }

    private int getNumberOfPrimaryShards() {
        return Math.min(this.nodeFilter.getNumberOfEligibleDataNodes(), this.maxPrimaryShards);
    }

    public void initDefaultAnomalyResultIndexDirectly(ActionListener<CreateIndexResponse> actionListener) throws IOException {
        this.initAnomalyResultIndexDirectly(AD_RESULT_HISTORY_INDEX_PATTERN, ".opendistro-anomaly-results", true, actionListener);
    }

    public void initCustomAnomalyResultIndexDirectly(String resultIndex, ActionListener<CreateIndexResponse> actionListener) throws IOException {
        this.initAnomalyResultIndexDirectly(resultIndex, null, false, actionListener);
    }

    public void initAnomalyResultIndexDirectly(String resultIndex, String alias, boolean hiddenIndex, ActionListener<CreateIndexResponse> actionListener) throws IOException {
        String mapping = AnomalyDetectionIndices.getAnomalyResultMappings();
        CreateIndexRequest request = new CreateIndexRequest(resultIndex).mapping(mapping, XContentType.JSON);
        if (alias != null) {
            request.alias(new Alias(".opendistro-anomaly-results"));
        }
        this.choosePrimaryShards(request, hiddenIndex);
        if (AD_RESULT_HISTORY_INDEX_PATTERN.equals(resultIndex)) {
            this.adminClient.indices().create(request, this.markMappingUpToDate(ADIndex.RESULT, actionListener));
        } else {
            this.adminClient.indices().create(request, actionListener);
        }
    }

    public void initAnomalyDetectorJobIndex(ActionListener<CreateIndexResponse> actionListener) {
        try {
            CreateIndexRequest request = new CreateIndexRequest(".opendistro-anomaly-detector-jobs").mapping(AnomalyDetectionIndices.getAnomalyDetectorJobMappings(), XContentType.JSON);
            request.settings(Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", minJobIndexReplicas + "-" + maxJobIndexReplicas).put("index.hidden", true));
            this.adminClient.indices().create(request, this.markMappingUpToDate(ADIndex.JOB, actionListener));
        }
        catch (IOException e) {
            logger.error("Fail to init AD job index", (Throwable)e);
            actionListener.onFailure((Exception)e);
        }
    }

    public void initDetectionStateIndex(ActionListener<CreateIndexResponse> actionListener) {
        try {
            CreateIndexRequest request = new CreateIndexRequest(".opendistro-anomaly-detection-state").mapping(AnomalyDetectionIndices.getDetectionStateMappings(), XContentType.JSON).settings(this.settings);
            this.adminClient.indices().create(request, this.markMappingUpToDate(ADIndex.STATE, actionListener));
        }
        catch (IOException e) {
            logger.error("Fail to init AD detection state index", (Throwable)e);
            actionListener.onFailure((Exception)e);
        }
    }

    public void initCheckpointIndex(ActionListener<CreateIndexResponse> actionListener) {
        String mapping;
        try {
            mapping = AnomalyDetectionIndices.getCheckpointMappings();
        }
        catch (IOException e) {
            throw new EndRunException("", "Cannot find checkpoint mapping file", true);
        }
        CreateIndexRequest request = new CreateIndexRequest(".opendistro-anomaly-checkpoints").mapping(mapping, XContentType.JSON);
        this.choosePrimaryShards(request);
        this.adminClient.indices().create(request, this.markMappingUpToDate(ADIndex.CHECKPOINT, actionListener));
    }

    public void onClusterManager() {
        try {
            this.rolloverAndDeleteHistoryIndex();
            this.scheduledRollover = this.threadPool.scheduleWithFixedDelay(() -> this.rolloverAndDeleteHistoryIndex(), this.historyRolloverPeriod, this.executorName());
        }
        catch (Exception e) {
            logger.error("Error rollover AD result indices. Can't rollover AD result until clusterManager node is restarted.", (Throwable)e);
        }
    }

    public void offClusterManager() {
        if (this.scheduledRollover != null) {
            this.scheduledRollover.cancel();
        }
    }

    private String executorName() {
        return "management";
    }

    private void rescheduleRollover() {
        if (this.clusterService.state().getNodes().isLocalNodeElectedClusterManager()) {
            if (this.scheduledRollover != null) {
                this.scheduledRollover.cancel();
            }
            this.scheduledRollover = this.threadPool.scheduleWithFixedDelay(() -> this.rolloverAndDeleteHistoryIndex(), this.historyRolloverPeriod, this.executorName());
        }
    }

    void rolloverAndDeleteHistoryIndex() {
        if (!this.doesDefaultAnomalyResultIndexExist()) {
            return;
        }
        RolloverRequest rollOverRequest = new RolloverRequest(".opendistro-anomaly-results", null);
        String adResultMapping = null;
        try {
            adResultMapping = AnomalyDetectionIndices.getAnomalyResultMappings();
        }
        catch (IOException e) {
            logger.error("Fail to roll over AD result index, as can't get AD result index mapping");
            return;
        }
        CreateIndexRequest createRequest = rollOverRequest.getCreateIndexRequest();
        createRequest.index(AD_RESULT_HISTORY_INDEX_PATTERN).mapping(adResultMapping, XContentType.JSON);
        this.choosePrimaryShards(createRequest);
        rollOverRequest.addMaxIndexDocsCondition(this.historyMaxDocs * (long)this.getNumberOfPrimaryShards());
        this.adminClient.indices().rolloverIndex(rollOverRequest, ActionListener.wrap(response -> {
            if (!response.isRolledOver()) {
                logger.warn("{} not rolled over. Conditions were: {}", (Object)".opendistro-anomaly-results", (Object)response.getConditionStatus());
            } else {
                IndexState indexStatetate = this.indexStates.computeIfAbsent(ADIndex.RESULT, x$0 -> new IndexState((ADIndex)((Object)((Object)x$0))));
                indexStatetate.mappingUpToDate = true;
                logger.info("{} rolled over. Conditions were: {}", (Object)".opendistro-anomaly-results", (Object)response.getConditionStatus());
                this.deleteOldHistoryIndices();
            }
        }, exception -> logger.error("Fail to roll over result index", (Throwable)exception)));
    }

    void deleteOldHistoryIndices() {
        HashSet candidates = new HashSet();
        ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(new String[]{ALL_AD_RESULTS_INDEX_PATTERN}).metadata(true).local(true)).indicesOptions(IndicesOptions.strictExpand());
        this.adminClient.cluster().state(clusterStateRequest, ActionListener.wrap(clusterStateResponse -> {
            String latestToDelete = null;
            long latest = Long.MIN_VALUE;
            for (ObjectCursor cursor : clusterStateResponse.getState().metadata().indices().values()) {
                IndexMetadata indexMetaData = (IndexMetadata)cursor.value;
                long creationTime = indexMetaData.getCreationDate();
                if (Instant.now().toEpochMilli() - creationTime <= this.historyRetentionPeriod.millis()) continue;
                String indexName = indexMetaData.getIndex().getName();
                candidates.add(indexName);
                if (latest >= creationTime) continue;
                latest = creationTime;
                latestToDelete = indexName;
            }
            if (candidates.size() > 1) {
                candidates.remove(latestToDelete);
                String[] toDelete = candidates.toArray(Strings.EMPTY_ARRAY);
                DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(toDelete);
                this.adminClient.indices().delete(deleteIndexRequest, ActionListener.wrap(deleteIndexResponse -> {
                    if (!deleteIndexResponse.isAcknowledged()) {
                        logger.error("Could not delete one or more Anomaly result indices: {}. Retrying one by one.", (Object)Arrays.toString(toDelete));
                        this.deleteIndexIteration(toDelete);
                    } else {
                        logger.info("Succeeded in deleting expired anomaly result indices: {}.", (Object)Arrays.toString(toDelete));
                    }
                }, exception -> {
                    logger.error("Failed to delete expired anomaly result indices: {}.", (Object)Arrays.toString(toDelete));
                    this.deleteIndexIteration(toDelete);
                }));
            }
        }, exception -> logger.error("Fail to delete result indices", (Throwable)exception)));
    }

    private void deleteIndexIteration(String[] toDelete) {
        for (String index : toDelete) {
            DeleteIndexRequest singleDeleteRequest = new DeleteIndexRequest(index);
            this.adminClient.indices().delete(singleDeleteRequest, ActionListener.wrap(singleDeleteResponse -> {
                if (!singleDeleteResponse.isAcknowledged()) {
                    logger.error("Retrying deleting {} does not succeed.", (Object)index);
                }
            }, exception -> {
                if (exception instanceof IndexNotFoundException) {
                    logger.info("{} was already deleted.", (Object)index);
                } else {
                    logger.error((Message)new ParameterizedMessage("Retrying deleting {} does not succeed.", (Object)index), (Throwable)exception);
                }
            }));
        }
    }

    public void update() {
        if (this.allMappingUpdated && this.allSettingUpdated || this.updateRunningTimes >= this.maxUpdateRunningTimes || this.updateRunning.get()) {
            return;
        }
        this.updateRunning.set(true);
        ++this.updateRunningTimes;
        GroupedActionListener groupListeneer = new GroupedActionListener(ActionListener.wrap(r -> this.updateRunning.set(false), exception -> {
            this.updateRunning.set(false);
            logger.error("Fail to update AD indices", (Throwable)exception);
        }), 2);
        this.updateMappingIfNecessary((GroupedActionListener<Void>)groupListeneer);
        this.updateSettingIfNecessary((GroupedActionListener<Void>)groupListeneer);
    }

    private void updateSettingIfNecessary(GroupedActionListener<Void> delegateListeneer) {
        if (this.allSettingUpdated) {
            delegateListeneer.onResponse(null);
            return;
        }
        ArrayList<ADIndex> updates = new ArrayList<ADIndex>();
        for (ADIndex index : ADIndex.values()) {
            Boolean updated = this.indexStates.computeIfAbsent((ADIndex)index, (Function<ADIndex, IndexState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateSettingIfNecessary$29(org.opensearch.ad.indices.ADIndex ), (Lorg/opensearch/ad/indices/ADIndex;)Lorg/opensearch/ad/indices/AnomalyDetectionIndices$IndexState;)((AnomalyDetectionIndices)this)).settingUpToDate;
            if (!Boolean.FALSE.equals(updated)) continue;
            updates.add(index);
        }
        if (updates.size() == 0) {
            this.allSettingUpdated = true;
            delegateListeneer.onResponse(null);
            return;
        }
        GroupedActionListener conglomerateListeneer = new GroupedActionListener(ActionListener.wrap(r -> delegateListeneer.onResponse(null), exception -> {
            delegateListeneer.onResponse(null);
            logger.error("Fail to update AD indices' mappings", (Throwable)exception);
        }), updates.size());
        block4: for (ADIndex adIndex : updates) {
            logger.info((Message)new ParameterizedMessage("Check [{}]'s setting", (Object)adIndex.getIndexName()));
            switch (adIndex) {
                case JOB: {
                    this.updateJobIndexSettingIfNecessary(this.indexStates.computeIfAbsent(adIndex, x$0 -> new IndexState((ADIndex)((Object)x$0))), (ActionListener<Void>)conglomerateListeneer);
                    continue block4;
                }
            }
            IndexState indexState = this.indexStates.computeIfAbsent(adIndex, x$0 -> new IndexState((ADIndex)((Object)x$0)));
            indexState.settingUpToDate = true;
            logger.info((Message)new ParameterizedMessage("Mark [{}]'s setting up-to-date", (Object)adIndex.getIndexName()));
            conglomerateListeneer.onResponse(null);
        }
    }

    private void updateMappingIfNecessary(GroupedActionListener<Void> delegateListeneer) {
        if (this.allMappingUpdated) {
            delegateListeneer.onResponse(null);
            return;
        }
        ArrayList<ADIndex> updates = new ArrayList<ADIndex>();
        for (ADIndex index : ADIndex.values()) {
            Boolean updated = this.indexStates.computeIfAbsent((ADIndex)index, (Function<ADIndex, IndexState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateMappingIfNecessary$34(org.opensearch.ad.indices.ADIndex ), (Lorg/opensearch/ad/indices/ADIndex;)Lorg/opensearch/ad/indices/AnomalyDetectionIndices$IndexState;)((AnomalyDetectionIndices)this)).mappingUpToDate;
            if (!Boolean.FALSE.equals(updated)) continue;
            updates.add(index);
        }
        if (updates.size() == 0) {
            this.allMappingUpdated = true;
            delegateListeneer.onResponse(null);
            return;
        }
        GroupedActionListener conglomerateListeneer = new GroupedActionListener(ActionListener.wrap(r -> delegateListeneer.onResponse(null), exception -> {
            delegateListeneer.onResponse(null);
            logger.error("Fail to update AD indices' mappings", (Throwable)exception);
        }), updates.size());
        for (ADIndex adIndex : updates) {
            logger.info((Message)new ParameterizedMessage("Check [{}]'s mapping", (Object)adIndex.getIndexName()));
            this.shouldUpdateIndex(adIndex, (ActionListener<Boolean>)ActionListener.wrap(shouldUpdate -> {
                if (shouldUpdate.booleanValue()) {
                    this.adminClient.indices().putMapping(new PutMappingRequest().indices(new String[]{adIndex.getIndexName()}).source(adIndex.getMapping(), XContentType.JSON), ActionListener.wrap(putMappingResponse -> {
                        if (putMappingResponse.isAcknowledged()) {
                            logger.info((Message)new ParameterizedMessage("Succeeded in updating [{}]'s mapping", (Object)adIndex.getIndexName()));
                            this.markMappingUpdated(adIndex);
                        } else {
                            logger.error((Message)new ParameterizedMessage("Fail to update [{}]'s mapping", (Object)adIndex.getIndexName()));
                        }
                        conglomerateListeneer.onResponse(null);
                    }, exception -> {
                        logger.error((Message)new ParameterizedMessage("Fail to update [{}]'s mapping due to [{}]", (Object)adIndex.getIndexName(), (Object)exception.getMessage()));
                        conglomerateListeneer.onFailure(exception);
                    }));
                } else {
                    logger.info((Message)new ParameterizedMessage("We don't need to update [{}]'s mapping", (Object)adIndex.getIndexName()));
                    this.markMappingUpdated(adIndex);
                    conglomerateListeneer.onResponse(null);
                }
            }, exception -> {
                logger.error((Message)new ParameterizedMessage("Fail to check whether we should update [{}]'s mapping", (Object)adIndex.getIndexName()), (Throwable)exception);
                conglomerateListeneer.onFailure(exception);
            }));
        }
    }

    private void markMappingUpdated(ADIndex adIndex) {
        IndexState indexState = this.indexStates.computeIfAbsent(adIndex, x$0 -> new IndexState((ADIndex)((Object)x$0)));
        if (Boolean.FALSE.equals(indexState.mappingUpToDate)) {
            indexState.mappingUpToDate = Boolean.TRUE;
            logger.info((Message)new ParameterizedMessage("Mark [{}]'s mapping up-to-date", (Object)adIndex.getIndexName()));
        }
    }

    private void shouldUpdateIndex(ADIndex index, ActionListener<Boolean> thenDo) {
        boolean exists = false;
        exists = index.isAlias() ? AnomalyDetectionIndices.doesAliasExists(this.clusterService, index.getIndexName()) : AnomalyDetectionIndices.doesIndexExists(this.clusterService, index.getIndexName());
        if (!exists) {
            thenDo.onResponse((Object)Boolean.FALSE);
            return;
        }
        Integer newVersion = this.indexStates.computeIfAbsent((ADIndex)index, (Function<ADIndex, IndexState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$shouldUpdateIndex$42(org.opensearch.ad.indices.ADIndex ), (Lorg/opensearch/ad/indices/ADIndex;)Lorg/opensearch/ad/indices/AnomalyDetectionIndices$IndexState;)((AnomalyDetectionIndices)this)).schemaVersion;
        if (index.isAlias()) {
            GetAliasesRequest getAliasRequest = new GetAliasesRequest().aliases(new String[]{index.getIndexName()}).indicesOptions(IndicesOptions.lenientExpandOpenHidden());
            this.adminClient.indices().getAliases(getAliasRequest, ActionListener.wrap(getAliasResponse -> {
                String concreteIndex = null;
                for (ObjectObjectCursor entry : getAliasResponse.getAliases()) {
                    if (((List)entry.value).isEmpty()) continue;
                    concreteIndex = (String)entry.key;
                    break;
                }
                if (concreteIndex == null) {
                    thenDo.onResponse((Object)Boolean.FALSE);
                    return;
                }
                this.shouldUpdateConcreteIndex(concreteIndex, newVersion, thenDo);
            }, exception -> logger.error((Message)new ParameterizedMessage("Fail to get [{}]'s alias", (Object)index.getIndexName()), (Throwable)exception)));
        } else {
            this.shouldUpdateConcreteIndex(index.getIndexName(), newVersion, thenDo);
        }
    }

    private void shouldUpdateConcreteIndex(String concreteIndex, Integer newVersion, ActionListener<Boolean> thenDo) {
        Map metaMapping;
        Object schemaVersion;
        IndexMetadata indexMeataData = (IndexMetadata)this.clusterService.state().getMetadata().indices().get((Object)concreteIndex);
        if (indexMeataData == null) {
            thenDo.onResponse((Object)Boolean.FALSE);
            return;
        }
        Integer oldVersion = CommonValue.NO_SCHEMA_VERSION;
        Map indexMapping = indexMeataData.mapping().getSourceAsMap();
        Object meta = indexMapping.get(META);
        if (meta != null && meta instanceof Map && (schemaVersion = (metaMapping = (Map)meta).get(SCHEMA_VERSION)) instanceof Integer) {
            oldVersion = (Integer)schemaVersion;
        }
        thenDo.onResponse((Object)(newVersion > oldVersion ? 1 : 0));
    }

    private static Integer parseSchemaVersion(String mapping) {
        try {
            XContentParser xcp = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, mapping);
            while (!xcp.isClosed()) {
                XContentParser.Token token = xcp.currentToken();
                if (token != null && token != XContentParser.Token.END_OBJECT && token != XContentParser.Token.START_OBJECT) {
                    if (xcp.currentName() != META) {
                        xcp.nextToken();
                        xcp.skipChildren();
                    } else {
                        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                            if (xcp.currentName().equals(SCHEMA_VERSION)) {
                                Integer version = xcp.intValue();
                                if (version < 0) {
                                    version = CommonValue.NO_SCHEMA_VERSION;
                                }
                                return version;
                            }
                            xcp.nextToken();
                        }
                    }
                }
                xcp.nextToken();
            }
            return CommonValue.NO_SCHEMA_VERSION;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getSchemaVersion(ADIndex index) {
        IndexState indexState = this.indexStates.computeIfAbsent(index, x$0 -> new IndexState((ADIndex)((Object)x$0)));
        return indexState.schemaVersion;
    }

    private void updateJobIndexSettingIfNecessary(IndexState jobIndexState, ActionListener<Void> listener) {
        GetSettingsRequest getSettingsRequest = new GetSettingsRequest().indices(new String[]{ADIndex.JOB.getIndexName()}).names(new String[]{"index.number_of_shards", "index.number_of_replicas", "index.auto_expand_replicas"});
        this.client.execute((ActionType)GetSettingsAction.INSTANCE, (ActionRequest)getSettingsRequest, ActionListener.wrap(settingResponse -> {
            String autoExpandReplica = AnomalyDetectionIndices.getStringSetting(settingResponse, "index.auto_expand_replicas");
            if (autoExpandReplica != null) {
                jobIndexState.settingUpToDate = true;
                logger.info((Message)new ParameterizedMessage("Mark [{}]'s mapping up-to-date", (Object)ADIndex.JOB.getIndexName()));
                listener.onResponse(null);
                return;
            }
            Integer primaryShardsNumber = AnomalyDetectionIndices.getIntegerSetting(settingResponse, "index.number_of_shards");
            Integer replicaNumber = AnomalyDetectionIndices.getIntegerSetting(settingResponse, "index.number_of_replicas");
            if (primaryShardsNumber == null || replicaNumber == null) {
                logger.error((Message)new ParameterizedMessage("Fail to find AD job index's primary or replica shard number: primary [{}], replica [{}]", (Object)primaryShardsNumber, (Object)replicaNumber));
                listener.onResponse(null);
                return;
            }
            int maxExpectedReplicas = Math.max(maxJobIndexReplicas / primaryShardsNumber, minJobIndexReplicas);
            Settings updatedSettings = Settings.builder().put("index.auto_expand_replicas", minJobIndexReplicas + "-" + maxExpectedReplicas).build();
            UpdateSettingsRequest updateSettingsRequest = new UpdateSettingsRequest(new String[]{ADIndex.JOB.getIndexName()}).settings(updatedSettings);
            this.client.admin().indices().updateSettings(updateSettingsRequest, ActionListener.wrap(response -> {
                jobIndexState.settingUpToDate = true;
                logger.info((Message)new ParameterizedMessage("Mark [{}]'s mapping up-to-date", (Object)ADIndex.JOB.getIndexName()));
                listener.onResponse(null);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                jobIndexState.settingUpToDate = true;
                logger.info((Message)new ParameterizedMessage("Mark [{}]'s mapping up-to-date", (Object)ADIndex.JOB.getIndexName()));
                listener.onResponse(null);
            } else {
                listener.onFailure(e);
            }
        }));
    }

    private static Integer getIntegerSetting(GetSettingsResponse settingsResponse, String settingKey) {
        Settings settings;
        Integer value = null;
        Iterator iter = settingsResponse.getIndexToSettings().valuesIt();
        while (iter.hasNext() && (value = (settings = (Settings)iter.next()).getAsInt(settingKey, null)) == null) {
        }
        return value;
    }

    private static String getStringSetting(GetSettingsResponse settingsResponse, String settingKey) {
        Settings settings;
        String value = null;
        Iterator iter = settingsResponse.getIndexToSettings().valuesIt();
        while (iter.hasNext() && (value = (settings = (Settings)iter.next()).get(settingKey, null)) == null) {
        }
        return value;
    }

    private /* synthetic */ IndexState lambda$shouldUpdateIndex$42(ADIndex x$0) {
        return new IndexState(x$0);
    }

    private /* synthetic */ IndexState lambda$updateMappingIfNecessary$34(ADIndex x$0) {
        return new IndexState(x$0);
    }

    private /* synthetic */ IndexState lambda$updateSettingIfNecessary$29(ADIndex x$0) {
        return new IndexState(x$0);
    }

    class IndexState {
        private Boolean mappingUpToDate = false;
        private Boolean settingUpToDate = false;
        private Integer schemaVersion;

        IndexState(ADIndex index) {
            this.schemaVersion = AnomalyDetectionIndices.parseSchemaVersion(index.getMapping());
        }
    }
}

