/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.plugin.config;

import org.opensearch.client.node.NodeClient;
import org.opensearch.sql.analysis.Analyzer;
import org.opensearch.sql.analysis.ExpressionAnalyzer;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.executor.QueryManager;
import org.opensearch.sql.executor.QueryService;
import org.opensearch.sql.executor.execution.QueryPlanFactory;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.monitor.ResourceMonitor;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.client.OpenSearchNodeClient;
import org.opensearch.sql.opensearch.executor.OpenSearchExecutionEngine;
import org.opensearch.sql.opensearch.executor.OpenSearchQueryManager;
import org.opensearch.sql.opensearch.executor.protector.ExecutionProtector;
import org.opensearch.sql.opensearch.executor.protector.OpenSearchExecutionProtector;
import org.opensearch.sql.opensearch.monitor.OpenSearchMemoryHealthy;
import org.opensearch.sql.opensearch.monitor.OpenSearchResourceMonitor;
import org.opensearch.sql.opensearch.storage.OpenSearchStorageEngine;
import org.opensearch.sql.planner.Planner;
import org.opensearch.sql.planner.optimizer.LogicalPlanOptimizer;
import org.opensearch.sql.storage.StorageEngine;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class OpenSearchPluginConfig {
    @Autowired
    private NodeClient nodeClient;
    @Autowired
    private Settings settings;
    @Autowired
    private DataSourceService dataSourceService;

    @Bean
    @Scope(value="prototype")
    public OpenSearchClient client() {
        return new OpenSearchNodeClient(this.nodeClient);
    }

    @Bean
    @Scope(value="prototype")
    public StorageEngine storageEngine() {
        return new OpenSearchStorageEngine(this.client(), this.settings);
    }

    @Bean
    @Scope(value="prototype")
    public ExecutionEngine executionEngine() {
        return new OpenSearchExecutionEngine(this.client(), this.protector());
    }

    @Bean
    @Scope(value="prototype")
    public ResourceMonitor resourceMonitor() {
        return new OpenSearchResourceMonitor(this.settings, new OpenSearchMemoryHealthy());
    }

    @Bean
    @Scope(value="prototype")
    public ExecutionProtector protector() {
        return new OpenSearchExecutionProtector(this.resourceMonitor());
    }

    @Bean
    public QueryManager queryManager() {
        return new OpenSearchQueryManager(this.nodeClient);
    }

    @Bean
    @Scope(value="prototype")
    public QueryPlanFactory queryExecutionFactory() {
        BuiltinFunctionRepository functionRepository = BuiltinFunctionRepository.getInstance();
        Analyzer analyzer = new Analyzer(new ExpressionAnalyzer(functionRepository), this.dataSourceService, functionRepository);
        Planner planner = new Planner(LogicalPlanOptimizer.create());
        return new QueryPlanFactory(new QueryService(analyzer, this.executionEngine(), planner));
    }
}

