# This file has been autogenerated by the pywayland scanner

# Copyright © 2022 Joshua Ashton
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)
from ..wayland import WlSurface
from .xwayland_surface_v1 import XwaylandSurfaceV1


class XwaylandShellV1(Interface):
    """Context object for xwayland shell

    :class:`XwaylandShellV1` is a singleton global object that provides the
    ability to create a
    :class:`~pywayland.protocol.xwayland_shell_v1.XwaylandSurfaceV1` object for
    a given :class:`~pywayland.protocol.wayland.WlSurface`.

    This interface is intended to be bound by the Xwayland server.

    A compositor must not allow clients other than Xwayland to bind to this
    interface. A compositor should hide this global from other clients'
    :class:`~pywayland.protocol.wayland.WlRegistry`. A client the compositor
    does not consider to be an Xwayland server attempting to bind this
    interface will result in an implementation-defined error.

    An Xwayland server that has bound this interface must not set the
    `WL_SURFACE_ID` atom on a window.
    """

    name = "xwayland_shell_v1"
    version = 1

    class error(enum.IntEnum):
        role = 0


class XwaylandShellV1Proxy(Proxy[XwaylandShellV1]):
    interface = XwaylandShellV1

    @XwaylandShellV1.request()
    def destroy(self) -> None:
        """Destroy the xwayland shell object

        Destroy the :class:`XwaylandShellV1` object.

        The child objects created via this interface are unaffected.
        """
        self._marshal(0)
        self._destroy()

    @XwaylandShellV1.request(
        Argument(ArgumentType.NewId, interface=XwaylandSurfaceV1),
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def get_xwayland_surface(self, surface: WlSurface) -> Proxy[XwaylandSurfaceV1]:
        """Assign the xwayland_surface surface role

        Create an
        :class:`~pywayland.protocol.xwayland_shell_v1.XwaylandSurfaceV1`
        interface for a given :class:`~pywayland.protocol.wayland.WlSurface`
        object and gives it the xwayland_surface role.

        It is illegal to create an
        :class:`~pywayland.protocol.xwayland_shell_v1.XwaylandSurfaceV1` for a
        :class:`~pywayland.protocol.wayland.WlSurface` which already has an
        assigned role and this will result in the `role` protocol error.

        See the documentation of
        :class:`~pywayland.protocol.xwayland_shell_v1.XwaylandSurfaceV1` for
        more details about what an
        :class:`~pywayland.protocol.xwayland_shell_v1.XwaylandSurfaceV1` is and
        how it is used.

        :param surface:
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :returns:
            :class:`~pywayland.protocol.xwayland_shell_v1.XwaylandSurfaceV1`
        """
        id = self._marshal_constructor(1, XwaylandSurfaceV1, surface)
        return id


class XwaylandShellV1Resource(Resource):
    interface = XwaylandShellV1


class XwaylandShellV1Global(Global):
    interface = XwaylandShellV1


XwaylandShellV1._gen_c()
XwaylandShellV1.proxy_class = XwaylandShellV1Proxy
XwaylandShellV1.resource_class = XwaylandShellV1Resource
XwaylandShellV1.global_class = XwaylandShellV1Global
