/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.nio.channels.NetworkChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLEngine;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.compat.JrePlatform;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AbstractJsseEndpoint;
import org.apache.tomcat.util.net.Acceptor;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.net.Nio2Channel;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SecureNio2Channel;
import org.apache.tomcat.util.net.SendfileDataBase;
import org.apache.tomcat.util.net.SendfileState;
import org.apache.tomcat.util.net.SocketBufferHandler;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketProcessorBase;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.net.jsse.JSSESupport;

public class Nio2Endpoint
extends AbstractJsseEndpoint<Nio2Channel, AsynchronousSocketChannel> {
    private static final Log log = LogFactory.getLog(Nio2Endpoint.class);
    private static final Log logCertificate = LogFactory.getLog((String)(Nio2Endpoint.class.getName() + ".certificate"));
    private static final Log logHandshake = LogFactory.getLog((String)(Nio2Endpoint.class.getName() + ".handshake"));
    private volatile AsynchronousServerSocketChannel serverSock = null;
    private static ThreadLocal<Boolean> inlineCompletion = new ThreadLocal();
    private AsynchronousChannelGroup threadGroup = null;
    private volatile boolean allClosed;
    private SynchronizedStack<Nio2Channel> nioChannels;
    private SocketAddress previousAcceptedSocketRemoteAddress = null;
    private long previousAcceptedSocketNanoTime = 0L;

    @Override
    public boolean getDeferAccept() {
        return false;
    }

    public int getKeepAliveCount() {
        return -1;
    }

    @Override
    public void bind() throws Exception {
        if (this.getExecutor() == null) {
            this.createExecutor();
        }
        if (this.getExecutor() instanceof ExecutorService) {
            this.threadGroup = AsynchronousChannelGroup.withThreadPool((ExecutorService)this.getExecutor());
        }
        if (!this.internalExecutor) {
            log.warn((Object)sm.getString("endpoint.nio2.exclusiveExecutor"));
        }
        this.serverSock = AsynchronousServerSocketChannel.open(this.threadGroup);
        this.socketProperties.setProperties(this.serverSock);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.getAddress(), this.getPortWithOffset());
        this.serverSock.bind(inetSocketAddress, this.getAcceptCount());
        this.initialiseSsl();
    }

    @Override
    public void startInternal() throws Exception {
        if (!this.running) {
            this.allClosed = false;
            this.running = true;
            this.paused = false;
            if (this.socketProperties.getProcessorCache() != 0) {
                this.processorCache = new SynchronizedStack(128, this.socketProperties.getProcessorCache());
            }
            if (this.socketProperties.getBufferPool() != 0) {
                this.nioChannels = new SynchronizedStack(128, this.socketProperties.getBufferPool());
            }
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            this.initializeConnectionLatch();
            this.startAcceptorThread();
        }
    }

    @Override
    protected void startAcceptorThread() {
        if (this.acceptor == null) {
            this.acceptor = new Nio2Acceptor(this);
            this.acceptor.setThreadName(this.getName() + "-Acceptor");
        }
        this.acceptor.state = Acceptor.AcceptorState.RUNNING;
        this.getExecutor().execute(this.acceptor);
    }

    @Override
    public void resume() {
        super.resume();
        if (this.isRunning()) {
            this.acceptor.state = Acceptor.AcceptorState.RUNNING;
            this.getExecutor().execute(this.acceptor);
        }
    }

    @Override
    public void stopInternal() {
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            this.running = false;
            this.acceptor.stop(10);
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (SocketWrapperBase socketWrapperBase : Nio2Endpoint.this.getConnections()) {
                            socketWrapperBase.close();
                        }
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                    }
                    finally {
                        Nio2Endpoint.this.allClosed = true;
                    }
                }
            });
            if (this.nioChannels != null) {
                Nio2Channel nio2Channel;
                while ((nio2Channel = (Nio2Channel)this.nioChannels.pop()) != null) {
                    nio2Channel.free();
                }
                this.nioChannels = null;
            }
            if (this.processorCache != null) {
                this.processorCache.clear();
                this.processorCache = null;
            }
        }
    }

    @Override
    public void unbind() throws Exception {
        if (this.running) {
            this.stop();
        }
        this.doCloseServerSocket();
        this.destroySsl();
        super.unbind();
        this.shutdownExecutor();
        if (this.getHandler() != null) {
            this.getHandler().recycle();
        }
    }

    @Override
    protected void doCloseServerSocket() throws IOException {
        if (this.serverSock != null) {
            this.serverSock.close();
            this.serverSock = null;
        }
    }

    @Override
    public void shutdownExecutor() {
        if (this.threadGroup != null && this.internalExecutor) {
            try {
                long l;
                for (l = this.getExecutorTerminationTimeoutMillis(); l > 0L && !this.allClosed; --l) {
                    Thread.sleep(1L);
                }
                this.threadGroup.shutdownNow();
                if (l > 0L) {
                    this.threadGroup.awaitTermination(l, TimeUnit.MILLISECONDS);
                }
            }
            catch (IOException iOException) {
                this.getLog().warn((Object)sm.getString("endpoint.warn.executorShutdown", new Object[]{this.getName()}), (Throwable)iOException);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.threadGroup.isTerminated()) {
                this.getLog().warn((Object)sm.getString("endpoint.warn.executorShutdown", new Object[]{this.getName()}));
            }
            this.threadGroup = null;
        }
        super.shutdownExecutor();
    }

    @Override
    protected boolean setSocketOptions(AsynchronousSocketChannel asynchronousSocketChannel) {
        Object object = null;
        try {
            Object object2;
            Nio2Channel nio2Channel = null;
            if (this.nioChannels != null) {
                nio2Channel = (Nio2Channel)this.nioChannels.pop();
            }
            if (nio2Channel == null) {
                object2 = new SocketBufferHandler(this.socketProperties.getAppReadBufSize(), this.socketProperties.getAppWriteBufSize(), this.socketProperties.getDirectBuffer());
                nio2Channel = this.isSSLEnabled() ? new SecureNio2Channel((SocketBufferHandler)object2, this) : new Nio2Channel((SocketBufferHandler)object2);
            }
            object2 = new Nio2SocketWrapper(nio2Channel, this);
            nio2Channel.reset(asynchronousSocketChannel, (SocketWrapperBase<Nio2Channel>)object2);
            this.connections.put(asynchronousSocketChannel, object2);
            object = object2;
            this.socketProperties.setProperties(asynchronousSocketChannel);
            ((SocketWrapperBase)object).setReadTimeout(this.getConnectionTimeout());
            ((SocketWrapperBase)object).setWriteTimeout(this.getConnectionTimeout());
            ((SocketWrapperBase)object).setKeepAliveLeft(this.getMaxKeepAliveRequests());
            return this.processSocket(object, SocketEvent.OPEN_READ, false);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.error((Object)sm.getString("endpoint.socketOptionsError"), throwable);
            if (object == null) {
                this.destroySocket(asynchronousSocketChannel);
            }
            return false;
        }
    }

    @Override
    protected void destroySocket(AsynchronousSocketChannel asynchronousSocketChannel) {
        block2: {
            this.countDownConnection();
            try {
                asynchronousSocketChannel.close();
            }
            catch (IOException iOException) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)sm.getString("endpoint.err.close"), (Throwable)iOException);
            }
        }
    }

    protected SynchronizedStack<Nio2Channel> getNioChannels() {
        return this.nioChannels;
    }

    @Override
    protected NetworkChannel getServerSocket() {
        return this.serverSock;
    }

    @Override
    protected AsynchronousSocketChannel serverSocketAccept() throws Exception {
        AsynchronousSocketChannel asynchronousSocketChannel = this.serverSock.accept().get();
        if (!JrePlatform.IS_WINDOWS) {
            SocketAddress socketAddress = asynchronousSocketChannel.getRemoteAddress();
            long l = System.nanoTime();
            if (socketAddress.equals(this.previousAcceptedSocketRemoteAddress) && l - this.previousAcceptedSocketNanoTime < 1000L) {
                throw new IOException(sm.getString("endpoint.err.duplicateAccept"));
            }
            this.previousAcceptedSocketRemoteAddress = socketAddress;
            this.previousAcceptedSocketNanoTime = l;
        }
        return asynchronousSocketChannel;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected Log getLogCertificate() {
        return logCertificate;
    }

    @Override
    protected SocketProcessorBase<Nio2Channel> createSocketProcessor(SocketWrapperBase<Nio2Channel> socketWrapperBase, SocketEvent socketEvent) {
        return new SocketProcessor(socketWrapperBase, socketEvent);
    }

    public static void startInline() {
        inlineCompletion.set(Boolean.TRUE);
    }

    public static void endInline() {
        inlineCompletion.set(Boolean.FALSE);
    }

    public static boolean isInline() {
        Boolean bl = inlineCompletion.get();
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public static class SendfileData
    extends SendfileDataBase {
        private FileChannel fchannel;
        private boolean doneInline = false;
        private boolean error = false;

        public SendfileData(String string, long l, long l2) {
            super(string, l, l2);
        }
    }

    protected class SocketProcessor
    extends SocketProcessorBase<Nio2Channel> {
        public SocketProcessor(SocketWrapperBase<Nio2Channel> socketWrapperBase, SocketEvent socketEvent) {
            super(socketWrapperBase, socketEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRun() {
            boolean bl = false;
            try {
                int n;
                block30: {
                    n = -1;
                    try {
                        if (((Nio2Channel)this.socketWrapper.getSocket()).isHandshakeComplete()) {
                            n = 0;
                        } else if (this.event == SocketEvent.STOP || this.event == SocketEvent.DISCONNECT || this.event == SocketEvent.ERROR) {
                            n = -1;
                        } else {
                            n = ((Nio2Channel)this.socketWrapper.getSocket()).handshake();
                            this.event = SocketEvent.OPEN_READ;
                        }
                    }
                    catch (IOException iOException) {
                        n = -1;
                        if (!logHandshake.isDebugEnabled()) break block30;
                        logHandshake.debug((Object)AbstractEndpoint.sm.getString("endpoint.err.handshake", new Object[]{this.socketWrapper.getRemoteAddr(), Integer.toString(this.socketWrapper.getRemotePort())}), (Throwable)iOException);
                    }
                }
                if (n == 0) {
                    AbstractEndpoint.Handler.SocketState socketState = AbstractEndpoint.Handler.SocketState.OPEN;
                    socketState = this.event == null ? Nio2Endpoint.this.getHandler().process(this.socketWrapper, SocketEvent.OPEN_READ) : Nio2Endpoint.this.getHandler().process(this.socketWrapper, this.event);
                    if (socketState == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        this.socketWrapper.close();
                    } else if (socketState == AbstractEndpoint.Handler.SocketState.UPGRADING) {
                        bl = true;
                    }
                } else if (n == -1) {
                    Nio2Endpoint.this.getHandler().process(this.socketWrapper, SocketEvent.CONNECT_FAIL);
                    this.socketWrapper.close();
                }
            }
            catch (VirtualMachineError virtualMachineError) {
                ExceptionUtils.handleThrowable((Throwable)virtualMachineError);
            }
            catch (Throwable throwable) {
                log.error((Object)AbstractEndpoint.sm.getString("endpoint.processing.fail"), throwable);
                if (this.socketWrapper != null) {
                    ((Nio2SocketWrapper)this.socketWrapper).close();
                }
            }
            finally {
                block32: {
                    if (bl) {
                        try {
                            Nio2Endpoint.this.getExecutor().execute(new SocketProcessor(this.socketWrapper, SocketEvent.OPEN_READ));
                        }
                        catch (NullPointerException nullPointerException) {
                            if (!Nio2Endpoint.this.running) break block32;
                            log.error((Object)AbstractEndpoint.sm.getString("endpoint.launch.fail"), (Throwable)nullPointerException);
                        }
                    }
                }
                this.socketWrapper = null;
                this.event = null;
                if (Nio2Endpoint.this.running && Nio2Endpoint.this.processorCache != null) {
                    Nio2Endpoint.this.processorCache.push((Object)this);
                }
            }
        }
    }

    public static class Nio2SocketWrapper
    extends SocketWrapperBase<Nio2Channel> {
        private final SynchronizedStack<Nio2Channel> nioChannels;
        private SendfileData sendfileData = null;
        private final CompletionHandler<Integer, ByteBuffer> readCompletionHandler;
        private boolean readInterest = false;
        private boolean readNotify = false;
        private final CompletionHandler<Integer, ByteBuffer> writeCompletionHandler;
        private final CompletionHandler<Long, ByteBuffer[]> gatheringWriteCompletionHandler;
        private boolean writeInterest = false;
        private boolean writeNotify = false;
        private CompletionHandler<Integer, SendfileData> sendfileHandler = new CompletionHandler<Integer, SendfileData>(){

            @Override
            public void completed(Integer n, SendfileData sendfileData) {
                if (n < 0) {
                    this.failed((Throwable)new EOFException(), sendfileData);
                    return;
                }
                sendfileData.pos += (long)n.intValue();
                ByteBuffer byteBuffer = ((Nio2Channel)this.getSocket()).getBufHandler().getWriteBuffer();
                if (!byteBuffer.hasRemaining()) {
                    if (sendfileData.length <= 0L) {
                        this.setSendfileData(null);
                        try {
                            sendfileData.fchannel.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (Nio2Endpoint.isInline()) {
                            sendfileData.doneInline = true;
                        } else {
                            switch (sendfileData.keepAliveState) {
                                case NONE: {
                                    this.getEndpoint().processSocket(this, SocketEvent.DISCONNECT, false);
                                    break;
                                }
                                case PIPELINED: {
                                    if (this.getEndpoint().processSocket(this, SocketEvent.OPEN_READ, true)) break;
                                    this.close();
                                    break;
                                }
                                case OPEN: {
                                    this.registerReadInterest();
                                }
                            }
                        }
                        return;
                    }
                    ((Nio2Channel)this.getSocket()).getBufHandler().configureWriteBufferForWrite();
                    int n2 = -1;
                    try {
                        n2 = sendfileData.fchannel.read(byteBuffer);
                    }
                    catch (IOException iOException) {
                        this.failed((Throwable)iOException, sendfileData);
                        return;
                    }
                    if (n2 > 0) {
                        ((Nio2Channel)this.getSocket()).getBufHandler().configureWriteBufferForRead();
                        if (sendfileData.length < (long)byteBuffer.remaining()) {
                            byteBuffer.limit(byteBuffer.limit() - byteBuffer.remaining() + (int)sendfileData.length);
                        }
                        sendfileData.length -= (long)n2;
                    } else {
                        this.failed((Throwable)new EOFException(), sendfileData);
                        return;
                    }
                }
                ((Nio2Channel)this.getSocket()).write(byteBuffer, AbstractEndpoint.toTimeout(this.getWriteTimeout()), TimeUnit.MILLISECONDS, sendfileData, this);
            }

            @Override
            public void failed(Throwable throwable, SendfileData sendfileData) {
                try {
                    sendfileData.fchannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!Nio2Endpoint.isInline()) {
                    this.getEndpoint().processSocket(this, SocketEvent.ERROR, false);
                } else {
                    sendfileData.doneInline = true;
                    sendfileData.error = true;
                }
            }
        };

        public Nio2SocketWrapper(Nio2Channel nio2Channel, final Nio2Endpoint nio2Endpoint) {
            super(nio2Channel, nio2Endpoint);
            this.nioChannels = nio2Endpoint.getNioChannels();
            this.socketBufferHandler = nio2Channel.getBufHandler();
            this.readCompletionHandler = new CompletionHandler<Integer, ByteBuffer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void completed(Integer n, ByteBuffer byteBuffer) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Socket: [" + this + "], Interest: [" + readInterest + "]"));
                    }
                    readNotify = false;
                    CompletionHandler completionHandler = readCompletionHandler;
                    synchronized (completionHandler) {
                        if (n < 0) {
                            this.failed((Throwable)new EOFException(), byteBuffer);
                        } else {
                            if (readInterest && !Nio2Endpoint.isInline()) {
                                readNotify = true;
                            } else {
                                readPending.release();
                            }
                            readInterest = false;
                        }
                    }
                    if (readNotify) {
                        this.getEndpoint().processSocket(this, SocketEvent.OPEN_READ, false);
                    }
                }

                @Override
                public void failed(Throwable throwable, ByteBuffer byteBuffer) {
                    IOException iOException = throwable instanceof IOException ? (IOException)throwable : new IOException(throwable);
                    this.setError(iOException);
                    if (throwable instanceof AsynchronousCloseException) {
                        readPending.release();
                        this.getEndpoint().processSocket(this, SocketEvent.STOP, false);
                    } else if (!this.getEndpoint().processSocket(this, SocketEvent.ERROR, true)) {
                        this.close();
                    }
                }
            };
            this.writeCompletionHandler = new CompletionHandler<Integer, ByteBuffer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void completed(Integer n, ByteBuffer byteBuffer) {
                    writeNotify = false;
                    boolean bl = false;
                    CompletionHandler completionHandler = writeCompletionHandler;
                    synchronized (completionHandler) {
                        if (n < 0) {
                            this.failed((Throwable)new EOFException(SocketWrapperBase.sm.getString("iob.failedwrite")), byteBuffer);
                        } else if (!nonBlockingWriteBuffer.isEmpty()) {
                            ByteBuffer[] byteBufferArray = nonBlockingWriteBuffer.toArray(byteBuffer);
                            ((Nio2Channel)this.getSocket()).write(byteBufferArray, 0, byteBufferArray.length, AbstractEndpoint.toTimeout(this.getWriteTimeout()), TimeUnit.MILLISECONDS, byteBufferArray, gatheringWriteCompletionHandler);
                        } else if (byteBuffer.hasRemaining()) {
                            ((Nio2Channel)this.getSocket()).write(byteBuffer, AbstractEndpoint.toTimeout(this.getWriteTimeout()), TimeUnit.MILLISECONDS, byteBuffer, writeCompletionHandler);
                        } else {
                            if (writeInterest && !Nio2Endpoint.isInline()) {
                                writeNotify = true;
                                bl = true;
                            } else {
                                writePending.release();
                            }
                            writeInterest = false;
                        }
                    }
                    if (bl && !nio2Endpoint.processSocket(this, SocketEvent.OPEN_WRITE, true)) {
                        this.close();
                    }
                }

                @Override
                public void failed(Throwable throwable, ByteBuffer byteBuffer) {
                    IOException iOException = throwable instanceof IOException ? (IOException)throwable : new IOException(throwable);
                    this.setError(iOException);
                    writePending.release();
                    if (!nio2Endpoint.processSocket(this, SocketEvent.ERROR, true)) {
                        this.close();
                    }
                }
            };
            this.gatheringWriteCompletionHandler = new CompletionHandler<Long, ByteBuffer[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void completed(Long l, ByteBuffer[] byteBufferArray) {
                    writeNotify = false;
                    boolean bl = false;
                    CompletionHandler completionHandler = writeCompletionHandler;
                    synchronized (completionHandler) {
                        if (l < 0L) {
                            this.failed((Throwable)new EOFException(SocketWrapperBase.sm.getString("iob.failedwrite")), byteBufferArray);
                        } else if (!nonBlockingWriteBuffer.isEmpty() || SocketWrapperBase.buffersArrayHasRemaining(byteBufferArray, 0, byteBufferArray.length)) {
                            ByteBuffer[] byteBufferArray2 = nonBlockingWriteBuffer.toArray(byteBufferArray);
                            ((Nio2Channel)this.getSocket()).write(byteBufferArray2, 0, byteBufferArray2.length, AbstractEndpoint.toTimeout(this.getWriteTimeout()), TimeUnit.MILLISECONDS, byteBufferArray2, gatheringWriteCompletionHandler);
                        } else {
                            if (writeInterest && !Nio2Endpoint.isInline()) {
                                writeNotify = true;
                                bl = true;
                            } else {
                                writePending.release();
                            }
                            writeInterest = false;
                        }
                    }
                    if (bl && !nio2Endpoint.processSocket(this, SocketEvent.OPEN_WRITE, true)) {
                        this.close();
                    }
                }

                @Override
                public void failed(Throwable throwable, ByteBuffer[] byteBufferArray) {
                    IOException iOException = throwable instanceof IOException ? (IOException)throwable : new IOException(throwable);
                    this.setError(iOException);
                    writePending.release();
                    if (!nio2Endpoint.processSocket(this, SocketEvent.ERROR, true)) {
                        this.close();
                    }
                }
            };
        }

        public void setSendfileData(SendfileData sendfileData) {
            this.sendfileData = sendfileData;
        }

        public SendfileData getSendfileData() {
            return this.sendfileData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadyForRead() throws IOException {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.readCompletionHandler;
            synchronized (completionHandler) {
                boolean bl;
                if (this.readNotify) {
                    return true;
                }
                if (!this.readPending.tryAcquire()) {
                    this.readInterest = true;
                    return false;
                }
                if (!this.socketBufferHandler.isReadBufferEmpty()) {
                    this.readPending.release();
                    return true;
                }
                boolean bl2 = bl = this.fillReadBuffer(false) > 0;
                if (!bl) {
                    this.readInterest = true;
                }
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadyForWrite() {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.writeCompletionHandler;
            synchronized (completionHandler) {
                boolean bl;
                if (this.writeNotify) {
                    return true;
                }
                if (!this.writePending.tryAcquire()) {
                    this.writeInterest = true;
                    return false;
                }
                if (this.socketBufferHandler.isWriteBufferEmpty() && this.nonBlockingWriteBuffer.isEmpty()) {
                    this.writePending.release();
                    return true;
                }
                boolean bl2 = bl = !this.flushNonBlockingInternal(true);
                if (!bl) {
                    this.writeInterest = true;
                }
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(boolean bl, byte[] byArray, int n, int n2) throws IOException {
            int n3;
            this.checkError();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Socket: [" + this + "], block: [" + bl + "], length: [" + n2 + "]"));
            }
            if (this.socketBufferHandler == null) {
                throw new IOException(sm.getString("socket.closed"));
            }
            if (!this.readNotify) {
                if (bl) {
                    try {
                        this.readPending.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException(interruptedException);
                    }
                } else if (!this.readPending.tryAcquire()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Socket: [" + this + "], Read in progress. Returning [0]"));
                    }
                    return 0;
                }
            }
            if ((n3 = this.populateReadBuffer(byArray, n, n2)) > 0) {
                this.readNotify = false;
                this.readPending.release();
                return n3;
            }
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.readCompletionHandler;
            synchronized (completionHandler) {
                n3 = this.fillReadBuffer(bl);
                if (n3 > 0) {
                    this.socketBufferHandler.configureReadBufferForRead();
                    n3 = Math.min(n3, n2);
                    this.socketBufferHandler.getReadBuffer().get(byArray, n, n3);
                } else if (n3 == 0 && !bl) {
                    this.readInterest = true;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Socket: [" + this + "], Read: [" + n3 + "]"));
                }
                return n3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(boolean bl, ByteBuffer byteBuffer) throws IOException {
            int n;
            this.checkError();
            if (this.socketBufferHandler == null) {
                throw new IOException(sm.getString("socket.closed"));
            }
            if (!this.readNotify) {
                if (bl) {
                    try {
                        this.readPending.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException(interruptedException);
                    }
                } else if (!this.readPending.tryAcquire()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Socket: [" + this + "], Read in progress. Returning [0]"));
                    }
                    return 0;
                }
            }
            if ((n = this.populateReadBuffer(byteBuffer)) > 0) {
                this.readNotify = false;
                this.readPending.release();
                return n;
            }
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.readCompletionHandler;
            synchronized (completionHandler) {
                int n2 = this.socketBufferHandler.getReadBuffer().capacity();
                if (bl && byteBuffer.remaining() >= n2) {
                    byteBuffer.limit(byteBuffer.position() + n2);
                    n = this.fillReadBuffer(bl, byteBuffer);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Socket: [" + this + "], Read direct from socket: [" + n + "]"));
                    }
                } else {
                    n = this.fillReadBuffer(bl);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Socket: [" + this + "], Read into buffer: [" + n + "]"));
                    }
                    if (n > 0) {
                        n = this.populateReadBuffer(byteBuffer);
                    } else if (n == 0 && !bl) {
                        this.readInterest = true;
                    }
                }
                return n;
            }
        }

        @Override
        protected void doClose() {
            block13: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Calling [" + this.getEndpoint() + "].closeSocket([" + this + "])"));
                }
                try {
                    this.getEndpoint().connections.remove(((Nio2Channel)this.getSocket()).getIOChannel());
                    if (((Nio2Channel)this.getSocket()).isOpen()) {
                        ((Nio2Channel)this.getSocket()).close(true);
                    }
                    if (this.getEndpoint().running && (this.nioChannels == null || !this.nioChannels.push(this.getSocket()))) {
                        ((Nio2Channel)this.getSocket()).free();
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    if (log.isDebugEnabled()) {
                        log.error((Object)sm.getString("endpoint.debug.channelCloseFail"), throwable);
                    }
                }
                finally {
                    this.socketBufferHandler = SocketBufferHandler.EMPTY;
                    this.nonBlockingWriteBuffer.clear();
                    this.reset(Nio2Channel.CLOSED_NIO2_CHANNEL);
                }
                try {
                    SendfileData sendfileData = this.getSendfileData();
                    if (sendfileData != null && sendfileData.fchannel != null && sendfileData.fchannel.isOpen()) {
                        sendfileData.fchannel.close();
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    if (!log.isDebugEnabled()) break block13;
                    log.error((Object)sm.getString("endpoint.sendfile.closeError"), throwable);
                }
            }
        }

        @Override
        public boolean hasAsyncIO() {
            return this.getEndpoint().getUseAsyncIO();
        }

        @Override
        public boolean needSemaphores() {
            return true;
        }

        @Override
        public boolean hasPerOperationTimeout() {
            return true;
        }

        @Override
        protected <A> SocketWrapperBase.OperationState<A> newOperationState(boolean bl, ByteBuffer[] byteBufferArray, int n, int n2, SocketWrapperBase.BlockingMode blockingMode, long l, TimeUnit timeUnit, A a, SocketWrapperBase.CompletionCheck completionCheck, CompletionHandler<Long, ? super A> completionHandler, Semaphore semaphore, SocketWrapperBase.VectoredIOCompletionHandler<A> vectoredIOCompletionHandler) {
            return new Nio2OperationState(bl, byteBufferArray, n, n2, blockingMode, l, timeUnit, a, completionCheck, completionHandler, semaphore, vectoredIOCompletionHandler);
        }

        private int fillReadBuffer(boolean bl) throws IOException {
            this.socketBufferHandler.configureReadBufferForWrite();
            return this.fillReadBuffer(bl, this.socketBufferHandler.getReadBuffer());
        }

        private int fillReadBuffer(boolean bl, ByteBuffer byteBuffer) throws IOException {
            int n = 0;
            Future<Integer> future = null;
            if (bl) {
                try {
                    future = ((Nio2Channel)this.getSocket()).read(byteBuffer);
                    long l = this.getReadTimeout();
                    if (l > 0L) {
                        n = future.get(l, TimeUnit.MILLISECONDS);
                    }
                    n = future.get();
                }
                catch (ExecutionException executionException) {
                    if (executionException.getCause() instanceof IOException) {
                        throw (IOException)executionException.getCause();
                    }
                    throw new IOException(executionException);
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException);
                }
                catch (TimeoutException timeoutException) {
                    future.cancel(true);
                    throw new SocketTimeoutException();
                }
                finally {
                    this.readPending.release();
                }
            } else {
                Nio2Endpoint.startInline();
                ((Nio2Channel)this.getSocket()).read(byteBuffer, AbstractEndpoint.toTimeout(this.getReadTimeout()), TimeUnit.MILLISECONDS, byteBuffer, this.readCompletionHandler);
                Nio2Endpoint.endInline();
                if (this.readPending.availablePermits() == 1) {
                    n = byteBuffer.position();
                }
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void writeNonBlocking(byte[] byArray, int n, int n2) throws IOException {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.writeCompletionHandler;
            synchronized (completionHandler) {
                this.checkError();
                if (this.writeNotify || this.writePending.tryAcquire()) {
                    this.socketBufferHandler.configureWriteBufferForWrite();
                    int n3 = Nio2SocketWrapper.transfer(byArray, n, n2, this.socketBufferHandler.getWriteBuffer());
                    n += n3;
                    if ((n2 -= n3) > 0) {
                        this.nonBlockingWriteBuffer.add(byArray, n, n2);
                    }
                    this.flushNonBlockingInternal(true);
                } else {
                    this.nonBlockingWriteBuffer.add(byArray, n, n2);
                }
            }
        }

        @Override
        protected void writeNonBlocking(ByteBuffer byteBuffer) throws IOException {
            this.writeNonBlockingInternal(byteBuffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void writeNonBlockingInternal(ByteBuffer byteBuffer) throws IOException {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.writeCompletionHandler;
            synchronized (completionHandler) {
                this.checkError();
                if (this.writeNotify || this.writePending.tryAcquire()) {
                    this.socketBufferHandler.configureWriteBufferForWrite();
                    Nio2SocketWrapper.transfer(byteBuffer, this.socketBufferHandler.getWriteBuffer());
                    if (byteBuffer.remaining() > 0) {
                        this.nonBlockingWriteBuffer.add(byteBuffer);
                    }
                    this.flushNonBlockingInternal(true);
                } else {
                    this.nonBlockingWriteBuffer.add(byteBuffer);
                }
            }
        }

        @Override
        protected void doWrite(boolean bl, ByteBuffer byteBuffer) throws IOException {
            Future<Integer> future = null;
            try {
                do {
                    future = ((Nio2Channel)this.getSocket()).write(byteBuffer);
                    long l = this.getWriteTimeout();
                    if (!(l > 0L ? future.get(l, TimeUnit.MILLISECONDS) < 0 : future.get() < 0)) continue;
                    throw new EOFException(sm.getString("iob.failedwrite"));
                } while (byteBuffer.hasRemaining());
            }
            catch (ExecutionException executionException) {
                if (executionException.getCause() instanceof IOException) {
                    throw (IOException)executionException.getCause();
                }
                throw new IOException(executionException);
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException);
            }
            catch (TimeoutException timeoutException) {
                future.cancel(true);
                throw new SocketTimeoutException();
            }
        }

        @Override
        protected void flushBlocking() throws IOException {
            this.checkError();
            try {
                if (!this.writePending.tryAcquire(AbstractEndpoint.toTimeout(this.getWriteTimeout()), TimeUnit.MILLISECONDS)) {
                    throw new SocketTimeoutException();
                }
                this.writePending.release();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            super.flushBlocking();
        }

        @Override
        protected boolean flushNonBlocking() throws IOException {
            this.checkError();
            return this.flushNonBlockingInternal(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean flushNonBlockingInternal(boolean bl) {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.writeCompletionHandler;
            synchronized (completionHandler) {
                if (this.writeNotify || bl || this.writePending.tryAcquire()) {
                    this.writeNotify = false;
                    this.socketBufferHandler.configureWriteBufferForRead();
                    if (!this.nonBlockingWriteBuffer.isEmpty()) {
                        ByteBuffer[] byteBufferArray = this.nonBlockingWriteBuffer.toArray(this.socketBufferHandler.getWriteBuffer());
                        Nio2Endpoint.startInline();
                        ((Nio2Channel)this.getSocket()).write(byteBufferArray, 0, byteBufferArray.length, AbstractEndpoint.toTimeout(this.getWriteTimeout()), TimeUnit.MILLISECONDS, byteBufferArray, this.gatheringWriteCompletionHandler);
                        Nio2Endpoint.endInline();
                    } else if (this.socketBufferHandler.getWriteBuffer().hasRemaining()) {
                        Nio2Endpoint.startInline();
                        ((Nio2Channel)this.getSocket()).write(this.socketBufferHandler.getWriteBuffer(), AbstractEndpoint.toTimeout(this.getWriteTimeout()), TimeUnit.MILLISECONDS, this.socketBufferHandler.getWriteBuffer(), this.writeCompletionHandler);
                        Nio2Endpoint.endInline();
                    } else {
                        if (!bl) {
                            this.writePending.release();
                        }
                        this.writeInterest = false;
                    }
                }
                return this.hasDataToWrite();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasDataToRead() {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.readCompletionHandler;
            synchronized (completionHandler) {
                return !this.socketBufferHandler.isReadBufferEmpty() || this.readNotify || this.getError() != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasDataToWrite() {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.writeCompletionHandler;
            synchronized (completionHandler) {
                return !this.socketBufferHandler.isWriteBufferEmpty() || !this.nonBlockingWriteBuffer.isEmpty() || this.writeNotify || this.writePending.availablePermits() == 0 || this.getError() != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadPending() {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.readCompletionHandler;
            synchronized (completionHandler) {
                return this.readPending.availablePermits() == 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isWritePending() {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.writeCompletionHandler;
            synchronized (completionHandler) {
                return this.writePending.availablePermits() == 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean awaitReadComplete(long l, TimeUnit timeUnit) {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.readCompletionHandler;
            synchronized (completionHandler) {
                try {
                    if (this.readNotify) {
                        return true;
                    }
                    if (this.readPending.tryAcquire(l, timeUnit)) {
                        this.readPending.release();
                        return true;
                    }
                    return false;
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean awaitWriteComplete(long l, TimeUnit timeUnit) {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.writeCompletionHandler;
            synchronized (completionHandler) {
                try {
                    if (this.writeNotify) {
                        return true;
                    }
                    if (this.writePending.tryAcquire(l, timeUnit)) {
                        this.writePending.release();
                        return true;
                    }
                    return false;
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerReadInterest() {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.readCompletionHandler;
            synchronized (completionHandler) {
                if (this.readNotify) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("endpoint.debug.registerRead", new Object[]{this}));
                }
                this.readInterest = true;
                if (this.readPending.tryAcquire()) {
                    try {
                        if (this.fillReadBuffer(false) > 0 && !this.getEndpoint().processSocket(this, SocketEvent.OPEN_READ, true)) {
                            this.close();
                        }
                    }
                    catch (IOException iOException) {
                        this.setError(iOException);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerWriteInterest() {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.writeCompletionHandler;
            synchronized (completionHandler) {
                if (this.writeNotify) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("endpoint.debug.registerWrite", new Object[]{this}));
                }
                this.writeInterest = true;
                if (this.writePending.availablePermits() == 1 && !this.getEndpoint().processSocket(this, SocketEvent.OPEN_WRITE, true)) {
                    this.close();
                }
            }
        }

        @Override
        public SendfileDataBase createSendfileData(String string, long l, long l2) {
            return new SendfileData(string, l, l2);
        }

        @Override
        public SendfileState processSendfile(SendfileDataBase sendfileDataBase) {
            Comparable<Path> comparable;
            SendfileData sendfileData = (SendfileData)sendfileDataBase;
            this.setSendfileData(sendfileData);
            if (sendfileData.fchannel == null || !sendfileData.fchannel.isOpen()) {
                comparable = new File(sendfileDataBase.fileName).toPath();
                try {
                    sendfileData.fchannel = FileChannel.open(comparable, new OpenOption[]{StandardOpenOption.READ}).position(sendfileDataBase.pos);
                }
                catch (IOException iOException) {
                    return SendfileState.ERROR;
                }
            }
            ((Nio2Channel)this.getSocket()).getBufHandler().configureWriteBufferForWrite();
            comparable = ((Nio2Channel)this.getSocket()).getBufHandler().getWriteBuffer();
            int n = -1;
            try {
                n = sendfileData.fchannel.read((ByteBuffer)comparable);
            }
            catch (IOException iOException) {
                return SendfileState.ERROR;
            }
            if (n >= 0) {
                sendfileData.length -= (long)n;
                ((Nio2Channel)this.getSocket()).getBufHandler().configureWriteBufferForRead();
                Nio2Endpoint.startInline();
                ((Nio2Channel)this.getSocket()).write((ByteBuffer)comparable, AbstractEndpoint.toTimeout(this.getWriteTimeout()), TimeUnit.MILLISECONDS, sendfileData, this.sendfileHandler);
                Nio2Endpoint.endInline();
                if (sendfileData.doneInline) {
                    if (sendfileData.error) {
                        return SendfileState.ERROR;
                    }
                    return SendfileState.DONE;
                }
                return SendfileState.PENDING;
            }
            return SendfileState.ERROR;
        }

        @Override
        protected void populateRemoteAddr() {
            AsynchronousSocketChannel asynchronousSocketChannel = ((Nio2Channel)this.getSocket()).getIOChannel();
            if (asynchronousSocketChannel != null) {
                SocketAddress socketAddress = null;
                try {
                    socketAddress = asynchronousSocketChannel.getRemoteAddress();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (socketAddress instanceof InetSocketAddress) {
                    this.remoteAddr = ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
                }
            }
        }

        @Override
        protected void populateRemoteHost() {
            AsynchronousSocketChannel asynchronousSocketChannel = ((Nio2Channel)this.getSocket()).getIOChannel();
            if (asynchronousSocketChannel != null) {
                SocketAddress socketAddress = null;
                try {
                    socketAddress = asynchronousSocketChannel.getRemoteAddress();
                }
                catch (IOException iOException) {
                    log.warn((Object)sm.getString("endpoint.warn.noRemoteHost", new Object[]{this.getSocket()}), (Throwable)iOException);
                }
                if (socketAddress instanceof InetSocketAddress) {
                    this.remoteHost = ((InetSocketAddress)socketAddress).getAddress().getHostName();
                    if (this.remoteAddr == null) {
                        this.remoteAddr = ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
                    }
                }
            }
        }

        @Override
        protected void populateRemotePort() {
            AsynchronousSocketChannel asynchronousSocketChannel = ((Nio2Channel)this.getSocket()).getIOChannel();
            if (asynchronousSocketChannel != null) {
                SocketAddress socketAddress = null;
                try {
                    socketAddress = asynchronousSocketChannel.getRemoteAddress();
                }
                catch (IOException iOException) {
                    log.warn((Object)sm.getString("endpoint.warn.noRemotePort", new Object[]{this.getSocket()}), (Throwable)iOException);
                }
                if (socketAddress instanceof InetSocketAddress) {
                    this.remotePort = ((InetSocketAddress)socketAddress).getPort();
                }
            }
        }

        @Override
        protected void populateLocalName() {
            AsynchronousSocketChannel asynchronousSocketChannel = ((Nio2Channel)this.getSocket()).getIOChannel();
            if (asynchronousSocketChannel != null) {
                SocketAddress socketAddress = null;
                try {
                    socketAddress = asynchronousSocketChannel.getLocalAddress();
                }
                catch (IOException iOException) {
                    log.warn((Object)sm.getString("endpoint.warn.noLocalName", new Object[]{this.getSocket()}), (Throwable)iOException);
                }
                if (socketAddress instanceof InetSocketAddress) {
                    this.localName = ((InetSocketAddress)socketAddress).getHostName();
                }
            }
        }

        @Override
        protected void populateLocalAddr() {
            AsynchronousSocketChannel asynchronousSocketChannel = ((Nio2Channel)this.getSocket()).getIOChannel();
            if (asynchronousSocketChannel != null) {
                SocketAddress socketAddress = null;
                try {
                    socketAddress = asynchronousSocketChannel.getLocalAddress();
                }
                catch (IOException iOException) {
                    log.warn((Object)sm.getString("endpoint.warn.noLocalAddr", new Object[]{this.getSocket()}), (Throwable)iOException);
                }
                if (socketAddress instanceof InetSocketAddress) {
                    this.localAddr = ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
                }
            }
        }

        @Override
        protected void populateLocalPort() {
            AsynchronousSocketChannel asynchronousSocketChannel = ((Nio2Channel)this.getSocket()).getIOChannel();
            if (asynchronousSocketChannel != null) {
                SocketAddress socketAddress = null;
                try {
                    socketAddress = asynchronousSocketChannel.getLocalAddress();
                }
                catch (IOException iOException) {
                    log.warn((Object)sm.getString("endpoint.warn.noLocalPort", new Object[]{this.getSocket()}), (Throwable)iOException);
                }
                if (socketAddress instanceof InetSocketAddress) {
                    this.localPort = ((InetSocketAddress)socketAddress).getPort();
                }
            }
        }

        @Override
        public SSLSupport getSslSupport(String string) {
            if (this.getSocket() instanceof SecureNio2Channel) {
                SecureNio2Channel secureNio2Channel = (SecureNio2Channel)this.getSocket();
                return secureNio2Channel.getSSLSupport();
            }
            return null;
        }

        @Override
        public void doClientAuth(SSLSupport sSLSupport) throws IOException {
            SecureNio2Channel secureNio2Channel = (SecureNio2Channel)this.getSocket();
            SSLEngine sSLEngine = secureNio2Channel.getSslEngine();
            if (!sSLEngine.getNeedClientAuth()) {
                sSLEngine.setNeedClientAuth(true);
                secureNio2Channel.rehandshake();
                ((JSSESupport)sSLSupport).setSession(sSLEngine.getSession());
            }
        }

        @Override
        public void setAppReadBufHandler(ApplicationBufferHandler applicationBufferHandler) {
            ((Nio2Channel)this.getSocket()).setAppReadBufHandler(applicationBufferHandler);
        }

        private class Nio2OperationState<A>
        extends SocketWrapperBase.OperationState<A> {
            private Nio2OperationState(boolean bl, ByteBuffer[] byteBufferArray, int n, int n2, SocketWrapperBase.BlockingMode blockingMode, long l, TimeUnit timeUnit, A a, SocketWrapperBase.CompletionCheck completionCheck, CompletionHandler<Long, ? super A> completionHandler, Semaphore semaphore, SocketWrapperBase.VectoredIOCompletionHandler<A> vectoredIOCompletionHandler) {
                super(Nio2SocketWrapper.this, bl, byteBufferArray, n, n2, blockingMode, l, timeUnit, a, completionCheck, completionHandler, semaphore, vectoredIOCompletionHandler);
            }

            @Override
            protected boolean isInline() {
                return Nio2Endpoint.isInline();
            }

            @Override
            protected void start() {
                if (this.read) {
                    Nio2SocketWrapper.this.readNotify = true;
                } else {
                    Nio2SocketWrapper.this.writeNotify = true;
                }
                Nio2Endpoint.startInline();
                try {
                    this.run();
                }
                finally {
                    Nio2Endpoint.endInline();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (this.read) {
                    long l = 0L;
                    if (!Nio2SocketWrapper.this.socketBufferHandler.isReadBufferEmpty()) {
                        CompletionHandler completionHandler = Nio2SocketWrapper.this.readCompletionHandler;
                        synchronized (completionHandler) {
                            Nio2SocketWrapper.this.socketBufferHandler.configureReadBufferForRead();
                            for (int i = 0; i < this.length && !Nio2SocketWrapper.this.socketBufferHandler.isReadBufferEmpty(); ++i) {
                                l += (long)SocketWrapperBase.transfer(Nio2SocketWrapper.this.socketBufferHandler.getReadBuffer(), this.buffers[this.offset + i]);
                            }
                        }
                        if (l > 0L) {
                            this.completion.completed(l, this);
                        }
                    }
                    if (l == 0L) {
                        ((Nio2Channel)Nio2SocketWrapper.this.getSocket()).read(this.buffers, this.offset, this.length, this.timeout, this.unit, this, this.completion);
                    }
                } else {
                    if (!Nio2SocketWrapper.this.socketBufferHandler.isWriteBufferEmpty()) {
                        CompletionHandler completionHandler = Nio2SocketWrapper.this.writeCompletionHandler;
                        synchronized (completionHandler) {
                            Nio2SocketWrapper.this.socketBufferHandler.configureWriteBufferForRead();
                            ByteBuffer[] byteBufferArray = Nio2SocketWrapper.this.nonBlockingWriteBuffer.toArray(Nio2SocketWrapper.this.socketBufferHandler.getWriteBuffer());
                            if (SocketWrapperBase.buffersArrayHasRemaining(byteBufferArray, 0, byteBufferArray.length)) {
                                ((Nio2Channel)Nio2SocketWrapper.this.getSocket()).write(byteBufferArray, 0, byteBufferArray.length, this.timeout, this.unit, byteBufferArray, new CompletionHandler<Long, ByteBuffer[]>(){

                                    @Override
                                    public void completed(Long l, ByteBuffer[] byteBufferArray) {
                                        if (l < 0L) {
                                            this.failed((Throwable)new EOFException(), null);
                                        } else if (SocketWrapperBase.buffersArrayHasRemaining(byteBufferArray, 0, byteBufferArray.length)) {
                                            ((Nio2Channel)Nio2SocketWrapper.this.getSocket()).write(byteBufferArray, 0, byteBufferArray.length, AbstractEndpoint.toTimeout(Nio2SocketWrapper.this.getWriteTimeout()), TimeUnit.MILLISECONDS, byteBufferArray, this);
                                        } else {
                                            Nio2OperationState.this.process();
                                        }
                                    }

                                    @Override
                                    public void failed(Throwable throwable, ByteBuffer[] byteBufferArray) {
                                        Nio2OperationState.this.completion.failed(throwable, Nio2OperationState.this);
                                    }
                                });
                                return;
                            }
                        }
                    }
                    ((Nio2Channel)Nio2SocketWrapper.this.getSocket()).write(this.buffers, this.offset, this.length, this.timeout, this.unit, this, this.completion);
                }
            }
        }
    }

    protected class Nio2Acceptor
    extends Acceptor<AsynchronousSocketChannel>
    implements CompletionHandler<AsynchronousSocketChannel, Void> {
        protected int errorDelay;

        public Nio2Acceptor(AbstractEndpoint<?, AsynchronousSocketChannel> abstractEndpoint) {
            super(abstractEndpoint);
            this.errorDelay = 0;
        }

        @Override
        public void run() {
            if (!Nio2Endpoint.this.isPaused()) {
                try {
                    Nio2Endpoint.this.countUpOrAwaitConnection();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!Nio2Endpoint.this.isPaused()) {
                    Nio2Endpoint.this.serverSock.accept(null, this);
                } else {
                    this.state = Acceptor.AcceptorState.PAUSED;
                }
            } else {
                this.state = Acceptor.AcceptorState.PAUSED;
            }
        }

        @Override
        public void stop(int n) {
            Nio2Endpoint.this.acceptor.state = Acceptor.AcceptorState.ENDED;
        }

        @Override
        public void completed(AsynchronousSocketChannel asynchronousSocketChannel, Void void_) {
            this.errorDelay = 0;
            if (Nio2Endpoint.this.isRunning() && !Nio2Endpoint.this.isPaused()) {
                if (Nio2Endpoint.this.getMaxConnections() == -1) {
                    Nio2Endpoint.this.serverSock.accept(null, this);
                } else if (Nio2Endpoint.this.getConnectionCount() < (long)Nio2Endpoint.this.getMaxConnections()) {
                    try {
                        Nio2Endpoint.this.countUpOrAwaitConnection();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Nio2Endpoint.this.serverSock.accept(null, this);
                } else {
                    Nio2Endpoint.this.getExecutor().execute(this);
                }
                if (!Nio2Endpoint.this.setSocketOptions(asynchronousSocketChannel)) {
                    Nio2Endpoint.this.closeSocket(asynchronousSocketChannel);
                }
            } else {
                if (Nio2Endpoint.this.isRunning()) {
                    this.state = Acceptor.AcceptorState.PAUSED;
                }
                Nio2Endpoint.this.destroySocket(asynchronousSocketChannel);
            }
        }

        @Override
        public void failed(Throwable throwable, Void void_) {
            if (Nio2Endpoint.this.isRunning()) {
                if (!Nio2Endpoint.this.isPaused()) {
                    if (Nio2Endpoint.this.getMaxConnections() == -1) {
                        Nio2Endpoint.this.serverSock.accept(null, this);
                    } else {
                        Nio2Endpoint.this.getExecutor().execute(this);
                    }
                } else {
                    this.state = Acceptor.AcceptorState.PAUSED;
                }
                Nio2Endpoint.this.countDownConnection();
                this.errorDelay = this.handleExceptionWithDelay(this.errorDelay);
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)AbstractEndpoint.sm.getString("endpoint.accept.fail"), throwable);
            } else {
                Nio2Endpoint.this.countDownConnection();
            }
        }
    }
}

