/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.ModuleDeclaration;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.IrritantSet;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.parser.NLSTag;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.HashSetOfInt;

public class CompilationUnitDeclaration
extends ASTNode
implements ProblemSeverities,
ReferenceContext {
    private static final Comparator STRING_LITERAL_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            StringLiteral stringLiteral = (StringLiteral)object;
            StringLiteral stringLiteral2 = (StringLiteral)object2;
            return stringLiteral.sourceStart - stringLiteral2.sourceStart;
        }
    };
    private static final int STRING_LITERALS_INCREMENT = 10;
    public ImportReference currentPackage;
    public ImportReference[] imports;
    public TypeDeclaration[] types;
    public ModuleDeclaration moduleDeclaration;
    public int[][] comments;
    public boolean ignoreFurtherInvestigation = false;
    public boolean ignoreMethodBodies = false;
    public CompilationUnitScope scope;
    public ProblemReporter problemReporter;
    public CompilationResult compilationResult;
    public Map<Integer, LocalTypeBinding> localTypes = Collections.emptyMap();
    public boolean isPropagatingInnerClassEmulation;
    public Javadoc javadoc;
    public NLSTag[] nlsTags;
    private StringLiteral[] stringLiterals;
    private int stringLiteralsPtr;
    private HashSetOfInt stringLiteralsStart;
    public boolean[] validIdentityComparisonLines;
    IrritantSet[] suppressWarningIrritants;
    Annotation[] suppressWarningAnnotations;
    long[] suppressWarningScopePositions;
    int suppressWarningsCount;
    public int functionalExpressionsCount;
    public FunctionalExpression[] functionalExpressions;

    public CompilationUnitDeclaration(ProblemReporter problemReporter, CompilationResult compilationResult, int n) {
        this.problemReporter = problemReporter;
        this.compilationResult = compilationResult;
        this.sourceStart = 0;
        this.sourceEnd = n - 1;
    }

    @Override
    public void abort(int n, CategorizedProblem categorizedProblem) {
        switch (n) {
            case 8: {
                throw new AbortType(this.compilationResult, categorizedProblem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, categorizedProblem);
            }
        }
        throw new AbortCompilationUnit(this.compilationResult, categorizedProblem);
    }

    public void analyseCode() {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (this.types != null) {
                int n = this.types.length;
                for (int i = 0; i < n; ++i) {
                    this.types[i].analyseCode(this.scope);
                }
            }
            if (this.moduleDeclaration != null) {
                this.moduleDeclaration.analyseCode(this.scope);
            }
            this.propagateInnerEmulationForAllLocalTypes();
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void cleanUp() {
        int n;
        if (this.types != null) {
            n = this.types.length;
            for (int i = 0; i < n; ++i) {
                this.cleanUp(this.types[i]);
            }
            for (LocalTypeBinding localTypeBinding : this.localTypes.values()) {
                localTypeBinding.cleanUp();
                localTypeBinding.enclosingCase = null;
            }
        }
        if (this.functionalExpressionsCount > 0) {
            n = this.functionalExpressionsCount;
            for (int i = 0; i < n; ++i) {
                this.functionalExpressions[i].cleanUp();
            }
        }
        this.compilationResult.recoveryScannerData = null;
        for (ClassFile classFile : this.compilationResult.getClassFiles()) {
            classFile.referenceBinding = null;
            classFile.innerClassesBindings = null;
            classFile.bootstrapMethods = null;
            classFile.missingTypes = null;
            classFile.visitedTypes = null;
        }
        this.suppressWarningAnnotations = null;
        if (this.scope != null) {
            this.scope.cleanUpInferenceContexts();
        }
    }

    private void cleanUp(TypeDeclaration typeDeclaration) {
        if (typeDeclaration.memberTypes != null) {
            int n = typeDeclaration.memberTypes.length;
            for (int i = 0; i < n; ++i) {
                this.cleanUp(typeDeclaration.memberTypes[i]);
            }
        }
        if (typeDeclaration.binding != null && typeDeclaration.binding.isAnnotationType()) {
            this.compilationResult.hasAnnotations = true;
        }
        if (typeDeclaration.binding != null) {
            typeDeclaration.binding.cleanUp();
        }
    }

    public void checkUnusedImports() {
        if (this.scope.imports != null) {
            for (ImportBinding importBinding : this.scope.imports) {
                ImportReference importReference = importBinding.reference;
                if (importReference == null || (importReference.bits & 2) != 0) continue;
                this.scope.problemReporter().unusedImport(importReference);
            }
        }
    }

    @Override
    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public void createPackageInfoType() {
        TypeDeclaration typeDeclaration = new TypeDeclaration(this.compilationResult);
        typeDeclaration.name = TypeConstants.PACKAGE_INFO_NAME;
        typeDeclaration.modifiers = 512;
        typeDeclaration.javadoc = this.javadoc;
        this.types[0] = typeDeclaration;
    }

    public TypeDeclaration declarationOfType(char[][] cArray) {
        for (int i = 0; i < this.types.length; ++i) {
            TypeDeclaration typeDeclaration = this.types[i].declarationOfType(cArray);
            if (typeDeclaration == null) continue;
            return typeDeclaration;
        }
        return null;
    }

    public void finalizeProblems() {
        int n;
        int n2;
        CategorizedProblem categorizedProblem;
        int n3;
        int n4 = this.compilationResult.problemCount;
        CategorizedProblem[] categorizedProblemArray = this.compilationResult.problems;
        if (this.suppressWarningsCount == 0) {
            return;
        }
        int n5 = 0;
        IrritantSet[] irritantSetArray = new IrritantSet[this.suppressWarningsCount];
        CompilerOptions compilerOptions = this.scope.compilerOptions();
        boolean bl = false;
        int n6 = n4;
        block0: for (n3 = 0; n3 < n6; ++n3) {
            categorizedProblem = categorizedProblemArray[n3];
            n2 = categorizedProblem.getID();
            int n7 = ProblemReporter.getIrritant(n2);
            boolean bl2 = categorizedProblem.isError();
            if (bl2) {
                if (n7 == 0) {
                    bl = true;
                    continue;
                }
                if (!compilerOptions.suppressOptionalErrors) continue;
            }
            int n8 = categorizedProblem.getSourceStart();
            int n9 = categorizedProblem.getSourceEnd();
            int n10 = this.suppressWarningsCount;
            for (int i = 0; i < n10; ++i) {
                long l = this.suppressWarningScopePositions[i];
                int n11 = (int)(l >>> 32);
                n = (int)l;
                if (n8 < n11 || n9 > n || !this.suppressWarningIrritants[i].isSet(n7)) continue;
                ++n5;
                categorizedProblemArray[n3] = null;
                this.compilationResult.removeProblem(categorizedProblem);
                if (irritantSetArray[i] == null) {
                    irritantSetArray[i] = new IrritantSet(n7);
                    continue block0;
                }
                irritantSetArray[i].set(n7);
                continue block0;
            }
        }
        if (n5 > 0) {
            n6 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                categorizedProblem = categorizedProblemArray[n3];
                if (categorizedProblem == null) continue;
                if (n3 > n6) {
                    categorizedProblemArray[n6++] = categorizedProblem;
                    continue;
                }
                ++n6;
            }
        }
        if (!bl && (n3 = compilerOptions.getSeverity(0x22000000)) != 256) {
            n6 = (n3 & 1) == 0 ? 1 : 0;
            n2 = this.suppressWarningsCount;
            block3: for (int i = 0; i < n2; ++i) {
                Annotation annotation = this.suppressWarningAnnotations[i];
                if (annotation == null) continue;
                IrritantSet irritantSet = this.suppressWarningIrritants[i];
                if (n6 != 0 && irritantSet.areAllSet() || irritantSet == irritantSetArray[i]) continue;
                for (MemberValuePair memberValuePair : annotation.memberValuePairs()) {
                    int n12;
                    int n13;
                    Object object;
                    TypeIds typeIds;
                    if (!CharOperation.equals(memberValuePair.name, TypeConstants.VALUE)) continue;
                    Expression expression = memberValuePair.value;
                    if (expression instanceof ArrayInitializer) {
                        typeIds = (ArrayInitializer)expression;
                        object = ((ArrayInitializer)typeIds).expressions;
                        if (object == null) continue block3;
                        int n14 = ((Expression[])object).length;
                        for (n = 0; n < n14; ++n) {
                            int n15;
                            IrritantSet irritantSet2;
                            Constant constant = ((Expression)object[n]).constant;
                            if (constant == Constant.NotAConstant || constant.typeID() != 11 || (irritantSet2 = CompilerOptions.warningTokenToIrritants(constant.stringValue())) == null || irritantSet2.areAllSet() || irritantSetArray[i] != null && irritantSetArray[i].isAnySet(irritantSet2)) continue;
                            if (n6 != 0) {
                                n15 = expression.sourceStart;
                                n13 = expression.sourceEnd;
                                for (n12 = i - 1; n12 >= 0; --n12) {
                                    long l = this.suppressWarningScopePositions[n12];
                                    int n16 = (int)(l >>> 32);
                                    int n17 = (int)l;
                                    if (n15 >= n16 && n13 <= n17 && this.suppressWarningIrritants[n12].areAllSet()) continue block3;
                                }
                            }
                            if ((n15 = compilerOptions.getIgnoredIrritant(irritantSet2)) > 0) {
                                String string = CompilerOptions.optionKeyFromIrritant(n15);
                                this.scope.problemReporter().problemNotAnalysed((Expression)object[n], string);
                                continue;
                            }
                            this.scope.problemReporter().unusedWarningToken((Expression)object[n]);
                        }
                        continue block3;
                    }
                    typeIds = expression.constant;
                    if (typeIds == Constant.NotAConstant || ((Constant)typeIds).typeID() != 11 || (object = CompilerOptions.warningTokenToIrritants(((Constant)typeIds).stringValue())) == null || ((IrritantSet)object).areAllSet() || irritantSetArray[i] != null && irritantSetArray[i].isAnySet((IrritantSet)object)) continue block3;
                    if (n6 != 0) {
                        n = expression.sourceStart;
                        int n18 = expression.sourceEnd;
                        for (int j = i - 1; j >= 0; --j) {
                            long l = this.suppressWarningScopePositions[j];
                            n13 = (int)(l >>> 32);
                            n12 = (int)l;
                            if (n >= n13 && n18 <= n12 && this.suppressWarningIrritants[j].areAllSet()) continue block3;
                        }
                    }
                    if ((n = compilerOptions.getIgnoredIrritant((IrritantSet)object)) > 0) {
                        String string = CompilerOptions.optionKeyFromIrritant(n);
                        this.scope.problemReporter().problemNotAnalysed(expression, string);
                        continue block3;
                    }
                    this.scope.problemReporter().unusedWarningToken(expression);
                    continue block3;
                }
            }
        }
    }

    public void generateCode() {
        if (this.ignoreFurtherInvestigation) {
            if (this.types != null) {
                int n = this.types.length;
                for (int i = 0; i < n; ++i) {
                    this.types[i].ignoreFurtherInvestigation = true;
                    this.types[i].generateCode(this.scope);
                }
            }
            return;
        }
        try {
            if (this.types != null) {
                int n = this.types.length;
                for (int i = 0; i < n; ++i) {
                    this.types[i].generateCode(this.scope);
                }
            }
            if (this.moduleDeclaration != null) {
                this.moduleDeclaration.generateCode();
            }
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            // empty catch block
        }
    }

    @Override
    public CompilationUnitDeclaration getCompilationUnitDeclaration() {
        return this;
    }

    public char[] getFileName() {
        return this.compilationResult.getFileName();
    }

    public char[] getMainTypeName() {
        if (this.compilationResult.compilationUnit == null) {
            int n;
            char[] cArray = this.compilationResult.getFileName();
            int n2 = CharOperation.lastIndexOf('/', cArray) + 1;
            if (n2 == 0 || n2 < CharOperation.lastIndexOf('\\', cArray)) {
                n2 = CharOperation.lastIndexOf('\\', cArray) + 1;
            }
            if ((n = CharOperation.lastIndexOf('.', cArray)) == -1) {
                n = cArray.length;
            }
            return CharOperation.subarray(cArray, n2, n);
        }
        return this.compilationResult.compilationUnit.getMainTypeName();
    }

    public boolean isEmpty() {
        return this.currentPackage == null && this.imports == null && this.types == null;
    }

    public boolean isPackageInfo() {
        return CharOperation.equals(this.getMainTypeName(), TypeConstants.PACKAGE_INFO_NAME);
    }

    public boolean isModuleInfo() {
        return CharOperation.equals(this.getMainTypeName(), TypeConstants.MODULE_INFO_NAME);
    }

    public boolean isSuppressed(CategorizedProblem categorizedProblem) {
        if (this.suppressWarningsCount == 0) {
            return false;
        }
        int n = ProblemReporter.getIrritant(categorizedProblem.getID());
        if (n == 0) {
            return false;
        }
        int n2 = categorizedProblem.getSourceStart();
        int n3 = categorizedProblem.getSourceEnd();
        int n4 = this.suppressWarningsCount;
        for (int i = 0; i < n4; ++i) {
            long l = this.suppressWarningScopePositions[i];
            int n5 = (int)(l >>> 32);
            int n6 = (int)l;
            if (n2 < n5 || n3 > n6 || !this.suppressWarningIrritants[i].isSet(n)) continue;
            return true;
        }
        return false;
    }

    public boolean hasFunctionalTypes() {
        return this.compilationResult.hasFunctionalTypes;
    }

    @Override
    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        int n2;
        if (this.currentPackage != null) {
            CompilationUnitDeclaration.printIndent(n, stringBuffer).append("package ");
            this.currentPackage.print(0, stringBuffer, false).append(";\n");
        }
        if (this.imports != null) {
            for (n2 = 0; n2 < this.imports.length; ++n2) {
                CompilationUnitDeclaration.printIndent(n, stringBuffer).append("import ");
                ImportReference importReference = this.imports[n2];
                if (importReference.isStatic()) {
                    stringBuffer.append("static ");
                }
                importReference.print(0, stringBuffer).append(";\n");
            }
        }
        if (this.moduleDeclaration != null) {
            this.moduleDeclaration.print(n, stringBuffer).append("\n");
        } else if (this.types != null) {
            for (n2 = 0; n2 < this.types.length; ++n2) {
                this.types[n2].print(n, stringBuffer).append("\n");
            }
        }
        return stringBuffer;
    }

    public void propagateInnerEmulationForAllLocalTypes() {
        this.isPropagatingInnerClassEmulation = true;
        for (LocalTypeBinding localTypeBinding : this.localTypes.values()) {
            if ((localTypeBinding.scope.referenceType().bits & Integer.MIN_VALUE) == 0) continue;
            localTypeBinding.updateInnerEmulationDependents();
        }
    }

    public void recordStringLiteral(StringLiteral stringLiteral, boolean bl) {
        int n;
        if (this.stringLiteralsStart != null) {
            if (this.stringLiteralsStart.contains(stringLiteral.sourceStart)) {
                return;
            }
            this.stringLiteralsStart.add(stringLiteral.sourceStart);
        } else if (bl) {
            this.stringLiteralsStart = new HashSetOfInt(this.stringLiteralsPtr + 10);
            for (n = 0; n < this.stringLiteralsPtr; ++n) {
                this.stringLiteralsStart.add(this.stringLiterals[n].sourceStart);
            }
            if (this.stringLiteralsStart.contains(stringLiteral.sourceStart)) {
                return;
            }
            this.stringLiteralsStart.add(stringLiteral.sourceStart);
        }
        if (this.stringLiterals == null) {
            this.stringLiterals = new StringLiteral[10];
            this.stringLiteralsPtr = 0;
        } else {
            n = this.stringLiterals.length;
            if (this.stringLiteralsPtr == n) {
                this.stringLiterals = new StringLiteral[n + 10];
                System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, n);
            }
        }
        this.stringLiterals[this.stringLiteralsPtr++] = stringLiteral;
    }

    private boolean isLambdaExpressionCopyContext(ReferenceContext referenceContext) {
        if (referenceContext instanceof LambdaExpression && referenceContext != ((LambdaExpression)referenceContext).original()) {
            return true;
        }
        MethodScope methodScope = referenceContext instanceof AbstractMethodDeclaration ? ((AbstractMethodDeclaration)referenceContext).scope : (referenceContext instanceof TypeDeclaration ? ((TypeDeclaration)referenceContext).scope : (referenceContext instanceof LambdaExpression ? ((LambdaExpression)referenceContext).scope : null));
        return methodScope != null ? this.isLambdaExpressionCopyContext(methodScope.parent.referenceContext()) : false;
    }

    public void recordSuppressWarnings(IrritantSet irritantSet, Annotation annotation, int n, int n2, ReferenceContext referenceContext) {
        if (this.isLambdaExpressionCopyContext(referenceContext)) {
            return;
        }
        if (this.suppressWarningIrritants == null) {
            this.suppressWarningIrritants = new IrritantSet[3];
            this.suppressWarningAnnotations = new Annotation[3];
            this.suppressWarningScopePositions = new long[3];
        } else if (this.suppressWarningIrritants.length == this.suppressWarningsCount) {
            this.suppressWarningIrritants = new IrritantSet[2 * this.suppressWarningsCount];
            System.arraycopy(this.suppressWarningIrritants, 0, this.suppressWarningIrritants, 0, this.suppressWarningsCount);
            this.suppressWarningAnnotations = new Annotation[2 * this.suppressWarningsCount];
            System.arraycopy(this.suppressWarningAnnotations, 0, this.suppressWarningAnnotations, 0, this.suppressWarningsCount);
            this.suppressWarningScopePositions = new long[2 * this.suppressWarningsCount];
            System.arraycopy(this.suppressWarningScopePositions, 0, this.suppressWarningScopePositions, 0, this.suppressWarningsCount);
        }
        long l = ((long)n << 32) + (long)n2;
        int n3 = this.suppressWarningsCount;
        for (int i = 0; i < n3; ++i) {
            if (this.suppressWarningAnnotations[i] != annotation || this.suppressWarningScopePositions[i] != l || !this.suppressWarningIrritants[i].hasSameIrritants(irritantSet)) continue;
            return;
        }
        this.suppressWarningIrritants[this.suppressWarningsCount] = irritantSet;
        this.suppressWarningAnnotations[this.suppressWarningsCount] = annotation;
        this.suppressWarningScopePositions[this.suppressWarningsCount++] = l;
    }

    public void record(LocalTypeBinding localTypeBinding) {
        if (this.localTypes == Collections.EMPTY_MAP) {
            this.localTypes = new HashMap<Integer, LocalTypeBinding>();
        }
        this.localTypes.put(localTypeBinding.sourceStart, localTypeBinding);
    }

    public void updateLocalTypesInMethod(MethodBinding methodBinding) {
        if (this.localTypes == Collections.EMPTY_MAP) {
            return;
        }
        LambdaExpression.updateLocalTypesInMethod(methodBinding, new LambdaExpression.LocalTypeSubstitutor(this.localTypes, methodBinding), new Substitution.NullSubstitution(this.scope.environment()));
    }

    public int record(FunctionalExpression functionalExpression) {
        if (this.functionalExpressionsCount == 0) {
            this.functionalExpressions = new FunctionalExpression[5];
        } else if (this.functionalExpressionsCount == this.functionalExpressions.length) {
            this.functionalExpressions = new FunctionalExpression[this.functionalExpressionsCount * 2];
            System.arraycopy(this.functionalExpressions, 0, this.functionalExpressions, 0, this.functionalExpressionsCount);
        }
        this.functionalExpressions[this.functionalExpressionsCount++] = functionalExpression;
        return functionalExpression.enclosingScope.classScope().referenceContext.record(functionalExpression);
    }

    public void resolve() {
        int n;
        Object object;
        int n2 = 0;
        boolean bl = this.isPackageInfo();
        boolean bl2 = this.isModuleInfo();
        if (this.types != null && bl) {
            object = this.types[0];
            if (((TypeDeclaration)object).javadoc == null) {
                ((TypeDeclaration)object).javadoc = new Javadoc(((TypeDeclaration)object).declarationSourceStart, ((TypeDeclaration)object).declarationSourceStart);
            }
            ((TypeDeclaration)object).resolve(this.scope);
            if (this.javadoc != null && ((TypeDeclaration)object).staticInitializerScope != null) {
                this.javadoc.resolve(((TypeDeclaration)object).staticInitializerScope);
            }
            n2 = 1;
        } else if (this.moduleDeclaration != null && bl2) {
            if (this.javadoc != null) {
                this.javadoc.resolve(this.moduleDeclaration.scope);
            } else if (this.moduleDeclaration.binding != null && (n = ((ProblemReporter)(object = this.scope.problemReporter())).computeSeverity(-1610612250)) != 256) {
                ((ProblemReporter)object).javadocModuleMissing(this.moduleDeclaration.declarationSourceStart, this.moduleDeclaration.bodyStart, n);
            }
        } else if (this.javadoc != null) {
            this.javadoc.resolve(this.scope);
        }
        if (this.currentPackage != null && this.currentPackage.annotations != null && !bl) {
            this.scope.problemReporter().invalidFileNameForPackageAnnotations(this.currentPackage.annotations[0]);
        }
        try {
            if (this.types != null) {
                n = this.types.length;
                for (int i = n2; i < n; ++i) {
                    this.types[i].resolve(this.scope);
                }
            }
            if (!this.compilationResult.hasMandatoryErrors()) {
                this.checkUnusedImports();
            }
            this.reportNLSProblems();
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    private void reportNLSProblems() {
        block20: {
            int n;
            int n2;
            block21: {
                if (this.nlsTags == null && this.stringLiterals == null) break block20;
                n2 = this.stringLiteralsPtr;
                int n3 = n = this.nlsTags == null ? 0 : this.nlsTags.length;
                if (n2 != 0) break block21;
                if (n == 0) break block20;
                for (int i = 0; i < n; ++i) {
                    NLSTag nLSTag = this.nlsTags[i];
                    if (nLSTag == null) continue;
                    this.scope.problemReporter().unnecessaryNLSTags(nLSTag.start, nLSTag.end);
                }
                break block20;
            }
            if (n == 0) {
                if (this.stringLiterals.length != n2) {
                    this.stringLiterals = new StringLiteral[n2];
                    System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, n2);
                }
                Arrays.sort(this.stringLiterals, STRING_LITERAL_COMPARATOR);
                for (int i = 0; i < n2; ++i) {
                    this.scope.problemReporter().nonExternalizedStringLiteral(this.stringLiterals[i]);
                }
            } else {
                int n4;
                if (this.stringLiterals.length != n2) {
                    this.stringLiterals = new StringLiteral[n2];
                    System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, n2);
                }
                Arrays.sort(this.stringLiterals, STRING_LITERAL_COMPARATOR);
                int n5 = 1;
                int n6 = -1;
                StringLiteral stringLiteral = null;
                int n7 = 0;
                block2: for (n4 = 0; n4 < n2; ++n4) {
                    stringLiteral = this.stringLiterals[n4];
                    int n8 = stringLiteral.lineNumber;
                    if (n6 != n8) {
                        n5 = 1;
                        n6 = n8;
                    } else {
                        ++n5;
                    }
                    if (n7 >= n) break;
                    while (n7 < n) {
                        NLSTag nLSTag = this.nlsTags[n7];
                        if (nLSTag != null) {
                            int n9 = nLSTag.lineNumber;
                            if (n8 < n9) {
                                this.scope.problemReporter().nonExternalizedStringLiteral(stringLiteral);
                                continue block2;
                            }
                            if (n8 == n9) {
                                if (nLSTag.index == n5) {
                                    this.nlsTags[n7] = null;
                                    ++n7;
                                    continue block2;
                                }
                                for (int i = n7 + 1; i < n; ++i) {
                                    NLSTag nLSTag2 = this.nlsTags[i];
                                    if (nLSTag2 == null) continue;
                                    int n10 = nLSTag2.lineNumber;
                                    if (n8 == n10) {
                                        if (nLSTag2.index != n5) continue;
                                        this.nlsTags[i] = null;
                                        continue block2;
                                    }
                                    this.scope.problemReporter().nonExternalizedStringLiteral(stringLiteral);
                                    continue block2;
                                }
                                this.scope.problemReporter().nonExternalizedStringLiteral(stringLiteral);
                                continue block2;
                            }
                            this.scope.problemReporter().unnecessaryNLSTags(nLSTag.start, nLSTag.end);
                        }
                        ++n7;
                    }
                    break block2;
                }
                while (n4 < n2) {
                    this.scope.problemReporter().nonExternalizedStringLiteral(this.stringLiterals[n4]);
                    ++n4;
                }
                if (n7 < n) {
                    while (n7 < n) {
                        NLSTag nLSTag = this.nlsTags[n7];
                        if (nLSTag != null) {
                            this.scope.problemReporter().unnecessaryNLSTags(nLSTag.start, nLSTag.end);
                        }
                        ++n7;
                    }
                }
            }
        }
    }

    @Override
    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    @Override
    public void tagAsHavingIgnoredMandatoryErrors(int n) {
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
        this.traverse(aSTVisitor, compilationUnitScope, true);
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope, boolean bl) {
        if (bl && this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (aSTVisitor.visit(this, this.scope)) {
                if (this.types != null && this.isPackageInfo()) {
                    Annotation[] annotationArray;
                    TypeDeclaration typeDeclaration = this.types[0];
                    MethodScope methodScope = typeDeclaration.staticInitializerScope;
                    if (this.javadoc != null && methodScope != null) {
                        this.javadoc.traverse(aSTVisitor, methodScope);
                    }
                    if (this.currentPackage != null && methodScope != null && (annotationArray = this.currentPackage.annotations) != null) {
                        int n = annotationArray.length;
                        for (int i = 0; i < n; ++i) {
                            annotationArray[i].traverse(aSTVisitor, methodScope);
                        }
                    }
                }
                if (this.currentPackage != null) {
                    this.currentPackage.traverse(aSTVisitor, this.scope);
                }
                if (this.imports != null) {
                    int n = this.imports.length;
                    for (int i = 0; i < n; ++i) {
                        this.imports[i].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.types != null) {
                    int n = this.types.length;
                    for (int i = 0; i < n; ++i) {
                        this.types[i].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.isModuleInfo() && this.moduleDeclaration != null) {
                    this.moduleDeclaration.traverse(aSTVisitor, this.scope);
                }
            }
            aSTVisitor.endVisit(this, this.scope);
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            // empty catch block
        }
    }

    public ModuleBinding module(LookupEnvironment lookupEnvironment) {
        Object object;
        if (this.moduleDeclaration != null && (object = this.moduleDeclaration.binding) != null) {
            return object;
        }
        if (this.compilationResult != null && (object = this.compilationResult.compilationUnit) != null) {
            return object.module(lookupEnvironment);
        }
        return lookupEnvironment.module;
    }
}

