;;; haskell-ghc-support.el --- GHC specific code    -*- coding: utf-8; lexical-binding: t -*-

;; Copyright © 2016 Haskell Mode
;; Author:  2016 Gracjan Polak

;; This file is not part of GNU Emacs.

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;; This file contains GHC specific constants and information.

;;; Code:

(defvar haskell-ghc-supported-extensions
  '(
    ;;; BEGIN haskell-ghc-supported-extensions
    "AllowAmbiguousTypes"
    "AlternativeLayoutRule"
    "AlternativeLayoutRuleTransitional"
    "ApplicativeDo"
    "Arrows"
    "AutoDeriveTypeable"
    "BangPatterns"
    "BinaryLiterals"
    "BlockArguments"
    "CApiFFI"
    "CPP"
    "CUSKs"
    "ConstrainedClassMethods"
    "ConstraintKinds"
    "DataKinds"
    "DatatypeContexts"
    "DefaultSignatures"
    "DeriveAnyClass"
    "DeriveDataTypeable"
    "DeriveFoldable"
    "DeriveFunctor"
    "DeriveGeneric"
    "DeriveLift"
    "DeriveTraversable"
    "DerivingStrategies"
    "DerivingVia"
    "DisambiguateRecordFields"
    "DoAndIfThenElse"
    "DoRec"
    "DuplicateRecordFields"
    "EmptyCase"
    "EmptyDataDecls"
    "EmptyDataDeriving"
    "ExistentialQuantification"
    "ExplicitForAll"
    "ExplicitNamespaces"
    "ExtendedDefaultRules"
    "FieldSelectors"
    "FlexibleContexts"
    "FlexibleInstances"
    "ForeignFunctionInterface"
    "FunctionalDependencies"
    "GADTSyntax"
    "GADTs"
    "GHC2021"
    "GHCForeignImportPrim"
    "GeneralisedNewtypeDeriving"
    "GeneralizedNewtypeDeriving"
    "Haskell2010"
    "Haskell98"
    "HexFloatLiterals"
    "ImplicitParams"
    "ImplicitPrelude"
    "ImportQualifiedPost"
    "ImpredicativeTypes"
    "IncoherentInstances"
    "InstanceSigs"
    "InterruptibleFFI"
    "JavaScriptFFI"
    "KindSignatures"
    "LambdaCase"
    "LexicalNegation"
    "LiberalTypeSynonyms"
    "LinearTypes"
    "MagicHash"
    "MonadComprehensions"
    "MonadFailDesugaring"
    "MonoLocalBinds"
    "MonoPatBinds"
    "MonomorphismRestriction"
    "MultiParamTypeClasses"
    "MultiWayIf"
    "NPlusKPatterns"
    "NamedFieldPuns"
    "NamedWildCards"
    "NegativeLiterals"
    "NoAllowAmbiguousTypes"
    "NoAlternativeLayoutRule"
    "NoAlternativeLayoutRuleTransitional"
    "NoApplicativeDo"
    "NoArrows"
    "NoAutoDeriveTypeable"
    "NoBangPatterns"
    "NoBinaryLiterals"
    "NoBlockArguments"
    "NoCApiFFI"
    "NoCPP"
    "NoCUSKs"
    "NoConstrainedClassMethods"
    "NoConstraintKinds"
    "NoDataKinds"
    "NoDatatypeContexts"
    "NoDefaultSignatures"
    "NoDeriveAnyClass"
    "NoDeriveDataTypeable"
    "NoDeriveFoldable"
    "NoDeriveFunctor"
    "NoDeriveGeneric"
    "NoDeriveLift"
    "NoDeriveTraversable"
    "NoDerivingStrategies"
    "NoDerivingVia"
    "NoDisambiguateRecordFields"
    "NoDoAndIfThenElse"
    "NoDoRec"
    "NoDuplicateRecordFields"
    "NoEmptyCase"
    "NoEmptyDataDecls"
    "NoEmptyDataDeriving"
    "NoExistentialQuantification"
    "NoExplicitForAll"
    "NoExplicitNamespaces"
    "NoExtendedDefaultRules"
    "NoFieldSelectors"
    "NoFlexibleContexts"
    "NoFlexibleInstances"
    "NoForeignFunctionInterface"
    "NoFunctionalDependencies"
    "NoGADTSyntax"
    "NoGADTs"
    "NoGHCForeignImportPrim"
    "NoGeneralisedNewtypeDeriving"
    "NoGeneralizedNewtypeDeriving"
    "NoHexFloatLiterals"
    "NoImplicitParams"
    "NoImplicitPrelude"
    "NoImportQualifiedPost"
    "NoImpredicativeTypes"
    "NoIncoherentInstances"
    "NoInstanceSigs"
    "NoInterruptibleFFI"
    "NoJavaScriptFFI"
    "NoKindSignatures"
    "NoLambdaCase"
    "NoLexicalNegation"
    "NoLiberalTypeSynonyms"
    "NoLinearTypes"
    "NoMagicHash"
    "NoMonadComprehensions"
    "NoMonadFailDesugaring"
    "NoMonoLocalBinds"
    "NoMonoPatBinds"
    "NoMonomorphismRestriction"
    "NoMultiParamTypeClasses"
    "NoMultiWayIf"
    "NoNPlusKPatterns"
    "NoNamedFieldPuns"
    "NoNamedWildCards"
    "NoNegativeLiterals"
    "NoNondecreasingIndentation"
    "NoNullaryTypeClasses"
    "NoNumDecimals"
    "NoNumericUnderscores"
    "NoOverlappingInstances"
    "NoOverloadedLabels"
    "NoOverloadedLists"
    "NoOverloadedRecordDot"
    "NoOverloadedRecordUpdate"
    "NoOverloadedStrings"
    "NoPackageImports"
    "NoParallelArrays"
    "NoParallelListComp"
    "NoPartialTypeSignatures"
    "NoPatternGuards"
    "NoPatternSignatures"
    "NoPatternSynonyms"
    "NoPolyKinds"
    "NoPolymorphicComponents"
    "NoPostfixOperators"
    "NoQualifiedDo"
    "NoQuantifiedConstraints"
    "NoQuasiQuotes"
    "NoRank2Types"
    "NoRankNTypes"
    "NoRebindableSyntax"
    "NoRecordPuns"
    "NoRecordWildCards"
    "NoRecursiveDo"
    "NoRelaxedLayout"
    "NoRelaxedPolyRec"
    "NoRoleAnnotations"
    "NoScopedTypeVariables"
    "NoStandaloneDeriving"
    "NoStandaloneKindSignatures"
    "NoStarIsType"
    "NoStaticPointers"
    "NoStrict"
    "NoStrictData"
    "NoTemplateHaskell"
    "NoTemplateHaskellQuotes"
    "NoTraditionalRecordSyntax"
    "NoTransformListComp"
    "NoTupleSections"
    "NoTypeApplications"
    "NoTypeFamilies"
    "NoTypeFamilyDependencies"
    "NoTypeInType"
    "NoTypeOperators"
    "NoTypeSynonymInstances"
    "NoUnboxedSums"
    "NoUnboxedTuples"
    "NoUndecidableInstances"
    "NoUndecidableSuperClasses"
    "NoUnicodeSyntax"
    "NoUnliftedDatatypes"
    "NoUnliftedFFITypes"
    "NoUnliftedNewtypes"
    "NoViewPatterns"
    "NondecreasingIndentation"
    "NullaryTypeClasses"
    "NumDecimals"
    "NumericUnderscores"
    "OverlappingInstances"
    "OverloadedLabels"
    "OverloadedLists"
    "OverloadedRecordDot"
    "OverloadedRecordUpdate"
    "OverloadedStrings"
    "PackageImports"
    "ParallelArrays"
    "ParallelListComp"
    "PartialTypeSignatures"
    "PatternGuards"
    "PatternSignatures"
    "PatternSynonyms"
    "PolyKinds"
    "PolymorphicComponents"
    "PostfixOperators"
    "QualifiedDo"
    "QuantifiedConstraints"
    "QuasiQuotes"
    "Rank2Types"
    "RankNTypes"
    "RebindableSyntax"
    "RecordPuns"
    "RecordWildCards"
    "RecursiveDo"
    "RelaxedLayout"
    "RelaxedPolyRec"
    "RoleAnnotations"
    "Safe"
    "ScopedTypeVariables"
    "StandaloneDeriving"
    "StandaloneKindSignatures"
    "StarIsType"
    "StaticPointers"
    "Strict"
    "StrictData"
    "TemplateHaskell"
    "TemplateHaskellQuotes"
    "TraditionalRecordSyntax"
    "TransformListComp"
    "Trustworthy"
    "TupleSections"
    "TypeApplications"
    "TypeFamilies"
    "TypeFamilyDependencies"
    "TypeInType"
    "TypeOperators"
    "TypeSynonymInstances"
    "UnboxedSums"
    "UnboxedTuples"
    "UndecidableInstances"
    "UndecidableSuperClasses"
    "UnicodeSyntax"
    "UnliftedDatatypes"
    "UnliftedFFITypes"
    "UnliftedNewtypes"
    "Unsafe"
    "ViewPatterns"
    ;;; END haskell-ghc-supported-extensions
    )
  "List of language extensions supported by any known version of GHC.

This list should be updated by running `haskell-update-ghc-support'.")

(defvar haskell-ghc-supported-options
  '(
    ;;; BEGIN haskell-ghc-supported-options
    "-#include"
    "--abi-hash"
    "--backpack"
    "--frontend"
    "--help"
    "--info"
    "--interactive"
    "--make"
    "--numeric-version"
    "--print-booter-version"
    "--print-build-platform"
    "--print-c-compiler-flags"
    "--print-c-compiler-link-flags"
    "--print-debug-on"
    "--print-gcc-linker-flags"
    "--print-global-package-db"
    "--print-have-interpreter"
    "--print-have-native-code-generator"
    "--print-host-platform"
    "--print-ld-flags"
    "--print-ld-linker-flags"
    "--print-leading-underscore"
    "--print-libdir"
    "--print-object-splitting-supported"
    "--print-project-git-commit-id"
    "--print-project-version"
    "--print-rts-ways"
    "--print-stage"
    "--print-support-smp"
    "--print-tables-next-to-code"
    "--print-target-platform"
    "--print-unregisterised"
    "--run"
    "--show-iface"
    "--show-options"
    "--show-packages"
    "--supported-extensions"
    "--supported-languages"
    "--version"
    "-?"
    "-C"
    "-D"
    "-E"
    "-F"
    "-H"
    "-I"
    "-L"
    "-M"
    "-O"
    "-Odph"
    "-Onot"
    "-Rghc-timing"
    "-S"
    "-U"
    "-V"
    "-W"
    "-Wall"
    "-Wall-missed-specialisations"
    "-Wall-missed-specializations"
    "-Walternative-layout-rule-transitional"
    "-Wambiguous-fields"
    "-Wamp"
    "-Wauto-orphans"
    "-Wcompat"
    "-Wcompat-unqualified-imports"
    "-Wcontext-quantification"
    "-Wcpp-undef"
    "-Wdefault"
    "-Wdeferred-out-of-scope-variables"
    "-Wdeferred-type-errors"
    "-Wdeprecated-flags"
    "-Wdeprecations"
    "-Wderiving-defaults"
    "-Wderiving-typeable"
    "-Wdodgy-exports"
    "-Wdodgy-foreign-imports"
    "-Wdodgy-imports"
    "-Wduplicate-constraints"
    "-Wduplicate-exports"
    "-Wempty-enumerations"
    "-Werror"
    "-Werror=all-missed-specialisations"
    "-Werror=all-missed-specializations"
    "-Werror=alternative-layout-rule-transitional"
    "-Werror=ambiguous-fields"
    "-Werror=auto-orphans"
    "-Werror=compat"
    "-Werror=compat-unqualified-imports"
    "-Werror=cpp-undef"
    "-Werror=deferred-out-of-scope-variables"
    "-Werror=deferred-type-errors"
    "-Werror=deprecated-flags"
    "-Werror=deprecations"
    "-Werror=deriving-defaults"
    "-Werror=deriving-typeable"
    "-Werror=dodgy-exports"
    "-Werror=dodgy-foreign-imports"
    "-Werror=dodgy-imports"
    "-Werror=duplicate-constraints"
    "-Werror=duplicate-exports"
    "-Werror=empty-enumerations"
    "-Werror=hi-shadowing"
    "-Werror=identities"
    "-Werror=implicit-kind-vars"
    "-Werror=implicit-lift"
    "-Werror=implicit-prelude"
    "-Werror=inaccessible-code"
    "-Werror=incomplete-patterns"
    "-Werror=incomplete-record-updates"
    "-Werror=incomplete-uni-patterns"
    "-Werror=inferred-safe-imports"
    "-Werror=inline-rule-shadowing"
    "-Werror=invalid-haddock"
    "-Werror=missed-extra-shared-lib"
    "-Werror=missed-specialisations"
    "-Werror=missed-specializations"
    "-Werror=missing-deriving-strategies"
    "-Werror=missing-export-lists"
    "-Werror=missing-exported-signatures"
    "-Werror=missing-exported-sigs"
    "-Werror=missing-fields"
    "-Werror=missing-home-modules"
    "-Werror=missing-import-lists"
    "-Werror=missing-kind-signatures"
    "-Werror=missing-local-signatures"
    "-Werror=missing-local-sigs"
    "-Werror=missing-methods"
    "-Werror=missing-monadfail-instances"
    "-Werror=missing-pattern-synonym-signatures"
    "-Werror=missing-safe-haskell-mode"
    "-Werror=missing-signatures"
    "-Werror=missing-space-after-bang"
    "-Werror=monomorphism-restriction"
    "-Werror=name-shadowing"
    "-Werror=noncanonical-monad-instances"
    "-Werror=noncanonical-monadfail-instances"
    "-Werror=noncanonical-monoid-instances"
    "-Werror=operator-whitespace"
    "-Werror=operator-whitespace-ext-conflict"
    "-Werror=orphans"
    "-Werror=overflowed-literals"
    "-Werror=overlapping-patterns"
    "-Werror=partial-fields"
    "-Werror=partial-type-signatures"
    "-Werror=prepositive-qualified-module"
    "-Werror=redundant-bang-patterns"
    "-Werror=redundant-constraints"
    "-Werror=redundant-record-wildcards"
    "-Werror=safe"
    "-Werror=semigroup"
    "-Werror=simplifiable-class-constraints"
    "-Werror=star-binder"
    "-Werror=star-is-type"
    "-Werror=tabs"
    "-Werror=trustworthy-safe"
    "-Werror=type-defaults"
    "-Werror=typed-holes"
    "-Werror=unbanged-strict-patterns"
    "-Werror=unicode-bidirectional-format-characters"
    "-Werror=unrecognised-pragmas"
    "-Werror=unrecognised-warning-flags"
    "-Werror=unsafe"
    "-Werror=unsupported-calling-conventions"
    "-Werror=unsupported-llvm-version"
    "-Werror=unticked-promoted-constructors"
    "-Werror=unused-do-bind"
    "-Werror=unused-foralls"
    "-Werror=unused-imports"
    "-Werror=unused-local-binds"
    "-Werror=unused-matches"
    "-Werror=unused-packages"
    "-Werror=unused-pattern-binds"
    "-Werror=unused-record-wildcards"
    "-Werror=unused-top-binds"
    "-Werror=unused-type-patterns"
    "-Werror=warnings-deprecations"
    "-Werror=wrong-do-bind"
    "-Weverything"
    "-Wextra"
    "-Whi-shadowing"
    "-Widentities"
    "-Wimplicit-kind-vars"
    "-Wimplicit-lift"
    "-Wimplicit-prelude"
    "-Winaccessible-code"
    "-Wincomplete-patterns"
    "-Wincomplete-record-updates"
    "-Wincomplete-uni-patterns"
    "-Winferred-safe-imports"
    "-Winline-rule-shadowing"
    "-Winvalid-haddock"
    "-Wmissed-extra-shared-lib"
    "-Wmissed-specialisations"
    "-Wmissed-specializations"
    "-Wmissing-deriving-strategies"
    "-Wmissing-export-lists"
    "-Wmissing-exported-signatures"
    "-Wmissing-exported-sigs"
    "-Wmissing-fields"
    "-Wmissing-home-modules"
    "-Wmissing-import-lists"
    "-Wmissing-kind-signatures"
    "-Wmissing-local-signatures"
    "-Wmissing-local-sigs"
    "-Wmissing-methods"
    "-Wmissing-monadfail-instances"
    "-Wmissing-pattern-synonym-signatures"
    "-Wmissing-safe-haskell-mode"
    "-Wmissing-signatures"
    "-Wmissing-space-after-bang"
    "-Wmonomorphism-restriction"
    "-Wname-shadowing"
    "-Wno-all"
    "-Wno-all-missed-specialisations"
    "-Wno-all-missed-specializations"
    "-Wno-alternative-layout-rule-transitional"
    "-Wno-ambiguous-fields"
    "-Wno-amp"
    "-Wno-auto-orphans"
    "-Wno-compat"
    "-Wno-compat-unqualified-imports"
    "-Wno-context-quantification"
    "-Wno-cpp-undef"
    "-Wno-default"
    "-Wno-deferred-out-of-scope-variables"
    "-Wno-deferred-type-errors"
    "-Wno-deprecated-flags"
    "-Wno-deprecations"
    "-Wno-deriving-defaults"
    "-Wno-deriving-typeable"
    "-Wno-dodgy-exports"
    "-Wno-dodgy-foreign-imports"
    "-Wno-dodgy-imports"
    "-Wno-duplicate-constraints"
    "-Wno-duplicate-exports"
    "-Wno-empty-enumerations"
    "-Wno-error=all-missed-specialisations"
    "-Wno-error=all-missed-specializations"
    "-Wno-error=alternative-layout-rule-transitional"
    "-Wno-error=ambiguous-fields"
    "-Wno-error=auto-orphans"
    "-Wno-error=compat"
    "-Wno-error=compat-unqualified-imports"
    "-Wno-error=cpp-undef"
    "-Wno-error=deferred-out-of-scope-variables"
    "-Wno-error=deferred-type-errors"
    "-Wno-error=deprecated-flags"
    "-Wno-error=deprecations"
    "-Wno-error=deriving-defaults"
    "-Wno-error=deriving-typeable"
    "-Wno-error=dodgy-exports"
    "-Wno-error=dodgy-foreign-imports"
    "-Wno-error=dodgy-imports"
    "-Wno-error=duplicate-constraints"
    "-Wno-error=duplicate-exports"
    "-Wno-error=empty-enumerations"
    "-Wno-error=hi-shadowing"
    "-Wno-error=identities"
    "-Wno-error=implicit-kind-vars"
    "-Wno-error=implicit-lift"
    "-Wno-error=implicit-prelude"
    "-Wno-error=inaccessible-code"
    "-Wno-error=incomplete-patterns"
    "-Wno-error=incomplete-record-updates"
    "-Wno-error=incomplete-uni-patterns"
    "-Wno-error=inferred-safe-imports"
    "-Wno-error=inline-rule-shadowing"
    "-Wno-error=invalid-haddock"
    "-Wno-error=missed-extra-shared-lib"
    "-Wno-error=missed-specialisations"
    "-Wno-error=missed-specializations"
    "-Wno-error=missing-deriving-strategies"
    "-Wno-error=missing-export-lists"
    "-Wno-error=missing-exported-signatures"
    "-Wno-error=missing-exported-sigs"
    "-Wno-error=missing-fields"
    "-Wno-error=missing-home-modules"
    "-Wno-error=missing-import-lists"
    "-Wno-error=missing-kind-signatures"
    "-Wno-error=missing-local-signatures"
    "-Wno-error=missing-local-sigs"
    "-Wno-error=missing-methods"
    "-Wno-error=missing-monadfail-instances"
    "-Wno-error=missing-pattern-synonym-signatures"
    "-Wno-error=missing-safe-haskell-mode"
    "-Wno-error=missing-signatures"
    "-Wno-error=missing-space-after-bang"
    "-Wno-error=monomorphism-restriction"
    "-Wno-error=name-shadowing"
    "-Wno-error=noncanonical-monad-instances"
    "-Wno-error=noncanonical-monadfail-instances"
    "-Wno-error=noncanonical-monoid-instances"
    "-Wno-error=operator-whitespace"
    "-Wno-error=operator-whitespace-ext-conflict"
    "-Wno-error=orphans"
    "-Wno-error=overflowed-literals"
    "-Wno-error=overlapping-patterns"
    "-Wno-error=partial-fields"
    "-Wno-error=partial-type-signatures"
    "-Wno-error=prepositive-qualified-module"
    "-Wno-error=redundant-bang-patterns"
    "-Wno-error=redundant-constraints"
    "-Wno-error=redundant-record-wildcards"
    "-Wno-error=safe"
    "-Wno-error=semigroup"
    "-Wno-error=simplifiable-class-constraints"
    "-Wno-error=star-binder"
    "-Wno-error=star-is-type"
    "-Wno-error=tabs"
    "-Wno-error=trustworthy-safe"
    "-Wno-error=type-defaults"
    "-Wno-error=typed-holes"
    "-Wno-error=unbanged-strict-patterns"
    "-Wno-error=unicode-bidirectional-format-characters"
    "-Wno-error=unrecognised-pragmas"
    "-Wno-error=unrecognised-warning-flags"
    "-Wno-error=unsafe"
    "-Wno-error=unsupported-calling-conventions"
    "-Wno-error=unsupported-llvm-version"
    "-Wno-error=unticked-promoted-constructors"
    "-Wno-error=unused-do-bind"
    "-Wno-error=unused-foralls"
    "-Wno-error=unused-imports"
    "-Wno-error=unused-local-binds"
    "-Wno-error=unused-matches"
    "-Wno-error=unused-packages"
    "-Wno-error=unused-pattern-binds"
    "-Wno-error=unused-record-wildcards"
    "-Wno-error=unused-top-binds"
    "-Wno-error=unused-type-patterns"
    "-Wno-error=warnings-deprecations"
    "-Wno-error=wrong-do-bind"
    "-Wno-everything"
    "-Wno-extra"
    "-Wno-hi-shadowing"
    "-Wno-identities"
    "-Wno-implicit-kind-vars"
    "-Wno-implicit-lift"
    "-Wno-implicit-prelude"
    "-Wno-inaccessible-code"
    "-Wno-incomplete-patterns"
    "-Wno-incomplete-record-updates"
    "-Wno-incomplete-uni-patterns"
    "-Wno-inferred-safe-imports"
    "-Wno-inline-rule-shadowing"
    "-Wno-invalid-haddock"
    "-Wno-missed-extra-shared-lib"
    "-Wno-missed-specialisations"
    "-Wno-missed-specializations"
    "-Wno-missing-deriving-strategies"
    "-Wno-missing-export-lists"
    "-Wno-missing-exported-signatures"
    "-Wno-missing-exported-sigs"
    "-Wno-missing-fields"
    "-Wno-missing-home-modules"
    "-Wno-missing-import-lists"
    "-Wno-missing-kind-signatures"
    "-Wno-missing-local-signatures"
    "-Wno-missing-local-sigs"
    "-Wno-missing-methods"
    "-Wno-missing-monadfail-instances"
    "-Wno-missing-pattern-synonym-signatures"
    "-Wno-missing-safe-haskell-mode"
    "-Wno-missing-signatures"
    "-Wno-missing-space-after-bang"
    "-Wno-monomorphism-restriction"
    "-Wno-name-shadowing"
    "-Wno-noncanonical-monad-instances"
    "-Wno-noncanonical-monadfail-instances"
    "-Wno-noncanonical-monoid-instances"
    "-Wno-operator-whitespace"
    "-Wno-operator-whitespace-ext-conflict"
    "-Wno-orphans"
    "-Wno-overflowed-literals"
    "-Wno-overlapping-patterns"
    "-Wno-partial-fields"
    "-Wno-partial-type-signatures"
    "-Wno-prepositive-qualified-module"
    "-Wno-redundant-bang-patterns"
    "-Wno-redundant-constraints"
    "-Wno-redundant-record-wildcards"
    "-Wno-safe"
    "-Wno-semigroup"
    "-Wno-simplifiable-class-constraints"
    "-Wno-star-binder"
    "-Wno-star-is-type"
    "-Wno-tabs"
    "-Wno-trustworthy-safe"
    "-Wno-type-defaults"
    "-Wno-typed-holes"
    "-Wno-unbanged-strict-patterns"
    "-Wno-unicode-bidirectional-format-characters"
    "-Wno-unrecognised-pragmas"
    "-Wno-unrecognised-warning-flags"
    "-Wno-unsafe"
    "-Wno-unsupported-calling-conventions"
    "-Wno-unsupported-llvm-version"
    "-Wno-unticked-promoted-constructors"
    "-Wno-unused-binds"
    "-Wno-unused-do-bind"
    "-Wno-unused-foralls"
    "-Wno-unused-imports"
    "-Wno-unused-local-binds"
    "-Wno-unused-matches"
    "-Wno-unused-packages"
    "-Wno-unused-pattern-binds"
    "-Wno-unused-record-wildcards"
    "-Wno-unused-top-binds"
    "-Wno-unused-type-patterns"
    "-Wno-warnings-deprecations"
    "-Wno-wrong-do-bind"
    "-Wnoncanonical-monad-instances"
    "-Wnoncanonical-monadfail-instances"
    "-Wnoncanonical-monoid-instances"
    "-Wnot"
    "-Woperator-whitespace"
    "-Woperator-whitespace-ext-conflict"
    "-Worphans"
    "-Woverflowed-literals"
    "-Woverlapping-patterns"
    "-Wpartial-fields"
    "-Wpartial-type-signatures"
    "-Wprepositive-qualified-module"
    "-Wredundant-bang-patterns"
    "-Wredundant-constraints"
    "-Wredundant-record-wildcards"
    "-Wsafe"
    "-Wsemigroup"
    "-Wsimplifiable-class-constraints"
    "-Wstar-binder"
    "-Wstar-is-type"
    "-Wtabs"
    "-Wtrustworthy-safe"
    "-Wtype-defaults"
    "-Wtyped-holes"
    "-Wunbanged-strict-patterns"
    "-Wunicode-bidirectional-format-characters"
    "-Wunrecognised-pragmas"
    "-Wunrecognised-warning-flags"
    "-Wunsafe"
    "-Wunsupported-calling-conventions"
    "-Wunsupported-llvm-version"
    "-Wunticked-promoted-constructors"
    "-Wunused-binds"
    "-Wunused-do-bind"
    "-Wunused-foralls"
    "-Wunused-imports"
    "-Wunused-local-binds"
    "-Wunused-matches"
    "-Wunused-packages"
    "-Wunused-pattern-binds"
    "-Wunused-record-wildcards"
    "-Wunused-top-binds"
    "-Wunused-type-patterns"
    "-Wwarn"
    "-Wwarn=all-missed-specialisations"
    "-Wwarn=all-missed-specializations"
    "-Wwarn=alternative-layout-rule-transitional"
    "-Wwarn=ambiguous-fields"
    "-Wwarn=auto-orphans"
    "-Wwarn=compat"
    "-Wwarn=compat-unqualified-imports"
    "-Wwarn=cpp-undef"
    "-Wwarn=deferred-out-of-scope-variables"
    "-Wwarn=deferred-type-errors"
    "-Wwarn=deprecated-flags"
    "-Wwarn=deprecations"
    "-Wwarn=deriving-defaults"
    "-Wwarn=deriving-typeable"
    "-Wwarn=dodgy-exports"
    "-Wwarn=dodgy-foreign-imports"
    "-Wwarn=dodgy-imports"
    "-Wwarn=duplicate-constraints"
    "-Wwarn=duplicate-exports"
    "-Wwarn=empty-enumerations"
    "-Wwarn=hi-shadowing"
    "-Wwarn=identities"
    "-Wwarn=implicit-kind-vars"
    "-Wwarn=implicit-lift"
    "-Wwarn=implicit-prelude"
    "-Wwarn=inaccessible-code"
    "-Wwarn=incomplete-patterns"
    "-Wwarn=incomplete-record-updates"
    "-Wwarn=incomplete-uni-patterns"
    "-Wwarn=inferred-safe-imports"
    "-Wwarn=inline-rule-shadowing"
    "-Wwarn=invalid-haddock"
    "-Wwarn=missed-extra-shared-lib"
    "-Wwarn=missed-specialisations"
    "-Wwarn=missed-specializations"
    "-Wwarn=missing-deriving-strategies"
    "-Wwarn=missing-export-lists"
    "-Wwarn=missing-exported-signatures"
    "-Wwarn=missing-exported-sigs"
    "-Wwarn=missing-fields"
    "-Wwarn=missing-home-modules"
    "-Wwarn=missing-import-lists"
    "-Wwarn=missing-kind-signatures"
    "-Wwarn=missing-local-signatures"
    "-Wwarn=missing-local-sigs"
    "-Wwarn=missing-methods"
    "-Wwarn=missing-monadfail-instances"
    "-Wwarn=missing-pattern-synonym-signatures"
    "-Wwarn=missing-safe-haskell-mode"
    "-Wwarn=missing-signatures"
    "-Wwarn=missing-space-after-bang"
    "-Wwarn=monomorphism-restriction"
    "-Wwarn=name-shadowing"
    "-Wwarn=noncanonical-monad-instances"
    "-Wwarn=noncanonical-monadfail-instances"
    "-Wwarn=noncanonical-monoid-instances"
    "-Wwarn=operator-whitespace"
    "-Wwarn=operator-whitespace-ext-conflict"
    "-Wwarn=orphans"
    "-Wwarn=overflowed-literals"
    "-Wwarn=overlapping-patterns"
    "-Wwarn=partial-fields"
    "-Wwarn=partial-type-signatures"
    "-Wwarn=prepositive-qualified-module"
    "-Wwarn=redundant-bang-patterns"
    "-Wwarn=redundant-constraints"
    "-Wwarn=redundant-record-wildcards"
    "-Wwarn=safe"
    "-Wwarn=semigroup"
    "-Wwarn=simplifiable-class-constraints"
    "-Wwarn=star-binder"
    "-Wwarn=star-is-type"
    "-Wwarn=tabs"
    "-Wwarn=trustworthy-safe"
    "-Wwarn=type-defaults"
    "-Wwarn=typed-holes"
    "-Wwarn=unbanged-strict-patterns"
    "-Wwarn=unicode-bidirectional-format-characters"
    "-Wwarn=unrecognised-pragmas"
    "-Wwarn=unrecognised-warning-flags"
    "-Wwarn=unsafe"
    "-Wwarn=unsupported-calling-conventions"
    "-Wwarn=unsupported-llvm-version"
    "-Wwarn=unticked-promoted-constructors"
    "-Wwarn=unused-do-bind"
    "-Wwarn=unused-foralls"
    "-Wwarn=unused-imports"
    "-Wwarn=unused-local-binds"
    "-Wwarn=unused-matches"
    "-Wwarn=unused-packages"
    "-Wwarn=unused-pattern-binds"
    "-Wwarn=unused-record-wildcards"
    "-Wwarn=unused-top-binds"
    "-Wwarn=unused-type-patterns"
    "-Wwarn=warnings-deprecations"
    "-Wwarn=wrong-do-bind"
    "-Wwarnings-deprecations"
    "-Wwrong-do-bind"
    "-XAllowAmbiguousTypes"
    "-XAlternativeLayoutRule"
    "-XAlternativeLayoutRuleTransitional"
    "-XApplicativeDo"
    "-XArrows"
    "-XAutoDeriveTypeable"
    "-XBangPatterns"
    "-XBinaryLiterals"
    "-XBlockArguments"
    "-XCApiFFI"
    "-XCPP"
    "-XCUSKs"
    "-XConstrainedClassMethods"
    "-XConstraintKinds"
    "-XDataKinds"
    "-XDatatypeContexts"
    "-XDefaultSignatures"
    "-XDeriveAnyClass"
    "-XDeriveDataTypeable"
    "-XDeriveFoldable"
    "-XDeriveFunctor"
    "-XDeriveGeneric"
    "-XDeriveLift"
    "-XDeriveTraversable"
    "-XDerivingStrategies"
    "-XDerivingVia"
    "-XDisambiguateRecordFields"
    "-XDoAndIfThenElse"
    "-XDoRec"
    "-XDuplicateRecordFields"
    "-XEmptyCase"
    "-XEmptyDataDecls"
    "-XEmptyDataDeriving"
    "-XExistentialQuantification"
    "-XExplicitForAll"
    "-XExplicitNamespaces"
    "-XExtendedDefaultRules"
    "-XFieldSelectors"
    "-XFlexibleContexts"
    "-XFlexibleInstances"
    "-XForeignFunctionInterface"
    "-XFunctionalDependencies"
    "-XGADTSyntax"
    "-XGADTs"
    "-XGHC2021"
    "-XGHCForeignImportPrim"
    "-XGeneralisedNewtypeDeriving"
    "-XGeneralizedNewtypeDeriving"
    "-XGenerics"
    "-XHaskell2010"
    "-XHaskell98"
    "-XHexFloatLiterals"
    "-XImplicitParams"
    "-XImplicitPrelude"
    "-XImportQualifiedPost"
    "-XImpredicativeTypes"
    "-XIncoherentInstances"
    "-XInstanceSigs"
    "-XInterruptibleFFI"
    "-XJavaScriptFFI"
    "-XKindSignatures"
    "-XLambdaCase"
    "-XLexicalNegation"
    "-XLiberalTypeSynonyms"
    "-XLinearTypes"
    "-XMagicHash"
    "-XMonadComprehensions"
    "-XMonadFailDesugaring"
    "-XMonoLocalBinds"
    "-XMonoPatBinds"
    "-XMonomorphismRestriction"
    "-XMultiParamTypeClasses"
    "-XMultiWayIf"
    "-XNPlusKPatterns"
    "-XNamedFieldPuns"
    "-XNamedWildCards"
    "-XNegativeLiterals"
    "-XNoAllowAmbiguousTypes"
    "-XNoAlternativeLayoutRule"
    "-XNoAlternativeLayoutRuleTransitional"
    "-XNoApplicativeDo"
    "-XNoArrows"
    "-XNoAutoDeriveTypeable"
    "-XNoBangPatterns"
    "-XNoBinaryLiterals"
    "-XNoBlockArguments"
    "-XNoCApiFFI"
    "-XNoCPP"
    "-XNoCUSKs"
    "-XNoConstrainedClassMethods"
    "-XNoConstraintKinds"
    "-XNoDataKinds"
    "-XNoDatatypeContexts"
    "-XNoDefaultSignatures"
    "-XNoDeriveAnyClass"
    "-XNoDeriveDataTypeable"
    "-XNoDeriveFoldable"
    "-XNoDeriveFunctor"
    "-XNoDeriveGeneric"
    "-XNoDeriveLift"
    "-XNoDeriveTraversable"
    "-XNoDerivingStrategies"
    "-XNoDerivingVia"
    "-XNoDisambiguateRecordFields"
    "-XNoDoAndIfThenElse"
    "-XNoDoRec"
    "-XNoDuplicateRecordFields"
    "-XNoEmptyCase"
    "-XNoEmptyDataDecls"
    "-XNoEmptyDataDeriving"
    "-XNoExistentialQuantification"
    "-XNoExplicitForAll"
    "-XNoExplicitNamespaces"
    "-XNoExtendedDefaultRules"
    "-XNoFieldSelectors"
    "-XNoFlexibleContexts"
    "-XNoFlexibleInstances"
    "-XNoForeignFunctionInterface"
    "-XNoFunctionalDependencies"
    "-XNoGADTSyntax"
    "-XNoGADTs"
    "-XNoGHCForeignImportPrim"
    "-XNoGeneralisedNewtypeDeriving"
    "-XNoGeneralizedNewtypeDeriving"
    "-XNoGenerics"
    "-XNoHexFloatLiterals"
    "-XNoImplicitParams"
    "-XNoImplicitPrelude"
    "-XNoImportQualifiedPost"
    "-XNoImpredicativeTypes"
    "-XNoIncoherentInstances"
    "-XNoInstanceSigs"
    "-XNoInterruptibleFFI"
    "-XNoJavaScriptFFI"
    "-XNoKindSignatures"
    "-XNoLambdaCase"
    "-XNoLexicalNegation"
    "-XNoLiberalTypeSynonyms"
    "-XNoLinearTypes"
    "-XNoMagicHash"
    "-XNoMonadComprehensions"
    "-XNoMonadFailDesugaring"
    "-XNoMonoLocalBinds"
    "-XNoMonoPatBinds"
    "-XNoMonomorphismRestriction"
    "-XNoMultiParamTypeClasses"
    "-XNoMultiWayIf"
    "-XNoNPlusKPatterns"
    "-XNoNamedFieldPuns"
    "-XNoNamedWildCards"
    "-XNoNegativeLiterals"
    "-XNoNondecreasingIndentation"
    "-XNoNullaryTypeClasses"
    "-XNoNumDecimals"
    "-XNoNumericUnderscores"
    "-XNoOverlappingInstances"
    "-XNoOverloadedLabels"
    "-XNoOverloadedLists"
    "-XNoOverloadedRecordDot"
    "-XNoOverloadedRecordUpdate"
    "-XNoOverloadedStrings"
    "-XNoPackageImports"
    "-XNoParallelArrays"
    "-XNoParallelListComp"
    "-XNoPartialTypeSignatures"
    "-XNoPatternGuards"
    "-XNoPatternSignatures"
    "-XNoPatternSynonyms"
    "-XNoPolyKinds"
    "-XNoPolymorphicComponents"
    "-XNoPostfixOperators"
    "-XNoQualifiedDo"
    "-XNoQuantifiedConstraints"
    "-XNoQuasiQuotes"
    "-XNoRank2Types"
    "-XNoRankNTypes"
    "-XNoRebindableSyntax"
    "-XNoRecordPuns"
    "-XNoRecordWildCards"
    "-XNoRecursiveDo"
    "-XNoRelaxedLayout"
    "-XNoRelaxedPolyRec"
    "-XNoRoleAnnotations"
    "-XNoScopedTypeVariables"
    "-XNoStandaloneDeriving"
    "-XNoStandaloneKindSignatures"
    "-XNoStarIsType"
    "-XNoStaticPointers"
    "-XNoStrict"
    "-XNoStrictData"
    "-XNoTemplateHaskell"
    "-XNoTemplateHaskellQuotes"
    "-XNoTraditionalRecordSyntax"
    "-XNoTransformListComp"
    "-XNoTupleSections"
    "-XNoTypeApplications"
    "-XNoTypeFamilies"
    "-XNoTypeFamilyDependencies"
    "-XNoTypeInType"
    "-XNoTypeOperators"
    "-XNoTypeSynonymInstances"
    "-XNoUnboxedSums"
    "-XNoUnboxedTuples"
    "-XNoUndecidableInstances"
    "-XNoUndecidableSuperClasses"
    "-XNoUnicodeSyntax"
    "-XNoUnliftedDatatypes"
    "-XNoUnliftedFFITypes"
    "-XNoUnliftedNewtypes"
    "-XNoViewPatterns"
    "-XNondecreasingIndentation"
    "-XNullaryTypeClasses"
    "-XNumDecimals"
    "-XNumericUnderscores"
    "-XOverlappingInstances"
    "-XOverloadedLabels"
    "-XOverloadedLists"
    "-XOverloadedRecordDot"
    "-XOverloadedRecordUpdate"
    "-XOverloadedStrings"
    "-XPackageImports"
    "-XParallelArrays"
    "-XParallelListComp"
    "-XPartialTypeSignatures"
    "-XPatternGuards"
    "-XPatternSignatures"
    "-XPatternSynonyms"
    "-XPolyKinds"
    "-XPolymorphicComponents"
    "-XPostfixOperators"
    "-XQualifiedDo"
    "-XQuantifiedConstraints"
    "-XQuasiQuotes"
    "-XRank2Types"
    "-XRankNTypes"
    "-XRebindableSyntax"
    "-XRecordPuns"
    "-XRecordWildCards"
    "-XRecursiveDo"
    "-XRelaxedLayout"
    "-XRelaxedPolyRec"
    "-XRoleAnnotations"
    "-XSafe"
    "-XScopedTypeVariables"
    "-XStandaloneDeriving"
    "-XStandaloneKindSignatures"
    "-XStarIsType"
    "-XStaticPointers"
    "-XStrict"
    "-XStrictData"
    "-XTemplateHaskell"
    "-XTemplateHaskellQuotes"
    "-XTraditionalRecordSyntax"
    "-XTransformListComp"
    "-XTrustworthy"
    "-XTupleSections"
    "-XTypeApplications"
    "-XTypeFamilies"
    "-XTypeFamilyDependencies"
    "-XTypeInType"
    "-XTypeOperators"
    "-XTypeSynonymInstances"
    "-XUnboxedSums"
    "-XUnboxedTuples"
    "-XUndecidableInstances"
    "-XUndecidableSuperClasses"
    "-XUnicodeSyntax"
    "-XUnliftedDatatypes"
    "-XUnliftedFFITypes"
    "-XUnliftedNewtypes"
    "-XUnsafe"
    "-XViewPatterns"
    "-auto"
    "-auto-all"
    "-c"
    "-caf-all"
    "-clear-package-db"
    "-copy-libs-when-linking"
    "-cpp"
    "-dannot-lint"
    "-dasm-lint"
    "-dcmm-lint"
    "-dcore-lint"
    "-ddebug-output"
    "-ddump-asm"
    "-ddump-asm-conflicts"
    "-ddump-asm-expanded"
    "-ddump-asm-liveness"
    "-ddump-asm-native"
    "-ddump-asm-regalloc"
    "-ddump-asm-regalloc-stages"
    "-ddump-asm-stats"
    "-ddump-bcos"
    "-ddump-c-backend"
    "-ddump-call-arity"
    "-ddump-cfg-weights"
    "-ddump-cmm"
    "-ddump-cmm-caf"
    "-ddump-cmm-cbe"
    "-ddump-cmm-cfg"
    "-ddump-cmm-cps"
    "-ddump-cmm-from-stg"
    "-ddump-cmm-info"
    "-ddump-cmm-opt"
    "-ddump-cmm-proc"
    "-ddump-cmm-procmap"
    "-ddump-cmm-raw"
    "-ddump-cmm-sink"
    "-ddump-cmm-sp"
    "-ddump-cmm-split"
    "-ddump-cmm-switch"
    "-ddump-cmm-verbose"
    "-ddump-cmm-verbose-by-proc"
    "-ddump-core-stats"
    "-ddump-cpr-signatures"
    "-ddump-cpranal"
    "-ddump-cs-trace"
    "-ddump-cse"
    "-ddump-debug"
    "-ddump-deriv"
    "-ddump-ds"
    "-ddump-ds-preopt"
    "-ddump-ec-trace"
    "-ddump-exitify"
    "-ddump-faststrings"
    "-ddump-file-prefix"
    "-ddump-foreign"
    "-ddump-hi"
    "-ddump-hi-diffs"
    "-ddump-hie"
    "-ddump-hpc"
    "-ddump-if-trace"
    "-ddump-inlinings"
    "-ddump-json"
    "-ddump-llvm"
    "-ddump-minimal-imports"
    "-ddump-mod-cycles"
    "-ddump-mod-map"
    "-ddump-occur-anal"
    "-ddump-opt-cmm"
    "-ddump-parsed"
    "-ddump-parsed-ast"
    "-ddump-prep"
    "-ddump-rn"
    "-ddump-rn-ast"
    "-ddump-rn-stats"
    "-ddump-rn-trace"
    "-ddump-rtti"
    "-ddump-rule-firings"
    "-ddump-rule-rewrites"
    "-ddump-rules"
    "-ddump-simpl"
    "-ddump-simpl-iterations"
    "-ddump-simpl-stats"
    "-ddump-simpl-trace"
    "-ddump-spec"
    "-ddump-splices"
    "-ddump-stg"
    "-ddump-stg-final"
    "-ddump-stg-from-core"
    "-ddump-stg-unarised"
    "-ddump-str-signatures"
    "-ddump-stranal"
    "-ddump-strsigs"
    "-ddump-tc"
    "-ddump-tc-ast"
    "-ddump-tc-trace"
    "-ddump-ticked"
    "-ddump-timings"
    "-ddump-to-file"
    "-ddump-types"
    "-ddump-vect"
    "-ddump-view-pattern-commoning"
    "-ddump-vt-trace"
    "-ddump-worker-wrapper"
    "-debug"
    "-dep-makefile"
    "-dep-suffix"
    "-dfaststring-stats"
    "-dhex-word-literals"
    "-dinitial-unique"
    "-dinline-check"
    "-distrust"
    "-distrust-all-packages"
    "-dlinear-core-lint"
    "-dno-debug-output"
    "-dno-llvm-mangler"
    "-dno-ppr-case-as-let"
    "-dno-ppr-ticks"
    "-dno-suppress-coercions"
    "-dno-suppress-idinfo"
    "-dno-suppress-module-prefixes"
    "-dno-suppress-stg-exts"
    "-dno-suppress-stg-free-vars"
    "-dno-suppress-ticks"
    "-dno-suppress-timestamps"
    "-dno-suppress-type-applications"
    "-dno-suppress-type-signatures"
    "-dno-suppress-unfoldings"
    "-dno-suppress-uniques"
    "-dno-suppress-var-kinds"
    "-dno-typeable-binds"
    "-dppr-case-as-let"
    "-dppr-cols"
    "-dppr-debug"
    "-dppr-ticks"
    "-dppr-user-length"
    "-drule-check"
    "-dshow-passes"
    "-dsource-stats"
    "-dstg-lint"
    "-dstg-stats"
    "-dsuppress-all"
    "-dsuppress-coercions"
    "-dsuppress-idinfo"
    "-dsuppress-module-prefixes"
    "-dsuppress-stg-exts"
    "-dsuppress-stg-free-vars"
    "-dsuppress-ticks"
    "-dsuppress-timestamps"
    "-dsuppress-type-applications"
    "-dsuppress-type-signatures"
    "-dsuppress-unfoldings"
    "-dsuppress-uniques"
    "-dsuppress-var-kinds"
    "-dth-dec-file"
    "-dtrace-level"
    "-dumpdir"
    "-dunique-increment"
    "-dverbose-core2core"
    "-dverbose-stg2stg"
    "-dylib-install-name"
    "-dynamic"
    "-dynamic-too"
    "-dynhisuf"
    "-dynload"
    "-dyno"
    "-dynohi"
    "-dynosuf"
    "-e"
    "-eventlog"
    "-exclude-module"
    "-fPArr"
    "-fPIC"
    "-fPIE"
    "-fabstract-refinement-hole-fits"
    "-falignment-sanitisation"
    "-fallow-incoherent-instances"
    "-fallow-overlapping-instances"
    "-fallow-undecidable-instances"
    "-farrows"
    "-fasm"
    "-fasm-shortcutting"
    "-fbang-patterns"
    "-fbinary-blob-threshold"
    "-fblock-layout-cfg"
    "-fblock-layout-weightless"
    "-fblock-layout-weights"
    "-fbuilding-cabal-package"
    "-fbyte-code"
    "-fcall-arity"
    "-fcase-folding"
    "-fcase-merge"
    "-fcatch-bottoms"
    "-fcheck-prim-bounds"
    "-fclear-plugins"
    "-fcmm-elim-common-blocks"
    "-fcmm-sink"
    "-fcmm-static-pred"
    "-fcompact-unwind"
    "-fconstraint-solver-iterations"
    "-fcontext-stack"
    "-fcpr-anal"
    "-fcpr-off"
    "-fcross-module-specialise"
    "-fcross-module-specialize"
    "-fcse"
    "-fdefer-diagnostics"
    "-fdefer-out-of-scope-variables"
    "-fdefer-type-errors"
    "-fdefer-typed-holes"
    "-fdiagnostics-color=always"
    "-fdiagnostics-color=auto"
    "-fdiagnostics-color=never"
    "-fdiagnostics-show-caret"
    "-fdicts-cheap"
    "-fdicts-strict"
    "-fdistinct-constructor-tables"
    "-fdmd-tx-dict-sel"
    "-fdo-eta-reduction"
    "-fdo-lambda-eta-expansion"
    "-feager-blackholing"
    "-fembed-manifest"
    "-fenable-rewrite-rules"
    "-fenable-th-splice-warnings"
    "-ferror-spans"
    "-fexcess-precision"
    "-fexitification"
    "-fexpose-all-unfoldings"
    "-fexpose-internal-symbols"
    "-fext-core"
    "-fextended-default-rules"
    "-fexternal-dynamic-refs"
    "-fexternal-interpreter"
    "-ffamily-application-cache"
    "-fffi"
    "-ffi"
    "-fflat-cache"
    "-ffloat-all-lams"
    "-ffloat-in"
    "-ffloat-lam-args"
    "-fforce-recomp"
    "-ffrontend-opt"
    "-ffull-laziness"
    "-ffun-to-thunk"
    "-fgen-manifest"
    "-fghci-history"
    "-fghci-leak-check"
    "-fghci-sandbox"
    "-fglasgow-exts"
    "-fhelpful-errors"
    "-fhide-source-paths"
    "-fhistory-size"
    "-fhpc"
    "-fhpc-no-auto"
    "-fignore-asserts"
    "-fignore-hpc-changes"
    "-fignore-interface-pragmas"
    "-fignore-optim-changes"
    "-fimplicit-params"
    "-fimplicit-prelude"
    "-finfo-table-map"
    "-finline-generics"
    "-finline-generics-aggressively"
    "-firrefutable-tuples"
    "-fkeep-cafs"
    "-fkeep-going"
    "-fkill-absence"
    "-fkill-one-shot"
    "-flate-dmd-anal"
    "-flate-specialise"
    "-fliberate-case"
    "-fliberate-case-threshold"
    "-flink-rts"
    "-fllvm"
    "-fllvm-pass-vectors-in-regs"
    "-floopification"
    "-fmax-errors"
    "-fmax-inline-alloc-size"
    "-fmax-inline-memcpy-insns"
    "-fmax-inline-memset-insns"
    "-fmax-pmcheck-iterations"
    "-fmax-pmcheck-models"
    "-fmax-refinement-hole-fits"
    "-fmax-relevant-binds"
    "-fmax-simplifier-iterations"
    "-fmax-uncovered-patterns"
    "-fmax-valid-hole-fits"
    "-fmax-worker-args"
    "-fmono-pat-binds"
    "-fmonomorphism-restriction"
    "-fno-PArr"
    "-fno-PIC"
    "-fno-PIE"
    "-fno-abstract-refinement-hole-fits"
    "-fno-alignment-sanitisation"
    "-fno-allow-incoherent-instances"
    "-fno-allow-overlapping-instances"
    "-fno-allow-undecidable-instances"
    "-fno-arrows"
    "-fno-asm-shortcutting"
    "-fno-bang-patterns"
    "-fno-block-layout-cfg"
    "-fno-block-layout-weightless"
    "-fno-building-cabal-package"
    "-fno-call-arity"
    "-fno-case-folding"
    "-fno-case-merge"
    "-fno-catch-bottoms"
    "-fno-check-prim-bounds"
    "-fno-cmm-elim-common-blocks"
    "-fno-cmm-sink"
    "-fno-cmm-static-pred"
    "-fno-code"
    "-fno-cpr-anal"
    "-fno-cross-module-specialise"
    "-fno-cross-module-specialize"
    "-fno-cse"
    "-fno-defer-diagnostics"
    "-fno-defer-out-of-scope-variables"
    "-fno-defer-type-errors"
    "-fno-defer-typed-holes"
    "-fno-diagnostics-show-caret"
    "-fno-dicts-cheap"
    "-fno-dicts-strict"
    "-fno-dmd-tx-dict-sel"
    "-fno-do-eta-reduction"
    "-fno-do-lambda-eta-expansion"
    "-fno-eager-blackholing"
    "-fno-embed-manifest"
    "-fno-enable-rewrite-rules"
    "-fno-enable-th-splice-warnings"
    "-fno-error-spans"
    "-fno-excess-precision"
    "-fno-exitification"
    "-fno-expose-all-unfoldings"
    "-fno-expose-internal-symbols"
    "-fno-ext-core"
    "-fno-extended-default-rules"
    "-fno-external-dynamic-refs"
    "-fno-external-interpreter"
    "-fno-family-application-cache"
    "-fno-ffi"
    "-fno-fi"
    "-fno-flat-cache"
    "-fno-float-in"
    "-fno-force-recomp"
    "-fno-full-laziness"
    "-fno-fun-to-thunk"
    "-fno-gen-manifest"
    "-fno-ghci-history"
    "-fno-ghci-leak-check"
    "-fno-ghci-sandbox"
    "-fno-glasgow-exts"
    "-fno-helpful-errors"
    "-fno-hide-source-paths"
    "-fno-hpc"
    "-fno-hpc-no-auto"
    "-fno-ignore-asserts"
    "-fno-ignore-hpc-changes"
    "-fno-ignore-interface-pragmas"
    "-fno-ignore-optim-changes"
    "-fno-implicit-params"
    "-fno-implicit-prelude"
    "-fno-inline-generics"
    "-fno-inline-generics-aggressively"
    "-fno-irrefutable-tuples"
    "-fno-keep-cafs"
    "-fno-keep-going"
    "-fno-kill-absence"
    "-fno-kill-one-shot"
    "-fno-late-dmd-anal"
    "-fno-late-specialise"
    "-fno-liberate-case"
    "-fno-liberate-case-threshold"
    "-fno-link-rts"
    "-fno-loopification"
    "-fno-max-errors"
    "-fno-max-refinement-hole-fits"
    "-fno-max-relevant-binds"
    "-fno-max-valid-hole-fits"
    "-fno-mono-pat-binds"
    "-fno-monomorphism-restriction"
    "-fno-num-constant-folding"
    "-fno-omit-interface-pragmas"
    "-fno-omit-yields"
    "-fno-opt-coercion"
    "-fno-optimal-applicative-do"
    "-fno-parr"
    "-fno-pedantic-bottoms"
    "-fno-pre-inlining"
    "-fno-print-axiom-incomps"
    "-fno-print-equality-relations"
    "-fno-print-expanded-synonyms"
    "-fno-print-explicit-coercions"
    "-fno-print-explicit-foralls"
    "-fno-print-explicit-kinds"
    "-fno-print-explicit-runtime-reps"
    "-fno-print-potential-instances"
    "-fno-print-typechecker-elaboration"
    "-fno-print-unicode-syntax"
    "-fno-prof-auto"
    "-fno-prof-cafs"
    "-fno-prof-count-entries"
    "-fno-refinement-level-hole-fits"
    "-fno-regs-graph"
    "-fno-regs-iterative"
    "-fno-reverse-errors"
    "-fno-rewrite-rules"
    "-fno-safe-haskell"
    "-fno-safe-infer"
    "-fno-scoped-type-variables"
    "-fno-shared-implib"
    "-fno-show-docs-of-hole-fits"
    "-fno-show-hole-constraints"
    "-fno-show-hole-matches-of-hole-fits"
    "-fno-show-loaded-modules"
    "-fno-show-provenance-of-hole-fits"
    "-fno-show-type-app-of-hole-fits"
    "-fno-show-type-app-vars-of-hole-fits"
    "-fno-show-type-of-hole-fits"
    "-fno-show-valid-hole-fits"
    "-fno-show-valid-substitutions"
    "-fno-show-warning-groups"
    "-fno-simple-list-literals"
    "-fno-solve-constant-dicts"
    "-fno-sort-by-size-hole-fits"
    "-fno-sort-by-subsumption-hole-fits"
    "-fno-sort-valid-hole-fits"
    "-fno-spec-constr"
    "-fno-spec-constr-count"
    "-fno-spec-constr-keen"
    "-fno-spec-constr-threshold"
    "-fno-specialise"
    "-fno-specialise-aggressively"
    "-fno-specialize"
    "-fno-specialize-aggressively"
    "-fno-state-hack"
    "-fno-static-argument-transformation"
    "-fno-stg-cse"
    "-fno-stg-lift-lams"
    "-fno-stg-lift-lams-known"
    "-fno-strictness"
    "-fno-th"
    "-fno-unbox-small-strict-fields"
    "-fno-unbox-strict-fields"
    "-fno-unclutter-valid-hole-fits"
    "-fno-use-rpaths"
    "-fno-validate-ide-info"
    "-fno-vectorisation-avoidance"
    "-fno-vectorise"
    "-fno-version-macros"
    "-fno-warn-"
    "-fno-warn-alternative-layout-rule-transitional"
    "-fno-warn-amp"
    "-fno-warn-auto-orphans"
    "-fno-warn-context-quantification"
    "-fno-warn-deprecated-flags"
    "-fno-warn-deprecations"
    "-fno-warn-deriving-typeable"
    "-fno-warn-dodgy-exports"
    "-fno-warn-dodgy-foreign-imports"
    "-fno-warn-dodgy-imports"
    "-fno-warn-duplicate-constraints"
    "-fno-warn-duplicate-exports"
    "-fno-warn-empty-enumerations"
    "-fno-warn-hi-shadowing"
    "-fno-warn-identities"
    "-fno-warn-implicit-prelude"
    "-fno-warn-incomplete-patterns"
    "-fno-warn-incomplete-record-updates"
    "-fno-warn-incomplete-uni-patterns"
    "-fno-warn-inline-rule-shadowing"
    "-fno-warn-missing-exported-sigs"
    "-fno-warn-missing-fields"
    "-fno-warn-missing-import-lists"
    "-fno-warn-missing-local-sigs"
    "-fno-warn-missing-methods"
    "-fno-warn-missing-signatures"
    "-fno-warn-monomorphism-restriction"
    "-fno-warn-name-shadowing"
    "-fno-warn-orphans"
    "-fno-warn-overflowed-literals"
    "-fno-warn-overlapping-patterns"
    "-fno-warn-partial-type-signatures"
    "-fno-warn-pointless-pragmas"
    "-fno-warn-safe"
    "-fno-warn-tabs"
    "-fno-warn-trustworthy-safe"
    "-fno-warn-type-defaults"
    "-fno-warn-typed-holes"
    "-fno-warn-unrecognised-pragmas"
    "-fno-warn-unsafe"
    "-fno-warn-unsupported-calling-conventions"
    "-fno-warn-unsupported-llvm-version"
    "-fno-warn-unticked-promoted-constructors"
    "-fno-warn-unused-binds"
    "-fno-warn-unused-do-bind"
    "-fno-warn-unused-imports"
    "-fno-warn-unused-matches"
    "-fno-warn-warnings-deprecations"
    "-fno-warn-wrong-do-bind"
    "-fno-whole-archive-hs-libs"
    "-fno-worker-wrapper"
    "-fno-write-ide-info"
    "-fno-write-interface"
    "-fnum-constant-folding"
    "-fobject-code"
    "-fomit-interface-pragmas"
    "-fomit-yields"
    "-foptimal-applicative-do"
    "-fpackage-trust"
    "-fparr"
    "-fpedantic-bottoms"
    "-fplugin"
    "-fplugin-opt"
    "-fplugin-trustworthy"
    "-fpre-inlining"
    "-fprint-axiom-incomps"
    "-fprint-equality-relations"
    "-fprint-expanded-synonyms"
    "-fprint-explicit-coercions"
    "-fprint-explicit-foralls"
    "-fprint-explicit-kinds"
    "-fprint-explicit-runtime-reps"
    "-fprint-potential-instances"
    "-fprint-typechecker-elaboration"
    "-fprint-unicode-syntax"
    "-fproc-alignment"
    "-fprof-auto"
    "-fprof-auto-calls"
    "-fprof-auto-exported"
    "-fprof-auto-top"
    "-fprof-cafs"
    "-fprof-callers"
    "-fprof-count-entries"
    "-framework"
    "-framework-path"
    "-freduction-depth"
    "-frefinement-level-hole-fits"
    "-fregs-graph"
    "-fregs-iterative"
    "-freverse-errors"
    "-frewrite-rules"
    "-frule-check"
    "-fscoped-type-variables"
    "-fshared-implib"
    "-fshow-docs-of-hole-fits"
    "-fshow-hole-constraints"
    "-fshow-hole-matches-of-hole-fits"
    "-fshow-loaded-modules"
    "-fshow-provenance-of-hole-fits"
    "-fshow-type-app-of-hole-fits"
    "-fshow-type-app-vars-of-hole-fits"
    "-fshow-type-of-hole-fits"
    "-fshow-valid-hole-fits"
    "-fshow-valid-substitutions"
    "-fshow-warning-groups"
    "-fsimpl-tick-factor"
    "-fsimple-list-literals"
    "-fsimplifier-phases"
    "-fsolve-constant-dicts"
    "-fsort-by-size-hole-fits"
    "-fsort-by-subsumption-hole-fits"
    "-fsort-valid-hole-fits"
    "-fspec-constr"
    "-fspec-constr-count"
    "-fspec-constr-keen"
    "-fspec-constr-recursive"
    "-fspec-constr-threshold"
    "-fspecialise"
    "-fspecialise-aggressively"
    "-fspecialize"
    "-fspecialize-aggressively"
    "-fstatic-argument-transformation"
    "-fstg-cse"
    "-fstg-lift-lams"
    "-fstg-lift-lams-known"
    "-fstg-lift-lams-non-rec-args"
    "-fstg-lift-lams-non-rec-args-any"
    "-fstg-lift-lams-rec-args"
    "-fstg-lift-lams-rec-args-any"
    "-fstrictness"
    "-fstrictness-before"
    "-fth"
    "-ftype-function-depth"
    "-funbox-small-strict-fields"
    "-funbox-strict-fields"
    "-funclutter-valid-hole-fits"
    "-funfolding-case-scaling"
    "-funfolding-case-threshold"
    "-funfolding-creation-threshold"
    "-funfolding-dict-discount"
    "-funfolding-fun-discount"
    "-funfolding-keeness-factor"
    "-funfolding-use-threshold"
    "-fuse-rpaths"
    "-fvalidate-ide-info"
    "-fvectorisation-avoidance"
    "-fvectorise"
    "-fversion-macros"
    "-fvia-C"
    "-fvia-c"
    "-fwarn-"
    "-fwarn-alternative-layout-rule-transitional"
    "-fwarn-amp"
    "-fwarn-auto-orphans"
    "-fwarn-context-quantification"
    "-fwarn-deprecated-flags"
    "-fwarn-deprecations"
    "-fwarn-deriving-typeable"
    "-fwarn-dodgy-exports"
    "-fwarn-dodgy-foreign-imports"
    "-fwarn-dodgy-imports"
    "-fwarn-duplicate-constraints"
    "-fwarn-duplicate-exports"
    "-fwarn-empty-enumerations"
    "-fwarn-hi-shadowing"
    "-fwarn-identities"
    "-fwarn-implicit-prelude"
    "-fwarn-incomplete-patterns"
    "-fwarn-incomplete-record-updates"
    "-fwarn-incomplete-uni-patterns"
    "-fwarn-inline-rule-shadowing"
    "-fwarn-missing-exported-sigs"
    "-fwarn-missing-fields"
    "-fwarn-missing-import-lists"
    "-fwarn-missing-local-sigs"
    "-fwarn-missing-methods"
    "-fwarn-missing-signatures"
    "-fwarn-monomorphism-restriction"
    "-fwarn-name-shadowing"
    "-fwarn-orphans"
    "-fwarn-overflowed-literals"
    "-fwarn-overlapping-patterns"
    "-fwarn-partial-type-signatures"
    "-fwarn-pointless-pragmas"
    "-fwarn-safe"
    "-fwarn-tabs"
    "-fwarn-trustworthy-safe"
    "-fwarn-type-defaults"
    "-fwarn-typed-holes"
    "-fwarn-unrecognised-pragmas"
    "-fwarn-unsafe"
    "-fwarn-unsupported-calling-conventions"
    "-fwarn-unsupported-llvm-version"
    "-fwarn-unticked-promoted-constructors"
    "-fwarn-unused-binds"
    "-fwarn-unused-do-bind"
    "-fwarn-unused-imports"
    "-fwarn-unused-matches"
    "-fwarn-warnings-deprecations"
    "-fwarn-wrong-do-bind"
    "-fwhole-archive-hs-libs"
    "-fworker-wrapper"
    "-fwrite-ide-info"
    "-fwrite-interface"
    "-g"
    "-ghcversion-file"
    "-global-package-db"
    "-gransim"
    "-haddock"
    "-haddock-opts"
    "-hcsuf"
    "-hide-all-packages"
    "-hide-all-plugin-packages"
    "-hide-package"
    "-hidir"
    "-hiedir"
    "-hiesuf"
    "-hisuf"
    "-hpcdir"
    "-i"
    "-ignore-package"
    "-include-cpp-deps"
    "-include-pkg-deps"
    "-instantiated-with"
    "-j"
    "-keep-hc-file"
    "-keep-hc-files"
    "-keep-hi-file"
    "-keep-hi-files"
    "-keep-hscpp-file"
    "-keep-hscpp-files"
    "-keep-llvm-file"
    "-keep-llvm-files"
    "-keep-o-file"
    "-keep-o-files"
    "-keep-s-file"
    "-keep-s-files"
    "-keep-tmp-files"
    "-l"
    "-main-is"
    "-mavx"
    "-mavx2"
    "-mavx512cd"
    "-mavx512er"
    "-mavx512f"
    "-mavx512pf"
    "-mbmi"
    "-mbmi2"
    "-msse"
    "-msse2"
    "-msse3"
    "-msse4"
    "-msse4.2"
    "-n"
    "-ndp"
    "-no-auto"
    "-no-auto-all"
    "-no-auto-link-packages"
    "-no-caf-all"
    "-no-global-package-db"
    "-no-haddock"
    "-no-hs-main"
    "-no-keep-hi-file"
    "-no-keep-hi-files"
    "-no-keep-o-file"
    "-no-keep-o-files"
    "-no-link"
    "-no-pie"
    "-no-recomp"
    "-no-rtsopts"
    "-no-rtsopts-suggestions"
    "-no-user-package-conf"
    "-no-user-package-db"
    "-o"
    "-odir"
    "-ohi"
    "-optF"
    "-optL"
    "-optP"
    "-opta"
    "-optc"
    "-optcxx"
    "-opti"
    "-optl"
    "-optlc"
    "-optlm"
    "-optlo"
    "-optwindres"
    "-osuf"
    "-outputdir"
    "-package"
    "-package-conf"
    "-package-db"
    "-package-env"
    "-package-id"
    "-package-key"
    "-package-name"
    "-parallel"
    "-pgmF"
    "-pgmL"
    "-pgmP"
    "-pgma"
    "-pgmar"
    "-pgmc"
    "-pgmc-supports-no-pie"
    "-pgmdll"
    "-pgmi"
    "-pgminstall_name_tool"
    "-pgml"
    "-pgmlc"
    "-pgmlibtool"
    "-pgmlm"
    "-pgmlo"
    "-pgmotool"
    "-pgmranlib"
    "-pgms"
    "-pgmwindres"
    "-pie"
    "-plugin-package"
    "-plugin-package-id"
    "-prof"
    "-rdynamic"
    "-recomp"
    "-relative-dynlib-paths"
    "-rtsopts"
    "-rtsopts=all"
    "-rtsopts=ignore"
    "-rtsopts=ignoreAll"
    "-rtsopts=none"
    "-rtsopts=some"
    "-shared"
    "-sig-of"
    "-smp"
    "-split-objs"
    "-split-sections"
    "-static"
    "-staticlib"
    "-stubdir"
    "-syslib"
    "-this-component-id"
    "-this-package-key"
    "-this-unit-id"
    "-threaded"
    "-ticky"
    "-ticky-LNE"
    "-ticky-allocd"
    "-ticky-dyn-thunk"
    "-tmpdir"
    "-trust"
    "-user-package-db"
    "-v"
    "-w"
    "-with-rtsopts"
    ;;; END haskell-ghc-supported-options
    )
  "List of options supported by any known version of GHC.

This list should be updated by running `haskell-update-ghc-support'.")


(defun haskell-update-ghc-support (ghc-path)
  "Update `haskell-ghc-supported-options' and `haskell-ghc-supported-extensions'.

This command should be run once a GHC is released. It will use
--show-options and --supported-extensions to source the
information from GHC-PATH. Then it will update source code to
include newly found options. Old options are never removed and
are retained to support old versions of the compiler.

Options and extension are kept in ascending order."
  (interactive
   (list
    (read-shell-command "GHC command: " nil nil
                        (let ((filename
                               (cond
                                (buffer-file-name)
                                ((eq major-mode 'dired-mode)
                                 (when (fboundp 'dired-get-filename)
                                   ;; silence the checker
                                   (dired-get-filename nil t))))))
                          (and filename (file-relative-name filename))))))


  (let ((extentions (split-string (shell-command-to-string (concat ghc-path " --supported-extensions"))))
        (options (split-string (shell-command-to-string (concat ghc-path " --show-options")))))
    (with-current-buffer
        (find-file-noselect (replace-regexp-in-string "\\.elc$" ".el" (symbol-file 'haskell-ghc-supported-options)))
      (save-excursion
        (goto-char (point-min))
        (re-search-forward "BEGIN haskell-ghc-supported-extensions")
        (forward-line 1)
        (let ((point (point)))
          (re-search-forward "END haskell-ghc-supported-extensions")
          (goto-char (line-beginning-position))
          (delete-region point (point)))
        (setq haskell-ghc-supported-extensions
              (delete-dups (sort (append extentions haskell-ghc-supported-extensions) #'string<)))
        (dolist (item haskell-ghc-supported-extensions)
          (insert "    \"" item "\"\n"))
        (re-search-forward "BEGIN haskell-ghc-supported-options")
        (forward-line 1)
        (let ((point (point)))
          (re-search-forward "END haskell-ghc-supported-options")
          (goto-char (line-beginning-position))
          (delete-region point (point)))
        (setq haskell-ghc-supported-options
              (delete-dups (sort (append options haskell-ghc-supported-options) #'string<)))
        (dolist (item haskell-ghc-supported-options)
          (insert "    \"" item "\"\n"))))))

(provide 'haskell-ghc-support)
