/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import java.util.ArrayList;
import java.util.List;
import tim.prune.cmd.AppendRangeCmd;
import tim.prune.cmd.Command;
import tim.prune.cmd.CompoundCommand;
import tim.prune.cmd.DeleteFinalRangeCmd;
import tim.prune.cmd.PointFlag;
import tim.prune.cmd.RearrangePointsCmd;
import tim.prune.cmd.SetSegmentsCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;

public class SewSegmentsCmd
extends CompoundCommand {
    private final List<Integer> _indexesToDelete;

    public SewSegmentsCmd(List<Integer> list, List<Integer> list2, List<PointFlag> list3) {
        this._indexesToDelete = list2;
        this.addCommand(new RearrangePointsCmd(this.combine(list, list2)));
        this.addCommand(new DeleteFinalRangeCmd(list2.size()));
        this.addCommand(new SetSegmentsCmd(list3));
    }

    private List<Integer> combine(List<Integer> list, List<Integer> list2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    public int getNumJoins() {
        return this._indexesToDelete.size();
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        return this.makeInverse(trackInfo, null, new AppendRangeCmd(this.getCommand(1), this.getDeletedPoints(trackInfo.getTrack())), null);
    }

    private List<DataPoint> getDeletedPoints(Track track) {
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        for (int n : this._indexesToDelete) {
            arrayList.add(track.getPoint(n));
        }
        return arrayList;
    }
}

