/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class WizardLayout
extends CardLayout {
    private final JPanel _panel;
    private int _currentCard = 0;
    private int _numCards = 0;

    public WizardLayout(JPanel jPanel) {
        this._panel = jPanel;
        this._panel.setLayout(this);
    }

    public void addCard(Component component) {
        this._panel.add(component, "card" + this._numCards);
        ++this._numCards;
    }

    public int getCurrentCardIndex() {
        return this._currentCard;
    }

    public void showFirstCard() {
        this.first(this._panel);
        this._currentCard = 0;
    }

    public void showNextCard() {
        if (this._currentCard < this._numCards - 1) {
            this.next(this._panel);
            ++this._currentCard;
        }
    }

    public void showPreviousCard() {
        if (this._currentCard > 0) {
            this.previous(this._panel);
            --this._currentCard;
        }
    }

    public boolean isFirstCard() {
        return this._currentCard == 0;
    }

    public boolean isLastCard() {
        return this._currentCard == this._numCards - 1;
    }

    public void showCard(int n) {
        if (n >= 0 && n < this._numCards) {
            this.show(this._panel, "card" + n);
            this._currentCard = n;
        }
    }
}

