info = {
    "name": "pt",
    "date_order": "DMY",
    "january": [
        "jan",
        "janeiro"
    ],
    "february": [
        "fev",
        "fevereiro"
    ],
    "march": [
        "mar",
        "março"
    ],
    "april": [
        "abr",
        "abril"
    ],
    "may": [
        "mai",
        "maio"
    ],
    "june": [
        "jun",
        "junho"
    ],
    "july": [
        "jul",
        "julho"
    ],
    "august": [
        "ago",
        "agosto"
    ],
    "september": [
        "set",
        "setembro",
        "Septembro"
    ],
    "october": [
        "out",
        "outubro"
    ],
    "november": [
        "nov",
        "novembro"
    ],
    "december": [
        "dez",
        "dezembro"
    ],
    "monday": [
        "seg",
        "segunda-feira",
        "Segunda"
    ],
    "tuesday": [
        "ter",
        "terça-feira",
        "Terça"
    ],
    "wednesday": [
        "qua",
        "quarta-feira",
        "Quarta"
    ],
    "thursday": [
        "qui",
        "quinta-feira",
        "Quinta"
    ],
    "friday": [
        "sex",
        "sexta-feira",
        "Sexta"
    ],
    "saturday": [
        "sáb",
        "sábado",
        "Sab"
    ],
    "sunday": [
        "dom",
        "domingo"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "ano",
        "anos"
    ],
    "month": [
        "mês",
        "meses"
    ],
    "week": [
        "sem",
        "semana",
        "semanas"
    ],
    "day": [
        "dia",
        "dias"
    ],
    "hour": [
        "h",
        "hora",
        "horas"
    ],
    "minute": [
        "m",
        "min",
        "minuto",
        "minutos"
    ],
    "second": [
        "s",
        "seg",
        "segundo",
        "segundos"
    ],
    "relative-type": {
        "0 day ago": [
            "hoje"
        ],
        "0 hour ago": [
            "esta hora"
        ],
        "0 minute ago": [
            "este minuto"
        ],
        "0 month ago": [
            "este mês"
        ],
        "0 second ago": [
            "agora"
        ],
        "0 week ago": [
            "esta semana"
        ],
        "0 year ago": [
            "este ano"
        ],
        "1 day ago": [
            "ontem"
        ],
        "1 month ago": [
            "mês passado"
        ],
        "1 week ago": [
            "semana passada"
        ],
        "1 year ago": [
            "ano passado"
        ],
        "in 1 day": [
            "amanhã"
        ],
        "in 1 month": [
            "próximo mês"
        ],
        "in 1 week": [
            "próxima semana"
        ],
        "in 1 year": [
            "próximo ano"
        ],
        "2 day ago": [
            "anteontem"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "há (\\d+) dia",
            "há (\\d+) dias"
        ],
        "\\1 hour ago": [
            "há (\\d+) h",
            "há (\\d+) hora",
            "há (\\d+) horas"
        ],
        "\\1 minute ago": [
            "há (\\d+) min",
            "há (\\d+) mins",
            "há (\\d+) minuto",
            "há (\\d+) minutos"
        ],
        "\\1 month ago": [
            "há (\\d+) meses",
            "há (\\d+) mês"
        ],
        "\\1 second ago": [
            "há (\\d+) seg",
            "há (\\d+) segundo",
            "há (\\d+) segundos"
        ],
        "\\1 week ago": [
            "há (\\d+) sem",
            "há (\\d+) semana",
            "há (\\d+) semanas"
        ],
        "\\1 year ago": [
            "há (\\d+) ano",
            "há (\\d+) anos"
        ],
        "in \\1 day": [
            "em (\\d+) dia",
            "em (\\d+) dias"
        ],
        "in \\1 hour": [
            "em (\\d+) h",
            "em (\\d+) hora",
            "em (\\d+) horas"
        ],
        "in \\1 minute": [
            "em (\\d+) min",
            "em (\\d+) mins",
            "em (\\d+) minuto",
            "em (\\d+) minutos"
        ],
        "in \\1 month": [
            "em (\\d+) meses",
            "em (\\d+) mês"
        ],
        "in \\1 second": [
            "em (\\d+) seg",
            "em (\\d+) segs",
            "em (\\d+) segundo",
            "em (\\d+) segundos"
        ],
        "in \\1 week": [
            "em (\\d+) sem",
            "em (\\d+) semana",
            "em (\\d+) semanas"
        ],
        "in \\1 year": [
            "em (\\d+) ano",
            "em (\\d+) anos"
        ]
    },
    "locale_specific": {
        "pt-AO": {
            "name": "pt-AO",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "da manhã",
                "manhã"
            ],
            "pm": [
                "da tarde",
                "tarde"
            ],
            "relative-type-regex": {
                "\\1 second ago": [
                    "há (\\d+) s"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dia",
                    "dentro de (\\d+) dias"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) s",
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ]
            }
        },
        "pt-CH": {
            "name": "pt-CH",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "da manhã",
                "manhã"
            ],
            "pm": [
                "da tarde",
                "tarde"
            ],
            "relative-type-regex": {
                "\\1 second ago": [
                    "há (\\d+) s"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dia",
                    "dentro de (\\d+) dias"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) s",
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ]
            }
        },
        "pt-CV": {
            "name": "pt-CV",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "da manhã",
                "manhã"
            ],
            "pm": [
                "da tarde",
                "tarde"
            ],
            "relative-type-regex": {
                "\\1 second ago": [
                    "há (\\d+) s"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dia",
                    "dentro de (\\d+) dias"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) s",
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ]
            }
        },
        "pt-GQ": {
            "name": "pt-GQ",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "da manhã",
                "manhã"
            ],
            "pm": [
                "da tarde",
                "tarde"
            ],
            "relative-type-regex": {
                "\\1 second ago": [
                    "há (\\d+) s"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dia",
                    "dentro de (\\d+) dias"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) s",
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ]
            }
        },
        "pt-GW": {
            "name": "pt-GW",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "da manhã",
                "manhã"
            ],
            "pm": [
                "da tarde",
                "tarde"
            ],
            "relative-type-regex": {
                "\\1 second ago": [
                    "há (\\d+) s"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dia",
                    "dentro de (\\d+) dias"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) s",
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ]
            }
        },
        "pt-LU": {
            "name": "pt-LU",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "da manhã",
                "manhã"
            ],
            "pm": [
                "da tarde",
                "tarde"
            ],
            "relative-type-regex": {
                "\\1 second ago": [
                    "há (\\d+) s"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dia",
                    "dentro de (\\d+) dias"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) s",
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ]
            }
        },
        "pt-MO": {
            "name": "pt-MO",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "da manhã",
                "manhã"
            ],
            "pm": [
                "da tarde",
                "tarde"
            ],
            "relative-type-regex": {
                "\\1 second ago": [
                    "há (\\d+) s"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dia",
                    "dentro de (\\d+) dias"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) s",
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ]
            }
        },
        "pt-MZ": {
            "name": "pt-MZ",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "da manhã",
                "manhã"
            ],
            "pm": [
                "da tarde",
                "tarde"
            ],
            "relative-type-regex": {
                "\\1 second ago": [
                    "há (\\d+) s"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dia",
                    "dentro de (\\d+) dias"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) s",
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ]
            }
        },
        "pt-PT": {
            "name": "pt-PT",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "da manhã",
                "manhã"
            ],
            "pm": [
                "da tarde",
                "tarde"
            ],
            "relative-type-regex": {
                "\\1 second ago": [
                    "há (\\d+) s"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dia",
                    "dentro de (\\d+) dias"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) s",
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ]
            }
        },
        "pt-ST": {
            "name": "pt-ST",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "da manhã",
                "manhã"
            ],
            "pm": [
                "da tarde",
                "tarde"
            ],
            "relative-type-regex": {
                "\\1 second ago": [
                    "há (\\d+) s"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dia",
                    "dentro de (\\d+) dias"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) s",
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ]
            }
        },
        "pt-TL": {
            "name": "pt-TL",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "da manhã",
                "manhã"
            ],
            "pm": [
                "da tarde",
                "tarde"
            ],
            "relative-type-regex": {
                "\\1 second ago": [
                    "há (\\d+) s"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dia",
                    "dentro de (\\d+) dias"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) s",
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ]
            }
        }
    },
    "skip": [
        "cerca",
        "de",
        "e",
        "às",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "pertain": [
        "de"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "atrás",
        "há"
    ],
    "in": [
        "em"
    ],
    "simplifications": [
        {
            "uma": "1"
        },
        {
            "um": "1"
        },
        {
            "alguns segundos": "44 segundos"
        }
    ]
}
