/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;

public class HashUtil {
    public static String getDigest(InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        return HashUtil.getDigest(null, inputStream);
    }

    public static String getDigest(String salt, InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        int numBytes;
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.reset();
        if (salt != null) {
            messageDigest.update(salt.getBytes(StandardCharsets.UTF_8));
        }
        byte[] bytes = new byte[1024];
        while ((numBytes = inputStream.read(bytes)) != -1) {
            messageDigest.update(bytes, 0, numBytes);
        }
        byte[] digest = messageDigest.digest();
        return new String(Hex.encodeHex((byte[])digest));
    }
}

