/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import javax.servlet.SessionCookieConfig;
import javax.servlet.http.Cookie;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.SessionConfig;
import org.apache.tomcat.util.res.StringManager;

public class ApplicationSessionCookieConfig
implements SessionCookieConfig {
    private static final StringManager sm = StringManager.getManager(ApplicationSessionCookieConfig.class);
    private boolean httpOnly;
    private boolean secure;
    private int maxAge = -1;
    private String comment;
    private String domain;
    private String name;
    private String path;
    private StandardContext context;

    public ApplicationSessionCookieConfig(StandardContext standardContext) {
        this.context = standardContext;
    }

    public String getComment() {
        return this.comment;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setComment(String string) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"comment", this.context.getPath()}));
        }
        this.comment = string;
    }

    public void setDomain(String string) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"domain name", this.context.getPath()}));
        }
        this.domain = string;
    }

    public void setHttpOnly(boolean bl) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"HttpOnly", this.context.getPath()}));
        }
        this.httpOnly = bl;
    }

    public void setMaxAge(int n) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"max age", this.context.getPath()}));
        }
        this.maxAge = n;
    }

    public void setName(String string) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"name", this.context.getPath()}));
        }
        this.name = string;
    }

    public void setPath(String string) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"path", this.context.getPath()}));
        }
        this.path = string;
    }

    public void setSecure(boolean bl) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"secure", this.context.getPath()}));
        }
        this.secure = bl;
    }

    public static Cookie createSessionCookie(Context context, String string, boolean bl) {
        SessionCookieConfig sessionCookieConfig = context.getServletContext().getSessionCookieConfig();
        Cookie cookie = new Cookie(SessionConfig.getSessionCookieName(context), string);
        cookie.setMaxAge(sessionCookieConfig.getMaxAge());
        cookie.setComment(sessionCookieConfig.getComment());
        if (context.getSessionCookieDomain() == null) {
            if (sessionCookieConfig.getDomain() != null) {
                cookie.setDomain(sessionCookieConfig.getDomain());
            }
        } else {
            cookie.setDomain(context.getSessionCookieDomain());
        }
        if (sessionCookieConfig.isSecure() || bl) {
            cookie.setSecure(true);
        }
        if (sessionCookieConfig.isHttpOnly() || context.getUseHttpOnly()) {
            cookie.setHttpOnly(true);
        }
        cookie.setPath(SessionConfig.getSessionCookiePath(context));
        return cookie;
    }
}

