[![SFML logo](https://www.sfml-dev.org/images/logo.png)](https://www.sfml-dev.org)

# CSFML - Simple and Fast Multimedia Library for C

SFML is a simple, fast, cross-platform and object-oriented multimedia API. It provides access to windowing, graphics, audio and network. It is originally written in C++, and this project is its official binding for the C language.

## Authors

  - Laurent Gomila - main developer (laurent@sfml-dev.org)
  - Lukas Dürrenberger - active maintainer (eXpl0it3r@sfml-dev.org)
  - Zachariah Brown (contact@zbrown.net)

## Download

You can get the latest official release on [SFML website](https://www.sfml-dev.org/download/csfml). You can also get the current development version from the [Git repository](https://github.com/SFML/CSFML).

## Learn

There is no tutorial for CSFML, but since it's a binding you can use the C++ resources:

  * The [official tutorials](https://www.sfml-dev.org/tutorials/)
  * The [online API documentation](https://www.sfml-dev.org/documentation/)
  * The [community wiki](https://github.com/SFML/SFML/wiki/)
  * The [community forum](https://en.sfml-dev.org/forums/) (or [French](https://fr.sfml-dev.org/forums/))

Of course, you can also find the CSFML API documentation in the SDK.

## Building

Set `SFML_DIR` to a directory containing the `SFMLConfig.cmake` file, usually located at `lib/cmake/SFML`.

## Contribute

SFML and CSFML are open-source projects, and they need your help to go on growing and improving. Don't hesitate to post suggestions or bug reports on [the forum](https://en.sfml-dev.org/forums/), or post new bugs/features requests on the [issue tracker](https://github.com/SFML/CSFML/issues/). You can even fork the project on GitHub, maintain your own version and send us pull requests periodically to merge your work.
