"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityPlugin = void 0;

var _opensearch_observability_plugin = require("./adaptors/opensearch_observability_plugin");

var _ppl_plugin = require("./adaptors/ppl_plugin");

var _index = require("./routes/index");

var _observability_saved_object = require("./saved_objects/observability_saved_object");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ObservabilityPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);

    this.logger = initializerContext.logger.get();
  }

  setup(core) {
    this.logger.debug('Observability: Setup');
    const router = core.http.createRouter();
    const openSearchObservabilityClient = core.opensearch.legacy.createClient('opensearch_observability', {
      plugins: [_ppl_plugin.PPLPlugin, _opensearch_observability_plugin.OpenSearchObservabilityPlugin]
    }); // @ts-ignore

    core.http.registerRouteHandlerContext('observability_plugin', (context, request) => {
      return {
        logger: this.logger,
        observabilityClient: openSearchObservabilityClient
      };
    });
    const obsPanelType = {
      name: 'observability-panel',
      hidden: false,
      namespaceType: 'single',
      mappings: {
        dynamic: false,
        properties: {
          title: {
            type: 'text'
          },
          description: {
            type: 'text'
          }
        }
      },
      management: {
        importableAndExportable: true,

        getInAppUrl() {
          return {
            path: `/app/management/observability/settings`,
            uiCapabilitiesPath: 'advancedSettings.show'
          };
        },

        getTitle(obj) {
          return `Observability Settings [${obj.id}]`;
        }

      },
      migrations: {
        '3.0.0': doc => ({ ...doc,
          description: ''
        }),
        '3.0.1': doc => ({ ...doc,
          description: 'Some Description Text'
        }),
        '3.0.2': doc => ({ ...doc,
          dateCreated: parseInt(doc.dateCreated || '0', 10)
        })
      }
    };
    core.savedObjects.registerType(obsPanelType); // Register server side APIs

    (0, _index.setupRoutes)({
      router,
      client: openSearchObservabilityClient
    });
    core.savedObjects.registerType(_observability_saved_object.visualizationSavedObject);
    core.capabilities.registerProvider(() => ({
      observability: {
        show: true
      }
    }));
    return {};
  }

  start(core) {
    this.logger.debug('Observability: Started');
    return {};
  }

  stop() {}

}

exports.ObservabilityPlugin = ObservabilityPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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