/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.executor.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.statement.Explain;
import org.opensearch.sql.ast.statement.Query;
import org.opensearch.sql.ast.statement.Statement;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.executor.QueryId;
import org.opensearch.sql.executor.QueryService;
import org.opensearch.sql.executor.execution.AbstractPlan;
import org.opensearch.sql.executor.execution.ExplainPlan;
import org.opensearch.sql.executor.execution.QueryPlan;

public class QueryPlanFactory
extends AbstractNodeVisitor<AbstractPlan, Pair<Optional<ResponseListener<ExecutionEngine.QueryResponse>>, Optional<ResponseListener<ExecutionEngine.ExplainResponse>>>> {
    private final QueryService queryService;
    @VisibleForTesting
    protected static final ResponseListener<ExecutionEngine.QueryResponse> NO_CONSUMER_RESPONSE_LISTENER = new ResponseListener<ExecutionEngine.QueryResponse>(){

        public void onResponse(ExecutionEngine.QueryResponse response) {
            throw new IllegalStateException("[BUG] query response should not sent to unexpected channel");
        }

        public void onFailure(Exception e) {
            throw new IllegalStateException("[BUG] exception response should not sent to unexpected channel");
        }
    };

    public AbstractPlan create(Statement statement, Optional<ResponseListener<ExecutionEngine.QueryResponse>> queryListener, Optional<ResponseListener<ExecutionEngine.ExplainResponse>> explainListener) {
        return statement.accept(this, Pair.of(queryListener, explainListener));
    }

    @Override
    public AbstractPlan visitQuery(Query node, Pair<Optional<ResponseListener<ExecutionEngine.QueryResponse>>, Optional<ResponseListener<ExecutionEngine.ExplainResponse>>> context) {
        Preconditions.checkArgument((boolean)((Optional)context.getLeft()).isPresent(), (Object)"[BUG] query listener must be not null");
        return new QueryPlan(QueryId.queryId(), node.getPlan(), this.queryService, (ResponseListener<ExecutionEngine.QueryResponse>)((ResponseListener)((Optional)context.getLeft()).get()));
    }

    @Override
    public AbstractPlan visitExplain(Explain node, Pair<Optional<ResponseListener<ExecutionEngine.QueryResponse>>, Optional<ResponseListener<ExecutionEngine.ExplainResponse>>> context) {
        Preconditions.checkArgument((boolean)((Optional)context.getRight()).isPresent(), (Object)"[BUG] explain listener must be not null");
        return new ExplainPlan(QueryId.queryId(), this.create(node.getStatement(), Optional.of(NO_CONSUMER_RESPONSE_LISTENER), Optional.empty()), (ResponseListener<ExecutionEngine.ExplainResponse>)((ResponseListener)((Optional)context.getRight()).get()));
    }

    @Generated
    public QueryPlanFactory(QueryService queryService) {
        this.queryService = queryService;
    }
}

