/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.common.grok;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.sql.common.grok.Converter;
import org.opensearch.sql.common.grok.GrokUtils;
import org.opensearch.sql.common.grok.Match;

public class Grok
implements Serializable {
    private final String namedRegex;
    private final Map<String, String> namedRegexCollection;
    private final String originalGrokPattern;
    private final Pattern compiledNamedRegex;
    private final Map<String, String> grokPatternDefinition;
    public final Set<String> namedGroups;
    public final Map<String, Converter.Type> groupTypes;
    public final Map<String, Converter.IConverter<? extends Object>> converters;
    private String savedPattern = "";

    public Grok(String pattern, String namedRegex, Map<String, String> namedRegexCollection, Map<String, String> patternDefinitions, ZoneId defaultTimeZone) {
        this.originalGrokPattern = pattern;
        this.namedRegex = namedRegex;
        this.compiledNamedRegex = Pattern.compile(namedRegex);
        this.namedRegexCollection = namedRegexCollection;
        this.namedGroups = GrokUtils.getNameGroups(namedRegex);
        this.groupTypes = Converter.getGroupTypes(namedRegexCollection.values());
        this.converters = Converter.getConverters(namedRegexCollection.values(), defaultTimeZone);
        this.grokPatternDefinition = patternDefinitions;
    }

    public String getSaved_pattern() {
        return this.savedPattern;
    }

    public void setSaved_pattern(String savedpattern) {
        this.savedPattern = savedpattern;
    }

    public Map<String, String> getPatterns() {
        return this.grokPatternDefinition;
    }

    public String getNamedRegex() {
        return this.namedRegex;
    }

    public String getOriginalGrokPattern() {
        return this.originalGrokPattern;
    }

    public String getNamedRegexCollectionById(String id) {
        return this.namedRegexCollection.get(id);
    }

    public Map<String, String> getNamedRegexCollection() {
        return this.namedRegexCollection;
    }

    public Map<String, Object> capture(String log) {
        Match match = this.match(log);
        return match.capture();
    }

    public ArrayList<Map<String, Object>> capture(List<String> logs) {
        ArrayList<Map<String, Object>> matched = new ArrayList<Map<String, Object>>();
        for (String log : logs) {
            matched.add(this.capture(log));
        }
        return matched;
    }

    public Match match(CharSequence text) {
        if (this.compiledNamedRegex == null || text == null) {
            return Match.EMPTY;
        }
        Matcher matcher = this.compiledNamedRegex.matcher(text);
        if (matcher.find()) {
            return new Match(text, this, matcher, matcher.start(0), matcher.end(0));
        }
        return Match.EMPTY;
    }
}

