/*
 * Decompiled with CFR 0.152.
 */
package org.protege.xmlcatalog.entry;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import org.protege.xmlcatalog.CatalogUtilities;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.XmlBaseContext;
import org.protege.xmlcatalog.entry.Entry;

public abstract class AbstractDelegateEntry
extends Entry
implements XmlBaseContext {
    private URI catalog;
    private XMLCatalog delegate;
    private URI xmlbase;

    public AbstractDelegateEntry(String id, XmlBaseContext xmlBaseContext, URI catalog, URI xmlbase) {
        super(id, xmlBaseContext);
        this.catalog = catalog;
        this.xmlbase = xmlbase;
    }

    public URI getCatalog() {
        return this.catalog;
    }

    public void setCatalog(URI catalog) {
        this.catalog = catalog;
    }

    public XMLCatalog getParsedCatalog() throws IOException {
        if (this.delegate == null) {
            try {
                URI base = CatalogUtilities.resolveXmlBase(this);
                URI doc = base.resolve(this.catalog);
                this.delegate = CatalogUtilities.parseDocument(doc.toURL());
            }
            catch (MalformedURLException mue) {
                IOException ioe = new IOException(mue.getMessage());
                ioe.initCause(mue);
                throw ioe;
            }
        }
        return this.delegate;
    }

    @Override
    public URI getXmlBase() {
        return this.xmlbase;
    }

    @Override
    public void setXmlBase(URI xmlbase) {
        this.xmlbase = xmlbase;
    }

    public String toString() {
        return "--> Delegate Catalog(@" + this.delegate.getXmlBase() + ")";
    }
}

