import threading
from typing import Any, ClassVar, overload

from typing_extensions import Literal  # Py38+: Available in ``typing``

from pykka import Actor, ActorRef, Future

class ActorRegistry:
    _actor_refs: ClassVar[list[ActorRef]]
    _actor_refs_lock: ClassVar[threading.RLock]
    @classmethod
    def broadcast(
        cls, message: Any, target_class: type[Actor] | None = ...
    ) -> None: ...
    @classmethod
    def get_all(cls) -> list[ActorRef]: ...
    @classmethod
    def get_by_class(cls, actor_class: type[Actor]) -> list[ActorRef]: ...
    @classmethod
    def get_by_class_name(cls, actor_class_name: str) -> list[ActorRef]: ...
    @classmethod
    def get_by_urn(cls, actor_urn: str) -> ActorRef | None: ...
    @classmethod
    def register(cls, actor_ref: ActorRef) -> None: ...
    @overload
    @classmethod
    def stop_all(
        cls, block: Literal[True], timeout: float | None = ...
    ) -> list[bool]: ...
    @overload  # noqa: Allow redefinition
    @classmethod
    def stop_all(
        cls, block: Literal[False], timeout: float | None = ...
    ) -> list[Future[bool]]: ...
    @overload  # noqa: Allow redefinition
    @classmethod
    def stop_all(
        cls, block: bool = ..., timeout: float | None = ...
    ) -> list[bool] | list[Future[bool]] | list[bool | Future[bool]]: ...
    @classmethod
    def unregister(cls, actor_ref: ActorRef) -> None: ...
