/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.JAASCallbackHandler;
import org.apache.catalina.realm.RealmBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;

public class JAASRealm
extends RealmBase {
    private static final Log log = LogFactory.getLog(JAASRealm.class);
    protected String appName = null;
    @Deprecated
    protected static final String name = "JAASRealm";
    protected final List<String> roleClasses = new ArrayList<String>();
    protected final List<String> userClasses = new ArrayList<String>();
    protected boolean useContextClassLoader = true;
    protected String configFile;
    protected volatile Configuration jaasConfiguration;
    protected volatile boolean jaasConfigurationLoaded = false;
    private volatile boolean invocationSuccess = true;
    protected String roleClassNames = null;
    protected String userClassNames = null;

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String string) {
        this.configFile = string;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setUseContextClassLoader(boolean bl) {
        this.useContextClassLoader = bl;
    }

    public boolean isUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        if (this.appName == null) {
            this.appName = this.makeLegalForJAAS(container.getName());
            log.info((Object)("Set JAAS app name " + this.appName));
        }
    }

    public String getRoleClassNames() {
        return this.roleClassNames;
    }

    public void setRoleClassNames(String string) {
        this.roleClassNames = string;
    }

    protected void parseClassNames(String string, List<String> list) {
        String[] stringArray;
        list.clear();
        if (string == null) {
            return;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (this.isUseContextClassLoader()) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        for (String string2 : stringArray = string.split("[ ]*,[ ]*")) {
            if (string2.length() == 0) continue;
            try {
                Class<?> clazz = Class.forName(string2, false, classLoader);
                if (Principal.class.isAssignableFrom(clazz)) {
                    list.add(string2);
                    continue;
                }
                log.error((Object)("Class " + string2 + " is not implementing java.security.Principal! Class not added."));
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error((Object)("Class " + string2 + " not found! Class not added."));
            }
        }
    }

    public String getUserClassNames() {
        return this.userClassNames;
    }

    public void setUserClassNames(String string) {
        this.userClassNames = string;
    }

    @Override
    public Principal authenticate(String string, String string2) {
        return this.authenticate(string, new JAASCallbackHandler(this, string, string2));
    }

    @Override
    public Principal authenticate(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        return this.authenticate(string, new JAASCallbackHandler(this, string, string2, string3, string4, string5, string6, string7, string8, string9, "DIGEST"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Principal authenticate(String string, CallbackHandler callbackHandler) {
        try {
            Principal principal;
            Object object;
            LoginContext loginContext = null;
            if (this.appName == null) {
                this.appName = "Tomcat";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("jaasRealm.beginLogin", new Object[]{string, this.appName}));
            }
            ClassLoader classLoader = null;
            Thread thread = null;
            if (!this.isUseContextClassLoader()) {
                thread = Thread.currentThread();
                classLoader = thread.getContextClassLoader();
                thread.setContextClassLoader(this.getClass().getClassLoader());
            }
            try {
                object = this.getConfig();
                loginContext = new LoginContext(this.appName, null, callbackHandler, (Configuration)object);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)sm.getString("jaasRealm.unexpectedError"), throwable);
                this.invocationSuccess = false;
                Principal principal2 = null;
                return principal2;
            }
            finally {
                if (thread != null) {
                    thread.setContextClassLoader(classLoader);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Login context created " + string));
            }
            object = null;
            try {
                loginContext.login();
                object = loginContext.getSubject();
                this.invocationSuccess = true;
                if (object == null) {
                    if (!log.isDebugEnabled()) return null;
                    log.debug((Object)sm.getString("jaasRealm.failedLogin", new Object[]{string}));
                    return null;
                }
            }
            catch (AccountExpiredException accountExpiredException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("jaasRealm.accountExpired", new Object[]{string}));
                }
                this.invocationSuccess = true;
                return null;
            }
            catch (CredentialExpiredException credentialExpiredException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("jaasRealm.credentialExpired", new Object[]{string}));
                }
                this.invocationSuccess = true;
                return null;
            }
            catch (FailedLoginException failedLoginException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("jaasRealm.failedLogin", new Object[]{string}));
                }
                this.invocationSuccess = true;
                return null;
            }
            catch (LoginException loginException) {
                log.warn((Object)sm.getString("jaasRealm.loginException", new Object[]{string}), (Throwable)loginException);
                this.invocationSuccess = true;
                return null;
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)sm.getString("jaasRealm.unexpectedError"), throwable);
                this.invocationSuccess = false;
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("jaasRealm.loginContextCreated", new Object[]{string}));
            }
            if ((principal = this.createPrincipal(string, (Subject)object, loginContext)) == null) {
                log.debug((Object)sm.getString("jaasRealm.authenticateFailure", new Object[]{string}));
                return null;
            }
            if (!log.isDebugEnabled()) return principal;
            log.debug((Object)sm.getString("jaasRealm.authenticateSuccess", new Object[]{string}));
            return principal;
        }
        catch (Throwable throwable) {
            log.error((Object)"error ", throwable);
            this.invocationSuccess = false;
            return null;
        }
    }

    @Override
    @Deprecated
    protected String getName() {
        return name;
    }

    @Override
    protected String getPassword(String string) {
        return null;
    }

    @Override
    protected Principal getPrincipal(String string) {
        return this.authenticate(string, new JAASCallbackHandler(this, string, null, null, null, null, null, null, null, null, "CLIENT_CERT"));
    }

    protected Principal createPrincipal(String string, Subject subject, LoginContext loginContext) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Principal principal = null;
        for (Principal principal2 : subject.getPrincipals()) {
            String string2 = principal2.getClass().getName();
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("jaasRealm.checkPrincipal", new Object[]{principal2, string2}));
            }
            if (principal == null && this.userClasses.contains(string2)) {
                principal = principal2;
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("jaasRealm.userPrincipalSuccess", new Object[]{principal2.getName()}));
                }
            }
            if (!this.roleClasses.contains(string2)) continue;
            arrayList.add(principal2.getName());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)sm.getString("jaasRealm.rolePrincipalAdd", new Object[]{principal2.getName()}));
        }
        if (principal == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("jaasRealm.userPrincipalFailure"));
                log.debug((Object)sm.getString("jaasRealm.rolePrincipalFailure"));
            }
            return null;
        }
        if (arrayList.size() == 0 && log.isDebugEnabled()) {
            log.debug((Object)sm.getString("jaasRealm.rolePrincipalFailure"));
        }
        return new GenericPrincipal(string, null, arrayList, principal, loginContext);
    }

    protected String makeLegalForJAAS(String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = "other";
        }
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.parseClassNames(this.userClassNames, this.userClasses);
        this.parseClassNames(this.roleClassNames, this.roleClasses);
        super.startInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Configuration getConfig() {
        String string = this.configFile;
        try {
            if (this.jaasConfigurationLoaded) {
                return this.jaasConfiguration;
            }
            JAASRealm jAASRealm = this;
            synchronized (jAASRealm) {
                Configuration configuration;
                if (string == null) {
                    this.jaasConfigurationLoaded = true;
                    return null;
                }
                URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
                URI uRI = uRL.toURI();
                Class<?> clazz = Class.forName("com.sun.security.auth.login.ConfigFile");
                Constructor<?> constructor = clazz.getConstructor(URI.class);
                this.jaasConfiguration = configuration = (Configuration)constructor.newInstance(uRI);
                this.jaasConfigurationLoaded = true;
                return this.jaasConfiguration;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getCause());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.invocationSuccess;
    }
}

