/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.ProfileRed;
import org.apache.xmlgraphics.java2d.color.ICCColorSpaceWithIntent;

public class ProfileRable
extends AbstractRable {
    private ICCColorSpaceWithIntent colorSpace;

    public ProfileRable(Filter filter, ICCColorSpaceWithIntent iCCColorSpaceWithIntent) {
        super(filter);
        this.colorSpace = iCCColorSpaceWithIntent;
    }

    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    public void setColorSpace(ICCColorSpaceWithIntent iCCColorSpaceWithIntent) {
        this.touch();
        this.colorSpace = iCCColorSpaceWithIntent;
    }

    public ICCColorSpaceWithIntent getColorSpace() {
        return this.colorSpace;
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        RenderedImage renderedImage = this.getSource().createRendering(renderContext);
        if (renderedImage == null) {
            return null;
        }
        CachableRed cachableRed = GraphicsUtil.wrap(renderedImage);
        return new ProfileRed(cachableRed, this.colorSpace);
    }
}

