/* browser-view.c generated by valac 0.56.3, the Vala compiler
 * generated from browser-view.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define MODEL_UTILS_undefined_context_id ((guint16) 0)
#define MODEL_UTILS_special_context_id_number ((guint16) 3)
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SIMPLE_SETTING_OBJECT (simple_setting_object_get_type ())
#define SIMPLE_SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject))
#define SIMPLE_SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObjectClass))
#define IS_SIMPLE_SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_SETTING_OBJECT))
#define IS_SIMPLE_SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_SETTING_OBJECT))
#define SIMPLE_SETTING_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObjectClass))

typedef struct _SimpleSettingObject SimpleSettingObject;
typedef struct _SimpleSettingObjectClass SimpleSettingObjectClass;
typedef struct _SimpleSettingObjectPrivate SimpleSettingObjectPrivate;
enum  {
	SIMPLE_SETTING_OBJECT_0_PROPERTY,
	SIMPLE_SETTING_OBJECT_IS_PINNED_PROPERTY,
	SIMPLE_SETTING_OBJECT_IS_SEARCH_PROPERTY,
	SIMPLE_SETTING_OBJECT_CONTEXT_ID_PROPERTY,
	SIMPLE_SETTING_OBJECT_NAME_PROPERTY,
	SIMPLE_SETTING_OBJECT_FULL_NAME_PROPERTY,
	SIMPLE_SETTING_OBJECT_CASEFOLDED_NAME_PROPERTY,
	SIMPLE_SETTING_OBJECT_NUM_PROPERTIES
};
static GParamSpec* simple_setting_object_properties[SIMPLE_SETTING_OBJECT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_BASE_VIEW (base_view_get_type ())
#define BASE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_VIEW, BaseView))
#define BASE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_VIEW, BaseViewClass))
#define IS_BASE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_VIEW))
#define IS_BASE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_VIEW))
#define BASE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_VIEW, BaseViewClass))

typedef struct _BaseView BaseView;
typedef struct _BaseViewClass BaseViewClass;
typedef struct _BaseViewPrivate BaseViewPrivate;

#define TYPE_BROWSER_VIEW (browser_view_get_type ())
#define BROWSER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_VIEW, BrowserView))
#define BROWSER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_VIEW, BrowserViewClass))
#define IS_BROWSER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_VIEW))
#define IS_BROWSER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_VIEW))
#define BROWSER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_VIEW, BrowserViewClass))

typedef struct _BrowserView BrowserView;
typedef struct _BrowserViewClass BrowserViewClass;
typedef struct _BrowserViewPrivate BrowserViewPrivate;
typedef enum  {
	VIEW_TYPE_OBJECT,
	VIEW_TYPE_FOLDER,
	VIEW_TYPE_SEARCH,
	VIEW_TYPE_CONFIG
} ViewType;

#define TYPE_VIEW_TYPE (view_type_get_type ())

#define TYPE_BROWSER_INFO_BAR (browser_info_bar_get_type ())
#define BROWSER_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_INFO_BAR, BrowserInfoBar))
#define BROWSER_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_INFO_BAR, BrowserInfoBarClass))
#define IS_BROWSER_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_INFO_BAR))
#define IS_BROWSER_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_INFO_BAR))
#define BROWSER_INFO_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_INFO_BAR, BrowserInfoBarClass))

typedef struct _BrowserInfoBar BrowserInfoBar;
typedef struct _BrowserInfoBarClass BrowserInfoBarClass;

#define TYPE_SORTING_OPTIONS (sorting_options_get_type ())
#define SORTING_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTING_OPTIONS, SortingOptions))
#define SORTING_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTING_OPTIONS, SortingOptionsClass))
#define IS_SORTING_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTING_OPTIONS))
#define IS_SORTING_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTING_OPTIONS))
#define SORTING_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTING_OPTIONS, SortingOptionsClass))

typedef struct _SortingOptions SortingOptions;
typedef struct _SortingOptionsClass SortingOptionsClass;

#define TYPE_BROWSER_CONTENT (browser_content_get_type ())
#define BROWSER_CONTENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_CONTENT, BrowserContent))
#define IS_BROWSER_CONTENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_CONTENT))
#define BROWSER_CONTENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_BROWSER_CONTENT, BrowserContentIface))

typedef struct _BrowserContent BrowserContent;
typedef struct _BrowserContentIface BrowserContentIface;
enum  {
	BROWSER_VIEW_0_PROPERTY,
	BROWSER_VIEW_LAST_CONTEXT_ID_PROPERTY,
	BROWSER_VIEW_BROWSER_CONTENT_PROPERTY,
	BROWSER_VIEW_CURRENT_VIEW_PROPERTY,
	BROWSER_VIEW_NUM_PROPERTIES
};
static GParamSpec* browser_view_properties[BROWSER_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SortingOptionsPrivate SortingOptionsPrivate;

#define TYPE_SETTINGS_MODEL_CORE (settings_model_core_get_type ())
#define SETTINGS_MODEL_CORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_MODEL_CORE, SettingsModelCore))
#define SETTINGS_MODEL_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_MODEL_CORE, SettingsModelCoreClass))
#define IS_SETTINGS_MODEL_CORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_MODEL_CORE))
#define IS_SETTINGS_MODEL_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_MODEL_CORE))
#define SETTINGS_MODEL_CORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_MODEL_CORE, SettingsModelCoreClass))

typedef struct _SettingsModelCore SettingsModelCore;
typedef struct _SettingsModelCoreClass SettingsModelCoreClass;

#define TYPE_SETTINGS_MODEL (settings_model_get_type ())
#define SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_MODEL, SettingsModel))
#define SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_MODEL, SettingsModelClass))
#define IS_SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_MODEL))
#define IS_SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_MODEL))
#define SETTINGS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_MODEL, SettingsModelClass))

typedef struct _SettingsModel SettingsModel;
typedef struct _SettingsModelClass SettingsModelClass;
enum  {
	SORTING_OPTIONS_0_PROPERTY,
	SORTING_OPTIONS_MODEL_PROPERTY,
	SORTING_OPTIONS_CASE_SENSITIVE_PROPERTY,
	SORTING_OPTIONS_NUM_PROPERTIES
};
static GParamSpec* sorting_options_properties[SORTING_OPTIONS_NUM_PROPERTIES];

#define TYPE_SETTING_COMPARATOR (setting_comparator_get_type ())
#define SETTING_COMPARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTING_COMPARATOR, SettingComparator))
#define SETTING_COMPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTING_COMPARATOR, SettingComparatorClass))
#define IS_SETTING_COMPARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTING_COMPARATOR))
#define IS_SETTING_COMPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTING_COMPARATOR))
#define SETTING_COMPARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTING_COMPARATOR, SettingComparatorClass))

typedef struct _SettingComparator SettingComparator;
typedef struct _SettingComparatorClass SettingComparatorClass;
typedef struct _Block6Data Block6Data;
typedef struct _SettingComparatorPrivate SettingComparatorPrivate;
enum  {
	SETTING_COMPARATOR_0_PROPERTY,
	SETTING_COMPARATOR_NUM_PROPERTIES
};
static GParamSpec* setting_comparator_properties[SETTING_COMPARATOR_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SimpleSettingObject {
	GObject parent_instance;
	SimpleSettingObjectPrivate * priv;
};

struct _SimpleSettingObjectClass {
	GObjectClass parent_class;
};

struct _SimpleSettingObjectPrivate {
	gboolean _is_pinned;
	gboolean _is_search;
	guint16 _context_id;
	gchar* _name;
	gchar* _full_name;
	gchar* _casefolded_name;
};

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _BaseView {
	GtkStack parent_instance;
	BaseViewPrivate * priv;
	GtkGrid* main_grid;
};

struct _BaseViewClass {
	GtkStackClass parent_class;
	gboolean (*handle_copy_text) (BaseView* self, gchar** copy_text);
	void (*close_popovers) (BaseView* self);
	void (*set_window_size) (BaseView* self, AdaptativeWidgetWindowSize new_size);
	void (*show_default_view) (BaseView* self);
	gboolean (*is_in_in_window_mode) (BaseView* self);
};

struct _BrowserView {
	BaseView parent_instance;
	BrowserViewPrivate * priv;
	BrowserInfoBar* info_bar;
	SortingOptions* sorting_options;
};

struct _BrowserViewClass {
	BaseViewClass parent_class;
	void (*set_path) (BrowserView* self, ViewType type, const gchar* path);
	gboolean (*next_match) (BrowserView* self);
	gboolean (*previous_match) (BrowserView* self);
	gboolean (*toggle_row_popover) (BrowserView* self);
};

struct _BrowserContentIface {
	GTypeInterface parent_iface;
	void (*prepare_folder_view) (BrowserContent* self, GListStore* key_model, gboolean is_ancestor);
	void (*prepare_object_view) (BrowserContent* self, const gchar* full_name, guint16 context_id, GVariant* properties, gboolean is_parent);
	void (*set_path) (BrowserContent* self, ViewType type, const gchar* path);
	gchar* (*get_selected_row_name) (BrowserContent* self);
	void (*select_row_named) (BrowserContent* self, const gchar* selected, guint16 last_context_id, gboolean grab_focus_if_needed);
	void (*select_first_row) (BrowserContent* self);
	void (*row_grab_focus) (BrowserContent* self);
	gboolean (*toggle_row_popover) (BrowserContent* self);
	void (*discard_row_popover) (BrowserContent* self);
	void (*invalidate_popovers) (BrowserContent* self);
	gboolean (*check_reload_folder) (BrowserContent* self, GVariant* fresh_key_model);
	gboolean (*check_reload_object) (BrowserContent* self, guint properties_hash);
	gboolean (*handle_copy_text) (BrowserContent* self, gchar** copy_text);
	gboolean (*handle_alt_copy_text) (BrowserContent* self, gchar** copy_text);
	gboolean (*next_match) (BrowserContent* self);
	gboolean (*previous_match) (BrowserContent* self);
	gboolean (*return_pressed) (BrowserContent* self);
	ViewType (*get_current_view) (BrowserContent* self);
	void (*set_current_view) (BrowserContent* self, ViewType value);
};

struct _BrowserViewPrivate {
	guint16 _last_context_id;
	BrowserContent* _browser_content;
	GListStore* key_model;
};

struct _SortingOptions {
	GObject parent_instance;
	SortingOptionsPrivate * priv;
};

struct _SortingOptionsClass {
	GObjectClass parent_class;
};

struct _SortingOptionsPrivate {
	SettingsModel* _model;
	GSettings* settings;
	gboolean _case_sensitive;
};

struct _Block6Data {
	int _ref_count_;
	SortingOptions* self;
	SettingComparator* comparator;
};

struct _SettingComparator {
	GObject parent_instance;
	SettingComparatorPrivate * priv;
};

struct _SettingComparatorClass {
	GObjectClass parent_class;
};

struct _SettingComparatorPrivate {
	guint16* sorted_context_id;
	gint sorted_context_id_length1;
	gint _sorted_context_id_size_;
	gboolean case_sensitive;
};

static gint SimpleSettingObject_private_offset;
static gpointer simple_setting_object_parent_class = NULL;
static gint BrowserView_private_offset;
static gpointer browser_view_parent_class = NULL;
static AdaptativeWidgetIface * browser_view_adaptative_widget_parent_iface = NULL;
static gint SortingOptions_private_offset;
static gpointer sorting_options_parent_class = NULL;
static gint SettingComparator_private_offset;
static gpointer setting_comparator_parent_class = NULL;

VALA_EXTERN GType simple_setting_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SimpleSettingObject, g_object_unref)
VALA_EXTERN SimpleSettingObject* simple_setting_object_new_from_base_path (guint16 _context_id,
                                                               const gchar* _name,
                                                               const gchar* _base_path,
                                                               gboolean _is_search,
                                                               gboolean _is_pinned);
VALA_EXTERN SimpleSettingObject* simple_setting_object_construct_from_base_path (GType object_type,
                                                                     guint16 _context_id,
                                                                     const gchar* _name,
                                                                     const gchar* _base_path,
                                                                     gboolean _is_search,
                                                                     gboolean _is_pinned);
VALA_EXTERN gchar* model_utils_recreate_full_name (const gchar* base_path,
                                       const gchar* name,
                                       gboolean is_folder);
VALA_EXTERN gboolean model_utils_is_folder_context_id (guint16 context_id);
VALA_EXTERN SimpleSettingObject* simple_setting_object_new_from_full_name (guint16 _context_id,
                                                               const gchar* _name,
                                                               const gchar* _full_name,
                                                               gboolean _is_search,
                                                               gboolean _is_pinned);
VALA_EXTERN SimpleSettingObject* simple_setting_object_construct_from_full_name (GType object_type,
                                                                     guint16 _context_id,
                                                                     const gchar* _name,
                                                                     const gchar* _full_name,
                                                                     gboolean _is_search,
                                                                     gboolean _is_pinned);
VALA_EXTERN SimpleSettingObject* simple_setting_object_new (void);
VALA_EXTERN SimpleSettingObject* simple_setting_object_construct (GType object_type);
VALA_EXTERN gboolean simple_setting_object_get_is_pinned (SimpleSettingObject* self);
static void simple_setting_object_set_is_pinned (SimpleSettingObject* self,
                                          gboolean value);
VALA_EXTERN gboolean simple_setting_object_get_is_search (SimpleSettingObject* self);
static void simple_setting_object_set_is_search (SimpleSettingObject* self,
                                          gboolean value);
VALA_EXTERN guint16 simple_setting_object_get_context_id (SimpleSettingObject* self);
static void simple_setting_object_set_context_id (SimpleSettingObject* self,
                                           guint16 value);
VALA_EXTERN const gchar* simple_setting_object_get_name (SimpleSettingObject* self);
static void simple_setting_object_set_name (SimpleSettingObject* self,
                                     const gchar* value);
VALA_EXTERN const gchar* simple_setting_object_get_full_name (SimpleSettingObject* self);
static void simple_setting_object_set_full_name (SimpleSettingObject* self,
                                          const gchar* value);
VALA_EXTERN const gchar* simple_setting_object_get_casefolded_name (SimpleSettingObject* self);
static void simple_setting_object_set_casefolded_name (SimpleSettingObject* self,
                                                const gchar* value);
static GObject * simple_setting_object_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void simple_setting_object_finalize (GObject * obj);
static GType simple_setting_object_get_type_once (void);
static void _vala_simple_setting_object_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_simple_setting_object_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType base_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseView, g_object_unref)
VALA_EXTERN GType browser_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserView, g_object_unref)
VALA_EXTERN GType view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType browser_info_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserInfoBar, g_object_unref)
VALA_EXTERN GType sorting_options_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SortingOptions, g_object_unref)
VALA_EXTERN GType browser_content_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void base_view_set_window_size (BaseView* self,
                                AdaptativeWidgetWindowSize new_size);
VALA_EXTERN void browser_view_set_path (BrowserView* self,
                            ViewType type,
                            const gchar* path);
VALA_EXTERN void base_view_close_popovers (BaseView* self);
VALA_EXTERN gboolean browser_view_next_match (BrowserView* self);
VALA_EXTERN gboolean browser_view_previous_match (BrowserView* self);
VALA_EXTERN gboolean browser_view_toggle_row_popover (BrowserView* self);
VALA_EXTERN gboolean base_view_handle_copy_text (BaseView* self,
                                     gchar** copy_text);
static void browser_view_refresh_folder (BrowserView* self);
static void _browser_view_refresh_folder_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void browser_view_real_set_window_size (AdaptativeWidget* base,
                                        AdaptativeWidgetWindowSize new_size);
static BrowserContent* browser_view_get_browser_content (BrowserView* self);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
VALA_EXTERN void browser_view_on_case_sensitive_changed (BrowserView* self);
VALA_EXTERN ViewType browser_view_get_current_view (BrowserView* self);
VALA_EXTERN gboolean sorting_options_is_key_model_sorted (SortingOptions* self,
                                              GListStore* key_model);
static void browser_view_show_soft_reload_warning (BrowserView* self);
static void browser_view_install_action_entries (BrowserView* self);
VALA_EXTERN void sorting_options_sort_key_model (SortingOptions* self,
                                     GListStore* key_model);
VALA_EXTERN void browser_view_hide_reload_warning (BrowserView* self);
VALA_EXTERN void browser_view_prepare_folder_view (BrowserView* self,
                                       GListStore* _key_model,
                                       gboolean is_ancestor);
VALA_EXTERN void browser_content_prepare_folder_view (BrowserContent* self,
                                          GListStore* key_model,
                                          gboolean is_ancestor);
VALA_EXTERN void browser_view_select_row (BrowserView* self,
                              const gchar* selected_or_empty);
VALA_EXTERN gboolean view_type_displays_objects_list (ViewType type);
VALA_EXTERN void browser_content_select_first_row (BrowserContent* self);
VALA_EXTERN void browser_content_select_row_named (BrowserContent* self,
                                       const gchar* selected,
                                       guint16 last_context_id,
                                       gboolean grab_focus_if_needed);
VALA_EXTERN guint16 browser_view_get_last_context_id (BrowserView* self);
VALA_EXTERN gboolean base_view_is_in_in_window_mode (BaseView* self);
VALA_EXTERN void browser_view_prepare_object_view (BrowserView* self,
                                       const gchar* full_name,
                                       guint16 context_id,
                                       GVariant* properties,
                                       gboolean is_parent);
VALA_EXTERN void browser_content_prepare_object_view (BrowserContent* self,
                                          const gchar* full_name,
                                          guint16 context_id,
                                          GVariant* properties,
                                          gboolean is_parent);
static void browser_view_set_last_context_id (BrowserView* self,
                                       guint16 value);
static void browser_view_real_set_path (BrowserView* self,
                                 ViewType type,
                                 const gchar* path);
VALA_EXTERN void browser_content_set_path (BrowserContent* self,
                               ViewType type,
                               const gchar* path);
VALA_EXTERN void browser_view_invalidate_popovers (BrowserView* self);
VALA_EXTERN void browser_info_bar_hide_warning (BrowserInfoBar* self);
VALA_EXTERN gboolean browser_info_bar_is_shown (BrowserInfoBar* self,
                                    const gchar* name);
VALA_EXTERN void browser_info_bar_show_warning (BrowserInfoBar* self,
                                    const gchar* name);
VALA_EXTERN void browser_view_row_grab_focus (BrowserView* self);
VALA_EXTERN void browser_content_row_grab_focus (BrowserContent* self);
static void browser_view_real_close_popovers (BaseView* base);
VALA_EXTERN void browser_content_discard_row_popover (BrowserContent* self);
VALA_EXTERN void browser_content_invalidate_popovers (BrowserContent* self);
VALA_EXTERN gboolean browser_view_return_pressed (BrowserView* self);
VALA_EXTERN gboolean browser_content_return_pressed (BrowserContent* self);
static gboolean browser_view_real_next_match (BrowserView* self);
VALA_EXTERN gboolean base_view_get_in_window_about (BaseView* self);
VALA_EXTERN gboolean browser_content_next_match (BrowserContent* self);
static gboolean browser_view_real_previous_match (BrowserView* self);
VALA_EXTERN gboolean browser_content_previous_match (BrowserContent* self);
static gboolean browser_view_real_toggle_row_popover (BrowserView* self);
VALA_EXTERN gboolean browser_content_toggle_row_popover (BrowserContent* self);
VALA_EXTERN gchar* browser_view_get_selected_row_name (BrowserView* self);
VALA_EXTERN gchar* browser_content_get_selected_row_name (BrowserContent* self);
static gboolean browser_view_real_handle_copy_text (BaseView* base,
                                             gchar** copy_text);
VALA_EXTERN gboolean browser_content_handle_copy_text (BrowserContent* self,
                                           gchar** copy_text);
VALA_EXTERN gboolean browser_view_handle_alt_copy_text (BrowserView* self,
                                            gchar** copy_text);
VALA_EXTERN gboolean browser_content_handle_alt_copy_text (BrowserContent* self,
                                               gchar** copy_text);
VALA_EXTERN BrowserView* browser_view_new (void);
VALA_EXTERN BrowserView* browser_view_construct (GType object_type);
VALA_EXTERN BaseView* base_view_new (void);
VALA_EXTERN BaseView* base_view_construct (GType object_type);
static void browser_view_set_browser_content (BrowserView* self,
                                       BrowserContent* value);
VALA_EXTERN ViewType browser_content_get_current_view (BrowserContent* self);
static GObject * browser_view_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
VALA_EXTERN BrowserInfoBar* browser_info_bar_new (void);
VALA_EXTERN BrowserInfoBar* browser_info_bar_construct (GType object_type);
VALA_EXTERN void browser_info_bar_add_label (BrowserInfoBar* self,
                                 const gchar* name,
                                 const gchar* text_label,
                                 const gchar* button_label,
                                 const gchar* button_action);
static void browser_view_finalize (GObject * obj);
static GType browser_view_get_type_once (void);
static void _vala_browser_view_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_browser_view_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
VALA_EXTERN GType settings_model_core_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsModelCore, g_object_unref)
VALA_EXTERN GType settings_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsModel, g_object_unref)
VALA_EXTERN SortingOptions* sorting_options_new (SettingsModel* _model);
VALA_EXTERN SortingOptions* sorting_options_construct (GType object_type,
                                           SettingsModel* _model);
VALA_EXTERN GType setting_comparator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingComparator, g_object_unref)
VALA_EXTERN SettingComparator* sorting_options_get_comparator (SortingOptions* self);
static SettingsModel* sorting_options_get_model (SortingOptions* self);
VALA_EXTERN guint16* settings_model_get_sorted_context_id (SettingsModel* self,
                                               gboolean case_sensitive,
                                               gint* result_length1);
VALA_EXTERN gboolean sorting_options_get_case_sensitive (SortingOptions* self);
VALA_EXTERN SettingComparator* setting_comparator_new (guint16* _sorted_context_id,
                                           gint _sorted_context_id_length1,
                                           gboolean _case_sensitive);
VALA_EXTERN SettingComparator* setting_comparator_construct (GType object_type,
                                                 guint16* _sorted_context_id,
                                                 gint _sorted_context_id_length1,
                                                 gboolean _case_sensitive);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gint __lambda91_ (Block6Data* _data6_,
                  GObject* a,
                  GObject* b);
VALA_EXTERN gint setting_comparator_compare (SettingComparator* self,
                                 SimpleSettingObject* a,
                                 SimpleSettingObject* b);
static gint ___lambda91__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static void sorting_options_set_model (SortingOptions* self,
                                SettingsModel* value);
VALA_EXTERN void sorting_options_set_case_sensitive (SortingOptions* self,
                                         gboolean value);
static GObject * sorting_options_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void sorting_options_finalize (GObject * obj);
static GType sorting_options_get_type_once (void);
static void _vala_sorting_options_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_sorting_options_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static guint16* _vala_array_dup6 (guint16* self,
                           gssize length);
static gboolean setting_comparator_sort_directories_first (SimpleSettingObject* a,
                                                    SimpleSettingObject* b,
                                                    gint* sort_hint);
static gboolean setting_comparator_sort_dconf_keys_second (SimpleSettingObject* a,
                                                    SimpleSettingObject* b,
                                                    gint* sort_hint);
static gint setting_comparator_sort_by_schema_thirdly (SimpleSettingObject* a,
                                                SimpleSettingObject* b,
                                                guint16* sorted_context_id,
                                                gint sorted_context_id_length1);
VALA_EXTERN gboolean model_utils_is_dconf_context_id (guint16 context_id);
static void setting_comparator_finalize (GObject * obj);
static GType setting_comparator_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GActionEntry BROWSER_VIEW_action_entries[1] = {{"refresh-folder", _browser_view_refresh_folder_gsimple_action_activate_callback}};

static inline gpointer
simple_setting_object_get_instance_private (SimpleSettingObject* self)
{
	return G_STRUCT_MEMBER_P (self, SimpleSettingObject_private_offset);
}

SimpleSettingObject*
simple_setting_object_construct_from_base_path (GType object_type,
                                                guint16 _context_id,
                                                const gchar* _name,
                                                const gchar* _base_path,
                                                gboolean _is_search,
                                                gboolean _is_pinned)
{
	SimpleSettingObject * self = NULL;
	gchar* _full_name = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (_name != NULL, NULL);
	g_return_val_if_fail (_base_path != NULL, NULL);
	_tmp0_ = model_utils_recreate_full_name (_base_path, _name, model_utils_is_folder_context_id (_context_id));
	_full_name = _tmp0_;
	self = (SimpleSettingObject*) g_object_new (object_type, "context-id", _context_id, "name", _name, "full-name", _full_name, "is-search", _is_search, "is-pinned", _is_pinned, NULL);
	_g_free0 (_full_name);
	return self;
}

SimpleSettingObject*
simple_setting_object_new_from_base_path (guint16 _context_id,
                                          const gchar* _name,
                                          const gchar* _base_path,
                                          gboolean _is_search,
                                          gboolean _is_pinned)
{
	return simple_setting_object_construct_from_base_path (TYPE_SIMPLE_SETTING_OBJECT, _context_id, _name, _base_path, _is_search, _is_pinned);
}

SimpleSettingObject*
simple_setting_object_construct_from_full_name (GType object_type,
                                                guint16 _context_id,
                                                const gchar* _name,
                                                const gchar* _full_name,
                                                gboolean _is_search,
                                                gboolean _is_pinned)
{
	SimpleSettingObject * self = NULL;
	g_return_val_if_fail (_name != NULL, NULL);
	g_return_val_if_fail (_full_name != NULL, NULL);
	self = (SimpleSettingObject*) g_object_new (object_type, "context-id", _context_id, "name", _name, "full-name", _full_name, "is-search", _is_search, "is-pinned", _is_pinned, NULL);
	return self;
}

SimpleSettingObject*
simple_setting_object_new_from_full_name (guint16 _context_id,
                                          const gchar* _name,
                                          const gchar* _full_name,
                                          gboolean _is_search,
                                          gboolean _is_pinned)
{
	return simple_setting_object_construct_from_full_name (TYPE_SIMPLE_SETTING_OBJECT, _context_id, _name, _full_name, _is_search, _is_pinned);
}

SimpleSettingObject*
simple_setting_object_construct (GType object_type)
{
	SimpleSettingObject * self = NULL;
	self = (SimpleSettingObject*) g_object_new (object_type, NULL);
	return self;
}

SimpleSettingObject*
simple_setting_object_new (void)
{
	return simple_setting_object_construct (TYPE_SIMPLE_SETTING_OBJECT);
}

gboolean
simple_setting_object_get_is_pinned (SimpleSettingObject* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_pinned;
	return result;
}

static void
simple_setting_object_set_is_pinned (SimpleSettingObject* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_pinned = value;
}

gboolean
simple_setting_object_get_is_search (SimpleSettingObject* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_search;
	return result;
}

static void
simple_setting_object_set_is_search (SimpleSettingObject* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_search = value;
}

guint16
simple_setting_object_get_context_id (SimpleSettingObject* self)
{
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_context_id;
	return result;
}

static void
simple_setting_object_set_context_id (SimpleSettingObject* self,
                                      guint16 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_context_id = value;
}

const gchar*
simple_setting_object_get_name (SimpleSettingObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
simple_setting_object_set_name (SimpleSettingObject* self,
                                const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}

const gchar*
simple_setting_object_get_full_name (SimpleSettingObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_full_name;
	result = _tmp0_;
	return result;
}

static void
simple_setting_object_set_full_name (SimpleSettingObject* self,
                                     const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_full_name);
	self->priv->_full_name = _tmp0_;
}

const gchar*
simple_setting_object_get_casefolded_name (SimpleSettingObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_casefolded_name;
	result = _tmp0_;
	return result;
}

static void
simple_setting_object_set_casefolded_name (SimpleSettingObject* self,
                                           const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_casefolded_name);
	self->priv->_casefolded_name = _tmp0_;
}

static GObject *
simple_setting_object_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SimpleSettingObject * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	parent_class = G_OBJECT_CLASS (simple_setting_object_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_utf8_casefold (_tmp0_, (gssize) -1);
	_tmp2_ = _tmp1_;
	simple_setting_object_set_casefolded_name (self, _tmp2_);
	_g_free0 (_tmp2_);
	return obj;
}

static void
simple_setting_object_class_init (SimpleSettingObjectClass * klass,
                                  gpointer klass_data)
{
	simple_setting_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SimpleSettingObject_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_simple_setting_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_simple_setting_object_set_property;
	G_OBJECT_CLASS (klass)->constructor = simple_setting_object_constructor;
	G_OBJECT_CLASS (klass)->finalize = simple_setting_object_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIMPLE_SETTING_OBJECT_IS_PINNED_PROPERTY, simple_setting_object_properties[SIMPLE_SETTING_OBJECT_IS_PINNED_PROPERTY] = g_param_spec_boolean ("is-pinned", "is-pinned", "is-pinned", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIMPLE_SETTING_OBJECT_IS_SEARCH_PROPERTY, simple_setting_object_properties[SIMPLE_SETTING_OBJECT_IS_SEARCH_PROPERTY] = g_param_spec_boolean ("is-search", "is-search", "is-search", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIMPLE_SETTING_OBJECT_CONTEXT_ID_PROPERTY, simple_setting_object_properties[SIMPLE_SETTING_OBJECT_CONTEXT_ID_PROPERTY] = g_param_spec_uint ("context-id", "context-id", "context-id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIMPLE_SETTING_OBJECT_NAME_PROPERTY, simple_setting_object_properties[SIMPLE_SETTING_OBJECT_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIMPLE_SETTING_OBJECT_FULL_NAME_PROPERTY, simple_setting_object_properties[SIMPLE_SETTING_OBJECT_FULL_NAME_PROPERTY] = g_param_spec_string ("full-name", "full-name", "full-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIMPLE_SETTING_OBJECT_CASEFOLDED_NAME_PROPERTY, simple_setting_object_properties[SIMPLE_SETTING_OBJECT_CASEFOLDED_NAME_PROPERTY] = g_param_spec_string ("casefolded-name", "casefolded-name", "casefolded-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
}

static void
simple_setting_object_instance_init (SimpleSettingObject * self,
                                     gpointer klass)
{
	self->priv = simple_setting_object_get_instance_private (self);
}

static void
simple_setting_object_finalize (GObject * obj)
{
	SimpleSettingObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_full_name);
	_g_free0 (self->priv->_casefolded_name);
	G_OBJECT_CLASS (simple_setting_object_parent_class)->finalize (obj);
}

static GType
simple_setting_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SimpleSettingObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) simple_setting_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SimpleSettingObject), 0, (GInstanceInitFunc) simple_setting_object_instance_init, NULL };
	GType simple_setting_object_type_id;
	simple_setting_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SimpleSettingObject", &g_define_type_info, 0);
	SimpleSettingObject_private_offset = g_type_add_instance_private (simple_setting_object_type_id, sizeof (SimpleSettingObjectPrivate));
	return simple_setting_object_type_id;
}

GType
simple_setting_object_get_type (void)
{
	static volatile gsize simple_setting_object_type_id__once = 0;
	if (g_once_init_enter (&simple_setting_object_type_id__once)) {
		GType simple_setting_object_type_id;
		simple_setting_object_type_id = simple_setting_object_get_type_once ();
		g_once_init_leave (&simple_setting_object_type_id__once, simple_setting_object_type_id);
	}
	return simple_setting_object_type_id__once;
}

static void
_vala_simple_setting_object_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	SimpleSettingObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject);
	switch (property_id) {
		case SIMPLE_SETTING_OBJECT_IS_PINNED_PROPERTY:
		g_value_set_boolean (value, simple_setting_object_get_is_pinned (self));
		break;
		case SIMPLE_SETTING_OBJECT_IS_SEARCH_PROPERTY:
		g_value_set_boolean (value, simple_setting_object_get_is_search (self));
		break;
		case SIMPLE_SETTING_OBJECT_CONTEXT_ID_PROPERTY:
		g_value_set_uint (value, simple_setting_object_get_context_id (self));
		break;
		case SIMPLE_SETTING_OBJECT_NAME_PROPERTY:
		g_value_set_string (value, simple_setting_object_get_name (self));
		break;
		case SIMPLE_SETTING_OBJECT_FULL_NAME_PROPERTY:
		g_value_set_string (value, simple_setting_object_get_full_name (self));
		break;
		case SIMPLE_SETTING_OBJECT_CASEFOLDED_NAME_PROPERTY:
		g_value_set_string (value, simple_setting_object_get_casefolded_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_simple_setting_object_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	SimpleSettingObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject);
	switch (property_id) {
		case SIMPLE_SETTING_OBJECT_IS_PINNED_PROPERTY:
		simple_setting_object_set_is_pinned (self, g_value_get_boolean (value));
		break;
		case SIMPLE_SETTING_OBJECT_IS_SEARCH_PROPERTY:
		simple_setting_object_set_is_search (self, g_value_get_boolean (value));
		break;
		case SIMPLE_SETTING_OBJECT_CONTEXT_ID_PROPERTY:
		simple_setting_object_set_context_id (self, g_value_get_uint (value));
		break;
		case SIMPLE_SETTING_OBJECT_NAME_PROPERTY:
		simple_setting_object_set_name (self, g_value_get_string (value));
		break;
		case SIMPLE_SETTING_OBJECT_FULL_NAME_PROPERTY:
		simple_setting_object_set_full_name (self, g_value_get_string (value));
		break;
		case SIMPLE_SETTING_OBJECT_CASEFOLDED_NAME_PROPERTY:
		simple_setting_object_set_casefolded_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
browser_view_get_instance_private (BrowserView* self)
{
	return G_STRUCT_MEMBER_P (self, BrowserView_private_offset);
}

static void
_browser_view_refresh_folder_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	browser_view_refresh_folder ((BrowserView*) self);
}

static void
browser_view_real_set_window_size (AdaptativeWidget* base,
                                   AdaptativeWidgetWindowSize new_size)
{
	BrowserView * self;
	BrowserContent* _tmp0_;
	self = (BrowserView*) base;
	BASE_VIEW_CLASS (browser_view_parent_class)->set_window_size (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BASE_VIEW, BaseView), new_size);
	_tmp0_ = self->priv->_browser_content;
	adaptative_widget_set_window_size ((AdaptativeWidget*) _tmp0_, new_size);
}

void
browser_view_on_case_sensitive_changed (BrowserView* self)
{
	ViewType _tmp0_;
	ViewType _tmp1_;
	gboolean _tmp2_ = FALSE;
	GListStore* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = browser_view_get_current_view (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VIEW_TYPE_FOLDER) {
		return;
	}
	_tmp3_ = self->priv->key_model;
	if (_tmp3_ != NULL) {
		SortingOptions* _tmp4_;
		GListStore* _tmp5_;
		_tmp4_ = self->sorting_options;
		_tmp5_ = self->priv->key_model;
		_tmp2_ = !sorting_options_is_key_model_sorted (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_list_store_get_type (), GListStore));
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		browser_view_show_soft_reload_warning (self);
	}
}

static void
browser_view_install_action_entries (BrowserView* self)
{
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_group_new ();
	action_group = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) action_group, BROWSER_VIEW_action_entries, (gint) G_N_ELEMENTS (BROWSER_VIEW_action_entries), self);
	gtk_widget_insert_action_group ((GtkWidget*) self, "bro", (GActionGroup*) action_group);
	_g_object_unref0 (action_group);
}

static void
browser_view_refresh_folder (BrowserView* self)
{
	GListStore* _tmp0_;
	SortingOptions* _tmp1_;
	GListStore* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_model;
	_vala_return_if_fail (_tmp0_ != NULL, "key_model != null");
	_tmp1_ = self->sorting_options;
	_tmp2_ = self->priv->key_model;
	sorting_options_sort_key_model (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_list_store_get_type (), GListStore));
	browser_view_hide_reload_warning (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
browser_view_prepare_folder_view (BrowserView* self,
                                  GListStore* _key_model,
                                  gboolean is_ancestor)
{
	GListStore* _tmp0_;
	SortingOptions* _tmp1_;
	GListStore* _tmp2_;
	BrowserContent* _tmp3_;
	GListStore* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_key_model != NULL);
	_tmp0_ = _g_object_ref0 (_key_model);
	_g_object_unref0 (self->priv->key_model);
	self->priv->key_model = _tmp0_;
	_tmp1_ = self->sorting_options;
	_tmp2_ = self->priv->key_model;
	sorting_options_sort_key_model (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_list_store_get_type (), GListStore));
	_tmp3_ = self->priv->_browser_content;
	_tmp4_ = self->priv->key_model;
	browser_content_prepare_folder_view (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_list_store_get_type (), GListStore), is_ancestor);
	browser_view_hide_reload_warning (self);
}

void
browser_view_select_row (BrowserView* self,
                         const gchar* selected_or_empty)
{
	ViewType _tmp0_;
	ViewType _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selected_or_empty != NULL);
	_tmp0_ = browser_view_get_current_view (self);
	_tmp1_ = _tmp0_;
	_vala_return_if_fail (view_type_displays_objects_list (_tmp1_), "ViewType.displays_objects_list (current_view)");
	if (g_strcmp0 (selected_or_empty, "") == 0) {
		BrowserContent* _tmp2_;
		_tmp2_ = self->priv->_browser_content;
		browser_content_select_first_row (_tmp2_);
	} else {
		BrowserContent* _tmp3_;
		guint16 _tmp4_;
		_tmp3_ = self->priv->_browser_content;
		_tmp4_ = self->priv->_last_context_id;
		browser_content_select_row_named (_tmp3_, selected_or_empty, _tmp4_, !base_view_is_in_in_window_mode ((BaseView*) self));
	}
}

void
browser_view_prepare_object_view (BrowserView* self,
                                  const gchar* full_name,
                                  guint16 context_id,
                                  GVariant* properties,
                                  gboolean is_parent)
{
	BrowserContent* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (full_name != NULL);
	g_return_if_fail (properties != NULL);
	_tmp0_ = self->priv->_browser_content;
	browser_content_prepare_object_view (_tmp0_, full_name, context_id, properties, is_parent);
	browser_view_hide_reload_warning (self);
	browser_view_set_last_context_id (self, context_id);
}

static void
browser_view_real_set_path (BrowserView* self,
                            ViewType type,
                            const gchar* path)
{
	BrowserContent* _tmp0_;
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->_browser_content;
	browser_content_set_path (_tmp0_, type, path);
	browser_view_invalidate_popovers (self);
}

void
browser_view_set_path (BrowserView* self,
                       ViewType type,
                       const gchar* path)
{
	BrowserViewClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BROWSER_VIEW_GET_CLASS (self);
	if (_klass_->set_path) {
		_klass_->set_path (self, type, path);
	}
}

void
browser_view_hide_reload_warning (BrowserView* self)
{
	BrowserInfoBar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->info_bar;
	browser_info_bar_hide_warning (_tmp0_);
}

static void
browser_view_show_soft_reload_warning (BrowserView* self)
{
	gboolean _tmp0_ = FALSE;
	BrowserInfoBar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->info_bar;
	if (!browser_info_bar_is_shown (_tmp1_, "hard-reload-folder")) {
		BrowserInfoBar* _tmp2_;
		_tmp2_ = self->info_bar;
		_tmp0_ = !browser_info_bar_is_shown (_tmp2_, "hard-reload-object");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		BrowserInfoBar* _tmp3_;
		_tmp3_ = self->info_bar;
		browser_info_bar_show_warning (_tmp3_, "soft-reload-folder");
	}
}

void
browser_view_row_grab_focus (BrowserView* self)
{
	BrowserContent* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_browser_content;
	browser_content_row_grab_focus (_tmp0_);
}

static void
browser_view_real_close_popovers (BaseView* base)
{
	BrowserView * self;
	BrowserContent* _tmp0_;
	self = (BrowserView*) base;
	_tmp0_ = self->priv->_browser_content;
	browser_content_discard_row_popover (_tmp0_);
}

void
browser_view_invalidate_popovers (BrowserView* self)
{
	BrowserContent* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_browser_content;
	browser_content_invalidate_popovers (_tmp0_);
}

gboolean
browser_view_return_pressed (BrowserView* self)
{
	BrowserContent* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_browser_content;
	result = browser_content_return_pressed (_tmp0_);
	return result;
}

static gboolean
browser_view_real_next_match (BrowserView* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	_tmp0_ = base_view_get_in_window_about ((BaseView*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	} else {
		BrowserContent* _tmp2_;
		_tmp2_ = self->priv->_browser_content;
		result = browser_content_next_match (_tmp2_);
		return result;
	}
}

gboolean
browser_view_next_match (BrowserView* self)
{
	BrowserViewClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BROWSER_VIEW_GET_CLASS (self);
	if (_klass_->next_match) {
		return _klass_->next_match (self);
	}
	return FALSE;
}

static gboolean
browser_view_real_previous_match (BrowserView* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	_tmp0_ = base_view_get_in_window_about ((BaseView*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	} else {
		BrowserContent* _tmp2_;
		_tmp2_ = self->priv->_browser_content;
		result = browser_content_previous_match (_tmp2_);
		return result;
	}
}

gboolean
browser_view_previous_match (BrowserView* self)
{
	BrowserViewClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BROWSER_VIEW_GET_CLASS (self);
	if (_klass_->previous_match) {
		return _klass_->previous_match (self);
	}
	return FALSE;
}

static gboolean
browser_view_real_toggle_row_popover (BrowserView* self)
{
	BrowserContent* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->_browser_content;
	result = browser_content_toggle_row_popover (_tmp0_);
	return result;
}

gboolean
browser_view_toggle_row_popover (BrowserView* self)
{
	BrowserViewClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BROWSER_VIEW_GET_CLASS (self);
	if (_klass_->toggle_row_popover) {
		return _klass_->toggle_row_popover (self);
	}
	return FALSE;
}

gchar*
browser_view_get_selected_row_name (BrowserView* self)
{
	BrowserContent* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_browser_content;
	_tmp1_ = browser_content_get_selected_row_name (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
browser_view_real_handle_copy_text (BaseView* base,
                                    gchar** copy_text)
{
	BrowserView * self;
	gchar* _vala_copy_text = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	BrowserContent* _tmp2_;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	gboolean result;
	self = (BrowserView*) base;
	_tmp1_ = BASE_VIEW_CLASS (browser_view_parent_class)->handle_copy_text (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BASE_VIEW, BaseView), &_tmp0_);
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp0_;
	if (_tmp1_) {
		result = TRUE;
		if (copy_text) {
			*copy_text = _vala_copy_text;
		} else {
			_g_free0 (_vala_copy_text);
		}
		return result;
	}
	_tmp2_ = self->priv->_browser_content;
	_tmp4_ = browser_content_handle_copy_text (_tmp2_, &_tmp3_);
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp3_;
	result = _tmp4_;
	if (copy_text) {
		*copy_text = _vala_copy_text;
	} else {
		_g_free0 (_vala_copy_text);
	}
	return result;
}

gboolean
browser_view_handle_alt_copy_text (BrowserView* self,
                                   gchar** copy_text)
{
	gchar* _vala_copy_text = NULL;
	BrowserContent* _tmp0_;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_browser_content;
	_tmp2_ = browser_content_handle_alt_copy_text (_tmp0_, &_tmp1_);
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp1_;
	result = _tmp2_;
	if (copy_text) {
		*copy_text = _vala_copy_text;
	} else {
		_g_free0 (_vala_copy_text);
	}
	return result;
}

BrowserView*
browser_view_construct (GType object_type)
{
	BrowserView * self = NULL;
	self = (BrowserView*) base_view_construct (object_type);
	return self;
}

BrowserView*
browser_view_new (void)
{
	return browser_view_construct (TYPE_BROWSER_VIEW);
}

guint16
browser_view_get_last_context_id (BrowserView* self)
{
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_last_context_id;
	return result;
}

static void
browser_view_set_last_context_id (BrowserView* self,
                                  guint16 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_last_context_id = value;
}

static BrowserContent*
browser_view_get_browser_content (BrowserView* self)
{
	BrowserContent* result;
	BrowserContent* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_browser_content;
	result = _tmp0_;
	return result;
}

static void
browser_view_set_browser_content (BrowserView* self,
                                  BrowserContent* value)
{
	BrowserContent* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_browser_content);
	self->priv->_browser_content = _tmp0_;
}

ViewType
browser_view_get_current_view (BrowserView* self)
{
	ViewType result;
	BrowserContent* _tmp0_;
	ViewType _tmp1_;
	ViewType _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_browser_content;
	_tmp1_ = browser_content_get_current_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static GObject *
browser_view_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BrowserView * self;
	BrowserInfoBar* _tmp0_;
	BrowserInfoBar* _tmp1_;
	BrowserInfoBar* _tmp2_;
	BrowserInfoBar* _tmp3_;
	BrowserInfoBar* _tmp4_;
	GtkGrid* _tmp5_;
	BrowserInfoBar* _tmp6_;
	GtkGrid* _tmp7_;
	BrowserContent* _tmp8_;
	parent_class = G_OBJECT_CLASS (browser_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BROWSER_VIEW, BrowserView);
	browser_view_install_action_entries (self);
	_tmp0_ = browser_info_bar_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->info_bar);
	self->info_bar = _tmp0_;
	_tmp1_ = self->info_bar;
	browser_info_bar_add_label (_tmp1_, "soft-reload-folder", _ ("Sort preferences have changed. Do you want to refresh the view?"), _ ("Refresh"), "bro.refresh-folder");
	_tmp2_ = self->info_bar;
	browser_info_bar_add_label (_tmp2_, "hard-reload-folder", _ ("This folder content has changed. Do you want to reload the view?"), _ ("Reload"), "browser.reload-folder");
	_tmp3_ = self->info_bar;
	browser_info_bar_add_label (_tmp3_, "hard-reload-object", _ ("This key’s properties have changed. Do you want to reload the view?"), _ ("Reload"), "browser.reload-object");
	_tmp4_ = self->info_bar;
	gtk_widget_show ((GtkWidget*) _tmp4_);
	_tmp5_ = ((BaseView*) self)->main_grid;
	_tmp6_ = self->info_bar;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = ((BaseView*) self)->main_grid;
	_tmp8_ = self->priv->_browser_content;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
	return obj;
}

static void
browser_view_class_init (BrowserViewClass * klass,
                         gpointer klass_data)
{
	browser_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BrowserView_private_offset);
	((BaseViewClass *) klass)->set_window_size = (void (*) (BaseView*, AdaptativeWidgetWindowSize)) browser_view_real_set_window_size;
	((BrowserViewClass *) klass)->set_path = (void (*) (BrowserView*, ViewType, const gchar*)) browser_view_real_set_path;
	((BaseViewClass *) klass)->close_popovers = (void (*) (BaseView*)) browser_view_real_close_popovers;
	((BrowserViewClass *) klass)->next_match = (gboolean (*) (BrowserView*)) browser_view_real_next_match;
	((BrowserViewClass *) klass)->previous_match = (gboolean (*) (BrowserView*)) browser_view_real_previous_match;
	((BrowserViewClass *) klass)->toggle_row_popover = (gboolean (*) (BrowserView*)) browser_view_real_toggle_row_popover;
	((BaseViewClass *) klass)->handle_copy_text = (gboolean (*) (BaseView*, gchar**)) browser_view_real_handle_copy_text;
	G_OBJECT_CLASS (klass)->get_property = _vala_browser_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_browser_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = browser_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = browser_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_VIEW_LAST_CONTEXT_ID_PROPERTY, browser_view_properties[BROWSER_VIEW_LAST_CONTEXT_ID_PROPERTY] = g_param_spec_uint ("last-context-id", "last-context-id", "last-context-id", 0, G_MAXUINT, MODEL_UTILS_undefined_context_id, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_VIEW_BROWSER_CONTENT_PROPERTY, browser_view_properties[BROWSER_VIEW_BROWSER_CONTENT_PROPERTY] = g_param_spec_object ("browser-content", "browser-content", "browser-content", TYPE_BROWSER_CONTENT, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_VIEW_CURRENT_VIEW_PROPERTY, browser_view_properties[BROWSER_VIEW_CURRENT_VIEW_PROPERTY] = g_param_spec_enum ("current-view", "current-view", "current-view", TYPE_VIEW_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
}

static void
browser_view_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                               gpointer iface_data)
{
	browser_view_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) browser_view_real_set_window_size;
}

static void
browser_view_instance_init (BrowserView * self,
                            gpointer klass)
{
	self->priv = browser_view_get_instance_private (self);
	self->priv->_last_context_id = MODEL_UTILS_undefined_context_id;
	self->priv->key_model = NULL;
}

static void
browser_view_finalize (GObject * obj)
{
	BrowserView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BROWSER_VIEW, BrowserView);
	_g_object_unref0 (self->priv->_browser_content);
	_g_object_unref0 (self->info_bar);
	_g_object_unref0 (self->sorting_options);
	_g_object_unref0 (self->priv->key_model);
	G_OBJECT_CLASS (browser_view_parent_class)->finalize (obj);
}

static GType
browser_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BrowserViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) browser_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BrowserView), 0, (GInstanceInitFunc) browser_view_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) browser_view_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType browser_view_type_id;
	browser_view_type_id = g_type_register_static (TYPE_BASE_VIEW, "BrowserView", &g_define_type_info, 0);
	g_type_add_interface_static (browser_view_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	BrowserView_private_offset = g_type_add_instance_private (browser_view_type_id, sizeof (BrowserViewPrivate));
	return browser_view_type_id;
}

GType
browser_view_get_type (void)
{
	static volatile gsize browser_view_type_id__once = 0;
	if (g_once_init_enter (&browser_view_type_id__once)) {
		GType browser_view_type_id;
		browser_view_type_id = browser_view_get_type_once ();
		g_once_init_leave (&browser_view_type_id__once, browser_view_type_id);
	}
	return browser_view_type_id__once;
}

static void
_vala_browser_view_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	BrowserView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BROWSER_VIEW, BrowserView);
	switch (property_id) {
		case BROWSER_VIEW_LAST_CONTEXT_ID_PROPERTY:
		g_value_set_uint (value, browser_view_get_last_context_id (self));
		break;
		case BROWSER_VIEW_BROWSER_CONTENT_PROPERTY:
		g_value_set_object (value, browser_view_get_browser_content (self));
		break;
		case BROWSER_VIEW_CURRENT_VIEW_PROPERTY:
		g_value_set_enum (value, browser_view_get_current_view (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_browser_view_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	BrowserView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BROWSER_VIEW, BrowserView);
	switch (property_id) {
		case BROWSER_VIEW_LAST_CONTEXT_ID_PROPERTY:
		browser_view_set_last_context_id (self, g_value_get_uint (value));
		break;
		case BROWSER_VIEW_BROWSER_CONTENT_PROPERTY:
		browser_view_set_browser_content (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
sorting_options_get_instance_private (SortingOptions* self)
{
	return G_STRUCT_MEMBER_P (self, SortingOptions_private_offset);
}

SortingOptions*
sorting_options_construct (GType object_type,
                           SettingsModel* _model)
{
	SortingOptions * self = NULL;
	g_return_val_if_fail (_model != NULL, NULL);
	self = (SortingOptions*) g_object_new (object_type, "model", _model, NULL);
	return self;
}

SortingOptions*
sorting_options_new (SettingsModel* _model)
{
	return sorting_options_construct (TYPE_SORTING_OPTIONS, _model);
}

SettingComparator*
sorting_options_get_comparator (SortingOptions* self)
{
	SettingsModel* _tmp0_;
	gboolean _tmp1_;
	gint _tmp2_ = 0;
	guint16* _tmp3_;
	guint16* _tmp4_;
	gint _tmp4__length1;
	gboolean _tmp5_;
	SettingComparator* _tmp6_;
	SettingComparator* _tmp7_;
	SettingComparator* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	_tmp1_ = self->priv->_case_sensitive;
	_tmp3_ = settings_model_get_sorted_context_id (_tmp0_, _tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp5_ = self->priv->_case_sensitive;
	_tmp6_ = setting_comparator_new (_tmp4_, _tmp2_, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp4_ = (g_free (_tmp4_), NULL);
	result = _tmp7_;
	return result;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		SortingOptions* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->comparator);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gint
__lambda91_ (Block6Data* _data6_,
             GObject* a,
             GObject* b)
{
	SortingOptions* self;
	gint result;
	self = _data6_->self;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	result = setting_comparator_compare (_data6_->comparator, G_TYPE_CHECK_INSTANCE_CAST (a, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject), G_TYPE_CHECK_INSTANCE_CAST (b, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject));
	return result;
}

static gint
___lambda91__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda91_ (self, (GObject*) a, (GObject*) b);
	return result;
}

void
sorting_options_sort_key_model (SortingOptions* self,
                                GListStore* key_model)
{
	Block6Data* _data6_;
	SettingComparator* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key_model != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = sorting_options_get_comparator (self);
	_data6_->comparator = _tmp0_;
	g_list_store_sort (key_model, ___lambda91__gcompare_data_func, _data6_);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

gboolean
sorting_options_is_key_model_sorted (SortingOptions* self,
                                     GListStore* key_model)
{
	SettingComparator* comparator = NULL;
	SettingComparator* _tmp0_;
	guint last = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key_model != NULL, FALSE);
	_tmp0_ = sorting_options_get_comparator (self);
	comparator = _tmp0_;
	last = g_list_model_get_n_items ((GListModel*) key_model) - 1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				SimpleSettingObject* item = NULL;
				GObject* _tmp3_;
				SimpleSettingObject* next = NULL;
				GObject* _tmp4_;
				SettingComparator* _tmp5_;
				SimpleSettingObject* _tmp6_;
				SimpleSettingObject* _tmp7_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(((guint) i) < last)) {
					break;
				}
				_tmp3_ = g_list_model_get_item ((GListModel*) key_model, (guint) i);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject);
				_tmp4_ = g_list_model_get_item ((GListModel*) key_model, (guint) (i + 1));
				next = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject);
				_tmp5_ = comparator;
				_tmp6_ = item;
				_tmp7_ = next;
				if (setting_comparator_compare (_tmp5_, _tmp6_, _tmp7_) > 0) {
					result = FALSE;
					_g_object_unref0 (next);
					_g_object_unref0 (item);
					_g_object_unref0 (comparator);
					return result;
				}
				_g_object_unref0 (next);
				_g_object_unref0 (item);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (comparator);
	return result;
}

static SettingsModel*
sorting_options_get_model (SortingOptions* self)
{
	SettingsModel* result;
	SettingsModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	result = _tmp0_;
	return result;
}

static void
sorting_options_set_model (SortingOptions* self,
                           SettingsModel* value)
{
	SettingsModel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp0_;
}

gboolean
sorting_options_get_case_sensitive (SortingOptions* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_case_sensitive;
	return result;
}

void
sorting_options_set_case_sensitive (SortingOptions* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sorting_options_get_case_sensitive (self);
	if (old_value != value) {
		self->priv->_case_sensitive = value;
		g_object_notify_by_pspec ((GObject *) self, sorting_options_properties[SORTING_OPTIONS_CASE_SENSITIVE_PROPERTY]);
	}
}

static GObject *
sorting_options_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SortingOptions * self;
	GSettings* _tmp0_;
	parent_class = G_OBJECT_CLASS (sorting_options_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SORTING_OPTIONS, SortingOptions);
	_tmp0_ = self->priv->settings;
	g_settings_bind (_tmp0_, "sort-case-sensitive", (GObject*) self, "case-sensitive", G_SETTINGS_BIND_GET);
	return obj;
}

static void
sorting_options_class_init (SortingOptionsClass * klass,
                            gpointer klass_data)
{
	sorting_options_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SortingOptions_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sorting_options_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sorting_options_set_property;
	G_OBJECT_CLASS (klass)->constructor = sorting_options_constructor;
	G_OBJECT_CLASS (klass)->finalize = sorting_options_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTING_OPTIONS_MODEL_PROPERTY, sorting_options_properties[SORTING_OPTIONS_MODEL_PROPERTY] = g_param_spec_object ("model", "model", "model", TYPE_SETTINGS_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTING_OPTIONS_CASE_SENSITIVE_PROPERTY, sorting_options_properties[SORTING_OPTIONS_CASE_SENSITIVE_PROPERTY] = g_param_spec_boolean ("case-sensitive", "case-sensitive", "case-sensitive", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
sorting_options_instance_init (SortingOptions * self,
                               gpointer klass)
{
	GSettings* _tmp0_;
	self->priv = sorting_options_get_instance_private (self);
	_tmp0_ = g_settings_new ("ca.desrt.dconf-editor.Settings");
	self->priv->settings = _tmp0_;
	self->priv->_case_sensitive = FALSE;
}

static void
sorting_options_finalize (GObject * obj)
{
	SortingOptions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SORTING_OPTIONS, SortingOptions);
	_g_object_unref0 (self->priv->_model);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (sorting_options_parent_class)->finalize (obj);
}

static GType
sorting_options_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SortingOptionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sorting_options_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SortingOptions), 0, (GInstanceInitFunc) sorting_options_instance_init, NULL };
	GType sorting_options_type_id;
	sorting_options_type_id = g_type_register_static (G_TYPE_OBJECT, "SortingOptions", &g_define_type_info, 0);
	SortingOptions_private_offset = g_type_add_instance_private (sorting_options_type_id, sizeof (SortingOptionsPrivate));
	return sorting_options_type_id;
}

GType
sorting_options_get_type (void)
{
	static volatile gsize sorting_options_type_id__once = 0;
	if (g_once_init_enter (&sorting_options_type_id__once)) {
		GType sorting_options_type_id;
		sorting_options_type_id = sorting_options_get_type_once ();
		g_once_init_leave (&sorting_options_type_id__once, sorting_options_type_id);
	}
	return sorting_options_type_id__once;
}

static void
_vala_sorting_options_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	SortingOptions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SORTING_OPTIONS, SortingOptions);
	switch (property_id) {
		case SORTING_OPTIONS_MODEL_PROPERTY:
		g_value_set_object (value, sorting_options_get_model (self));
		break;
		case SORTING_OPTIONS_CASE_SENSITIVE_PROPERTY:
		g_value_set_boolean (value, sorting_options_get_case_sensitive (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sorting_options_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	SortingOptions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SORTING_OPTIONS, SortingOptions);
	switch (property_id) {
		case SORTING_OPTIONS_MODEL_PROPERTY:
		sorting_options_set_model (self, g_value_get_object (value));
		break;
		case SORTING_OPTIONS_CASE_SENSITIVE_PROPERTY:
		sorting_options_set_case_sensitive (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
setting_comparator_get_instance_private (SettingComparator* self)
{
	return G_STRUCT_MEMBER_P (self, SettingComparator_private_offset);
}

static guint16*
_vala_array_dup6 (guint16* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint16));
	}
	return NULL;
}

SettingComparator*
setting_comparator_construct (GType object_type,
                              guint16* _sorted_context_id,
                              gint _sorted_context_id_length1,
                              gboolean _case_sensitive)
{
	SettingComparator * self = NULL;
	guint16* _tmp0_;
	gint _tmp0__length1;
	self = (SettingComparator*) g_object_new (object_type, NULL);
	_tmp0_ = (_sorted_context_id != NULL) ? _vala_array_dup6 (_sorted_context_id, _sorted_context_id_length1) : _sorted_context_id;
	_tmp0__length1 = _sorted_context_id_length1;
	self->priv->sorted_context_id = (g_free (self->priv->sorted_context_id), NULL);
	self->priv->sorted_context_id = _tmp0_;
	self->priv->sorted_context_id_length1 = _tmp0__length1;
	self->priv->_sorted_context_id_size_ = self->priv->sorted_context_id_length1;
	self->priv->case_sensitive = _case_sensitive;
	return self;
}

SettingComparator*
setting_comparator_new (guint16* _sorted_context_id,
                        gint _sorted_context_id_length1,
                        gboolean _case_sensitive)
{
	return setting_comparator_construct (TYPE_SETTING_COMPARATOR, _sorted_context_id, _sorted_context_id_length1, _case_sensitive);
}

gint
setting_comparator_compare (SettingComparator* self,
                            SimpleSettingObject* a,
                            SimpleSettingObject* b)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	guint16 _tmp4_;
	guint16 _tmp5_;
	guint16 _tmp6_;
	guint16 _tmp7_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = simple_setting_object_get_is_pinned (a);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = -1;
		return result;
	}
	_tmp2_ = simple_setting_object_get_is_pinned (b);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		result = 1;
		return result;
	}
	_tmp4_ = simple_setting_object_get_context_id (a);
	_tmp5_ = _tmp4_;
	_tmp6_ = simple_setting_object_get_context_id (b);
	_tmp7_ = _tmp6_;
	if (_tmp5_ != _tmp7_) {
		gint sort_hint = 0;
		gboolean _tmp8_;
		gboolean _tmp9_;
		guint16* _tmp10_;
		gint _tmp10__length1;
		sort_hint = 0;
		_tmp8_ = setting_comparator_sort_directories_first (a, b, &sort_hint);
		if (_tmp8_) {
			result = sort_hint;
			return result;
		}
		_tmp9_ = setting_comparator_sort_dconf_keys_second (a, b, &sort_hint);
		if (_tmp9_) {
			result = sort_hint;
			return result;
		}
		_tmp10_ = self->priv->sorted_context_id;
		_tmp10__length1 = self->priv->sorted_context_id_length1;
		result = setting_comparator_sort_by_schema_thirdly (a, b, _tmp10_, (gint) _tmp10__length1);
		return result;
	} else {
		if (self->priv->case_sensitive) {
			GCompareFunc _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp11_ = ((GCompareFunc) g_strcmp0);
			_tmp12_ = simple_setting_object_get_name (a);
			_tmp13_ = _tmp12_;
			_tmp14_ = simple_setting_object_get_name (b);
			_tmp15_ = _tmp14_;
			result = _tmp11_ (_tmp13_, _tmp15_);
			return result;
		} else {
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			_tmp16_ = simple_setting_object_get_casefolded_name (a);
			_tmp17_ = _tmp16_;
			_tmp18_ = simple_setting_object_get_casefolded_name (b);
			_tmp19_ = _tmp18_;
			result = g_utf8_collate (_tmp17_, _tmp19_);
			return result;
		}
	}
}

static gboolean
setting_comparator_sort_directories_first (SimpleSettingObject* a,
                                           SimpleSettingObject* b,
                                           gint* sort_hint)
{
	guint16 _tmp0_;
	guint16 _tmp1_;
	guint16 _tmp2_;
	guint16 _tmp3_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = simple_setting_object_get_context_id (a);
	_tmp1_ = _tmp0_;
	if (model_utils_is_folder_context_id (_tmp1_)) {
		*sort_hint = -1;
		result = TRUE;
		return result;
	}
	_tmp2_ = simple_setting_object_get_context_id (b);
	_tmp3_ = _tmp2_;
	if (model_utils_is_folder_context_id (_tmp3_)) {
		*sort_hint = 1;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
setting_comparator_sort_dconf_keys_second (SimpleSettingObject* a,
                                           SimpleSettingObject* b,
                                           gint* sort_hint)
{
	guint16 _tmp0_;
	guint16 _tmp1_;
	guint16 _tmp2_;
	guint16 _tmp3_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = simple_setting_object_get_context_id (a);
	_tmp1_ = _tmp0_;
	if (model_utils_is_dconf_context_id (_tmp1_)) {
		*sort_hint = -1;
		result = TRUE;
		return result;
	}
	_tmp2_ = simple_setting_object_get_context_id (b);
	_tmp3_ = _tmp2_;
	if (model_utils_is_dconf_context_id (_tmp3_)) {
		*sort_hint = 1;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gint
setting_comparator_sort_by_schema_thirdly (SimpleSettingObject* a,
                                           SimpleSettingObject* b,
                                           guint16* sorted_context_id,
                                           gint sorted_context_id_length1)
{
	guint16 a_place = 0U;
	guint16 _tmp0_;
	guint16 _tmp1_;
	guint16 _tmp2_;
	guint16 b_place = 0U;
	guint16 _tmp3_;
	guint16 _tmp4_;
	guint16 _tmp5_;
	gint _tmp6_ = 0;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = simple_setting_object_get_context_id (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = sorted_context_id[_tmp1_ - MODEL_UTILS_special_context_id_number];
	a_place = _tmp2_;
	_tmp3_ = simple_setting_object_get_context_id (b);
	_tmp4_ = _tmp3_;
	_tmp5_ = sorted_context_id[_tmp4_ - MODEL_UTILS_special_context_id_number];
	b_place = _tmp5_;
	if (a_place == b_place) {
		result = 0;
		return result;
	}
	if (a_place < b_place) {
		_tmp6_ = -1;
	} else {
		_tmp6_ = 1;
	}
	result = _tmp6_;
	return result;
}

static void
setting_comparator_class_init (SettingComparatorClass * klass,
                               gpointer klass_data)
{
	setting_comparator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SettingComparator_private_offset);
	G_OBJECT_CLASS (klass)->finalize = setting_comparator_finalize;
}

static void
setting_comparator_instance_init (SettingComparator * self,
                                  gpointer klass)
{
	self->priv = setting_comparator_get_instance_private (self);
}

static void
setting_comparator_finalize (GObject * obj)
{
	SettingComparator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SETTING_COMPARATOR, SettingComparator);
	self->priv->sorted_context_id = (g_free (self->priv->sorted_context_id), NULL);
	G_OBJECT_CLASS (setting_comparator_parent_class)->finalize (obj);
}

static GType
setting_comparator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SettingComparatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) setting_comparator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SettingComparator), 0, (GInstanceInitFunc) setting_comparator_instance_init, NULL };
	GType setting_comparator_type_id;
	setting_comparator_type_id = g_type_register_static (G_TYPE_OBJECT, "SettingComparator", &g_define_type_info, 0);
	SettingComparator_private_offset = g_type_add_instance_private (setting_comparator_type_id, sizeof (SettingComparatorPrivate));
	return setting_comparator_type_id;
}

GType
setting_comparator_get_type (void)
{
	static volatile gsize setting_comparator_type_id__once = 0;
	if (g_once_init_enter (&setting_comparator_type_id__once)) {
		GType setting_comparator_type_id;
		setting_comparator_type_id = setting_comparator_get_type_once ();
		g_once_init_leave (&setting_comparator_type_id__once, setting_comparator_type_id);
	}
	return setting_comparator_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

