/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.compiler;

import java.util.Arrays;
import java.util.BitSet;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;

class SubwordMatcher {
    private static final int[] EMPTY_REGIONS = new int[0];
    private final char[] name;
    private final BitSet wordBoundaries;

    public SubwordMatcher(String string) {
        this.name = string.toCharArray();
        this.wordBoundaries = new BitSet(string.length());
        for (int i = 0; i < this.name.length; ++i) {
            if (!SubwordMatcher.isWordBoundary(this.caseAt(i - 1), this.caseAt(i), this.caseAt(i + 1))) continue;
            this.wordBoundaries.set(i);
        }
    }

    private Case caseAt(int n) {
        if (n < 0 || n >= this.name.length) {
            return Case.SEPARATOR;
        }
        char c = this.name[n];
        if (c == '_') {
            return Case.SEPARATOR;
        }
        if (ScannerHelper.isUpperCase(c)) {
            return Case.UPPER;
        }
        return Case.LOWER;
    }

    private static boolean isWordBoundary(Case case_, Case case_2, Case case_3) {
        if (case_ == case_2 && case_2 == case_3) {
            return false;
        }
        if (case_ == Case.SEPARATOR) {
            return true;
        }
        return case_2 == Case.UPPER && (case_ == Case.LOWER || case_3 == Case.LOWER);
    }

    public int[] getMatchingRegions(String string) {
        int n = 0;
        int[] nArray = EMPTY_REGIONS;
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            int n4;
            int n5;
            char c;
            if (++n2 == this.name.length) {
                return null;
            }
            char c2 = string.charAt(i);
            if (c2 == (c = this.name[n2]) || !this.isWordBoundary(n2) && this.equalsIgnoreCase(c2, c)) continue;
            if (n2 > n) {
                nArray = Arrays.copyOf(nArray, nArray.length + 2);
                nArray[nArray.length - 2] = n;
                nArray[nArray.length - 1] = n2 - n;
            }
            if ((n5 = this.indexOfWordStart(n2, c2)) < 0 && (n4 = this.indexOfWordStart(n2, string.charAt(n3))) > 0) {
                n5 = n4;
                i = n3;
                nArray = Arrays.copyOfRange(nArray, 0, nArray.length - 2);
            }
            if (n5 < 0) {
                return null;
            }
            n = n5;
            n2 = n5;
            n3 = i;
        }
        nArray = Arrays.copyOf(nArray, nArray.length + 2);
        nArray[nArray.length - 2] = n;
        nArray[nArray.length - 1] = n2 - n + 1;
        return nArray;
    }

    private int indexOfWordStart(int n, char c) {
        for (int i = n; i < this.name.length; ++i) {
            char c2 = this.name[i];
            if (this.isWordBoundary(i) && this.equalsIgnoreCase(c2, c)) {
                return i;
            }
            if (ScannerHelper.isJavaIdentifierPart(c2)) continue;
            return -1;
        }
        return -1;
    }

    private boolean equalsIgnoreCase(char c, char c2) {
        return ScannerHelper.toLowerCase(c) == ScannerHelper.toLowerCase(c2);
    }

    private boolean isWordBoundary(int n) {
        return this.wordBoundaries.get(n);
    }

    private static enum Case {
        SEPARATOR,
        LOWER,
        UPPER;

    }
}

