/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.ParameterNonNullDefaultProvider;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ImplicitNullAnnotationVerifier {
    ImplicitNullAnnotationVerifier buddyImplicitNullAnnotationsVerifier;
    private boolean inheritNullAnnotations;
    protected LookupEnvironment environment;

    public static void ensureNullnessIsKnown(MethodBinding methodBinding, Scope scope) {
        if ((methodBinding.tagBits & 0x1000L) == 0L) {
            LookupEnvironment lookupEnvironment = scope.environment();
            new ImplicitNullAnnotationVerifier(lookupEnvironment, lookupEnvironment.globalOptions.inheritNullAnnotations).checkImplicitNullAnnotations(methodBinding, null, false, scope);
        }
    }

    public ImplicitNullAnnotationVerifier(LookupEnvironment lookupEnvironment, boolean bl) {
        this.buddyImplicitNullAnnotationsVerifier = this;
        this.inheritNullAnnotations = bl;
        this.environment = lookupEnvironment;
    }

    ImplicitNullAnnotationVerifier(LookupEnvironment lookupEnvironment) {
        CompilerOptions compilerOptions = lookupEnvironment.globalOptions;
        this.buddyImplicitNullAnnotationsVerifier = new ImplicitNullAnnotationVerifier(lookupEnvironment, compilerOptions.inheritNullAnnotations);
        this.inheritNullAnnotations = compilerOptions.inheritNullAnnotations;
        this.environment = lookupEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkImplicitNullAnnotations(MethodBinding methodBinding, AbstractMethodDeclaration abstractMethodDeclaration, boolean bl, Scope scope) {
        try {
            ReferenceBinding referenceBinding = methodBinding.declaringClass;
            if (referenceBinding.id == 1) {
                return;
            }
            boolean bl2 = scope.environment().usesNullTypeAnnotations();
            boolean bl3 = methodBinding.hasNonNullDefaultForReturnType(abstractMethodDeclaration);
            ParameterNonNullDefaultProvider parameterNonNullDefaultProvider = methodBinding.hasNonNullDefaultForParameter(abstractMethodDeclaration);
            boolean bl4 = bl3 | parameterNonNullDefaultProvider.hasAnyNonNullDefault();
            boolean bl5 = !methodBinding.isConstructor() && !methodBinding.isStatic();
            if (!(bl4 || (bl &= bl5) || this.inheritNullAnnotations && bl5)) {
                return;
            }
            if (bl5) {
                int n;
                ArrayList arrayList = new ArrayList();
                if (referenceBinding instanceof SourceTypeBinding && !referenceBinding.isHierarchyConnected() && !referenceBinding.isAnonymousType()) {
                    ((SourceTypeBinding)referenceBinding).scope.connectTypeHierarchy();
                }
                int n2 = methodBinding.parameters.length;
                this.findAllOverriddenMethods(methodBinding.original(), methodBinding.selector, n2, referenceBinding, new HashSet(), arrayList);
                InheritedNonNullnessInfo[] inheritedNonNullnessInfoArray = new InheritedNonNullnessInfo[n2 + 1];
                for (n = 0; n < n2 + 1; ++n) {
                    inheritedNonNullnessInfoArray[n] = new InheritedNonNullnessInfo();
                }
                int n3 = n = arrayList.size();
                while (--n3 >= 0) {
                    MethodBinding methodBinding2 = (MethodBinding)arrayList.get(n3);
                    if ((methodBinding2.tagBits & 0x1000L) == 0L) {
                        this.checkImplicitNullAnnotations(methodBinding2, null, false, scope);
                    }
                    this.checkNullSpecInheritance(methodBinding, abstractMethodDeclaration, bl3, parameterNonNullDefaultProvider, bl, methodBinding2, null, scope, inheritedNonNullnessInfoArray);
                    bl4 = false;
                }
                InheritedNonNullnessInfo inheritedNonNullnessInfo = inheritedNonNullnessInfoArray[0];
                if (!inheritedNonNullnessInfo.complained) {
                    long l = 0L;
                    if (inheritedNonNullnessInfo.inheritedNonNullness == Boolean.TRUE) {
                        l = 0x100000000000000L;
                    } else if (inheritedNonNullnessInfo.inheritedNonNullness == Boolean.FALSE) {
                        l = 0x80000000000000L;
                    }
                    if (l != 0L) {
                        if (!bl2) {
                            methodBinding.tagBits |= l;
                        } else if (!methodBinding.returnType.isBaseType()) {
                            LookupEnvironment lookupEnvironment = scope.environment();
                            methodBinding.returnType = lookupEnvironment.createAnnotatedType(methodBinding.returnType, lookupEnvironment.nullAnnotationsFromTagBits(l));
                        }
                    }
                }
                for (int i = 0; i < n2; ++i) {
                    Argument argument;
                    inheritedNonNullnessInfo = inheritedNonNullnessInfoArray[i + 1];
                    if (inheritedNonNullnessInfo.complained || inheritedNonNullnessInfo.inheritedNonNullness == null) continue;
                    Argument argument2 = argument = abstractMethodDeclaration == null ? null : abstractMethodDeclaration.arguments[i];
                    if (!bl2) {
                        this.recordArgNonNullness(methodBinding, n2, i, argument, inheritedNonNullnessInfo.inheritedNonNullness);
                        continue;
                    }
                    this.recordArgNonNullness18(methodBinding, i, argument, inheritedNonNullnessInfo.inheritedNonNullness, scope.environment());
                }
            }
            if (bl4) {
                if (!bl2) {
                    methodBinding.fillInDefaultNonNullness(abstractMethodDeclaration, bl3, parameterNonNullDefaultProvider);
                } else {
                    methodBinding.fillInDefaultNonNullness18(abstractMethodDeclaration, scope.environment());
                }
            }
        }
        finally {
            methodBinding.tagBits |= 0x1000L;
        }
    }

    private void findAllOverriddenMethods(MethodBinding methodBinding, char[] cArray, int n, ReferenceBinding referenceBinding, Set set, List list) {
        if (referenceBinding.id == 1) {
            return;
        }
        ReferenceBinding referenceBinding2 = referenceBinding.superclass();
        if (referenceBinding2 == null) {
            return;
        }
        this.collectOverriddenMethods(methodBinding, cArray, n, referenceBinding2, set, list);
        for (ReferenceBinding referenceBinding3 : referenceBinding.superInterfaces()) {
            if (!set.add(referenceBinding3.original())) continue;
            this.collectOverriddenMethods(methodBinding, cArray, n, referenceBinding3, set, list);
        }
    }

    private void collectOverriddenMethods(MethodBinding methodBinding, char[] cArray, int n, ReferenceBinding referenceBinding, Set set, List list) {
        MethodBinding[] methodBindingArray = referenceBinding.unResolvedMethods();
        int n2 = methodBindingArray.length;
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            MethodBinding methodBinding2 = methodBindingArray[i];
            if (!CharOperation.equals(cArray, methodBinding2.selector) || !methodBinding2.doesParameterLengthMatch(n) || methodBinding2.isStatic() || !MethodVerifier.doesMethodOverride(methodBinding, methodBinding2, this.environment)) continue;
            list.add(methodBinding2);
            bl = true;
        }
        if (!bl) {
            this.findAllOverriddenMethods(methodBinding, cArray, n, referenceBinding, set, list);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    void checkNullSpecInheritance(MethodBinding var1_1, AbstractMethodDeclaration var2_2, boolean var3_3, ParameterNonNullDefaultProvider var4_4, boolean var5_5, MethodBinding var6_6, MethodBinding[] var7_7, Scope var8_8, InheritedNonNullnessInfo[] var9_9) {
        block44: {
            block45: {
                block46: {
                    if (var1_1.declaringClass.id == 1) {
                        return;
                    }
                    if ((var6_6.tagBits & 4096L) == 0L) {
                        this.buddyImplicitNullAnnotationsVerifier.checkImplicitNullAnnotations(var6_6, null, false, var8_8);
                    }
                    var10_10 = this.environment.usesNullTypeAnnotations();
                    var11_11 = this.getReturnTypeNullnessTagBits(var6_6, var10_10);
                    var13_12 = this.getReturnTypeNullnessTagBits(var1_1, var10_10);
                    var15_13 = this.inheritNullAnnotations;
                    if (var1_1.returnType == null || var1_1.returnType.isBaseType()) break block44;
                    if (var13_12 != 0L) break block45;
                    if (!var15_13 || var11_11 == 0L) break block46;
                    if (var3_3 && var5_5 && var11_11 == 0x80000000000000L) {
                        var8_8.problemReporter().conflictingNullAnnotations(var1_1, ((MethodDeclaration)var2_2).returnType, var6_6);
                    }
                    if (var9_9 != null && var2_2 != null) {
                        this.recordDeferredInheritedNullness(var8_8, ((MethodDeclaration)var2_2).returnType, var6_6, var11_11 == 0x100000000000000L, var9_9[0]);
                    } else {
                        this.applyReturnNullBits(var1_1, var11_11);
                    }
                    break block44;
                }
                if (var3_3 && (!var10_10 || var1_1.returnType.acceptsNonNullDefault())) {
                    var13_12 = 0x100000000000000L;
                    this.applyReturnNullBits(var1_1, var13_12);
                }
            }
            if (!var5_5) break block44;
            if ((var11_11 & 0x100000000000000L) == 0L || var13_12 == 0x100000000000000L) ** GOTO lbl31
            if (var2_2 != null) {
                var8_8.problemReporter().illegalReturnRedefinition(var2_2, var6_6, this.environment.getNonNullAnnotationName());
            } else {
                var8_8.problemReporter().cannotImplementIncompatibleNullness(var8_8.referenceContext(), var1_1, var6_6, var10_10);
                return;
lbl31:
                // 1 sources

                if (var10_10) {
                    var16_14 /* !! */  = null;
                    var17_15 = var6_6.original().typeVariables;
                    if (var17_15 != null && var1_1.returnType.id != 6) {
                        var18_16 = this.environment.createParameterizedGenericMethod(var1_1, (TypeBinding[])var17_15);
                        var16_14 /* !! */  = var18_16.returnType;
                    }
                    if (NullAnnotationMatching.analyse(var6_6.returnType, var1_1.returnType, (TypeBinding)var16_14 /* !! */ , null, 0, null, NullAnnotationMatching.CheckMode.OVERRIDE_RETURN).isAnyMismatch()) {
                        if (var2_2 != null) {
                            var8_8.problemReporter().illegalReturnRedefinition(var2_2, var6_6, this.environment.getNonNullAnnotationName());
                        } else {
                            var8_8.problemReporter().cannotImplementIncompatibleNullness(var8_8.referenceContext(), var1_1, var6_6, var10_10);
                        }
                        return;
                    }
                }
            }
        }
        var16_14 /* !! */  = null;
        if (var5_5 && (var17_15 = var1_1.original().typeVariables) != Binding.NO_TYPE_VARIABLES) {
            var18_16 = this.environment.createParameterizedGenericMethod(var6_6, (TypeBinding[])var17_15);
            var16_14 /* !! */  = var18_16.parameters;
        }
        var17_15 = var2_2 == null ? null : var2_2.arguments;
        var18_17 = 0;
        if (var17_15 != null) {
            var18_17 = var17_15.length;
        }
        if (var10_10) {
            var18_17 = var1_1.parameters.length;
        } else if (var6_6.parameterNonNullness != null) {
            var18_17 = var6_6.parameterNonNullness.length;
        } else if (var1_1.parameterNonNullness != null) {
            var18_17 = var1_1.parameterNonNullness.length;
        }
        block0: for (var19_18 = 0; var19_18 < var18_17; ++var19_18) {
            if (var1_1.parameters[var19_18].isBaseType()) continue;
            var20_20 = var17_15 == null ? null : var17_15[var19_18];
            var21_21 = this.getParameterNonNullness(var6_6, var19_18, var10_10);
            var22_23 = this.getParameterNonNullness(var1_1, var19_18, var10_10);
            if (var22_23 == null) {
                if (var21_21 != null && var15_13) {
                    if (var4_4.hasNonNullDefaultForParam(var19_18) && var5_5 && var21_21 == Boolean.FALSE && var20_20 != null) {
                        var8_8.problemReporter().conflictingNullAnnotations(var1_1, (ASTNode)var20_20, var6_6);
                    }
                    if (var9_9 != null && var2_2 != null) {
                        this.recordDeferredInheritedNullness(var8_8, var2_2.arguments[var19_18].type, var6_6, var21_21, var9_9[var19_18 + 1]);
                        continue;
                    }
                    if (!var10_10) {
                        this.recordArgNonNullness(var1_1, var18_17, var19_18, (Argument)var20_20, var21_21);
                        continue;
                    }
                    this.recordArgNonNullness18(var1_1, var19_18, (Argument)var20_20, var21_21, this.environment);
                    continue;
                }
                if (var4_4.hasNonNullDefaultForParam(var19_18)) {
                    var22_23 = Boolean.TRUE;
                    if (!var10_10) {
                        this.recordArgNonNullness(var1_1, var18_17, var19_18, (Argument)var20_20, Boolean.TRUE);
                    } else if (var1_1.parameters[var19_18].acceptsNonNullDefault()) {
                        this.recordArgNonNullness18(var1_1, var19_18, (Argument)var20_20, Boolean.TRUE, this.environment);
                    } else {
                        var22_23 = null;
                    }
                }
            }
            if (!var5_5) continue;
            var23_24 = var21_21 == Boolean.TRUE ? this.environment.getNonNullAnnotationName() : this.environment.getNullableAnnotationName();
            if (var21_21 != Boolean.TRUE && var22_23 == Boolean.TRUE) {
                if (var20_20 != null) {
                    var8_8.problemReporter().illegalRedefinitionToNonNullParameter((Argument)var20_20, var6_6.declaringClass, var21_21 == null ? null : this.environment.getNullableAnnotationName());
                    continue;
                }
                var8_8.problemReporter().cannotImplementIncompatibleNullness(var8_8.referenceContext(), var1_1, var6_6, false);
                continue;
            }
            if (var22_23 == null) {
                if (var21_21 == Boolean.FALSE) {
                    if (var20_20 != null) {
                        var8_8.problemReporter().parameterLackingNullableAnnotation((Argument)var20_20, var6_6.declaringClass, var23_24);
                        continue;
                    }
                    var8_8.problemReporter().cannotImplementIncompatibleNullness(var8_8.referenceContext(), var1_1, var6_6, false);
                    continue;
                }
                if (var21_21 == Boolean.TRUE) {
                    if (var7_7 != null) {
                        for (MethodBinding var27_30 : var7_7) {
                            if (TypeBinding.equalsEquals(var6_6.declaringClass, var27_30.declaringClass) && this.getParameterNonNullness(var27_30, var19_18, var10_10) != Boolean.TRUE) continue block0;
                        }
                    }
                    if (var20_20 != null) {
                        var8_8.problemReporter().parameterLackingNonnullAnnotation((Argument)var20_20, var6_6.declaringClass, var23_24);
                        continue;
                    }
                    var24_25 /* !! */  = var8_8.classScope().referenceContext;
                    var25_27 /* !! */  = var24_25 /* !! */ .superclass != null ? var24_25 /* !! */ .superclass : var24_25 /* !! */ ;
                    var8_8.problemReporter().inheritedParameterLackingNonnullAnnotation(var1_1, var19_18 + 1, var6_6.declaringClass, (ASTNode)var25_27 /* !! */ , var23_24);
                    continue;
                }
            }
            if (!var10_10) continue;
            var24_25 /* !! */  = var6_6.parameters[var19_18];
            v0 = var25_28 = var16_14 /* !! */  != null ? var16_14 /* !! */ [var19_18] : null;
            if (!NullAnnotationMatching.analyse(var1_1.parameters[var19_18], (TypeBinding)var24_25 /* !! */ , var25_28, null, 0, null, NullAnnotationMatching.CheckMode.OVERRIDE).isAnyMismatch()) continue;
            if (var20_20 != null) {
                var8_8.problemReporter().illegalParameterRedefinition((Argument)var20_20, var6_6.declaringClass, (TypeBinding)var24_25 /* !! */ );
                continue;
            }
            var8_8.problemReporter().cannotImplementIncompatibleNullness(var8_8.referenceContext(), var1_1, var6_6, false);
        }
        if (var5_5 && var10_10 && var2_2 != null) {
            var19_19 = var1_1.typeVariables();
            var20_20 = var6_6.typeVariables();
            if (var19_19 != Binding.NO_TYPE_VARIABLES && var19_19.length == var20_20.length) {
                for (var21_22 = 0; var21_22 < var19_19.length; ++var21_22) {
                    var22_23 = var20_20[var21_22];
                    if (!NullAnnotationMatching.analyse((TypeBinding)var22_23, var19_19[var21_22], null, null, -1, null, NullAnnotationMatching.CheckMode.BOUND_CHECK).isAnyMismatch()) continue;
                    var8_8.problemReporter().cannotRedefineTypeArgumentNullity((TypeBinding)var22_23, var6_6, var2_2.typeParameters()[var21_22]);
                }
            }
        }
    }

    void applyReturnNullBits(MethodBinding methodBinding, long l) {
        if (this.environment.usesNullTypeAnnotations()) {
            if (!methodBinding.returnType.isBaseType()) {
                methodBinding.returnType = this.environment.createAnnotatedType(methodBinding.returnType, this.environment.nullAnnotationsFromTagBits(l));
            }
        } else {
            methodBinding.tagBits |= l;
        }
    }

    private Boolean getParameterNonNullness(MethodBinding methodBinding, int n, boolean bl) {
        if (bl) {
            long l;
            TypeBinding typeBinding = methodBinding.parameters[n];
            if (typeBinding != null && (l = NullAnnotationMatching.validNullTagBits(typeBinding.tagBits)) != 0L) {
                return l == 0x100000000000000L;
            }
            return null;
        }
        return methodBinding.parameterNonNullness == null ? null : methodBinding.parameterNonNullness[n];
    }

    private long getReturnTypeNullnessTagBits(MethodBinding methodBinding, boolean bl) {
        if (bl) {
            if (methodBinding.returnType == null) {
                return 0L;
            }
            return NullAnnotationMatching.validNullTagBits(methodBinding.returnType.tagBits);
        }
        return methodBinding.tagBits & 0x180000000000000L;
    }

    protected void recordDeferredInheritedNullness(Scope scope, ASTNode aSTNode, MethodBinding methodBinding, Boolean bl, InheritedNonNullnessInfo inheritedNonNullnessInfo) {
        if (inheritedNonNullnessInfo.inheritedNonNullness != null && inheritedNonNullnessInfo.inheritedNonNullness != bl) {
            scope.problemReporter().conflictingInheritedNullAnnotations(aSTNode, inheritedNonNullnessInfo.inheritedNonNullness, inheritedNonNullnessInfo.annotationOrigin, bl, methodBinding);
            inheritedNonNullnessInfo.complained = true;
        } else {
            inheritedNonNullnessInfo.inheritedNonNullness = bl;
            inheritedNonNullnessInfo.annotationOrigin = methodBinding;
        }
    }

    void recordArgNonNullness(MethodBinding methodBinding, int n, int n2, Argument argument, Boolean bl) {
        if (methodBinding.parameterNonNullness == null) {
            methodBinding.parameterNonNullness = new Boolean[n];
        }
        methodBinding.parameterNonNullness[n2] = bl;
        if (argument != null) {
            argument.binding.tagBits = argument.binding.tagBits | (bl != false ? 0x100000000000000L : 0x80000000000000L);
        }
    }

    void recordArgNonNullness18(MethodBinding methodBinding, int n, Argument argument, Boolean bl, LookupEnvironment lookupEnvironment) {
        AnnotationBinding annotationBinding = bl != false ? lookupEnvironment.getNonNullAnnotation() : lookupEnvironment.getNullableAnnotation();
        methodBinding.parameters[n] = lookupEnvironment.createAnnotatedType(methodBinding.parameters[n], new AnnotationBinding[]{annotationBinding});
        if (argument != null) {
            argument.binding.type = methodBinding.parameters[n];
        }
    }

    static boolean areParametersEqual(MethodBinding methodBinding, MethodBinding methodBinding2) {
        int n;
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
        if (typeBindingArray == typeBindingArray2) {
            return true;
        }
        int n2 = typeBindingArray.length;
        if (n2 != typeBindingArray2.length) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            if (ImplicitNullAnnotationVerifier.areTypesEqual(typeBindingArray[n], typeBindingArray2[n])) continue;
            if (typeBindingArray[n].leafComponentType().isRawType() && typeBindingArray[n].dimensions() == typeBindingArray2[n].dimensions() && typeBindingArray[n].leafComponentType().isEquivalentTo(typeBindingArray2[n].leafComponentType())) {
                if (methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    if (!typeBindingArray[i].leafComponentType().isParameterizedTypeWithActualArguments()) continue;
                    return false;
                }
                break;
            }
            return false;
        }
        ++n;
        while (n < n2) {
            if (!ImplicitNullAnnotationVerifier.areTypesEqual(typeBindingArray[n], typeBindingArray2[n])) {
                if (!typeBindingArray[n].leafComponentType().isRawType() || typeBindingArray[n].dimensions() != typeBindingArray2[n].dimensions() || !typeBindingArray[n].leafComponentType().isEquivalentTo(typeBindingArray2[n].leafComponentType())) {
                    return false;
                }
            } else if (typeBindingArray[n].leafComponentType().isParameterizedTypeWithActualArguments()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean areTypesEqual(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (TypeBinding.equalsEquals(typeBinding, typeBinding2)) {
            return true;
        }
        block0 : switch (typeBinding.kind()) {
            case 4: {
                switch (typeBinding2.kind()) {
                    case 260: 
                    case 1028: {
                        if (TypeBinding.equalsEquals(typeBinding, typeBinding2.erasure())) {
                            return true;
                        }
                        break block0;
                    }
                }
                break;
            }
            case 260: 
            case 1028: {
                switch (typeBinding2.kind()) {
                    case 4: {
                        if (!TypeBinding.equalsEquals(typeBinding.erasure(), typeBinding2)) break;
                        return true;
                    }
                }
                break;
            }
        }
        if (!typeBinding.isParameterizedType()) return false;
        if (!typeBinding2.isParameterizedType()) return false;
        if (!typeBinding.isEquivalentTo(typeBinding2)) return false;
        if (!typeBinding2.isEquivalentTo(typeBinding)) return false;
        return true;
    }

    static class InheritedNonNullnessInfo {
        Boolean inheritedNonNullness;
        MethodBinding annotationOrigin;
        boolean complained;

        InheritedNonNullnessInfo() {
        }
    }
}

