/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import java.util.ArrayList;
import java.util.List;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.cmd.PointFlag;
import tim.prune.cmd.ShuffleAndCropCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;

public class DeleteMarkedPointsFunction
extends GenericFunction {
    private boolean _splitSegments = false;
    private String _parentFunctionKey = null;

    public DeleteMarkedPointsFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.deletemarked";
    }

    public void setParentFunction(String string, boolean bl) {
        this._parentFunctionKey = string;
        this._splitSegments = bl;
    }

    @Override
    public void begin() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        Track track = this._app.getTrackInfo().getTrack();
        int n = 0;
        while (n < track.getNumPoints()) {
            DataPoint dataPoint = track.getPoint(n);
            if (dataPoint.getDeleteFlag()) {
                arrayList2.add(n);
            } else {
                arrayList.add(n);
            }
            ++n;
        }
        if (arrayList2.isEmpty()) {
            String string = this._parentFunctionKey == null ? this.getNameKey() : this._parentFunctionKey;
            this._app.showErrorMessage(string, "dialog.deletemarked.nonefound");
        } else {
            ShuffleAndCropCmd shuffleAndCropCmd = new ShuffleAndCropCmd(arrayList, arrayList2, this.makeSegmentFlags(track, arrayList2));
            this._app.execute(shuffleAndCropCmd);
        }
    }

    private List<PointFlag> makeSegmentFlags(Track track, ArrayList<Integer> arrayList) {
        ArrayList<PointFlag> arrayList2 = new ArrayList<PointFlag>();
        DataPoint dataPoint = null;
        for (int n : arrayList) {
            DataPoint dataPoint2;
            if (!track.getPoint(n).getSegmentStart() && !this._splitSegments || (dataPoint2 = track.getNextTrackPoint(n + 1)) == null || dataPoint2 == dataPoint) continue;
            boolean bl = false;
            for (int n2 : arrayList) {
                if (n2 <= n || track.getPoint(n2) != dataPoint2) continue;
                bl = true;
            }
            if (bl) continue;
            dataPoint = dataPoint2;
            arrayList2.add(new PointFlag(dataPoint2, true));
        }
        return arrayList2;
    }
}

