/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class EncryptingSerializer
extends StandardSerializer {
    private static final String DEFAULT_SECRET_KEY_ALGORITHM = "PBKDF2WithHmacSHA256";
    private static final String DEFAULT_CIPHER = "AES/ECB/PKCS5Padding";
    private static final int KEYHASH_ITERATION_COUNT = 1000;
    private static final int KEY_LENGTH = 256;
    private static final int TAG_LENGTH = 128;
    private static final int IV_LENGTH = 12;
    private static final int SALT_LENGTH = 16;
    private String psk;
    private String cipherTransformation = "AES/ECB/PKCS5Padding";
    private final SecureRandom secureRandom;
    private final SecretKeyFactory secretKeyFactory;
    private final IElementSerializer serializer;

    public EncryptingSerializer() {
        this(new StandardSerializer());
    }

    public EncryptingSerializer(IElementSerializer serializer) {
        this.serializer = serializer;
        try {
            this.secureRandom = new SecureRandom();
            this.secretKeyFactory = SecretKeyFactory.getInstance(DEFAULT_SECRET_KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not set up encryption tools", e);
        }
    }

    public void setPreSharedKey(String psk) {
        this.psk = psk;
    }

    public void setAesCipherTransformation(String transformation) {
        this.cipherTransformation = transformation;
    }

    private byte[] getRandomBytes(int length) {
        byte[] bytes = new byte[length];
        this.secureRandom.nextBytes(bytes);
        return bytes;
    }

    private SecretKey createSecretKey(String password, byte[] salt) throws InvalidKeySpecException {
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 1000, 256);
        SecretKey tmp = this.secretKeyFactory.generateSecret(spec);
        return new SecretKeySpec(tmp.getEncoded(), "AES");
    }

    private byte[] encrypt(byte[] source) throws IOException {
        try {
            byte[] salt = this.getRandomBytes(16);
            byte[] iv = this.getRandomBytes(12);
            SecretKey secretKey = this.createSecretKey(this.psk, salt);
            Cipher cipher = Cipher.getInstance(this.cipherTransformation);
            if (cipher.getAlgorithm().startsWith("AES/GCM")) {
                cipher.init(1, (Key)secretKey, new GCMParameterSpec(128, iv));
            } else {
                cipher.init(1, secretKey);
            }
            byte[] encrypted = cipher.doFinal(source);
            return ByteBuffer.allocate(28 + encrypted.length).put(iv).put(salt).put(encrypted).array();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IOException("Error while encrypting", e);
        }
    }

    private byte[] decrypt(byte[] source) throws IOException {
        try {
            ByteBuffer wrapped = ByteBuffer.wrap(source);
            byte[] iv = new byte[12];
            wrapped.get(iv);
            byte[] salt = new byte[16];
            wrapped.get(salt);
            byte[] encrypted = new byte[wrapped.remaining()];
            wrapped.get(encrypted);
            SecretKey secretKey = this.createSecretKey(this.psk, salt);
            Cipher cipher = Cipher.getInstance(this.cipherTransformation);
            if (cipher.getAlgorithm().startsWith("AES/GCM")) {
                cipher.init(2, (Key)secretKey, new GCMParameterSpec(128, iv));
            } else {
                cipher.init(2, secretKey);
            }
            return cipher.doFinal(encrypted);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IOException("Error while decrypting", e);
        }
    }

    @Override
    public <T> byte[] serialize(T obj) throws IOException {
        byte[] unencrypted = this.serializer.serialize(obj);
        return this.encrypt(unencrypted);
    }

    @Override
    public <T> T deSerialize(byte[] data, ClassLoader loader) throws IOException, ClassNotFoundException {
        if (data == null) {
            return null;
        }
        byte[] deccrypted = this.decrypt(data);
        return this.serializer.deSerialize(deccrypted, loader);
    }
}

